/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRVector3f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrBoundaryTestResult")
public class OVRBoundaryTestResult
extends Struct<OVRBoundaryTestResult>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ISTRIGGERING;
    public static final int CLOSESTDISTANCE;
    public static final int CLOSESTPOINT;
    public static final int CLOSESTPOINTNORMAL;

    protected OVRBoundaryTestResult(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected OVRBoundaryTestResult create(long address, @Nullable ByteBuffer container) {
        return new OVRBoundaryTestResult(address, container);
    }

    public OVRBoundaryTestResult(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), OVRBoundaryTestResult.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrBool")
    public boolean IsTriggering() {
        return OVRBoundaryTestResult.nIsTriggering(this.address());
    }

    public float ClosestDistance() {
        return OVRBoundaryTestResult.nClosestDistance(this.address());
    }

    @NativeType(value="ovrVector3f")
    public OVRVector3f ClosestPoint() {
        return OVRBoundaryTestResult.nClosestPoint(this.address());
    }

    @NativeType(value="ovrVector3f")
    public OVRVector3f ClosestPointNormal() {
        return OVRBoundaryTestResult.nClosestPointNormal(this.address());
    }

    public static OVRBoundaryTestResult malloc() {
        return new OVRBoundaryTestResult(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static OVRBoundaryTestResult calloc() {
        return new OVRBoundaryTestResult(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static OVRBoundaryTestResult create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new OVRBoundaryTestResult(MemoryUtil.memAddress(container), container);
    }

    public static OVRBoundaryTestResult create(long address) {
        return new OVRBoundaryTestResult(address, null);
    }

    public static @Nullable OVRBoundaryTestResult createSafe(long address) {
        return address == 0L ? null : new OVRBoundaryTestResult(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(OVRBoundaryTestResult.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRBoundaryTestResult.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRBoundaryTestResult mallocStack() {
        return OVRBoundaryTestResult.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRBoundaryTestResult callocStack() {
        return OVRBoundaryTestResult.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRBoundaryTestResult mallocStack(MemoryStack stack) {
        return OVRBoundaryTestResult.malloc(stack);
    }

    @Deprecated
    public static OVRBoundaryTestResult callocStack(MemoryStack stack) {
        return OVRBoundaryTestResult.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRBoundaryTestResult.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRBoundaryTestResult.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRBoundaryTestResult.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRBoundaryTestResult.calloc(capacity, stack);
    }

    public static OVRBoundaryTestResult malloc(MemoryStack stack) {
        return new OVRBoundaryTestResult(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRBoundaryTestResult calloc(MemoryStack stack) {
        return new OVRBoundaryTestResult(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static boolean nIsTriggering(long struct) {
        return MemoryUtil.memGetByte(struct + (long)ISTRIGGERING) != 0;
    }

    public static float nClosestDistance(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)CLOSESTDISTANCE);
    }

    public static OVRVector3f nClosestPoint(long struct) {
        return OVRVector3f.create(struct + (long)CLOSESTPOINT);
    }

    public static OVRVector3f nClosestPointNormal(long struct) {
        return OVRVector3f.create(struct + (long)CLOSESTPOINTNORMAL);
    }

    static {
        Struct.Layout layout = OVRBoundaryTestResult.__struct(OVRBoundaryTestResult.__member(1), OVRBoundaryTestResult.__member(4), OVRBoundaryTestResult.__member(OVRVector3f.SIZEOF, OVRVector3f.ALIGNOF), OVRBoundaryTestResult.__member(OVRVector3f.SIZEOF, OVRVector3f.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ISTRIGGERING = layout.offsetof(0);
        CLOSESTDISTANCE = layout.offsetof(1);
        CLOSESTPOINT = layout.offsetof(2);
        CLOSESTPOINTNORMAL = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<OVRBoundaryTestResult, Buffer>
    implements NativeResource {
        private static final OVRBoundaryTestResult ELEMENT_FACTORY = OVRBoundaryTestResult.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected OVRBoundaryTestResult getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ovrBool")
        public boolean IsTriggering() {
            return OVRBoundaryTestResult.nIsTriggering(this.address());
        }

        public float ClosestDistance() {
            return OVRBoundaryTestResult.nClosestDistance(this.address());
        }

        @NativeType(value="ovrVector3f")
        public OVRVector3f ClosestPoint() {
            return OVRBoundaryTestResult.nClosestPoint(this.address());
        }

        @NativeType(value="ovrVector3f")
        public OVRVector3f ClosestPointNormal() {
            return OVRBoundaryTestResult.nClosestPointNormal(this.address());
        }
    }
}

