/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRCameraExtrinsics;
import org.lwjgl.ovr.OVRCameraIntrinsics;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrExternalCamera")
public class OVRExternalCamera
extends Struct<OVRExternalCamera>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int INTRINSICS;
    public static final int EXTRINSICS;

    protected OVRExternalCamera(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected OVRExternalCamera create(long address, @Nullable ByteBuffer container) {
        return new OVRExternalCamera(address, container);
    }

    public OVRExternalCamera(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), OVRExternalCamera.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[32]")
    public ByteBuffer Name() {
        return OVRExternalCamera.nName(this.address());
    }

    @NativeType(value="char[32]")
    public String NameString() {
        return OVRExternalCamera.nNameString(this.address());
    }

    @NativeType(value="ovrCameraIntrinsics")
    public OVRCameraIntrinsics Intrinsics() {
        return OVRExternalCamera.nIntrinsics(this.address());
    }

    @NativeType(value="ovrCameraExtrinsics")
    public OVRCameraExtrinsics Extrinsics() {
        return OVRExternalCamera.nExtrinsics(this.address());
    }

    public static OVRExternalCamera malloc() {
        return new OVRExternalCamera(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static OVRExternalCamera calloc() {
        return new OVRExternalCamera(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static OVRExternalCamera create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new OVRExternalCamera(MemoryUtil.memAddress(container), container);
    }

    public static OVRExternalCamera create(long address) {
        return new OVRExternalCamera(address, null);
    }

    public static @Nullable OVRExternalCamera createSafe(long address) {
        return address == 0L ? null : new OVRExternalCamera(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(OVRExternalCamera.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRExternalCamera.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRExternalCamera mallocStack() {
        return OVRExternalCamera.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRExternalCamera callocStack() {
        return OVRExternalCamera.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRExternalCamera mallocStack(MemoryStack stack) {
        return OVRExternalCamera.malloc(stack);
    }

    @Deprecated
    public static OVRExternalCamera callocStack(MemoryStack stack) {
        return OVRExternalCamera.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRExternalCamera.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRExternalCamera.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRExternalCamera.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRExternalCamera.calloc(capacity, stack);
    }

    public static OVRExternalCamera malloc(MemoryStack stack) {
        return new OVRExternalCamera(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRExternalCamera calloc(MemoryStack stack) {
        return new OVRExternalCamera(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)NAME, 32);
    }

    public static String nNameString(long struct) {
        return MemoryUtil.memASCII(struct + (long)NAME);
    }

    public static OVRCameraIntrinsics nIntrinsics(long struct) {
        return OVRCameraIntrinsics.create(struct + (long)INTRINSICS);
    }

    public static OVRCameraExtrinsics nExtrinsics(long struct) {
        return OVRCameraExtrinsics.create(struct + (long)EXTRINSICS);
    }

    static {
        Struct.Layout layout = OVRExternalCamera.__struct(OVRExternalCamera.__array(1, 32), OVRExternalCamera.__member(OVRCameraIntrinsics.SIZEOF, OVRCameraIntrinsics.ALIGNOF), OVRExternalCamera.__member(OVRCameraExtrinsics.SIZEOF, OVRCameraExtrinsics.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        INTRINSICS = layout.offsetof(1);
        EXTRINSICS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<OVRExternalCamera, Buffer>
    implements NativeResource {
        private static final OVRExternalCamera ELEMENT_FACTORY = OVRExternalCamera.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected OVRExternalCamera getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[32]")
        public ByteBuffer Name() {
            return OVRExternalCamera.nName(this.address());
        }

        @NativeType(value="char[32]")
        public String NameString() {
            return OVRExternalCamera.nNameString(this.address());
        }

        @NativeType(value="ovrCameraIntrinsics")
        public OVRCameraIntrinsics Intrinsics() {
            return OVRExternalCamera.nIntrinsics(this.address());
        }

        @NativeType(value="ovrCameraExtrinsics")
        public OVRCameraExtrinsics Extrinsics() {
            return OVRExternalCamera.nExtrinsics(this.address());
        }
    }
}

