/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRFovPort;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.ovr.OVRRecti;
import org.lwjgl.ovr.OVRVector2f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrEyeRenderDesc")
public class OVREyeRenderDesc
extends Struct<OVREyeRenderDesc>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int EYE;
    public static final int FOV;
    public static final int DISTORTEDVIEWPORT;
    public static final int PIXELSPERTANANGLEATCENTER;
    public static final int HMDTOEYEPOSE;

    protected OVREyeRenderDesc(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected OVREyeRenderDesc create(long address, @Nullable ByteBuffer container) {
        return new OVREyeRenderDesc(address, container);
    }

    public OVREyeRenderDesc(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), OVREyeRenderDesc.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrEyeType")
    public int Eye() {
        return OVREyeRenderDesc.nEye(this.address());
    }

    @NativeType(value="ovrFovPort")
    public OVRFovPort Fov() {
        return OVREyeRenderDesc.nFov(this.address());
    }

    @NativeType(value="ovrRecti")
    public OVRRecti DistortedViewport() {
        return OVREyeRenderDesc.nDistortedViewport(this.address());
    }

    @NativeType(value="ovrVector2f")
    public OVRVector2f PixelsPerTanAngleAtCenter() {
        return OVREyeRenderDesc.nPixelsPerTanAngleAtCenter(this.address());
    }

    @NativeType(value="ovrPosef")
    public OVRPosef HmdToEyePose() {
        return OVREyeRenderDesc.nHmdToEyePose(this.address());
    }

    public static OVREyeRenderDesc malloc() {
        return new OVREyeRenderDesc(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static OVREyeRenderDesc calloc() {
        return new OVREyeRenderDesc(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static OVREyeRenderDesc create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new OVREyeRenderDesc(MemoryUtil.memAddress(container), container);
    }

    public static OVREyeRenderDesc create(long address) {
        return new OVREyeRenderDesc(address, null);
    }

    public static @Nullable OVREyeRenderDesc createSafe(long address) {
        return address == 0L ? null : new OVREyeRenderDesc(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(OVREyeRenderDesc.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVREyeRenderDesc.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVREyeRenderDesc mallocStack() {
        return OVREyeRenderDesc.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVREyeRenderDesc callocStack() {
        return OVREyeRenderDesc.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVREyeRenderDesc mallocStack(MemoryStack stack) {
        return OVREyeRenderDesc.malloc(stack);
    }

    @Deprecated
    public static OVREyeRenderDesc callocStack(MemoryStack stack) {
        return OVREyeRenderDesc.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVREyeRenderDesc.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVREyeRenderDesc.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVREyeRenderDesc.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVREyeRenderDesc.calloc(capacity, stack);
    }

    public static OVREyeRenderDesc malloc(MemoryStack stack) {
        return new OVREyeRenderDesc(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVREyeRenderDesc calloc(MemoryStack stack) {
        return new OVREyeRenderDesc(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nEye(long struct) {
        return MemoryUtil.memGetInt(struct + (long)EYE);
    }

    public static OVRFovPort nFov(long struct) {
        return OVRFovPort.create(struct + (long)FOV);
    }

    public static OVRRecti nDistortedViewport(long struct) {
        return OVRRecti.create(struct + (long)DISTORTEDVIEWPORT);
    }

    public static OVRVector2f nPixelsPerTanAngleAtCenter(long struct) {
        return OVRVector2f.create(struct + (long)PIXELSPERTANANGLEATCENTER);
    }

    public static OVRPosef nHmdToEyePose(long struct) {
        return OVRPosef.create(struct + (long)HMDTOEYEPOSE);
    }

    static {
        Struct.Layout layout = OVREyeRenderDesc.__struct(OVREyeRenderDesc.__member(4), OVREyeRenderDesc.__member(OVRFovPort.SIZEOF, OVRFovPort.ALIGNOF), OVREyeRenderDesc.__member(OVRRecti.SIZEOF, OVRRecti.ALIGNOF), OVREyeRenderDesc.__member(OVRVector2f.SIZEOF, OVRVector2f.ALIGNOF), OVREyeRenderDesc.__member(OVRPosef.SIZEOF, OVRPosef.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        EYE = layout.offsetof(0);
        FOV = layout.offsetof(1);
        DISTORTEDVIEWPORT = layout.offsetof(2);
        PIXELSPERTANANGLEATCENTER = layout.offsetof(3);
        HMDTOEYEPOSE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<OVREyeRenderDesc, Buffer>
    implements NativeResource {
        private static final OVREyeRenderDesc ELEMENT_FACTORY = OVREyeRenderDesc.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected OVREyeRenderDesc getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ovrEyeType")
        public int Eye() {
            return OVREyeRenderDesc.nEye(this.address());
        }

        @NativeType(value="ovrFovPort")
        public OVRFovPort Fov() {
            return OVREyeRenderDesc.nFov(this.address());
        }

        @NativeType(value="ovrRecti")
        public OVRRecti DistortedViewport() {
            return OVREyeRenderDesc.nDistortedViewport(this.address());
        }

        @NativeType(value="ovrVector2f")
        public OVRVector2f PixelsPerTanAngleAtCenter() {
            return OVREyeRenderDesc.nPixelsPerTanAngleAtCenter(this.address());
        }

        @NativeType(value="ovrPosef")
        public OVRPosef HmdToEyePose() {
            return OVREyeRenderDesc.nHmdToEyePose(this.address());
        }
    }
}

