/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRVector2f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrFovStencilMeshBuffer")
public class OVRFovStencilMeshBuffer
extends Struct<OVRFovStencilMeshBuffer>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ALLOCVERTEXCOUNT;
    public static final int USEDVERTEXCOUNT;
    public static final int VERTEXBUFFER;
    public static final int ALLOCINDEXCOUNT;
    public static final int USEDINDEXCOUNT;
    public static final int INDEXBUFFER;

    protected OVRFovStencilMeshBuffer(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected OVRFovStencilMeshBuffer create(long address, @Nullable ByteBuffer container) {
        return new OVRFovStencilMeshBuffer(address, container);
    }

    public OVRFovStencilMeshBuffer(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), OVRFovStencilMeshBuffer.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int AllocVertexCount() {
        return OVRFovStencilMeshBuffer.nAllocVertexCount(this.address());
    }

    public int UsedVertexCount() {
        return OVRFovStencilMeshBuffer.nUsedVertexCount(this.address());
    }

    @NativeType(value="ovrVector2f *")
    public @Nullable OVRVector2f.Buffer VertexBuffer() {
        return OVRFovStencilMeshBuffer.nVertexBuffer(this.address());
    }

    public int AllocIndexCount() {
        return OVRFovStencilMeshBuffer.nAllocIndexCount(this.address());
    }

    public int UsedIndexCount() {
        return OVRFovStencilMeshBuffer.nUsedIndexCount(this.address());
    }

    @NativeType(value="uint16_t *")
    public @Nullable ShortBuffer IndexBuffer() {
        return OVRFovStencilMeshBuffer.nIndexBuffer(this.address());
    }

    public OVRFovStencilMeshBuffer AllocVertexCount(int value) {
        OVRFovStencilMeshBuffer.nAllocVertexCount(this.address(), value);
        return this;
    }

    public OVRFovStencilMeshBuffer UsedVertexCount(int value) {
        OVRFovStencilMeshBuffer.nUsedVertexCount(this.address(), value);
        return this;
    }

    public OVRFovStencilMeshBuffer VertexBuffer(@NativeType(value="ovrVector2f *") @Nullable OVRVector2f.Buffer value) {
        OVRFovStencilMeshBuffer.nVertexBuffer(this.address(), value);
        return this;
    }

    public OVRFovStencilMeshBuffer AllocIndexCount(int value) {
        OVRFovStencilMeshBuffer.nAllocIndexCount(this.address(), value);
        return this;
    }

    public OVRFovStencilMeshBuffer UsedIndexCount(int value) {
        OVRFovStencilMeshBuffer.nUsedIndexCount(this.address(), value);
        return this;
    }

    public OVRFovStencilMeshBuffer IndexBuffer(@NativeType(value="uint16_t *") @Nullable ShortBuffer value) {
        OVRFovStencilMeshBuffer.nIndexBuffer(this.address(), value);
        return this;
    }

    public OVRFovStencilMeshBuffer set(int AllocVertexCount, int UsedVertexCount, @Nullable OVRVector2f.Buffer VertexBuffer, int AllocIndexCount, int UsedIndexCount, @Nullable ShortBuffer IndexBuffer) {
        this.AllocVertexCount(AllocVertexCount);
        this.UsedVertexCount(UsedVertexCount);
        this.VertexBuffer(VertexBuffer);
        this.AllocIndexCount(AllocIndexCount);
        this.UsedIndexCount(UsedIndexCount);
        this.IndexBuffer(IndexBuffer);
        return this;
    }

    public OVRFovStencilMeshBuffer set(OVRFovStencilMeshBuffer src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRFovStencilMeshBuffer malloc() {
        return new OVRFovStencilMeshBuffer(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static OVRFovStencilMeshBuffer calloc() {
        return new OVRFovStencilMeshBuffer(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static OVRFovStencilMeshBuffer create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new OVRFovStencilMeshBuffer(MemoryUtil.memAddress(container), container);
    }

    public static OVRFovStencilMeshBuffer create(long address) {
        return new OVRFovStencilMeshBuffer(address, null);
    }

    public static @Nullable OVRFovStencilMeshBuffer createSafe(long address) {
        return address == 0L ? null : new OVRFovStencilMeshBuffer(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(OVRFovStencilMeshBuffer.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRFovStencilMeshBuffer.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRFovStencilMeshBuffer mallocStack() {
        return OVRFovStencilMeshBuffer.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRFovStencilMeshBuffer callocStack() {
        return OVRFovStencilMeshBuffer.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRFovStencilMeshBuffer mallocStack(MemoryStack stack) {
        return OVRFovStencilMeshBuffer.malloc(stack);
    }

    @Deprecated
    public static OVRFovStencilMeshBuffer callocStack(MemoryStack stack) {
        return OVRFovStencilMeshBuffer.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRFovStencilMeshBuffer.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRFovStencilMeshBuffer.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRFovStencilMeshBuffer.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRFovStencilMeshBuffer.calloc(capacity, stack);
    }

    public static OVRFovStencilMeshBuffer malloc(MemoryStack stack) {
        return new OVRFovStencilMeshBuffer(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRFovStencilMeshBuffer calloc(MemoryStack stack) {
        return new OVRFovStencilMeshBuffer(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nAllocVertexCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ALLOCVERTEXCOUNT);
    }

    public static int nUsedVertexCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)USEDVERTEXCOUNT);
    }

    public static @Nullable OVRVector2f.Buffer nVertexBuffer(long struct) {
        return OVRVector2f.createSafe(MemoryUtil.memGetAddress(struct + (long)VERTEXBUFFER), OVRFovStencilMeshBuffer.nAllocVertexCount(struct));
    }

    public static int nAllocIndexCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ALLOCINDEXCOUNT);
    }

    public static int nUsedIndexCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)USEDINDEXCOUNT);
    }

    public static @Nullable ShortBuffer nIndexBuffer(long struct) {
        return MemoryUtil.memShortBufferSafe(MemoryUtil.memGetAddress(struct + (long)INDEXBUFFER), OVRFovStencilMeshBuffer.nAllocIndexCount(struct));
    }

    public static void nAllocVertexCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ALLOCVERTEXCOUNT, value);
    }

    public static void nUsedVertexCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)USEDVERTEXCOUNT, value);
    }

    public static void nVertexBuffer(long struct, @Nullable OVRVector2f.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)VERTEXBUFFER, MemoryUtil.memAddressSafe(value));
        OVRFovStencilMeshBuffer.nAllocVertexCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nAllocIndexCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ALLOCINDEXCOUNT, value);
    }

    public static void nUsedIndexCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)USEDINDEXCOUNT, value);
    }

    public static void nIndexBuffer(long struct, @Nullable ShortBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)INDEXBUFFER, MemoryUtil.memAddressSafe(value));
        OVRFovStencilMeshBuffer.nAllocIndexCount(struct, value == null ? 0 : value.remaining());
    }

    static {
        Struct.Layout layout = OVRFovStencilMeshBuffer.__struct(OVRFovStencilMeshBuffer.__member(4), OVRFovStencilMeshBuffer.__member(4), OVRFovStencilMeshBuffer.__member(POINTER_SIZE), OVRFovStencilMeshBuffer.__member(4), OVRFovStencilMeshBuffer.__member(4), OVRFovStencilMeshBuffer.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ALLOCVERTEXCOUNT = layout.offsetof(0);
        USEDVERTEXCOUNT = layout.offsetof(1);
        VERTEXBUFFER = layout.offsetof(2);
        ALLOCINDEXCOUNT = layout.offsetof(3);
        USEDINDEXCOUNT = layout.offsetof(4);
        INDEXBUFFER = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<OVRFovStencilMeshBuffer, Buffer>
    implements NativeResource {
        private static final OVRFovStencilMeshBuffer ELEMENT_FACTORY = OVRFovStencilMeshBuffer.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected OVRFovStencilMeshBuffer getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int AllocVertexCount() {
            return OVRFovStencilMeshBuffer.nAllocVertexCount(this.address());
        }

        public int UsedVertexCount() {
            return OVRFovStencilMeshBuffer.nUsedVertexCount(this.address());
        }

        @NativeType(value="ovrVector2f *")
        public @Nullable OVRVector2f.Buffer VertexBuffer() {
            return OVRFovStencilMeshBuffer.nVertexBuffer(this.address());
        }

        public int AllocIndexCount() {
            return OVRFovStencilMeshBuffer.nAllocIndexCount(this.address());
        }

        public int UsedIndexCount() {
            return OVRFovStencilMeshBuffer.nUsedIndexCount(this.address());
        }

        @NativeType(value="uint16_t *")
        public @Nullable ShortBuffer IndexBuffer() {
            return OVRFovStencilMeshBuffer.nIndexBuffer(this.address());
        }

        public Buffer AllocVertexCount(int value) {
            OVRFovStencilMeshBuffer.nAllocVertexCount(this.address(), value);
            return this;
        }

        public Buffer UsedVertexCount(int value) {
            OVRFovStencilMeshBuffer.nUsedVertexCount(this.address(), value);
            return this;
        }

        public Buffer VertexBuffer(@NativeType(value="ovrVector2f *") @Nullable OVRVector2f.Buffer value) {
            OVRFovStencilMeshBuffer.nVertexBuffer(this.address(), value);
            return this;
        }

        public Buffer AllocIndexCount(int value) {
            OVRFovStencilMeshBuffer.nAllocIndexCount(this.address(), value);
            return this;
        }

        public Buffer UsedIndexCount(int value) {
            OVRFovStencilMeshBuffer.nUsedIndexCount(this.address(), value);
            return this;
        }

        public Buffer IndexBuffer(@NativeType(value="uint16_t *") @Nullable ShortBuffer value) {
            OVRFovStencilMeshBuffer.nIndexBuffer(this.address(), value);
            return this;
        }
    }
}

