/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRLogCallback;
import org.lwjgl.ovr.OVRLogCallbackI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;

@NativeType(value="struct ovrInitParams")
public class OVRInitParams
extends Struct<OVRInitParams>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int REQUESTEDMINORVERSION;
    public static final int LOGCALLBACK;
    public static final int USERDATA;
    public static final int CONNECTIONTIMEOUTMS;

    protected OVRInitParams(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected OVRInitParams create(long address, @Nullable ByteBuffer container) {
        return new OVRInitParams(address, container);
    }

    public OVRInitParams(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), OVRInitParams.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int Flags() {
        return OVRInitParams.nFlags(this.address());
    }

    @NativeType(value="uint32_t")
    public int RequestedMinorVersion() {
        return OVRInitParams.nRequestedMinorVersion(this.address());
    }

    @NativeType(value="ovrLogCallback")
    public @Nullable OVRLogCallback LogCallback() {
        return OVRInitParams.nLogCallback(this.address());
    }

    @NativeType(value="uintptr_t")
    public long UserData() {
        return OVRInitParams.nUserData(this.address());
    }

    @NativeType(value="uint32_t")
    public int ConnectionTimeoutMS() {
        return OVRInitParams.nConnectionTimeoutMS(this.address());
    }

    public OVRInitParams Flags(@NativeType(value="uint32_t") int value) {
        OVRInitParams.nFlags(this.address(), value);
        return this;
    }

    public OVRInitParams RequestedMinorVersion(@NativeType(value="uint32_t") int value) {
        OVRInitParams.nRequestedMinorVersion(this.address(), value);
        return this;
    }

    public OVRInitParams LogCallback(@NativeType(value="ovrLogCallback") @Nullable OVRLogCallbackI value) {
        OVRInitParams.nLogCallback(this.address(), value);
        return this;
    }

    public OVRInitParams UserData(@NativeType(value="uintptr_t") long value) {
        OVRInitParams.nUserData(this.address(), value);
        return this;
    }

    public OVRInitParams ConnectionTimeoutMS(@NativeType(value="uint32_t") int value) {
        OVRInitParams.nConnectionTimeoutMS(this.address(), value);
        return this;
    }

    public OVRInitParams set(int Flags2, int RequestedMinorVersion, OVRLogCallbackI LogCallback, long UserData, int ConnectionTimeoutMS) {
        this.Flags(Flags2);
        this.RequestedMinorVersion(RequestedMinorVersion);
        this.LogCallback(LogCallback);
        this.UserData(UserData);
        this.ConnectionTimeoutMS(ConnectionTimeoutMS);
        return this;
    }

    public OVRInitParams set(OVRInitParams src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRInitParams malloc() {
        return new OVRInitParams(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static OVRInitParams calloc() {
        return new OVRInitParams(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static OVRInitParams create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new OVRInitParams(MemoryUtil.memAddress(container), container);
    }

    public static OVRInitParams create(long address) {
        return new OVRInitParams(address, null);
    }

    public static @Nullable OVRInitParams createSafe(long address) {
        return address == 0L ? null : new OVRInitParams(address, null);
    }

    @Deprecated
    public static OVRInitParams mallocStack() {
        return OVRInitParams.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRInitParams callocStack() {
        return OVRInitParams.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRInitParams mallocStack(MemoryStack stack) {
        return OVRInitParams.malloc(stack);
    }

    @Deprecated
    public static OVRInitParams callocStack(MemoryStack stack) {
        return OVRInitParams.calloc(stack);
    }

    public static OVRInitParams malloc(MemoryStack stack) {
        return new OVRInitParams(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRInitParams calloc(MemoryStack stack) {
        return new OVRInitParams(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static int nFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nRequestedMinorVersion(long struct) {
        return MemoryUtil.memGetInt(struct + (long)REQUESTEDMINORVERSION);
    }

    public static @Nullable OVRLogCallback nLogCallback(long struct) {
        return OVRLogCallback.createSafe(MemoryUtil.memGetAddress(struct + (long)LOGCALLBACK));
    }

    public static long nUserData(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)USERDATA);
    }

    public static int nConnectionTimeoutMS(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CONNECTIONTIMEOUTMS);
    }

    public static void nFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nRequestedMinorVersion(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)REQUESTEDMINORVERSION, value);
    }

    public static void nLogCallback(long struct, @Nullable OVRLogCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)LOGCALLBACK, MemoryUtil.memAddressSafe(value));
    }

    public static void nUserData(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)USERDATA, value);
    }

    public static void nConnectionTimeoutMS(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CONNECTIONTIMEOUTMS, value);
    }

    static {
        Struct.Layout layout = OVRInitParams.__struct(OVRInitParams.__member(4), OVRInitParams.__member(4), OVRInitParams.__member(POINTER_SIZE), OVRInitParams.__member(POINTER_SIZE), OVRInitParams.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        REQUESTEDMINORVERSION = layout.offsetof(1);
        LOGCALLBACK = layout.offsetof(2);
        USERDATA = layout.offsetof(3);
        CONNECTIONTIMEOUTMS = layout.offsetof(4);
    }
}

