/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.ovr.OVRFovPort;
import org.lwjgl.ovr.OVRLayerHeader;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.ovr.OVRRecti;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrLayerEyeFov")
public class OVRLayerEyeFov
extends Struct<OVRLayerEyeFov>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEADER;
    public static final int COLORTEXTURE;
    public static final int VIEWPORT;
    public static final int FOV;
    public static final int RENDERPOSE;
    public static final int SENSORSAMPLETIME;

    protected OVRLayerEyeFov(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected OVRLayerEyeFov create(long address, @Nullable ByteBuffer container) {
        return new OVRLayerEyeFov(address, container);
    }

    public OVRLayerEyeFov(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), OVRLayerEyeFov.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrLayerHeader")
    public OVRLayerHeader Header() {
        return OVRLayerEyeFov.nHeader(this.address());
    }

    @NativeType(value="ovrTextureSwapChain[ovrEye_Count]")
    public PointerBuffer ColorTexture() {
        return OVRLayerEyeFov.nColorTexture(this.address());
    }

    @NativeType(value="ovrTextureSwapChain")
    public long ColorTexture(int index) {
        return OVRLayerEyeFov.nColorTexture(this.address(), index);
    }

    @NativeType(value="ovrRecti[ovrEye_Count]")
    public OVRRecti.Buffer Viewport() {
        return OVRLayerEyeFov.nViewport(this.address());
    }

    @NativeType(value="ovrRecti")
    public OVRRecti Viewport(int index) {
        return OVRLayerEyeFov.nViewport(this.address(), index);
    }

    @NativeType(value="ovrFovPort[ovrEye_Count]")
    public OVRFovPort.Buffer Fov() {
        return OVRLayerEyeFov.nFov(this.address());
    }

    @NativeType(value="ovrFovPort")
    public OVRFovPort Fov(int index) {
        return OVRLayerEyeFov.nFov(this.address(), index);
    }

    @NativeType(value="ovrPosef[ovrEye_Count]")
    public OVRPosef.Buffer RenderPose() {
        return OVRLayerEyeFov.nRenderPose(this.address());
    }

    @NativeType(value="ovrPosef")
    public OVRPosef RenderPose(int index) {
        return OVRLayerEyeFov.nRenderPose(this.address(), index);
    }

    public double SensorSampleTime() {
        return OVRLayerEyeFov.nSensorSampleTime(this.address());
    }

    public OVRLayerEyeFov Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
        OVRLayerEyeFov.nHeader(this.address(), value);
        return this;
    }

    public OVRLayerEyeFov Header(Consumer<OVRLayerHeader> consumer) {
        consumer.accept(this.Header());
        return this;
    }

    public OVRLayerEyeFov ColorTexture(@NativeType(value="ovrTextureSwapChain[ovrEye_Count]") PointerBuffer value) {
        OVRLayerEyeFov.nColorTexture(this.address(), value);
        return this;
    }

    public OVRLayerEyeFov ColorTexture(int index, @NativeType(value="ovrTextureSwapChain") long value) {
        OVRLayerEyeFov.nColorTexture(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeFov Viewport(@NativeType(value="ovrRecti[ovrEye_Count]") OVRRecti.Buffer value) {
        OVRLayerEyeFov.nViewport(this.address(), value);
        return this;
    }

    public OVRLayerEyeFov Viewport(int index, @NativeType(value="ovrRecti") OVRRecti value) {
        OVRLayerEyeFov.nViewport(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeFov Viewport(Consumer<OVRRecti.Buffer> consumer) {
        consumer.accept(this.Viewport());
        return this;
    }

    public OVRLayerEyeFov Viewport(int index, Consumer<OVRRecti> consumer) {
        consumer.accept(this.Viewport(index));
        return this;
    }

    public OVRLayerEyeFov Fov(@NativeType(value="ovrFovPort[ovrEye_Count]") OVRFovPort.Buffer value) {
        OVRLayerEyeFov.nFov(this.address(), value);
        return this;
    }

    public OVRLayerEyeFov Fov(int index, @NativeType(value="ovrFovPort") OVRFovPort value) {
        OVRLayerEyeFov.nFov(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeFov Fov(Consumer<OVRFovPort.Buffer> consumer) {
        consumer.accept(this.Fov());
        return this;
    }

    public OVRLayerEyeFov Fov(int index, Consumer<OVRFovPort> consumer) {
        consumer.accept(this.Fov(index));
        return this;
    }

    public OVRLayerEyeFov RenderPose(@NativeType(value="ovrPosef[ovrEye_Count]") OVRPosef.Buffer value) {
        OVRLayerEyeFov.nRenderPose(this.address(), value);
        return this;
    }

    public OVRLayerEyeFov RenderPose(int index, @NativeType(value="ovrPosef") OVRPosef value) {
        OVRLayerEyeFov.nRenderPose(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeFov RenderPose(Consumer<OVRPosef.Buffer> consumer) {
        consumer.accept(this.RenderPose());
        return this;
    }

    public OVRLayerEyeFov RenderPose(int index, Consumer<OVRPosef> consumer) {
        consumer.accept(this.RenderPose(index));
        return this;
    }

    public OVRLayerEyeFov SensorSampleTime(double value) {
        OVRLayerEyeFov.nSensorSampleTime(this.address(), value);
        return this;
    }

    public OVRLayerEyeFov set(OVRLayerHeader Header, PointerBuffer ColorTexture, OVRRecti.Buffer Viewport, OVRFovPort.Buffer Fov, OVRPosef.Buffer RenderPose, double SensorSampleTime) {
        this.Header(Header);
        this.ColorTexture(ColorTexture);
        this.Viewport(Viewport);
        this.Fov(Fov);
        this.RenderPose(RenderPose);
        this.SensorSampleTime(SensorSampleTime);
        return this;
    }

    public OVRLayerEyeFov set(OVRLayerEyeFov src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRLayerEyeFov malloc() {
        return new OVRLayerEyeFov(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static OVRLayerEyeFov calloc() {
        return new OVRLayerEyeFov(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static OVRLayerEyeFov create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new OVRLayerEyeFov(MemoryUtil.memAddress(container), container);
    }

    public static OVRLayerEyeFov create(long address) {
        return new OVRLayerEyeFov(address, null);
    }

    public static @Nullable OVRLayerEyeFov createSafe(long address) {
        return address == 0L ? null : new OVRLayerEyeFov(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(OVRLayerEyeFov.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRLayerEyeFov.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRLayerEyeFov mallocStack() {
        return OVRLayerEyeFov.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRLayerEyeFov callocStack() {
        return OVRLayerEyeFov.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRLayerEyeFov mallocStack(MemoryStack stack) {
        return OVRLayerEyeFov.malloc(stack);
    }

    @Deprecated
    public static OVRLayerEyeFov callocStack(MemoryStack stack) {
        return OVRLayerEyeFov.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRLayerEyeFov.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRLayerEyeFov.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRLayerEyeFov.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRLayerEyeFov.calloc(capacity, stack);
    }

    public static OVRLayerEyeFov malloc(MemoryStack stack) {
        return new OVRLayerEyeFov(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRLayerEyeFov calloc(MemoryStack stack) {
        return new OVRLayerEyeFov(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OVRLayerHeader nHeader(long struct) {
        return OVRLayerHeader.create(struct + (long)HEADER);
    }

    public static PointerBuffer nColorTexture(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)COLORTEXTURE, 2);
    }

    public static long nColorTexture(long struct, int index) {
        return MemoryUtil.memGetAddress(struct + (long)COLORTEXTURE + Checks.check(index, 2) * (long)POINTER_SIZE);
    }

    public static OVRRecti.Buffer nViewport(long struct) {
        return OVRRecti.create(struct + (long)VIEWPORT, 2);
    }

    public static OVRRecti nViewport(long struct, int index) {
        return OVRRecti.create(struct + (long)VIEWPORT + Checks.check(index, 2) * (long)OVRRecti.SIZEOF);
    }

    public static OVRFovPort.Buffer nFov(long struct) {
        return OVRFovPort.create(struct + (long)FOV, 2);
    }

    public static OVRFovPort nFov(long struct, int index) {
        return OVRFovPort.create(struct + (long)FOV + Checks.check(index, 2) * (long)OVRFovPort.SIZEOF);
    }

    public static OVRPosef.Buffer nRenderPose(long struct) {
        return OVRPosef.create(struct + (long)RENDERPOSE, 2);
    }

    public static OVRPosef nRenderPose(long struct, int index) {
        return OVRPosef.create(struct + (long)RENDERPOSE + Checks.check(index, 2) * (long)OVRPosef.SIZEOF);
    }

    public static double nSensorSampleTime(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)SENSORSAMPLETIME);
    }

    public static void nHeader(long struct, OVRLayerHeader value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HEADER, OVRLayerHeader.SIZEOF);
    }

    public static void nColorTexture(long struct, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)COLORTEXTURE, value.remaining() * POINTER_SIZE);
    }

    public static void nColorTexture(long struct, int index, long value) {
        MemoryUtil.memPutAddress(struct + (long)COLORTEXTURE + Checks.check(index, 2) * (long)POINTER_SIZE, value);
    }

    public static void nViewport(long struct, OVRRecti.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)VIEWPORT, value.remaining() * OVRRecti.SIZEOF);
    }

    public static void nViewport(long struct, int index, OVRRecti value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VIEWPORT + Checks.check(index, 2) * (long)OVRRecti.SIZEOF, OVRRecti.SIZEOF);
    }

    public static void nFov(long struct, OVRFovPort.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)FOV, value.remaining() * OVRFovPort.SIZEOF);
    }

    public static void nFov(long struct, int index, OVRFovPort value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FOV + Checks.check(index, 2) * (long)OVRFovPort.SIZEOF, OVRFovPort.SIZEOF);
    }

    public static void nRenderPose(long struct, OVRPosef.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)RENDERPOSE, value.remaining() * OVRPosef.SIZEOF);
    }

    public static void nRenderPose(long struct, int index, OVRPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)RENDERPOSE + Checks.check(index, 2) * (long)OVRPosef.SIZEOF, OVRPosef.SIZEOF);
    }

    public static void nSensorSampleTime(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)SENSORSAMPLETIME, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)COLORTEXTURE));
    }

    static {
        Struct.Layout layout = OVRLayerEyeFov.__struct(OVRLayerEyeFov.__member(OVRLayerHeader.SIZEOF, OVRLayerHeader.ALIGNOF, true), OVRLayerEyeFov.__array(POINTER_SIZE, 2), OVRLayerEyeFov.__array(OVRRecti.SIZEOF, OVRRecti.ALIGNOF, 2), OVRLayerEyeFov.__array(OVRFovPort.SIZEOF, OVRFovPort.ALIGNOF, 2), OVRLayerEyeFov.__array(OVRPosef.SIZEOF, OVRPosef.ALIGNOF, 2), OVRLayerEyeFov.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEADER = layout.offsetof(0);
        COLORTEXTURE = layout.offsetof(1);
        VIEWPORT = layout.offsetof(2);
        FOV = layout.offsetof(3);
        RENDERPOSE = layout.offsetof(4);
        SENSORSAMPLETIME = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<OVRLayerEyeFov, Buffer>
    implements NativeResource {
        private static final OVRLayerEyeFov ELEMENT_FACTORY = OVRLayerEyeFov.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected OVRLayerEyeFov getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ovrLayerHeader")
        public OVRLayerHeader Header() {
            return OVRLayerEyeFov.nHeader(this.address());
        }

        @NativeType(value="ovrTextureSwapChain[ovrEye_Count]")
        public PointerBuffer ColorTexture() {
            return OVRLayerEyeFov.nColorTexture(this.address());
        }

        @NativeType(value="ovrTextureSwapChain")
        public long ColorTexture(int index) {
            return OVRLayerEyeFov.nColorTexture(this.address(), index);
        }

        @NativeType(value="ovrRecti[ovrEye_Count]")
        public OVRRecti.Buffer Viewport() {
            return OVRLayerEyeFov.nViewport(this.address());
        }

        @NativeType(value="ovrRecti")
        public OVRRecti Viewport(int index) {
            return OVRLayerEyeFov.nViewport(this.address(), index);
        }

        @NativeType(value="ovrFovPort[ovrEye_Count]")
        public OVRFovPort.Buffer Fov() {
            return OVRLayerEyeFov.nFov(this.address());
        }

        @NativeType(value="ovrFovPort")
        public OVRFovPort Fov(int index) {
            return OVRLayerEyeFov.nFov(this.address(), index);
        }

        @NativeType(value="ovrPosef[ovrEye_Count]")
        public OVRPosef.Buffer RenderPose() {
            return OVRLayerEyeFov.nRenderPose(this.address());
        }

        @NativeType(value="ovrPosef")
        public OVRPosef RenderPose(int index) {
            return OVRLayerEyeFov.nRenderPose(this.address(), index);
        }

        public double SensorSampleTime() {
            return OVRLayerEyeFov.nSensorSampleTime(this.address());
        }

        public Buffer Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
            OVRLayerEyeFov.nHeader(this.address(), value);
            return this;
        }

        public Buffer Header(Consumer<OVRLayerHeader> consumer) {
            consumer.accept(this.Header());
            return this;
        }

        public Buffer ColorTexture(@NativeType(value="ovrTextureSwapChain[ovrEye_Count]") PointerBuffer value) {
            OVRLayerEyeFov.nColorTexture(this.address(), value);
            return this;
        }

        public Buffer ColorTexture(int index, @NativeType(value="ovrTextureSwapChain") long value) {
            OVRLayerEyeFov.nColorTexture(this.address(), index, value);
            return this;
        }

        public Buffer Viewport(@NativeType(value="ovrRecti[ovrEye_Count]") OVRRecti.Buffer value) {
            OVRLayerEyeFov.nViewport(this.address(), value);
            return this;
        }

        public Buffer Viewport(int index, @NativeType(value="ovrRecti") OVRRecti value) {
            OVRLayerEyeFov.nViewport(this.address(), index, value);
            return this;
        }

        public Buffer Viewport(Consumer<OVRRecti.Buffer> consumer) {
            consumer.accept(this.Viewport());
            return this;
        }

        public Buffer Viewport(int index, Consumer<OVRRecti> consumer) {
            consumer.accept(this.Viewport(index));
            return this;
        }

        public Buffer Fov(@NativeType(value="ovrFovPort[ovrEye_Count]") OVRFovPort.Buffer value) {
            OVRLayerEyeFov.nFov(this.address(), value);
            return this;
        }

        public Buffer Fov(int index, @NativeType(value="ovrFovPort") OVRFovPort value) {
            OVRLayerEyeFov.nFov(this.address(), index, value);
            return this;
        }

        public Buffer Fov(Consumer<OVRFovPort.Buffer> consumer) {
            consumer.accept(this.Fov());
            return this;
        }

        public Buffer Fov(int index, Consumer<OVRFovPort> consumer) {
            consumer.accept(this.Fov(index));
            return this;
        }

        public Buffer RenderPose(@NativeType(value="ovrPosef[ovrEye_Count]") OVRPosef.Buffer value) {
            OVRLayerEyeFov.nRenderPose(this.address(), value);
            return this;
        }

        public Buffer RenderPose(int index, @NativeType(value="ovrPosef") OVRPosef value) {
            OVRLayerEyeFov.nRenderPose(this.address(), index, value);
            return this;
        }

        public Buffer RenderPose(Consumer<OVRPosef.Buffer> consumer) {
            consumer.accept(this.RenderPose());
            return this;
        }

        public Buffer RenderPose(int index, Consumer<OVRPosef> consumer) {
            consumer.accept(this.RenderPose(index));
            return this;
        }

        public Buffer SensorSampleTime(double value) {
            OVRLayerEyeFov.nSensorSampleTime(this.address(), value);
            return this;
        }
    }
}

