/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.ovr.OVRFovPort;
import org.lwjgl.ovr.OVRLayerHeader;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.ovr.OVRRecti;
import org.lwjgl.ovr.OVRTimewarpProjectionDesc;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrLayerEyeFovDepth")
public class OVRLayerEyeFovDepth
extends Struct<OVRLayerEyeFovDepth>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEADER;
    public static final int COLORTEXTURE;
    public static final int VIEWPORT;
    public static final int FOV;
    public static final int RENDERPOSE;
    public static final int SENSORSAMPLETIME;
    public static final int DEPTHTEXTURE;
    public static final int PROJECTIONDESC;

    protected OVRLayerEyeFovDepth(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected OVRLayerEyeFovDepth create(long address, @Nullable ByteBuffer container) {
        return new OVRLayerEyeFovDepth(address, container);
    }

    public OVRLayerEyeFovDepth(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), OVRLayerEyeFovDepth.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrLayerHeader")
    public OVRLayerHeader Header() {
        return OVRLayerEyeFovDepth.nHeader(this.address());
    }

    @NativeType(value="ovrTextureSwapChain[ovrEye_Count]")
    public PointerBuffer ColorTexture() {
        return OVRLayerEyeFovDepth.nColorTexture(this.address());
    }

    @NativeType(value="ovrTextureSwapChain")
    public long ColorTexture(int index) {
        return OVRLayerEyeFovDepth.nColorTexture(this.address(), index);
    }

    @NativeType(value="ovrRecti[ovrEye_Count]")
    public OVRRecti.Buffer Viewport() {
        return OVRLayerEyeFovDepth.nViewport(this.address());
    }

    @NativeType(value="ovrRecti")
    public OVRRecti Viewport(int index) {
        return OVRLayerEyeFovDepth.nViewport(this.address(), index);
    }

    @NativeType(value="ovrFovPort[ovrEye_Count]")
    public OVRFovPort.Buffer Fov() {
        return OVRLayerEyeFovDepth.nFov(this.address());
    }

    @NativeType(value="ovrFovPort")
    public OVRFovPort Fov(int index) {
        return OVRLayerEyeFovDepth.nFov(this.address(), index);
    }

    @NativeType(value="ovrPosef[ovrEye_Count]")
    public OVRPosef.Buffer RenderPose() {
        return OVRLayerEyeFovDepth.nRenderPose(this.address());
    }

    @NativeType(value="ovrPosef")
    public OVRPosef RenderPose(int index) {
        return OVRLayerEyeFovDepth.nRenderPose(this.address(), index);
    }

    public double SensorSampleTime() {
        return OVRLayerEyeFovDepth.nSensorSampleTime(this.address());
    }

    @NativeType(value="ovrTextureSwapChain[ovrEye_Count]")
    public PointerBuffer DepthTexture() {
        return OVRLayerEyeFovDepth.nDepthTexture(this.address());
    }

    @NativeType(value="ovrTextureSwapChain")
    public long DepthTexture(int index) {
        return OVRLayerEyeFovDepth.nDepthTexture(this.address(), index);
    }

    @NativeType(value="ovrTimewarpProjectionDesc")
    public OVRTimewarpProjectionDesc ProjectionDesc() {
        return OVRLayerEyeFovDepth.nProjectionDesc(this.address());
    }

    public OVRLayerEyeFovDepth Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
        OVRLayerEyeFovDepth.nHeader(this.address(), value);
        return this;
    }

    public OVRLayerEyeFovDepth Header(Consumer<OVRLayerHeader> consumer) {
        consumer.accept(this.Header());
        return this;
    }

    public OVRLayerEyeFovDepth ColorTexture(@NativeType(value="ovrTextureSwapChain[ovrEye_Count]") PointerBuffer value) {
        OVRLayerEyeFovDepth.nColorTexture(this.address(), value);
        return this;
    }

    public OVRLayerEyeFovDepth ColorTexture(int index, @NativeType(value="ovrTextureSwapChain") long value) {
        OVRLayerEyeFovDepth.nColorTexture(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeFovDepth Viewport(@NativeType(value="ovrRecti[ovrEye_Count]") OVRRecti.Buffer value) {
        OVRLayerEyeFovDepth.nViewport(this.address(), value);
        return this;
    }

    public OVRLayerEyeFovDepth Viewport(int index, @NativeType(value="ovrRecti") OVRRecti value) {
        OVRLayerEyeFovDepth.nViewport(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeFovDepth Viewport(Consumer<OVRRecti.Buffer> consumer) {
        consumer.accept(this.Viewport());
        return this;
    }

    public OVRLayerEyeFovDepth Viewport(int index, Consumer<OVRRecti> consumer) {
        consumer.accept(this.Viewport(index));
        return this;
    }

    public OVRLayerEyeFovDepth Fov(@NativeType(value="ovrFovPort[ovrEye_Count]") OVRFovPort.Buffer value) {
        OVRLayerEyeFovDepth.nFov(this.address(), value);
        return this;
    }

    public OVRLayerEyeFovDepth Fov(int index, @NativeType(value="ovrFovPort") OVRFovPort value) {
        OVRLayerEyeFovDepth.nFov(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeFovDepth Fov(Consumer<OVRFovPort.Buffer> consumer) {
        consumer.accept(this.Fov());
        return this;
    }

    public OVRLayerEyeFovDepth Fov(int index, Consumer<OVRFovPort> consumer) {
        consumer.accept(this.Fov(index));
        return this;
    }

    public OVRLayerEyeFovDepth RenderPose(@NativeType(value="ovrPosef[ovrEye_Count]") OVRPosef.Buffer value) {
        OVRLayerEyeFovDepth.nRenderPose(this.address(), value);
        return this;
    }

    public OVRLayerEyeFovDepth RenderPose(int index, @NativeType(value="ovrPosef") OVRPosef value) {
        OVRLayerEyeFovDepth.nRenderPose(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeFovDepth RenderPose(Consumer<OVRPosef.Buffer> consumer) {
        consumer.accept(this.RenderPose());
        return this;
    }

    public OVRLayerEyeFovDepth RenderPose(int index, Consumer<OVRPosef> consumer) {
        consumer.accept(this.RenderPose(index));
        return this;
    }

    public OVRLayerEyeFovDepth SensorSampleTime(double value) {
        OVRLayerEyeFovDepth.nSensorSampleTime(this.address(), value);
        return this;
    }

    public OVRLayerEyeFovDepth DepthTexture(@NativeType(value="ovrTextureSwapChain[ovrEye_Count]") PointerBuffer value) {
        OVRLayerEyeFovDepth.nDepthTexture(this.address(), value);
        return this;
    }

    public OVRLayerEyeFovDepth DepthTexture(int index, @NativeType(value="ovrTextureSwapChain") long value) {
        OVRLayerEyeFovDepth.nDepthTexture(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeFovDepth ProjectionDesc(@NativeType(value="ovrTimewarpProjectionDesc") OVRTimewarpProjectionDesc value) {
        OVRLayerEyeFovDepth.nProjectionDesc(this.address(), value);
        return this;
    }

    public OVRLayerEyeFovDepth set(OVRLayerHeader Header, PointerBuffer ColorTexture, OVRRecti.Buffer Viewport, OVRFovPort.Buffer Fov, OVRPosef.Buffer RenderPose, double SensorSampleTime, PointerBuffer DepthTexture, OVRTimewarpProjectionDesc ProjectionDesc) {
        this.Header(Header);
        this.ColorTexture(ColorTexture);
        this.Viewport(Viewport);
        this.Fov(Fov);
        this.RenderPose(RenderPose);
        this.SensorSampleTime(SensorSampleTime);
        this.DepthTexture(DepthTexture);
        this.ProjectionDesc(ProjectionDesc);
        return this;
    }

    public OVRLayerEyeFovDepth set(OVRLayerEyeFovDepth src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRLayerEyeFovDepth malloc() {
        return new OVRLayerEyeFovDepth(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static OVRLayerEyeFovDepth calloc() {
        return new OVRLayerEyeFovDepth(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static OVRLayerEyeFovDepth create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new OVRLayerEyeFovDepth(MemoryUtil.memAddress(container), container);
    }

    public static OVRLayerEyeFovDepth create(long address) {
        return new OVRLayerEyeFovDepth(address, null);
    }

    public static @Nullable OVRLayerEyeFovDepth createSafe(long address) {
        return address == 0L ? null : new OVRLayerEyeFovDepth(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(OVRLayerEyeFovDepth.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRLayerEyeFovDepth.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRLayerEyeFovDepth mallocStack() {
        return OVRLayerEyeFovDepth.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRLayerEyeFovDepth callocStack() {
        return OVRLayerEyeFovDepth.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRLayerEyeFovDepth mallocStack(MemoryStack stack) {
        return OVRLayerEyeFovDepth.malloc(stack);
    }

    @Deprecated
    public static OVRLayerEyeFovDepth callocStack(MemoryStack stack) {
        return OVRLayerEyeFovDepth.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRLayerEyeFovDepth.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRLayerEyeFovDepth.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRLayerEyeFovDepth.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRLayerEyeFovDepth.calloc(capacity, stack);
    }

    public static OVRLayerEyeFovDepth malloc(MemoryStack stack) {
        return new OVRLayerEyeFovDepth(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRLayerEyeFovDepth calloc(MemoryStack stack) {
        return new OVRLayerEyeFovDepth(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OVRLayerHeader nHeader(long struct) {
        return OVRLayerHeader.create(struct + (long)HEADER);
    }

    public static PointerBuffer nColorTexture(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)COLORTEXTURE, 2);
    }

    public static long nColorTexture(long struct, int index) {
        return MemoryUtil.memGetAddress(struct + (long)COLORTEXTURE + Checks.check(index, 2) * (long)POINTER_SIZE);
    }

    public static OVRRecti.Buffer nViewport(long struct) {
        return OVRRecti.create(struct + (long)VIEWPORT, 2);
    }

    public static OVRRecti nViewport(long struct, int index) {
        return OVRRecti.create(struct + (long)VIEWPORT + Checks.check(index, 2) * (long)OVRRecti.SIZEOF);
    }

    public static OVRFovPort.Buffer nFov(long struct) {
        return OVRFovPort.create(struct + (long)FOV, 2);
    }

    public static OVRFovPort nFov(long struct, int index) {
        return OVRFovPort.create(struct + (long)FOV + Checks.check(index, 2) * (long)OVRFovPort.SIZEOF);
    }

    public static OVRPosef.Buffer nRenderPose(long struct) {
        return OVRPosef.create(struct + (long)RENDERPOSE, 2);
    }

    public static OVRPosef nRenderPose(long struct, int index) {
        return OVRPosef.create(struct + (long)RENDERPOSE + Checks.check(index, 2) * (long)OVRPosef.SIZEOF);
    }

    public static double nSensorSampleTime(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)SENSORSAMPLETIME);
    }

    public static PointerBuffer nDepthTexture(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)DEPTHTEXTURE, 2);
    }

    public static long nDepthTexture(long struct, int index) {
        return MemoryUtil.memGetAddress(struct + (long)DEPTHTEXTURE + Checks.check(index, 2) * (long)POINTER_SIZE);
    }

    public static OVRTimewarpProjectionDesc nProjectionDesc(long struct) {
        return OVRTimewarpProjectionDesc.create(struct + (long)PROJECTIONDESC);
    }

    public static void nHeader(long struct, OVRLayerHeader value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HEADER, OVRLayerHeader.SIZEOF);
    }

    public static void nColorTexture(long struct, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)COLORTEXTURE, value.remaining() * POINTER_SIZE);
    }

    public static void nColorTexture(long struct, int index, long value) {
        MemoryUtil.memPutAddress(struct + (long)COLORTEXTURE + Checks.check(index, 2) * (long)POINTER_SIZE, value);
    }

    public static void nViewport(long struct, OVRRecti.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)VIEWPORT, value.remaining() * OVRRecti.SIZEOF);
    }

    public static void nViewport(long struct, int index, OVRRecti value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VIEWPORT + Checks.check(index, 2) * (long)OVRRecti.SIZEOF, OVRRecti.SIZEOF);
    }

    public static void nFov(long struct, OVRFovPort.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)FOV, value.remaining() * OVRFovPort.SIZEOF);
    }

    public static void nFov(long struct, int index, OVRFovPort value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FOV + Checks.check(index, 2) * (long)OVRFovPort.SIZEOF, OVRFovPort.SIZEOF);
    }

    public static void nRenderPose(long struct, OVRPosef.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)RENDERPOSE, value.remaining() * OVRPosef.SIZEOF);
    }

    public static void nRenderPose(long struct, int index, OVRPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)RENDERPOSE + Checks.check(index, 2) * (long)OVRPosef.SIZEOF, OVRPosef.SIZEOF);
    }

    public static void nSensorSampleTime(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)SENSORSAMPLETIME, value);
    }

    public static void nDepthTexture(long struct, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)DEPTHTEXTURE, value.remaining() * POINTER_SIZE);
    }

    public static void nDepthTexture(long struct, int index, long value) {
        MemoryUtil.memPutAddress(struct + (long)DEPTHTEXTURE + Checks.check(index, 2) * (long)POINTER_SIZE, value);
    }

    public static void nProjectionDesc(long struct, OVRTimewarpProjectionDesc value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PROJECTIONDESC, OVRTimewarpProjectionDesc.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)COLORTEXTURE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)DEPTHTEXTURE));
    }

    static {
        Struct.Layout layout = OVRLayerEyeFovDepth.__struct(OVRLayerEyeFovDepth.__member(OVRLayerHeader.SIZEOF, OVRLayerHeader.ALIGNOF, true), OVRLayerEyeFovDepth.__array(POINTER_SIZE, 2), OVRLayerEyeFovDepth.__array(OVRRecti.SIZEOF, OVRRecti.ALIGNOF, 2), OVRLayerEyeFovDepth.__array(OVRFovPort.SIZEOF, OVRFovPort.ALIGNOF, 2), OVRLayerEyeFovDepth.__array(OVRPosef.SIZEOF, OVRPosef.ALIGNOF, 2), OVRLayerEyeFovDepth.__member(8), OVRLayerEyeFovDepth.__array(POINTER_SIZE, 2), OVRLayerEyeFovDepth.__member(OVRTimewarpProjectionDesc.SIZEOF, OVRTimewarpProjectionDesc.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEADER = layout.offsetof(0);
        COLORTEXTURE = layout.offsetof(1);
        VIEWPORT = layout.offsetof(2);
        FOV = layout.offsetof(3);
        RENDERPOSE = layout.offsetof(4);
        SENSORSAMPLETIME = layout.offsetof(5);
        DEPTHTEXTURE = layout.offsetof(6);
        PROJECTIONDESC = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<OVRLayerEyeFovDepth, Buffer>
    implements NativeResource {
        private static final OVRLayerEyeFovDepth ELEMENT_FACTORY = OVRLayerEyeFovDepth.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected OVRLayerEyeFovDepth getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ovrLayerHeader")
        public OVRLayerHeader Header() {
            return OVRLayerEyeFovDepth.nHeader(this.address());
        }

        @NativeType(value="ovrTextureSwapChain[ovrEye_Count]")
        public PointerBuffer ColorTexture() {
            return OVRLayerEyeFovDepth.nColorTexture(this.address());
        }

        @NativeType(value="ovrTextureSwapChain")
        public long ColorTexture(int index) {
            return OVRLayerEyeFovDepth.nColorTexture(this.address(), index);
        }

        @NativeType(value="ovrRecti[ovrEye_Count]")
        public OVRRecti.Buffer Viewport() {
            return OVRLayerEyeFovDepth.nViewport(this.address());
        }

        @NativeType(value="ovrRecti")
        public OVRRecti Viewport(int index) {
            return OVRLayerEyeFovDepth.nViewport(this.address(), index);
        }

        @NativeType(value="ovrFovPort[ovrEye_Count]")
        public OVRFovPort.Buffer Fov() {
            return OVRLayerEyeFovDepth.nFov(this.address());
        }

        @NativeType(value="ovrFovPort")
        public OVRFovPort Fov(int index) {
            return OVRLayerEyeFovDepth.nFov(this.address(), index);
        }

        @NativeType(value="ovrPosef[ovrEye_Count]")
        public OVRPosef.Buffer RenderPose() {
            return OVRLayerEyeFovDepth.nRenderPose(this.address());
        }

        @NativeType(value="ovrPosef")
        public OVRPosef RenderPose(int index) {
            return OVRLayerEyeFovDepth.nRenderPose(this.address(), index);
        }

        public double SensorSampleTime() {
            return OVRLayerEyeFovDepth.nSensorSampleTime(this.address());
        }

        @NativeType(value="ovrTextureSwapChain[ovrEye_Count]")
        public PointerBuffer DepthTexture() {
            return OVRLayerEyeFovDepth.nDepthTexture(this.address());
        }

        @NativeType(value="ovrTextureSwapChain")
        public long DepthTexture(int index) {
            return OVRLayerEyeFovDepth.nDepthTexture(this.address(), index);
        }

        @NativeType(value="ovrTimewarpProjectionDesc")
        public OVRTimewarpProjectionDesc ProjectionDesc() {
            return OVRLayerEyeFovDepth.nProjectionDesc(this.address());
        }

        public Buffer Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
            OVRLayerEyeFovDepth.nHeader(this.address(), value);
            return this;
        }

        public Buffer Header(Consumer<OVRLayerHeader> consumer) {
            consumer.accept(this.Header());
            return this;
        }

        public Buffer ColorTexture(@NativeType(value="ovrTextureSwapChain[ovrEye_Count]") PointerBuffer value) {
            OVRLayerEyeFovDepth.nColorTexture(this.address(), value);
            return this;
        }

        public Buffer ColorTexture(int index, @NativeType(value="ovrTextureSwapChain") long value) {
            OVRLayerEyeFovDepth.nColorTexture(this.address(), index, value);
            return this;
        }

        public Buffer Viewport(@NativeType(value="ovrRecti[ovrEye_Count]") OVRRecti.Buffer value) {
            OVRLayerEyeFovDepth.nViewport(this.address(), value);
            return this;
        }

        public Buffer Viewport(int index, @NativeType(value="ovrRecti") OVRRecti value) {
            OVRLayerEyeFovDepth.nViewport(this.address(), index, value);
            return this;
        }

        public Buffer Viewport(Consumer<OVRRecti.Buffer> consumer) {
            consumer.accept(this.Viewport());
            return this;
        }

        public Buffer Viewport(int index, Consumer<OVRRecti> consumer) {
            consumer.accept(this.Viewport(index));
            return this;
        }

        public Buffer Fov(@NativeType(value="ovrFovPort[ovrEye_Count]") OVRFovPort.Buffer value) {
            OVRLayerEyeFovDepth.nFov(this.address(), value);
            return this;
        }

        public Buffer Fov(int index, @NativeType(value="ovrFovPort") OVRFovPort value) {
            OVRLayerEyeFovDepth.nFov(this.address(), index, value);
            return this;
        }

        public Buffer Fov(Consumer<OVRFovPort.Buffer> consumer) {
            consumer.accept(this.Fov());
            return this;
        }

        public Buffer Fov(int index, Consumer<OVRFovPort> consumer) {
            consumer.accept(this.Fov(index));
            return this;
        }

        public Buffer RenderPose(@NativeType(value="ovrPosef[ovrEye_Count]") OVRPosef.Buffer value) {
            OVRLayerEyeFovDepth.nRenderPose(this.address(), value);
            return this;
        }

        public Buffer RenderPose(int index, @NativeType(value="ovrPosef") OVRPosef value) {
            OVRLayerEyeFovDepth.nRenderPose(this.address(), index, value);
            return this;
        }

        public Buffer RenderPose(Consumer<OVRPosef.Buffer> consumer) {
            consumer.accept(this.RenderPose());
            return this;
        }

        public Buffer RenderPose(int index, Consumer<OVRPosef> consumer) {
            consumer.accept(this.RenderPose(index));
            return this;
        }

        public Buffer SensorSampleTime(double value) {
            OVRLayerEyeFovDepth.nSensorSampleTime(this.address(), value);
            return this;
        }

        public Buffer DepthTexture(@NativeType(value="ovrTextureSwapChain[ovrEye_Count]") PointerBuffer value) {
            OVRLayerEyeFovDepth.nDepthTexture(this.address(), value);
            return this;
        }

        public Buffer DepthTexture(int index, @NativeType(value="ovrTextureSwapChain") long value) {
            OVRLayerEyeFovDepth.nDepthTexture(this.address(), index, value);
            return this;
        }

        public Buffer ProjectionDesc(@NativeType(value="ovrTimewarpProjectionDesc") OVRTimewarpProjectionDesc value) {
            OVRLayerEyeFovDepth.nProjectionDesc(this.address(), value);
            return this;
        }
    }
}

