/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRLayerCube;
import org.lwjgl.ovr.OVRLayerCylinder;
import org.lwjgl.ovr.OVRLayerEyeFov;
import org.lwjgl.ovr.OVRLayerEyeFovDepth;
import org.lwjgl.ovr.OVRLayerEyeFovMultires;
import org.lwjgl.ovr.OVRLayerEyeMatrix;
import org.lwjgl.ovr.OVRLayerHeader;
import org.lwjgl.ovr.OVRLayerQuad;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="union ovrLayer_Union")
public class OVRLayerUnion
extends Struct<OVRLayerUnion>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEADER;
    public static final int EYEFOV;
    public static final int EYEFOVDEPTH;
    public static final int EYEMATRIX;
    public static final int MULTIRES;
    public static final int CYLINDER;
    public static final int CUBE;
    public static final int QUAD;

    protected OVRLayerUnion(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected OVRLayerUnion create(long address, @Nullable ByteBuffer container) {
        return new OVRLayerUnion(address, container);
    }

    public OVRLayerUnion(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), OVRLayerUnion.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrLayerHeader")
    public OVRLayerHeader Header() {
        return OVRLayerUnion.nHeader(this.address());
    }

    @NativeType(value="ovrLayerEyeFov")
    public OVRLayerEyeFov EyeFov() {
        return OVRLayerUnion.nEyeFov(this.address());
    }

    @NativeType(value="ovrLayerEyeFovDepth")
    public OVRLayerEyeFovDepth EyeFovDepth() {
        return OVRLayerUnion.nEyeFovDepth(this.address());
    }

    @NativeType(value="ovrLayerEyeMatrix")
    public OVRLayerEyeMatrix EyeMatrix() {
        return OVRLayerUnion.nEyeMatrix(this.address());
    }

    @NativeType(value="ovrLayerEyeFovMultires")
    public OVRLayerEyeFovMultires Multires() {
        return OVRLayerUnion.nMultires(this.address());
    }

    @NativeType(value="ovrLayerCylinder")
    public OVRLayerCylinder Cylinder() {
        return OVRLayerUnion.nCylinder(this.address());
    }

    @NativeType(value="ovrLayerCube")
    public OVRLayerCube Cube() {
        return OVRLayerUnion.nCube(this.address());
    }

    @NativeType(value="ovrLayerQuad")
    public OVRLayerQuad Quad() {
        return OVRLayerUnion.nQuad(this.address());
    }

    public OVRLayerUnion Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
        OVRLayerUnion.nHeader(this.address(), value);
        return this;
    }

    public OVRLayerUnion Header(Consumer<OVRLayerHeader> consumer) {
        consumer.accept(this.Header());
        return this;
    }

    public OVRLayerUnion EyeFov(@NativeType(value="ovrLayerEyeFov") OVRLayerEyeFov value) {
        OVRLayerUnion.nEyeFov(this.address(), value);
        return this;
    }

    public OVRLayerUnion EyeFov(Consumer<OVRLayerEyeFov> consumer) {
        consumer.accept(this.EyeFov());
        return this;
    }

    public OVRLayerUnion EyeFovDepth(@NativeType(value="ovrLayerEyeFovDepth") OVRLayerEyeFovDepth value) {
        OVRLayerUnion.nEyeFovDepth(this.address(), value);
        return this;
    }

    public OVRLayerUnion EyeFovDepth(Consumer<OVRLayerEyeFovDepth> consumer) {
        consumer.accept(this.EyeFovDepth());
        return this;
    }

    public OVRLayerUnion EyeMatrix(@NativeType(value="ovrLayerEyeMatrix") OVRLayerEyeMatrix value) {
        OVRLayerUnion.nEyeMatrix(this.address(), value);
        return this;
    }

    public OVRLayerUnion EyeMatrix(Consumer<OVRLayerEyeMatrix> consumer) {
        consumer.accept(this.EyeMatrix());
        return this;
    }

    public OVRLayerUnion Multires(@NativeType(value="ovrLayerEyeFovMultires") OVRLayerEyeFovMultires value) {
        OVRLayerUnion.nMultires(this.address(), value);
        return this;
    }

    public OVRLayerUnion Multires(Consumer<OVRLayerEyeFovMultires> consumer) {
        consumer.accept(this.Multires());
        return this;
    }

    public OVRLayerUnion Cylinder(@NativeType(value="ovrLayerCylinder") OVRLayerCylinder value) {
        OVRLayerUnion.nCylinder(this.address(), value);
        return this;
    }

    public OVRLayerUnion Cylinder(Consumer<OVRLayerCylinder> consumer) {
        consumer.accept(this.Cylinder());
        return this;
    }

    public OVRLayerUnion Cube(@NativeType(value="ovrLayerCube") OVRLayerCube value) {
        OVRLayerUnion.nCube(this.address(), value);
        return this;
    }

    public OVRLayerUnion Cube(Consumer<OVRLayerCube> consumer) {
        consumer.accept(this.Cube());
        return this;
    }

    public OVRLayerUnion Quad(@NativeType(value="ovrLayerQuad") OVRLayerQuad value) {
        OVRLayerUnion.nQuad(this.address(), value);
        return this;
    }

    public OVRLayerUnion Quad(Consumer<OVRLayerQuad> consumer) {
        consumer.accept(this.Quad());
        return this;
    }

    public OVRLayerUnion set(OVRLayerUnion src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRLayerUnion malloc() {
        return new OVRLayerUnion(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static OVRLayerUnion calloc() {
        return new OVRLayerUnion(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static OVRLayerUnion create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new OVRLayerUnion(MemoryUtil.memAddress(container), container);
    }

    public static OVRLayerUnion create(long address) {
        return new OVRLayerUnion(address, null);
    }

    public static @Nullable OVRLayerUnion createSafe(long address) {
        return address == 0L ? null : new OVRLayerUnion(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(OVRLayerUnion.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRLayerUnion.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRLayerUnion mallocStack() {
        return OVRLayerUnion.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRLayerUnion callocStack() {
        return OVRLayerUnion.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRLayerUnion mallocStack(MemoryStack stack) {
        return OVRLayerUnion.malloc(stack);
    }

    @Deprecated
    public static OVRLayerUnion callocStack(MemoryStack stack) {
        return OVRLayerUnion.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRLayerUnion.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRLayerUnion.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRLayerUnion.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRLayerUnion.calloc(capacity, stack);
    }

    public static OVRLayerUnion malloc(MemoryStack stack) {
        return new OVRLayerUnion(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRLayerUnion calloc(MemoryStack stack) {
        return new OVRLayerUnion(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OVRLayerHeader nHeader(long struct) {
        return OVRLayerHeader.create(struct + (long)HEADER);
    }

    public static OVRLayerEyeFov nEyeFov(long struct) {
        return OVRLayerEyeFov.create(struct + (long)EYEFOV);
    }

    public static OVRLayerEyeFovDepth nEyeFovDepth(long struct) {
        return OVRLayerEyeFovDepth.create(struct + (long)EYEFOVDEPTH);
    }

    public static OVRLayerEyeMatrix nEyeMatrix(long struct) {
        return OVRLayerEyeMatrix.create(struct + (long)EYEMATRIX);
    }

    public static OVRLayerEyeFovMultires nMultires(long struct) {
        return OVRLayerEyeFovMultires.create(struct + (long)MULTIRES);
    }

    public static OVRLayerCylinder nCylinder(long struct) {
        return OVRLayerCylinder.create(struct + (long)CYLINDER);
    }

    public static OVRLayerCube nCube(long struct) {
        return OVRLayerCube.create(struct + (long)CUBE);
    }

    public static OVRLayerQuad nQuad(long struct) {
        return OVRLayerQuad.create(struct + (long)QUAD);
    }

    public static void nHeader(long struct, OVRLayerHeader value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HEADER, OVRLayerHeader.SIZEOF);
    }

    public static void nEyeFov(long struct, OVRLayerEyeFov value) {
        MemoryUtil.memCopy(value.address(), struct + (long)EYEFOV, OVRLayerEyeFov.SIZEOF);
    }

    public static void nEyeFovDepth(long struct, OVRLayerEyeFovDepth value) {
        MemoryUtil.memCopy(value.address(), struct + (long)EYEFOVDEPTH, OVRLayerEyeFovDepth.SIZEOF);
    }

    public static void nEyeMatrix(long struct, OVRLayerEyeMatrix value) {
        MemoryUtil.memCopy(value.address(), struct + (long)EYEMATRIX, OVRLayerEyeMatrix.SIZEOF);
    }

    public static void nMultires(long struct, OVRLayerEyeFovMultires value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MULTIRES, OVRLayerEyeFovMultires.SIZEOF);
    }

    public static void nCylinder(long struct, OVRLayerCylinder value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CYLINDER, OVRLayerCylinder.SIZEOF);
    }

    public static void nCube(long struct, OVRLayerCube value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CUBE, OVRLayerCube.SIZEOF);
    }

    public static void nQuad(long struct, OVRLayerQuad value) {
        MemoryUtil.memCopy(value.address(), struct + (long)QUAD, OVRLayerQuad.SIZEOF);
    }

    static {
        Struct.Layout layout = OVRLayerUnion.__union(OVRLayerUnion.__member(OVRLayerHeader.SIZEOF, OVRLayerHeader.ALIGNOF, true), OVRLayerUnion.__member(OVRLayerEyeFov.SIZEOF, OVRLayerEyeFov.ALIGNOF), OVRLayerUnion.__member(OVRLayerEyeFovDepth.SIZEOF, OVRLayerEyeFovDepth.ALIGNOF), OVRLayerUnion.__member(OVRLayerEyeMatrix.SIZEOF, OVRLayerEyeMatrix.ALIGNOF), OVRLayerUnion.__member(OVRLayerEyeFovMultires.SIZEOF, OVRLayerEyeFovMultires.ALIGNOF), OVRLayerUnion.__member(OVRLayerCylinder.SIZEOF, OVRLayerCylinder.ALIGNOF), OVRLayerUnion.__member(OVRLayerCube.SIZEOF, OVRLayerCube.ALIGNOF), OVRLayerUnion.__member(OVRLayerQuad.SIZEOF, OVRLayerQuad.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEADER = layout.offsetof(0);
        EYEFOV = layout.offsetof(1);
        EYEFOVDEPTH = layout.offsetof(2);
        EYEMATRIX = layout.offsetof(3);
        MULTIRES = layout.offsetof(4);
        CYLINDER = layout.offsetof(5);
        CUBE = layout.offsetof(6);
        QUAD = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<OVRLayerUnion, Buffer>
    implements NativeResource {
        private static final OVRLayerUnion ELEMENT_FACTORY = OVRLayerUnion.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected OVRLayerUnion getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ovrLayerHeader")
        public OVRLayerHeader Header() {
            return OVRLayerUnion.nHeader(this.address());
        }

        @NativeType(value="ovrLayerEyeFov")
        public OVRLayerEyeFov EyeFov() {
            return OVRLayerUnion.nEyeFov(this.address());
        }

        @NativeType(value="ovrLayerEyeFovDepth")
        public OVRLayerEyeFovDepth EyeFovDepth() {
            return OVRLayerUnion.nEyeFovDepth(this.address());
        }

        @NativeType(value="ovrLayerEyeMatrix")
        public OVRLayerEyeMatrix EyeMatrix() {
            return OVRLayerUnion.nEyeMatrix(this.address());
        }

        @NativeType(value="ovrLayerEyeFovMultires")
        public OVRLayerEyeFovMultires Multires() {
            return OVRLayerUnion.nMultires(this.address());
        }

        @NativeType(value="ovrLayerCylinder")
        public OVRLayerCylinder Cylinder() {
            return OVRLayerUnion.nCylinder(this.address());
        }

        @NativeType(value="ovrLayerCube")
        public OVRLayerCube Cube() {
            return OVRLayerUnion.nCube(this.address());
        }

        @NativeType(value="ovrLayerQuad")
        public OVRLayerQuad Quad() {
            return OVRLayerUnion.nQuad(this.address());
        }

        public Buffer Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
            OVRLayerUnion.nHeader(this.address(), value);
            return this;
        }

        public Buffer Header(Consumer<OVRLayerHeader> consumer) {
            consumer.accept(this.Header());
            return this;
        }

        public Buffer EyeFov(@NativeType(value="ovrLayerEyeFov") OVRLayerEyeFov value) {
            OVRLayerUnion.nEyeFov(this.address(), value);
            return this;
        }

        public Buffer EyeFov(Consumer<OVRLayerEyeFov> consumer) {
            consumer.accept(this.EyeFov());
            return this;
        }

        public Buffer EyeFovDepth(@NativeType(value="ovrLayerEyeFovDepth") OVRLayerEyeFovDepth value) {
            OVRLayerUnion.nEyeFovDepth(this.address(), value);
            return this;
        }

        public Buffer EyeFovDepth(Consumer<OVRLayerEyeFovDepth> consumer) {
            consumer.accept(this.EyeFovDepth());
            return this;
        }

        public Buffer EyeMatrix(@NativeType(value="ovrLayerEyeMatrix") OVRLayerEyeMatrix value) {
            OVRLayerUnion.nEyeMatrix(this.address(), value);
            return this;
        }

        public Buffer EyeMatrix(Consumer<OVRLayerEyeMatrix> consumer) {
            consumer.accept(this.EyeMatrix());
            return this;
        }

        public Buffer Multires(@NativeType(value="ovrLayerEyeFovMultires") OVRLayerEyeFovMultires value) {
            OVRLayerUnion.nMultires(this.address(), value);
            return this;
        }

        public Buffer Multires(Consumer<OVRLayerEyeFovMultires> consumer) {
            consumer.accept(this.Multires());
            return this;
        }

        public Buffer Cylinder(@NativeType(value="ovrLayerCylinder") OVRLayerCylinder value) {
            OVRLayerUnion.nCylinder(this.address(), value);
            return this;
        }

        public Buffer Cylinder(Consumer<OVRLayerCylinder> consumer) {
            consumer.accept(this.Cylinder());
            return this;
        }

        public Buffer Cube(@NativeType(value="ovrLayerCube") OVRLayerCube value) {
            OVRLayerUnion.nCube(this.address(), value);
            return this;
        }

        public Buffer Cube(Consumer<OVRLayerCube> consumer) {
            consumer.accept(this.Cube());
            return this;
        }

        public Buffer Quad(@NativeType(value="ovrLayerQuad") OVRLayerQuad value) {
            OVRLayerUnion.nQuad(this.address(), value);
            return this;
        }

        public Buffer Quad(Consumer<OVRLayerQuad> consumer) {
            consumer.accept(this.Quad());
            return this;
        }
    }
}

