/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrVector2f")
public class OVRVector2f
extends Struct<OVRVector2f>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    protected OVRVector2f(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected OVRVector2f create(long address, @Nullable ByteBuffer container) {
        return new OVRVector2f(address, container);
    }

    public OVRVector2f(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), OVRVector2f.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return OVRVector2f.nx(this.address());
    }

    public float y() {
        return OVRVector2f.ny(this.address());
    }

    public OVRVector2f x(float value) {
        OVRVector2f.nx(this.address(), value);
        return this;
    }

    public OVRVector2f y(float value) {
        OVRVector2f.ny(this.address(), value);
        return this;
    }

    public OVRVector2f set(float x, float y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public OVRVector2f set(OVRVector2f src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRVector2f malloc() {
        return new OVRVector2f(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static OVRVector2f calloc() {
        return new OVRVector2f(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static OVRVector2f create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new OVRVector2f(MemoryUtil.memAddress(container), container);
    }

    public static OVRVector2f create(long address) {
        return new OVRVector2f(address, null);
    }

    public static @Nullable OVRVector2f createSafe(long address) {
        return address == 0L ? null : new OVRVector2f(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(OVRVector2f.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRVector2f.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRVector2f mallocStack() {
        return OVRVector2f.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRVector2f callocStack() {
        return OVRVector2f.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRVector2f mallocStack(MemoryStack stack) {
        return OVRVector2f.malloc(stack);
    }

    @Deprecated
    public static OVRVector2f callocStack(MemoryStack stack) {
        return OVRVector2f.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRVector2f.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRVector2f.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRVector2f.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRVector2f.calloc(capacity, stack);
    }

    public static OVRVector2f malloc(MemoryStack stack) {
        return new OVRVector2f(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRVector2f calloc(MemoryStack stack) {
        return new OVRVector2f(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = OVRVector2f.__struct(OVRVector2f.__member(4), OVRVector2f.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<OVRVector2f, Buffer>
    implements NativeResource {
        private static final OVRVector2f ELEMENT_FACTORY = OVRVector2f.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected OVRVector2f getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return OVRVector2f.nx(this.address());
        }

        public float y() {
            return OVRVector2f.ny(this.address());
        }

        public Buffer x(float value) {
            OVRVector2f.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            OVRVector2f.ny(this.address(), value);
            return this;
        }
    }
}

