/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrVector3f")
public class OVRVector3f
extends Struct<OVRVector3f>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int Z;

    protected OVRVector3f(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected OVRVector3f create(long address, @Nullable ByteBuffer container) {
        return new OVRVector3f(address, container);
    }

    public OVRVector3f(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), OVRVector3f.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return OVRVector3f.nx(this.address());
    }

    public float y() {
        return OVRVector3f.ny(this.address());
    }

    public float z() {
        return OVRVector3f.nz(this.address());
    }

    public OVRVector3f x(float value) {
        OVRVector3f.nx(this.address(), value);
        return this;
    }

    public OVRVector3f y(float value) {
        OVRVector3f.ny(this.address(), value);
        return this;
    }

    public OVRVector3f z(float value) {
        OVRVector3f.nz(this.address(), value);
        return this;
    }

    public OVRVector3f set(float x, float y, float z) {
        this.x(x);
        this.y(y);
        this.z(z);
        return this;
    }

    public OVRVector3f set(OVRVector3f src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRVector3f malloc() {
        return new OVRVector3f(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static OVRVector3f calloc() {
        return new OVRVector3f(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static OVRVector3f create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new OVRVector3f(MemoryUtil.memAddress(container), container);
    }

    public static OVRVector3f create(long address) {
        return new OVRVector3f(address, null);
    }

    public static @Nullable OVRVector3f createSafe(long address) {
        return address == 0L ? null : new OVRVector3f(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(OVRVector3f.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRVector3f.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRVector3f mallocStack() {
        return OVRVector3f.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRVector3f callocStack() {
        return OVRVector3f.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRVector3f mallocStack(MemoryStack stack) {
        return OVRVector3f.malloc(stack);
    }

    @Deprecated
    public static OVRVector3f callocStack(MemoryStack stack) {
        return OVRVector3f.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRVector3f.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRVector3f.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRVector3f.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRVector3f.calloc(capacity, stack);
    }

    public static OVRVector3f malloc(MemoryStack stack) {
        return new OVRVector3f(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRVector3f calloc(MemoryStack stack) {
        return new OVRVector3f(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static float nz(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Z);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    public static void nz(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Z, value);
    }

    static {
        Struct.Layout layout = OVRVector3f.__struct(OVRVector3f.__member(4), OVRVector3f.__member(4), OVRVector3f.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        Z = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<OVRVector3f, Buffer>
    implements NativeResource {
        private static final OVRVector3f ELEMENT_FACTORY = OVRVector3f.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected OVRVector3f getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return OVRVector3f.nx(this.address());
        }

        public float y() {
            return OVRVector3f.ny(this.address());
        }

        public float z() {
            return OVRVector3f.nz(this.address());
        }

        public Buffer x(float value) {
            OVRVector3f.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            OVRVector3f.ny(this.address(), value);
            return this;
        }

        public Buffer z(float value) {
            OVRVector3f.nz(this.address(), value);
            return this;
        }
    }
}

