/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.rpmalloc;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.rpmalloc.LibRPmalloc;
import org.lwjgl.system.rpmalloc.RPMallocConfig;
import org.lwjgl.system.rpmalloc.RPmallocGlobalStatistics;
import org.lwjgl.system.rpmalloc.RPmallocThreadStatistics;

public class RPmalloc {
    public static final int RPMALLOC_NO_PRESERVE = 1;
    public static final int RPMALLOC_GROW_OR_FAIL = 2;

    protected RPmalloc() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="void *")
    static native long rpmalloc_address();

    @NativeType(value="void *")
    static native long rpcalloc_address();

    @NativeType(value="void *")
    static native long rprealloc_address();

    @NativeType(value="void *")
    static native long rpfree_address();

    @NativeType(value="void *")
    static native long rpaligned_alloc_address();

    public static native int nrpmalloc_initialize();

    @NativeType(value="int")
    public static boolean rpmalloc_initialize() {
        return RPmalloc.nrpmalloc_initialize() != 0;
    }

    public static native int nrpmalloc_initialize_config(long var0);

    @NativeType(value="int")
    public static boolean rpmalloc_initialize_config(@NativeType(value="rpmalloc_config_t const *") @Nullable RPMallocConfig config) {
        return RPmalloc.nrpmalloc_initialize_config(MemoryUtil.memAddressSafe(config)) != 0;
    }

    public static native long nrpmalloc_config();

    @NativeType(value="rpmalloc_config_t const *")
    public static RPMallocConfig rpmalloc_config() {
        long __result = RPmalloc.nrpmalloc_config();
        return RPMallocConfig.create(__result);
    }

    public static native void rpmalloc_finalize();

    public static native void rpmalloc_thread_initialize();

    public static native void nrpmalloc_thread_finalize(int var0);

    public static void rpmalloc_thread_finalize(@NativeType(value="int") boolean release_caches) {
        RPmalloc.nrpmalloc_thread_finalize(release_caches ? 1 : 0);
    }

    public static native void rpmalloc_thread_collect();

    public static native int nrpmalloc_is_thread_initialized();

    @NativeType(value="int")
    public static boolean rpmalloc_is_thread_initialized() {
        return RPmalloc.nrpmalloc_is_thread_initialized() != 0;
    }

    public static native void nrpmalloc_thread_statistics(long var0);

    public static void rpmalloc_thread_statistics(@NativeType(value="rpmalloc_thread_statistics_t *") RPmallocThreadStatistics stats) {
        RPmalloc.nrpmalloc_thread_statistics(stats.address());
    }

    public static native void nrpmalloc_global_statistics(long var0);

    public static void rpmalloc_global_statistics(@NativeType(value="rpmalloc_global_statistics_t *") RPmallocGlobalStatistics stats) {
        RPmalloc.nrpmalloc_global_statistics(stats.address());
    }

    public static native long nrpmalloc(long var0);

    @NativeType(value="void *")
    public static @Nullable ByteBuffer rpmalloc(@NativeType(value="size_t") long size) {
        long __result = RPmalloc.nrpmalloc(size);
        return MemoryUtil.memByteBufferSafe(__result, (int)size);
    }

    public static native void nrpfree(long var0);

    public static void rpfree(@NativeType(value="void *") @Nullable ByteBuffer ptr) {
        RPmalloc.nrpfree(MemoryUtil.memAddressSafe(ptr));
    }

    public static void rpfree(@NativeType(value="void *") @Nullable ShortBuffer ptr) {
        RPmalloc.nrpfree(MemoryUtil.memAddressSafe(ptr));
    }

    public static void rpfree(@NativeType(value="void *") @Nullable IntBuffer ptr) {
        RPmalloc.nrpfree(MemoryUtil.memAddressSafe(ptr));
    }

    public static void rpfree(@NativeType(value="void *") @Nullable LongBuffer ptr) {
        RPmalloc.nrpfree(MemoryUtil.memAddressSafe(ptr));
    }

    public static void rpfree(@NativeType(value="void *") @Nullable FloatBuffer ptr) {
        RPmalloc.nrpfree(MemoryUtil.memAddressSafe(ptr));
    }

    public static void rpfree(@NativeType(value="void *") @Nullable DoubleBuffer ptr) {
        RPmalloc.nrpfree(MemoryUtil.memAddressSafe(ptr));
    }

    public static void rpfree(@NativeType(value="void *") @Nullable PointerBuffer ptr) {
        RPmalloc.nrpfree(MemoryUtil.memAddressSafe(ptr));
    }

    public static native long nrpcalloc(long var0, long var2);

    @NativeType(value="void *")
    public static @Nullable ByteBuffer rpcalloc(@NativeType(value="size_t") long num, @NativeType(value="size_t") long size) {
        long __result = RPmalloc.nrpcalloc(num, size);
        return MemoryUtil.memByteBufferSafe(__result, (int)num * (int)size);
    }

    public static native long nrprealloc(long var0, long var2);

    @NativeType(value="void *")
    public static @Nullable ByteBuffer rprealloc(@NativeType(value="void *") @Nullable ByteBuffer ptr, @NativeType(value="size_t") long size) {
        long __result = RPmalloc.nrprealloc(MemoryUtil.memAddressSafe(ptr), size);
        return MemoryUtil.memByteBufferSafe(__result, (int)size);
    }

    public static native long nrpaligned_realloc(long var0, long var2, long var4, long var6, int var8);

    @NativeType(value="void *")
    public static @Nullable ByteBuffer rpaligned_realloc(@NativeType(value="void *") @Nullable ByteBuffer ptr, @NativeType(value="size_t") long alignment, @NativeType(value="size_t") long size, @NativeType(value="unsigned int") int flags) {
        long __result = RPmalloc.nrpaligned_realloc(MemoryUtil.memAddressSafe(ptr), alignment, size, Checks.remainingSafe(ptr), flags);
        return MemoryUtil.memByteBufferSafe(__result, (int)size);
    }

    public static native long nrpaligned_alloc(long var0, long var2);

    @NativeType(value="void *")
    public static @Nullable ByteBuffer rpaligned_alloc(@NativeType(value="size_t") long alignment, @NativeType(value="size_t") long size) {
        long __result = RPmalloc.nrpaligned_alloc(alignment, size);
        return MemoryUtil.memByteBufferSafe(__result, (int)size);
    }

    public static native long nrpaligned_calloc(long var0, long var2, long var4);

    @NativeType(value="void *")
    public static @Nullable ByteBuffer rpaligned_calloc(@NativeType(value="size_t") long alignment, @NativeType(value="size_t") long num, @NativeType(value="size_t") long size) {
        long __result = RPmalloc.nrpaligned_calloc(alignment, num, size);
        return MemoryUtil.memByteBufferSafe(__result, (int)num * (int)size);
    }

    public static native long nrpmemalign(long var0, long var2);

    @NativeType(value="void *")
    public static @Nullable ByteBuffer rpmemalign(@NativeType(value="size_t") long alignment, @NativeType(value="size_t") long size) {
        long __result = RPmalloc.nrpmemalign(alignment, size);
        return MemoryUtil.memByteBufferSafe(__result, (int)size);
    }

    public static native int nrpposix_memalign(long var0, long var2, long var4);

    public static int rpposix_memalign(@NativeType(value="void **") PointerBuffer memptr, @NativeType(value="size_t") long alignment, @NativeType(value="size_t") long size) {
        if (Checks.CHECKS) {
            Checks.check(memptr, 1);
        }
        return RPmalloc.nrpposix_memalign(MemoryUtil.memAddress(memptr), alignment, size);
    }

    public static native long nrpmalloc_usable_size(long var0);

    @NativeType(value="size_t")
    public static long rpmalloc_usable_size(@NativeType(value="void *") ByteBuffer ptr) {
        return RPmalloc.nrpmalloc_usable_size(MemoryUtil.memAddress(ptr));
    }

    @NativeType(value="size_t")
    public static long rpmalloc_usable_size(@NativeType(value="void *") ShortBuffer ptr) {
        return RPmalloc.nrpmalloc_usable_size(MemoryUtil.memAddress(ptr));
    }

    @NativeType(value="size_t")
    public static long rpmalloc_usable_size(@NativeType(value="void *") IntBuffer ptr) {
        return RPmalloc.nrpmalloc_usable_size(MemoryUtil.memAddress(ptr));
    }

    @NativeType(value="size_t")
    public static long rpmalloc_usable_size(@NativeType(value="void *") LongBuffer ptr) {
        return RPmalloc.nrpmalloc_usable_size(MemoryUtil.memAddress(ptr));
    }

    @NativeType(value="size_t")
    public static long rpmalloc_usable_size(@NativeType(value="void *") FloatBuffer ptr) {
        return RPmalloc.nrpmalloc_usable_size(MemoryUtil.memAddress(ptr));
    }

    @NativeType(value="size_t")
    public static long rpmalloc_usable_size(@NativeType(value="void *") DoubleBuffer ptr) {
        return RPmalloc.nrpmalloc_usable_size(MemoryUtil.memAddress(ptr));
    }

    @NativeType(value="size_t")
    public static long rpmalloc_usable_size(@NativeType(value="void *") PointerBuffer ptr) {
        return RPmalloc.nrpmalloc_usable_size(MemoryUtil.memAddress(ptr));
    }

    @NativeType(value="rpmalloc_heap_t *")
    public static native long rpmalloc_heap_acquire();

    public static native void rpmalloc_heap_release(@NativeType(value="rpmalloc_heap_t *") long var0);

    public static native long nrpmalloc_heap_alloc(long var0, long var2);

    @NativeType(value="void *")
    public static @Nullable ByteBuffer rpmalloc_heap_alloc(@NativeType(value="rpmalloc_heap_t *") long heap, @NativeType(value="size_t") long size) {
        if (Checks.CHECKS) {
            Checks.check(heap);
        }
        long __result = RPmalloc.nrpmalloc_heap_alloc(heap, size);
        return MemoryUtil.memByteBufferSafe(__result, (int)size);
    }

    public static native long nrpmalloc_heap_aligned_alloc(long var0, long var2, long var4);

    @NativeType(value="void *")
    public static @Nullable ByteBuffer rpmalloc_heap_aligned_alloc(@NativeType(value="rpmalloc_heap_t *") long heap, @NativeType(value="size_t") long alignment, @NativeType(value="size_t") long size) {
        if (Checks.CHECKS) {
            Checks.check(heap);
        }
        long __result = RPmalloc.nrpmalloc_heap_aligned_alloc(heap, alignment, size);
        return MemoryUtil.memByteBufferSafe(__result, (int)size);
    }

    public static native long nrpmalloc_heap_calloc(long var0, long var2, long var4);

    @NativeType(value="void *")
    public static @Nullable ByteBuffer rpmalloc_heap_calloc(@NativeType(value="rpmalloc_heap_t *") long heap, @NativeType(value="size_t") long num, @NativeType(value="size_t") long size) {
        if (Checks.CHECKS) {
            Checks.check(heap);
        }
        long __result = RPmalloc.nrpmalloc_heap_calloc(heap, num, size);
        return MemoryUtil.memByteBufferSafe(__result, (int)num * (int)size);
    }

    public static native long nrpmalloc_heap_aligned_calloc(long var0, long var2, long var4, long var6);

    @NativeType(value="void *")
    public static @Nullable ByteBuffer rpmalloc_heap_aligned_calloc(@NativeType(value="rpmalloc_heap_t *") long heap, @NativeType(value="size_t") long alignment, @NativeType(value="size_t") long num, @NativeType(value="size_t") long size) {
        if (Checks.CHECKS) {
            Checks.check(heap);
        }
        long __result = RPmalloc.nrpmalloc_heap_aligned_calloc(heap, alignment, num, size);
        return MemoryUtil.memByteBufferSafe(__result, (int)num * (int)size);
    }

    public static native long nrpmalloc_heap_realloc(long var0, long var2, long var4, int var6);

    @NativeType(value="void *")
    public static @Nullable ByteBuffer rpmalloc_heap_realloc(@NativeType(value="rpmalloc_heap_t *") long heap, @NativeType(value="void *") @Nullable ByteBuffer ptr, @NativeType(value="size_t") long size, @NativeType(value="unsigned int") int flags) {
        if (Checks.CHECKS) {
            Checks.check(heap);
        }
        long __result = RPmalloc.nrpmalloc_heap_realloc(heap, MemoryUtil.memAddressSafe(ptr), size, flags);
        return MemoryUtil.memByteBufferSafe(__result, (int)size);
    }

    public static native long nrpmalloc_heap_aligned_realloc(long var0, long var2, long var4, long var6, int var8);

    @NativeType(value="void *")
    public static @Nullable ByteBuffer rpmalloc_heap_aligned_realloc(@NativeType(value="rpmalloc_heap_t *") long heap, @NativeType(value="void *") @Nullable ByteBuffer ptr, @NativeType(value="size_t") long alignment, @NativeType(value="size_t") long size, @NativeType(value="unsigned int") int flags) {
        if (Checks.CHECKS) {
            Checks.check(heap);
        }
        long __result = RPmalloc.nrpmalloc_heap_aligned_realloc(heap, MemoryUtil.memAddressSafe(ptr), alignment, size, flags);
        return MemoryUtil.memByteBufferSafe(__result, (int)size);
    }

    public static native void nrpmalloc_heap_free(long var0, long var2);

    public static void rpmalloc_heap_free(@NativeType(value="rpmalloc_heap_t *") long heap, @NativeType(value="void *") @Nullable ByteBuffer ptr) {
        if (Checks.CHECKS) {
            Checks.check(heap);
        }
        RPmalloc.nrpmalloc_heap_free(heap, MemoryUtil.memAddressSafe(ptr));
    }

    public static void rpmalloc_heap_free(@NativeType(value="rpmalloc_heap_t *") long heap, @NativeType(value="void *") @Nullable ShortBuffer ptr) {
        if (Checks.CHECKS) {
            Checks.check(heap);
        }
        RPmalloc.nrpmalloc_heap_free(heap, MemoryUtil.memAddressSafe(ptr));
    }

    public static void rpmalloc_heap_free(@NativeType(value="rpmalloc_heap_t *") long heap, @NativeType(value="void *") @Nullable IntBuffer ptr) {
        if (Checks.CHECKS) {
            Checks.check(heap);
        }
        RPmalloc.nrpmalloc_heap_free(heap, MemoryUtil.memAddressSafe(ptr));
    }

    public static void rpmalloc_heap_free(@NativeType(value="rpmalloc_heap_t *") long heap, @NativeType(value="void *") @Nullable LongBuffer ptr) {
        if (Checks.CHECKS) {
            Checks.check(heap);
        }
        RPmalloc.nrpmalloc_heap_free(heap, MemoryUtil.memAddressSafe(ptr));
    }

    public static void rpmalloc_heap_free(@NativeType(value="rpmalloc_heap_t *") long heap, @NativeType(value="void *") @Nullable FloatBuffer ptr) {
        if (Checks.CHECKS) {
            Checks.check(heap);
        }
        RPmalloc.nrpmalloc_heap_free(heap, MemoryUtil.memAddressSafe(ptr));
    }

    public static void rpmalloc_heap_free(@NativeType(value="rpmalloc_heap_t *") long heap, @NativeType(value="void *") @Nullable DoubleBuffer ptr) {
        if (Checks.CHECKS) {
            Checks.check(heap);
        }
        RPmalloc.nrpmalloc_heap_free(heap, MemoryUtil.memAddressSafe(ptr));
    }

    public static void rpmalloc_heap_free(@NativeType(value="rpmalloc_heap_t *") long heap, @NativeType(value="void *") @Nullable PointerBuffer ptr) {
        if (Checks.CHECKS) {
            Checks.check(heap);
        }
        RPmalloc.nrpmalloc_heap_free(heap, MemoryUtil.memAddressSafe(ptr));
    }

    public static native void nrpmalloc_heap_free_all(long var0);

    public static void rpmalloc_heap_free_all(@NativeType(value="rpmalloc_heap_t *") long heap) {
        if (Checks.CHECKS) {
            Checks.check(heap);
        }
        RPmalloc.nrpmalloc_heap_free_all(heap);
    }

    public static native void rpmalloc_heap_thread_set_current(@NativeType(value="rpmalloc_heap_t *") long var0);

    public static native long nrpmalloc_get_heap_for_ptr(long var0);

    @NativeType(value="rpmalloc_heap_t *")
    public static long rpmalloc_get_heap_for_ptr(@NativeType(value="void *") @Nullable ByteBuffer ptr) {
        return RPmalloc.nrpmalloc_get_heap_for_ptr(MemoryUtil.memAddressSafe(ptr));
    }

    @NativeType(value="rpmalloc_heap_t *")
    public static long rpmalloc_get_heap_for_ptr(@NativeType(value="void *") @Nullable ShortBuffer ptr) {
        return RPmalloc.nrpmalloc_get_heap_for_ptr(MemoryUtil.memAddressSafe(ptr));
    }

    @NativeType(value="rpmalloc_heap_t *")
    public static long rpmalloc_get_heap_for_ptr(@NativeType(value="void *") @Nullable IntBuffer ptr) {
        return RPmalloc.nrpmalloc_get_heap_for_ptr(MemoryUtil.memAddressSafe(ptr));
    }

    @NativeType(value="rpmalloc_heap_t *")
    public static long rpmalloc_get_heap_for_ptr(@NativeType(value="void *") @Nullable LongBuffer ptr) {
        return RPmalloc.nrpmalloc_get_heap_for_ptr(MemoryUtil.memAddressSafe(ptr));
    }

    @NativeType(value="rpmalloc_heap_t *")
    public static long rpmalloc_get_heap_for_ptr(@NativeType(value="void *") @Nullable FloatBuffer ptr) {
        return RPmalloc.nrpmalloc_get_heap_for_ptr(MemoryUtil.memAddressSafe(ptr));
    }

    @NativeType(value="rpmalloc_heap_t *")
    public static long rpmalloc_get_heap_for_ptr(@NativeType(value="void *") @Nullable DoubleBuffer ptr) {
        return RPmalloc.nrpmalloc_get_heap_for_ptr(MemoryUtil.memAddressSafe(ptr));
    }

    @NativeType(value="rpmalloc_heap_t *")
    public static long rpmalloc_get_heap_for_ptr(@NativeType(value="void *") @Nullable PointerBuffer ptr) {
        return RPmalloc.nrpmalloc_get_heap_for_ptr(MemoryUtil.memAddressSafe(ptr));
    }

    static {
        LibRPmalloc.initialize();
    }
}

