/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.harfbuzz;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.util.harfbuzz.hb_buffer_message_func_tI;
import org.lwjgl.util.harfbuzz.hb_color_line_t;
import org.lwjgl.util.harfbuzz.hb_color_stop_t;
import org.lwjgl.util.harfbuzz.hb_destroy_func_tI;
import org.lwjgl.util.harfbuzz.hb_draw_close_path_func_tI;
import org.lwjgl.util.harfbuzz.hb_draw_cubic_to_func_tI;
import org.lwjgl.util.harfbuzz.hb_draw_line_to_func_tI;
import org.lwjgl.util.harfbuzz.hb_draw_move_to_func_tI;
import org.lwjgl.util.harfbuzz.hb_draw_quadratic_to_func_tI;
import org.lwjgl.util.harfbuzz.hb_draw_state_t;
import org.lwjgl.util.harfbuzz.hb_feature_t;
import org.lwjgl.util.harfbuzz.hb_font_draw_glyph_func_tI;
import org.lwjgl.util.harfbuzz.hb_font_extents_t;
import org.lwjgl.util.harfbuzz.hb_font_get_glyph_contour_point_func_tI;
import org.lwjgl.util.harfbuzz.hb_font_get_glyph_extents_func_tI;
import org.lwjgl.util.harfbuzz.hb_font_get_glyph_from_name_func_tI;
import org.lwjgl.util.harfbuzz.hb_font_get_glyph_name_func_tI;
import org.lwjgl.util.harfbuzz.hb_font_get_nominal_glyph_func_tI;
import org.lwjgl.util.harfbuzz.hb_font_get_nominal_glyphs_func_tI;
import org.lwjgl.util.harfbuzz.hb_font_get_variation_glyph_func_tI;
import org.lwjgl.util.harfbuzz.hb_font_paint_glyph_func_tI;
import org.lwjgl.util.harfbuzz.hb_get_table_tags_func_tI;
import org.lwjgl.util.harfbuzz.hb_glyph_extents_t;
import org.lwjgl.util.harfbuzz.hb_glyph_info_t;
import org.lwjgl.util.harfbuzz.hb_glyph_position_t;
import org.lwjgl.util.harfbuzz.hb_paint_color_func_tI;
import org.lwjgl.util.harfbuzz.hb_paint_color_glyph_func_tI;
import org.lwjgl.util.harfbuzz.hb_paint_custom_palette_color_func_tI;
import org.lwjgl.util.harfbuzz.hb_paint_image_func_tI;
import org.lwjgl.util.harfbuzz.hb_paint_linear_gradient_func_tI;
import org.lwjgl.util.harfbuzz.hb_paint_pop_clip_func_tI;
import org.lwjgl.util.harfbuzz.hb_paint_pop_group_func_tI;
import org.lwjgl.util.harfbuzz.hb_paint_pop_transform_func_tI;
import org.lwjgl.util.harfbuzz.hb_paint_push_clip_glyph_func_tI;
import org.lwjgl.util.harfbuzz.hb_paint_push_clip_rectangle_func_tI;
import org.lwjgl.util.harfbuzz.hb_paint_push_group_func_tI;
import org.lwjgl.util.harfbuzz.hb_paint_push_transform_func_tI;
import org.lwjgl.util.harfbuzz.hb_paint_radial_gradient_func_tI;
import org.lwjgl.util.harfbuzz.hb_paint_sweep_gradient_func_tI;
import org.lwjgl.util.harfbuzz.hb_reference_table_func_tI;
import org.lwjgl.util.harfbuzz.hb_segment_properties_t;
import org.lwjgl.util.harfbuzz.hb_unicode_combining_class_func_tI;
import org.lwjgl.util.harfbuzz.hb_unicode_compose_func_tI;
import org.lwjgl.util.harfbuzz.hb_unicode_decompose_func_tI;
import org.lwjgl.util.harfbuzz.hb_unicode_general_category_func_tI;
import org.lwjgl.util.harfbuzz.hb_unicode_mirroring_func_tI;
import org.lwjgl.util.harfbuzz.hb_unicode_script_func_tI;
import org.lwjgl.util.harfbuzz.hb_user_data_key_t;
import org.lwjgl.util.harfbuzz.hb_variation_t;

public class HarfBuzz {
    private static final SharedLibrary HARFBUZZ;
    public static final int HB_CODEPOINT_INVALID = -1;
    public static final int HB_FEATURE_GLOBAL_START = 0;
    public static final int HB_FEATURE_GLOBAL_END = -1;
    public static final int HB_TAG_NONE;
    public static final int HB_TAG_MAX;
    public static final int HB_TAG_MAX_SIGNED;
    public static final int HB_DIRECTION_INVALID = 0;
    public static final int HB_DIRECTION_LTR = 4;
    public static final int HB_DIRECTION_RTL = 5;
    public static final int HB_DIRECTION_TTB = 6;
    public static final int HB_DIRECTION_BTT = 7;
    public static final int HB_SCRIPT_COMMON;
    public static final int HB_SCRIPT_INHERITED;
    public static final int HB_SCRIPT_UNKNOWN;
    public static final int HB_SCRIPT_ARABIC;
    public static final int HB_SCRIPT_ARMENIAN;
    public static final int HB_SCRIPT_BENGALI;
    public static final int HB_SCRIPT_CYRILLIC;
    public static final int HB_SCRIPT_DEVANAGARI;
    public static final int HB_SCRIPT_GEORGIAN;
    public static final int HB_SCRIPT_GREEK;
    public static final int HB_SCRIPT_GUJARATI;
    public static final int HB_SCRIPT_GURMUKHI;
    public static final int HB_SCRIPT_HANGUL;
    public static final int HB_SCRIPT_HAN;
    public static final int HB_SCRIPT_HEBREW;
    public static final int HB_SCRIPT_HIRAGANA;
    public static final int HB_SCRIPT_KANNADA;
    public static final int HB_SCRIPT_KATAKANA;
    public static final int HB_SCRIPT_LAO;
    public static final int HB_SCRIPT_LATIN;
    public static final int HB_SCRIPT_MALAYALAM;
    public static final int HB_SCRIPT_ORIYA;
    public static final int HB_SCRIPT_TAMIL;
    public static final int HB_SCRIPT_TELUGU;
    public static final int HB_SCRIPT_THAI;
    public static final int HB_SCRIPT_TIBETAN;
    public static final int HB_SCRIPT_BOPOMOFO;
    public static final int HB_SCRIPT_BRAILLE;
    public static final int HB_SCRIPT_CANADIAN_SYLLABICS;
    public static final int HB_SCRIPT_CHEROKEE;
    public static final int HB_SCRIPT_ETHIOPIC;
    public static final int HB_SCRIPT_KHMER;
    public static final int HB_SCRIPT_MONGOLIAN;
    public static final int HB_SCRIPT_MYANMAR;
    public static final int HB_SCRIPT_OGHAM;
    public static final int HB_SCRIPT_RUNIC;
    public static final int HB_SCRIPT_SINHALA;
    public static final int HB_SCRIPT_SYRIAC;
    public static final int HB_SCRIPT_THAANA;
    public static final int HB_SCRIPT_YI;
    public static final int HB_SCRIPT_DESERET;
    public static final int HB_SCRIPT_GOTHIC;
    public static final int HB_SCRIPT_OLD_ITALIC;
    public static final int HB_SCRIPT_BUHID;
    public static final int HB_SCRIPT_HANUNOO;
    public static final int HB_SCRIPT_TAGALOG;
    public static final int HB_SCRIPT_TAGBANWA;
    public static final int HB_SCRIPT_CYPRIOT;
    public static final int HB_SCRIPT_LIMBU;
    public static final int HB_SCRIPT_LINEAR_B;
    public static final int HB_SCRIPT_OSMANYA;
    public static final int HB_SCRIPT_SHAVIAN;
    public static final int HB_SCRIPT_TAI_LE;
    public static final int HB_SCRIPT_UGARITIC;
    public static final int HB_SCRIPT_BUGINESE;
    public static final int HB_SCRIPT_COPTIC;
    public static final int HB_SCRIPT_GLAGOLITIC;
    public static final int HB_SCRIPT_KHAROSHTHI;
    public static final int HB_SCRIPT_NEW_TAI_LUE;
    public static final int HB_SCRIPT_OLD_PERSIAN;
    public static final int HB_SCRIPT_SYLOTI_NAGRI;
    public static final int HB_SCRIPT_TIFINAGH;
    public static final int HB_SCRIPT_BALINESE;
    public static final int HB_SCRIPT_CUNEIFORM;
    public static final int HB_SCRIPT_NKO;
    public static final int HB_SCRIPT_PHAGS_PA;
    public static final int HB_SCRIPT_PHOENICIAN;
    public static final int HB_SCRIPT_CARIAN;
    public static final int HB_SCRIPT_CHAM;
    public static final int HB_SCRIPT_KAYAH_LI;
    public static final int HB_SCRIPT_LEPCHA;
    public static final int HB_SCRIPT_LYCIAN;
    public static final int HB_SCRIPT_LYDIAN;
    public static final int HB_SCRIPT_OL_CHIKI;
    public static final int HB_SCRIPT_REJANG;
    public static final int HB_SCRIPT_SAURASHTRA;
    public static final int HB_SCRIPT_SUNDANESE;
    public static final int HB_SCRIPT_VAI;
    public static final int HB_SCRIPT_AVESTAN;
    public static final int HB_SCRIPT_BAMUM;
    public static final int HB_SCRIPT_EGYPTIAN_HIEROGLYPHS;
    public static final int HB_SCRIPT_IMPERIAL_ARAMAIC;
    public static final int HB_SCRIPT_INSCRIPTIONAL_PAHLAVI;
    public static final int HB_SCRIPT_INSCRIPTIONAL_PARTHIAN;
    public static final int HB_SCRIPT_JAVANESE;
    public static final int HB_SCRIPT_KAITHI;
    public static final int HB_SCRIPT_LISU;
    public static final int HB_SCRIPT_MEETEI_MAYEK;
    public static final int HB_SCRIPT_OLD_SOUTH_ARABIAN;
    public static final int HB_SCRIPT_OLD_TURKIC;
    public static final int HB_SCRIPT_SAMARITAN;
    public static final int HB_SCRIPT_TAI_THAM;
    public static final int HB_SCRIPT_TAI_VIET;
    public static final int HB_SCRIPT_BATAK;
    public static final int HB_SCRIPT_BRAHMI;
    public static final int HB_SCRIPT_MANDAIC;
    public static final int HB_SCRIPT_CHAKMA;
    public static final int HB_SCRIPT_MEROITIC_CURSIVE;
    public static final int HB_SCRIPT_MEROITIC_HIEROGLYPHS;
    public static final int HB_SCRIPT_MIAO;
    public static final int HB_SCRIPT_SHARADA;
    public static final int HB_SCRIPT_SORA_SOMPENG;
    public static final int HB_SCRIPT_TAKRI;
    public static final int HB_SCRIPT_BASSA_VAH;
    public static final int HB_SCRIPT_CAUCASIAN_ALBANIAN;
    public static final int HB_SCRIPT_DUPLOYAN;
    public static final int HB_SCRIPT_ELBASAN;
    public static final int HB_SCRIPT_GRANTHA;
    public static final int HB_SCRIPT_KHOJKI;
    public static final int HB_SCRIPT_KHUDAWADI;
    public static final int HB_SCRIPT_LINEAR_A;
    public static final int HB_SCRIPT_MAHAJANI;
    public static final int HB_SCRIPT_MANICHAEAN;
    public static final int HB_SCRIPT_MENDE_KIKAKUI;
    public static final int HB_SCRIPT_MODI;
    public static final int HB_SCRIPT_MRO;
    public static final int HB_SCRIPT_NABATAEAN;
    public static final int HB_SCRIPT_OLD_NORTH_ARABIAN;
    public static final int HB_SCRIPT_OLD_PERMIC;
    public static final int HB_SCRIPT_PAHAWH_HMONG;
    public static final int HB_SCRIPT_PALMYRENE;
    public static final int HB_SCRIPT_PAU_CIN_HAU;
    public static final int HB_SCRIPT_PSALTER_PAHLAVI;
    public static final int HB_SCRIPT_SIDDHAM;
    public static final int HB_SCRIPT_TIRHUTA;
    public static final int HB_SCRIPT_WARANG_CITI;
    public static final int HB_SCRIPT_AHOM;
    public static final int HB_SCRIPT_ANATOLIAN_HIEROGLYPHS;
    public static final int HB_SCRIPT_HATRAN;
    public static final int HB_SCRIPT_MULTANI;
    public static final int HB_SCRIPT_OLD_HUNGARIAN;
    public static final int HB_SCRIPT_SIGNWRITING;
    public static final int HB_SCRIPT_ADLAM;
    public static final int HB_SCRIPT_BHAIKSUKI;
    public static final int HB_SCRIPT_MARCHEN;
    public static final int HB_SCRIPT_OSAGE;
    public static final int HB_SCRIPT_TANGUT;
    public static final int HB_SCRIPT_NEWA;
    public static final int HB_SCRIPT_MASARAM_GONDI;
    public static final int HB_SCRIPT_NUSHU;
    public static final int HB_SCRIPT_SOYOMBO;
    public static final int HB_SCRIPT_ZANABAZAR_SQUARE;
    public static final int HB_SCRIPT_DOGRA;
    public static final int HB_SCRIPT_GUNJALA_GONDI;
    public static final int HB_SCRIPT_HANIFI_ROHINGYA;
    public static final int HB_SCRIPT_MAKASAR;
    public static final int HB_SCRIPT_MEDEFAIDRIN;
    public static final int HB_SCRIPT_OLD_SOGDIAN;
    public static final int HB_SCRIPT_SOGDIAN;
    public static final int HB_SCRIPT_ELYMAIC;
    public static final int HB_SCRIPT_NANDINAGARI;
    public static final int HB_SCRIPT_NYIAKENG_PUACHUE_HMONG;
    public static final int HB_SCRIPT_WANCHO;
    public static final int HB_SCRIPT_CHORASMIAN;
    public static final int HB_SCRIPT_DIVES_AKURU;
    public static final int HB_SCRIPT_KHITAN_SMALL_SCRIPT;
    public static final int HB_SCRIPT_YEZIDI;
    public static final int HB_SCRIPT_CYPRO_MINOAN;
    public static final int HB_SCRIPT_OLD_UYGHUR;
    public static final int HB_SCRIPT_TANGSA;
    public static final int HB_SCRIPT_TOTO;
    public static final int HB_SCRIPT_VITHKUQI;
    public static final int HB_SCRIPT_MATH;
    public static final int HB_SCRIPT_KAWI;
    public static final int HB_SCRIPT_NAG_MUNDARI;
    public static final int HB_SCRIPT_GARAY;
    public static final int HB_SCRIPT_GURUNG_KHEMA;
    public static final int HB_SCRIPT_KIRAT_RAI;
    public static final int HB_SCRIPT_OL_ONAL;
    public static final int HB_SCRIPT_SUNUWAR;
    public static final int HB_SCRIPT_TODHRI;
    public static final int HB_SCRIPT_TULU_TIGALARI;
    public static final int HB_SCRIPT_INVALID;
    public static final int HB_LANGUAGE_INVALID = 0;
    public static final int HB_MEMORY_MODE_DUPLICATE = 0;
    public static final int HB_MEMORY_MODE_READONLY = 1;
    public static final int HB_MEMORY_MODE_WRITABLE = 2;
    public static final int HB_MEMORY_MODE_READONLY_MAY_MAKE_WRITABLE = 3;
    public static final int HB_GLYPH_FLAG_UNSAFE_TO_BREAK = 1;
    public static final int HB_GLYPH_FLAG_UNSAFE_TO_CONCAT = 2;
    public static final int HB_GLYPH_FLAG_SAFE_TO_INSERT_TATWEEL = 4;
    public static final int HB_GLYPH_FLAG_DEFINED = 7;
    public static final int HB_BUFFER_CONTENT_TYPE_INVALID = 0;
    public static final int HB_BUFFER_CONTENT_TYPE_UNICODE = 1;
    public static final int HB_BUFFER_CONTENT_TYPE_GLYPHS = 2;
    public static final int HB_BUFFER_FLAG_DEFAULT = 0;
    public static final int HB_BUFFER_FLAG_BOT = 1;
    public static final int HB_BUFFER_FLAG_EOT = 2;
    public static final int HB_BUFFER_FLAG_PRESERVE_DEFAULT_IGNORABLES = 4;
    public static final int HB_BUFFER_FLAG_REMOVE_DEFAULT_IGNORABLES = 8;
    public static final int HB_BUFFER_FLAG_DO_NOT_INSERT_DOTTED_CIRCLE = 16;
    public static final int HB_BUFFER_FLAG_VERIFY = 32;
    public static final int HB_BUFFER_FLAG_PRODUCE_UNSAFE_TO_CONCAT = 64;
    public static final int HB_BUFFER_FLAG_PRODUCE_SAFE_TO_INSERT_TATWEEL = 128;
    public static final int HB_BUFFER_FLAG_DEFINED = 255;
    public static final int HB_BUFFER_CLUSTER_LEVEL_MONOTONE_GRAPHEMES = 0;
    public static final int HB_BUFFER_CLUSTER_LEVEL_MONOTONE_CHARACTERS = 1;
    public static final int HB_BUFFER_CLUSTER_LEVEL_CHARACTERS = 2;
    public static final int HB_BUFFER_CLUSTER_LEVEL_DEFAULT = 0;
    public static final int HB_BUFFER_REPLACEMENT_CODEPOINT_DEFAULT = 65533;
    public static final int HB_BUFFER_SERIALIZE_FLAG_DEFAULT = 0;
    public static final int HB_BUFFER_SERIALIZE_FLAG_NO_CLUSTERS = 1;
    public static final int HB_BUFFER_SERIALIZE_FLAG_NO_POSITIONS = 2;
    public static final int HB_BUFFER_SERIALIZE_FLAG_NO_GLYPH_NAMES = 4;
    public static final int HB_BUFFER_SERIALIZE_FLAG_GLYPH_EXTENTS = 8;
    public static final int HB_BUFFER_SERIALIZE_FLAG_GLYPH_FLAGS = 16;
    public static final int HB_BUFFER_SERIALIZE_FLAG_NO_ADVANCES = 32;
    public static final int HB_BUFFER_SERIALIZE_FLAG_DEFINED = 63;
    public static final int HB_BUFFER_SERIALIZE_FORMAT_TEXT;
    public static final int HB_BUFFER_SERIALIZE_FORMAT_JSON;
    public static final int HB_BUFFER_SERIALIZE_FORMAT_INVALID;
    public static final int HB_BUFFER_DIFF_FLAG_EQUAL = 0;
    public static final int HB_BUFFER_DIFF_FLAG_CONTENT_TYPE_MISMATCH = 1;
    public static final int HB_BUFFER_DIFF_FLAG_LENGTH_MISMATCH = 2;
    public static final int HB_BUFFER_DIFF_FLAG_NOTDEF_PRESENT = 4;
    public static final int HB_BUFFER_DIFF_FLAG_DOTTED_CIRCLE_PRESENT = 8;
    public static final int HB_BUFFER_DIFF_FLAG_CODEPOINT_MISMATCH = 16;
    public static final int HB_BUFFER_DIFF_FLAG_CLUSTER_MISMATCH = 32;
    public static final int HB_BUFFER_DIFF_FLAG_GLYPH_FLAGS_MISMATCH = 64;
    public static final int HB_BUFFER_DIFF_FLAG_POSITION_MISMATCH = 128;
    public static final int HB_FONT_NO_VAR_NAMED_INSTANCE = -1;
    public static final int HB_MAP_VALUE_INVALID = -1;
    public static final int HB_PAINT_IMAGE_FORMAT_PNG;
    public static final int HB_PAINT_IMAGE_FORMAT_SVG;
    public static final int HB_PAINT_IMAGE_FORMAT_BGRA;
    public static final int HB_PAINT_EXTEND_PAD = 0;
    public static final int HB_PAINT_EXTEND_REPEAT = 1;
    public static final int HB_PAINT_EXTEND_REFLECT = 2;
    public static final int HB_PAINT_COMPOSITE_MODE_CLEAR = 0;
    public static final int HB_PAINT_COMPOSITE_MODE_SRC = 1;
    public static final int HB_PAINT_COMPOSITE_MODE_DEST = 2;
    public static final int HB_PAINT_COMPOSITE_MODE_SRC_OVER = 3;
    public static final int HB_PAINT_COMPOSITE_MODE_DEST_OVER = 4;
    public static final int HB_PAINT_COMPOSITE_MODE_SRC_IN = 5;
    public static final int HB_PAINT_COMPOSITE_MODE_DEST_IN = 6;
    public static final int HB_PAINT_COMPOSITE_MODE_SRC_OUT = 7;
    public static final int HB_PAINT_COMPOSITE_MODE_DEST_OUT = 8;
    public static final int HB_PAINT_COMPOSITE_MODE_SRC_ATOP = 9;
    public static final int HB_PAINT_COMPOSITE_MODE_DEST_ATOP = 10;
    public static final int HB_PAINT_COMPOSITE_MODE_XOR = 11;
    public static final int HB_PAINT_COMPOSITE_MODE_PLUS = 12;
    public static final int HB_PAINT_COMPOSITE_MODE_SCREEN = 13;
    public static final int HB_PAINT_COMPOSITE_MODE_OVERLAY = 14;
    public static final int HB_PAINT_COMPOSITE_MODE_DARKEN = 15;
    public static final int HB_PAINT_COMPOSITE_MODE_LIGHTEN = 16;
    public static final int HB_PAINT_COMPOSITE_MODE_COLOR_DODGE = 17;
    public static final int HB_PAINT_COMPOSITE_MODE_COLOR_BURN = 18;
    public static final int HB_PAINT_COMPOSITE_MODE_HARD_LIGHT = 19;
    public static final int HB_PAINT_COMPOSITE_MODE_SOFT_LIGHT = 20;
    public static final int HB_PAINT_COMPOSITE_MODE_DIFFERENCE = 21;
    public static final int HB_PAINT_COMPOSITE_MODE_EXCLUSION = 22;
    public static final int HB_PAINT_COMPOSITE_MODE_MULTIPLY = 23;
    public static final int HB_PAINT_COMPOSITE_MODE_HSL_HUE = 24;
    public static final int HB_PAINT_COMPOSITE_MODE_HSL_SATURATION = 25;
    public static final int HB_PAINT_COMPOSITE_MODE_HSL_COLOR = 26;
    public static final int HB_PAINT_COMPOSITE_MODE_HSL_LUMINOSITY = 27;
    public static final int HB_SET_VALUE_INVALID = -1;
    public static final int STYLE_TAG_ITALIC;
    public static final int STYLE_TAG_OPTICAL_SIZE;
    public static final int STYLE_TAG_SLANT_ANGLE;
    public static final int STYLE_TAG_SLANT_RATIO;
    public static final int STYLE_TAG_WIDTH;
    public static final int STYLE_TAG_WEIGHT;
    public static final int HB_UNICODE_MAX = 0x10FFFF;
    public static final int HB_UNICODE_GENERAL_CATEGORY_CONTROL = 0;
    public static final int HB_UNICODE_GENERAL_CATEGORY_FORMAT = 1;
    public static final int HB_UNICODE_GENERAL_CATEGORY_UNASSIGNED = 2;
    public static final int HB_UNICODE_GENERAL_CATEGORY_PRIVATE_USE = 3;
    public static final int HB_UNICODE_GENERAL_CATEGORY_SURROGATE = 4;
    public static final int HB_UNICODE_GENERAL_CATEGORY_LOWERCASE_LETTER = 5;
    public static final int HB_UNICODE_GENERAL_CATEGORY_MODIFIER_LETTER = 6;
    public static final int HB_UNICODE_GENERAL_CATEGORY_OTHER_LETTER = 7;
    public static final int HB_UNICODE_GENERAL_CATEGORY_TITLECASE_LETTER = 8;
    public static final int HB_UNICODE_GENERAL_CATEGORY_UPPERCASE_LETTER = 9;
    public static final int HB_UNICODE_GENERAL_CATEGORY_SPACING_MARK = 10;
    public static final int HB_UNICODE_GENERAL_CATEGORY_ENCLOSING_MARK = 11;
    public static final int HB_UNICODE_GENERAL_CATEGORY_NON_SPACING_MARK = 12;
    public static final int HB_UNICODE_GENERAL_CATEGORY_DECIMAL_NUMBER = 13;
    public static final int HB_UNICODE_GENERAL_CATEGORY_LETTER_NUMBER = 14;
    public static final int HB_UNICODE_GENERAL_CATEGORY_OTHER_NUMBER = 15;
    public static final int HB_UNICODE_GENERAL_CATEGORY_CONNECT_PUNCTUATION = 16;
    public static final int HB_UNICODE_GENERAL_CATEGORY_DASH_PUNCTUATION = 17;
    public static final int HB_UNICODE_GENERAL_CATEGORY_CLOSE_PUNCTUATION = 18;
    public static final int HB_UNICODE_GENERAL_CATEGORY_FINAL_PUNCTUATION = 19;
    public static final int HB_UNICODE_GENERAL_CATEGORY_INITIAL_PUNCTUATION = 20;
    public static final int HB_UNICODE_GENERAL_CATEGORY_OTHER_PUNCTUATION = 21;
    public static final int HB_UNICODE_GENERAL_CATEGORY_OPEN_PUNCTUATION = 22;
    public static final int HB_UNICODE_GENERAL_CATEGORY_CURRENCY_SYMBOL = 23;
    public static final int HB_UNICODE_GENERAL_CATEGORY_MODIFIER_SYMBOL = 24;
    public static final int HB_UNICODE_GENERAL_CATEGORY_MATH_SYMBOL = 25;
    public static final int HB_UNICODE_GENERAL_CATEGORY_OTHER_SYMBOL = 26;
    public static final int HB_UNICODE_GENERAL_CATEGORY_LINE_SEPARATOR = 27;
    public static final int HB_UNICODE_GENERAL_CATEGORY_PARAGRAPH_SEPARATOR = 28;
    public static final int HB_UNICODE_GENERAL_CATEGORY_SPACE_SEPARATOR = 29;
    public static final int HB_UNICODE_COMBINING_CLASS_NOT_REORDERED = 0;
    public static final int HB_UNICODE_COMBINING_CLASS_OVERLAY = 1;
    public static final int HB_UNICODE_COMBINING_CLASS_NUKTA = 7;
    public static final int HB_UNICODE_COMBINING_CLASS_KANA_VOICING = 8;
    public static final int HB_UNICODE_COMBINING_CLASS_VIRAMA = 9;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC10 = 10;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC11 = 11;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC12 = 12;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC13 = 13;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC14 = 14;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC15 = 15;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC16 = 16;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC17 = 17;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC18 = 18;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC19 = 19;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC20 = 20;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC21 = 21;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC22 = 22;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC23 = 23;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC24 = 24;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC25 = 25;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC26 = 26;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC27 = 27;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC28 = 28;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC29 = 29;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC30 = 30;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC31 = 31;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC32 = 32;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC33 = 33;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC34 = 34;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC35 = 35;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC36 = 36;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC84 = 84;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC91 = 91;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC103 = 103;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC107 = 107;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC118 = 118;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC122 = 122;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC129 = 129;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC130 = 130;
    public static final int HB_UNICODE_COMBINING_CLASS_CCC132 = 132;
    public static final int HB_UNICODE_COMBINING_CLASS_ATTACHED_BELOW_LEFT = 200;
    public static final int HB_UNICODE_COMBINING_CLASS_ATTACHED_BELOW = 202;
    public static final int HB_UNICODE_COMBINING_CLASS_ATTACHED_ABOVE = 214;
    public static final int HB_UNICODE_COMBINING_CLASS_ATTACHED_ABOVE_RIGHT = 216;
    public static final int HB_UNICODE_COMBINING_CLASS_BELOW_LEFT = 218;
    public static final int HB_UNICODE_COMBINING_CLASS_BELOW = 220;
    public static final int HB_UNICODE_COMBINING_CLASS_BELOW_RIGHT = 222;
    public static final int HB_UNICODE_COMBINING_CLASS_LEFT = 224;
    public static final int HB_UNICODE_COMBINING_CLASS_RIGHT = 226;
    public static final int HB_UNICODE_COMBINING_CLASS_ABOVE_LEFT = 228;
    public static final int HB_UNICODE_COMBINING_CLASS_ABOVE = 230;
    public static final int HB_UNICODE_COMBINING_CLASS_ABOVE_RIGHT = 232;
    public static final int HB_UNICODE_COMBINING_CLASS_DOUBLE_BELOW = 233;
    public static final int HB_UNICODE_COMBINING_CLASS_DOUBLE_ABOVE = 234;
    public static final int HB_UNICODE_COMBINING_CLASS_IOTA_SUBSCRIPT = 240;
    public static final int HB_UNICODE_COMBINING_CLASS_INVALID = 255;
    public static final int HB_VERSION_MAJOR = 10;
    public static final int HB_VERSION_MINOR = 1;
    public static final int HB_VERSION_MICRO = 0;
    public static final String HB_VERSION_STRING = "10.1.0";
    public static final hb_segment_properties_t HB_SEGMENT_PROPERTIES_DEFAULT;
    private static final int buffer_serialize_list_formats_COUNT;
    public static final hb_draw_state_t HB_DRAW_STATE_DEFAULT;
    private static final int shape_list_shapers_COUNT;

    public static SharedLibrary getLibrary() {
        return HARFBUZZ;
    }

    protected HarfBuzz() {
        throw new UnsupportedOperationException();
    }

    public static int nhb_tag_from_string(long str, int len) {
        long __functionAddress = Functions.tag_from_string;
        return JNI.invokePI(str, len, __functionAddress);
    }

    @NativeType(value="hb_tag_t")
    public static int hb_tag_from_string(@NativeType(value="char const *") ByteBuffer str) {
        return HarfBuzz.nhb_tag_from_string(MemoryUtil.memAddress(str), str.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="hb_tag_t")
    public static int hb_tag_from_string(@NativeType(value="char const *") CharSequence str) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int strEncodedLength = stack.nASCII(str, false);
            long strEncoded = stack.getPointerAddress();
            int n = HarfBuzz.nhb_tag_from_string(strEncoded, strEncodedLength);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nhb_tag_to_string(int tag, long buf) {
        long __functionAddress = Functions.tag_to_string;
        JNI.invokePV(tag, buf, __functionAddress);
    }

    public static void hb_tag_to_string(@NativeType(value="hb_tag_t") int tag, @NativeType(value="char *") ByteBuffer buf) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)buf, 4);
        }
        HarfBuzz.nhb_tag_to_string(tag, MemoryUtil.memAddress(buf));
    }

    public static int nhb_direction_from_string(long str, int len) {
        long __functionAddress = Functions.direction_from_string;
        return JNI.invokePI(str, len, __functionAddress);
    }

    @NativeType(value="hb_direction_t")
    public static int hb_direction_from_string(@NativeType(value="char const *") ByteBuffer str) {
        return HarfBuzz.nhb_direction_from_string(MemoryUtil.memAddress(str), str.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="hb_direction_t")
    public static int hb_direction_from_string(@NativeType(value="char const *") CharSequence str) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int strEncodedLength = stack.nASCII(str, false);
            long strEncoded = stack.getPointerAddress();
            int n = HarfBuzz.nhb_direction_from_string(strEncoded, strEncodedLength);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nhb_direction_to_string(int direction) {
        long __functionAddress = Functions.direction_to_string;
        return JNI.invokeP(direction, __functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String hb_direction_to_string(@NativeType(value="hb_direction_t") int direction) {
        long __result = HarfBuzz.nhb_direction_to_string(direction);
        return MemoryUtil.memASCIISafe(__result);
    }

    public static long nhb_language_from_string(long str, int len) {
        long __functionAddress = Functions.language_from_string;
        return JNI.invokePP(str, len, __functionAddress);
    }

    @NativeType(value="hb_language_t")
    public static long hb_language_from_string(@NativeType(value="char const *") ByteBuffer str) {
        return HarfBuzz.nhb_language_from_string(MemoryUtil.memAddress(str), str.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="hb_language_t")
    public static long hb_language_from_string(@NativeType(value="char const *") CharSequence str) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int strEncodedLength = stack.nASCII(str, false);
            long strEncoded = stack.getPointerAddress();
            long l = HarfBuzz.nhb_language_from_string(strEncoded, strEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nhb_language_to_string(long language) {
        long __functionAddress = Functions.language_to_string;
        if (Checks.CHECKS) {
            Checks.check(language);
        }
        return JNI.invokePP(language, __functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String hb_language_to_string(@NativeType(value="hb_language_t") long language) {
        long __result = HarfBuzz.nhb_language_to_string(language);
        return MemoryUtil.memASCIISafe(__result);
    }

    @NativeType(value="hb_language_t")
    public static long hb_language_get_default() {
        long __functionAddress = Functions.language_get_default;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_language_matches(@NativeType(value="hb_language_t") long language, @NativeType(value="hb_language_t") long specific) {
        long __functionAddress = Functions.language_matches;
        if (Checks.CHECKS) {
            Checks.check(language);
            Checks.check(specific);
        }
        return JNI.invokePPI(language, specific, __functionAddress) != 0;
    }

    @NativeType(value="hb_script_t")
    public static int hb_script_from_iso15924_tag(@NativeType(value="hb_tag_t") int tag) {
        long __functionAddress = Functions.script_from_iso15924_tag;
        return JNI.invokeI(tag, __functionAddress);
    }

    public static int nhb_script_from_string(long str, int len) {
        long __functionAddress = Functions.script_from_string;
        return JNI.invokePI(str, len, __functionAddress);
    }

    @NativeType(value="hb_script_t")
    public static int hb_script_from_string(@NativeType(value="char const *") ByteBuffer str) {
        return HarfBuzz.nhb_script_from_string(MemoryUtil.memAddress(str), str.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="hb_script_t")
    public static int hb_script_from_string(@NativeType(value="char const *") CharSequence str) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int strEncodedLength = stack.nASCII(str, false);
            long strEncoded = stack.getPointerAddress();
            int n = HarfBuzz.nhb_script_from_string(strEncoded, strEncodedLength);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="hb_tag_t")
    public static int hb_script_to_iso15924_tag(@NativeType(value="hb_script_t") int script) {
        long __functionAddress = Functions.script_to_iso15924_tag;
        return JNI.invokeI(script, __functionAddress);
    }

    @NativeType(value="hb_direction_t")
    public static int hb_script_get_horizontal_direction(@NativeType(value="hb_script_t") int script) {
        long __functionAddress = Functions.script_get_horizontal_direction;
        return JNI.invokeI(script, __functionAddress);
    }

    public static int nhb_feature_from_string(long str, int len, long feature) {
        long __functionAddress = Functions.feature_from_string;
        return JNI.invokePPI(str, len, feature, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_feature_from_string(@NativeType(value="char const *") ByteBuffer str, @NativeType(value="hb_feature_t *") hb_feature_t feature) {
        return HarfBuzz.nhb_feature_from_string(MemoryUtil.memAddress(str), str.remaining(), feature.address()) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="hb_bool_t")
    public static boolean hb_feature_from_string(@NativeType(value="char const *") CharSequence str, @NativeType(value="hb_feature_t *") hb_feature_t feature) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int strEncodedLength = stack.nASCII(str, false);
            long strEncoded = stack.getPointerAddress();
            boolean bl = HarfBuzz.nhb_feature_from_string(strEncoded, strEncodedLength, feature.address()) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nhb_feature_to_string(long feature, long buf, int size) {
        long __functionAddress = Functions.feature_to_string;
        JNI.invokePPV(feature, buf, size, __functionAddress);
    }

    public static void hb_feature_to_string(@NativeType(value="hb_feature_t *") hb_feature_t feature, @NativeType(value="char *") ByteBuffer buf) {
        HarfBuzz.nhb_feature_to_string(feature.address(), MemoryUtil.memAddress(buf), buf.remaining());
    }

    public static int nhb_variation_from_string(long str, int len, long variation) {
        long __functionAddress = Functions.variation_from_string;
        return JNI.invokePPI(str, len, variation, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_variation_from_string(@NativeType(value="char const *") ByteBuffer str, @NativeType(value="hb_variation_t *") hb_variation_t variation) {
        return HarfBuzz.nhb_variation_from_string(MemoryUtil.memAddress(str), str.remaining(), variation.address()) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="hb_bool_t")
    public static boolean hb_variation_from_string(@NativeType(value="char const *") CharSequence str, @NativeType(value="hb_variation_t *") hb_variation_t variation) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int strEncodedLength = stack.nASCII(str, false);
            long strEncoded = stack.getPointerAddress();
            boolean bl = HarfBuzz.nhb_variation_from_string(strEncoded, strEncodedLength, variation.address()) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nhb_variation_to_string(long variation, long buf, int size) {
        long __functionAddress = Functions.variation_to_string;
        JNI.invokePPV(variation, buf, size, __functionAddress);
    }

    public static void hb_variation_to_string(@NativeType(value="hb_variation_t *") hb_variation_t variation, @NativeType(value="char *") ByteBuffer buf) {
        HarfBuzz.nhb_variation_to_string(variation.address(), MemoryUtil.memAddress(buf), buf.remaining());
    }

    @NativeType(value="uint8_t")
    public static byte hb_color_get_alpha(@NativeType(value="hb_color_t") int color) {
        long __functionAddress = Functions.color_get_alpha;
        return JNI.invokeU(color, __functionAddress);
    }

    @NativeType(value="uint8_t")
    public static byte hb_color_get_red(@NativeType(value="hb_color_t") int color) {
        long __functionAddress = Functions.color_get_red;
        return JNI.invokeU(color, __functionAddress);
    }

    @NativeType(value="uint8_t")
    public static byte hb_color_get_green(@NativeType(value="hb_color_t") int color) {
        long __functionAddress = Functions.color_get_green;
        return JNI.invokeU(color, __functionAddress);
    }

    @NativeType(value="uint8_t")
    public static byte hb_color_get_blue(@NativeType(value="hb_color_t") int color) {
        long __functionAddress = Functions.color_get_blue;
        return JNI.invokeU(color, __functionAddress);
    }

    public static long nhb_blob_create(long data, int length, int mode, long user_data, long destroy) {
        long __functionAddress = Functions.blob_create;
        return JNI.invokePPPP(data, length, mode, user_data, destroy, __functionAddress);
    }

    @NativeType(value="hb_blob_t *")
    public static long hb_blob_create(@NativeType(value="char const *") ByteBuffer data, @NativeType(value="hb_memory_mode_t") int mode, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        return HarfBuzz.nhb_blob_create(MemoryUtil.memAddress(data), data.remaining(), mode, user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static long nhb_blob_create_or_fail(long data, int length, int mode, long user_data, long destroy) {
        long __functionAddress = Functions.blob_create_or_fail;
        return JNI.invokePPPP(data, length, mode, user_data, destroy, __functionAddress);
    }

    @NativeType(value="hb_blob_t *")
    public static long hb_blob_create_or_fail(@NativeType(value="char const *") ByteBuffer data, @NativeType(value="hb_memory_mode_t") int mode, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        return HarfBuzz.nhb_blob_create_or_fail(MemoryUtil.memAddress(data), data.remaining(), mode, user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static long nhb_blob_create_from_file(long file_name) {
        long __functionAddress = Functions.blob_create_from_file;
        return JNI.invokePP(file_name, __functionAddress);
    }

    @NativeType(value="hb_blob_t *")
    public static long hb_blob_create_from_file(@NativeType(value="char const *") ByteBuffer file_name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(file_name);
        }
        return HarfBuzz.nhb_blob_create_from_file(MemoryUtil.memAddress(file_name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="hb_blob_t *")
    public static long hb_blob_create_from_file(@NativeType(value="char const *") CharSequence file_name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(file_name, true);
            long file_nameEncoded = stack.getPointerAddress();
            long l = HarfBuzz.nhb_blob_create_from_file(file_nameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nhb_blob_create_from_file_or_fail(long file_name) {
        long __functionAddress = Functions.blob_create_from_file_or_fail;
        return JNI.invokePP(file_name, __functionAddress);
    }

    @NativeType(value="hb_blob_t *")
    public static long hb_blob_create_from_file_or_fail(@NativeType(value="char const *") ByteBuffer file_name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(file_name);
        }
        return HarfBuzz.nhb_blob_create_from_file_or_fail(MemoryUtil.memAddress(file_name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="hb_blob_t *")
    public static long hb_blob_create_from_file_or_fail(@NativeType(value="char const *") CharSequence file_name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(file_name, true);
            long file_nameEncoded = stack.getPointerAddress();
            long l = HarfBuzz.nhb_blob_create_from_file_or_fail(file_nameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="hb_blob_t *")
    public static long hb_blob_create_sub_blob(@NativeType(value="hb_blob_t *") long parent, @NativeType(value="unsigned int") int offset, @NativeType(value="unsigned int") int length) {
        long __functionAddress = Functions.blob_create_sub_blob;
        if (Checks.CHECKS) {
            Checks.check(parent);
        }
        return JNI.invokePP(parent, offset, length, __functionAddress);
    }

    @NativeType(value="hb_blob_t *")
    public static long hb_blob_copy_writable_or_fail(@NativeType(value="hb_blob_t *") long blob) {
        long __functionAddress = Functions.blob_copy_writable_or_fail;
        if (Checks.CHECKS) {
            Checks.check(blob);
        }
        return JNI.invokePP(blob, __functionAddress);
    }

    @NativeType(value="hb_blob_t *")
    public static long hb_blob_get_empty() {
        long __functionAddress = Functions.blob_get_empty;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="hb_blob_t *")
    public static long hb_blob_reference(@NativeType(value="hb_blob_t *") long blob) {
        long __functionAddress = Functions.blob_reference;
        if (Checks.CHECKS) {
            Checks.check(blob);
        }
        return JNI.invokePP(blob, __functionAddress);
    }

    public static void hb_blob_destroy(@NativeType(value="hb_blob_t *") long blob) {
        long __functionAddress = Functions.blob_destroy;
        if (Checks.CHECKS) {
            Checks.check(blob);
        }
        JNI.invokePV(blob, __functionAddress);
    }

    public static int nhb_blob_set_user_data(long blob, long key, long data, long destroy, int replace) {
        long __functionAddress = Functions.blob_set_user_data;
        if (Checks.CHECKS) {
            Checks.check(blob);
        }
        return JNI.invokePPPPI(blob, key, data, destroy, replace, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_blob_set_user_data(@NativeType(value="hb_blob_t *") long blob, @NativeType(value="hb_user_data_key_t *") hb_user_data_key_t key, @NativeType(value="void *") long data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy, @NativeType(value="hb_bool_t") boolean replace) {
        return HarfBuzz.nhb_blob_set_user_data(blob, key.address(), data, MemoryUtil.memAddressSafe(destroy), replace ? 1 : 0) != 0;
    }

    public static long nhb_blob_get_user_data(long blob, long key) {
        long __functionAddress = Functions.blob_get_user_data;
        if (Checks.CHECKS) {
            Checks.check(blob);
        }
        return JNI.invokePPP(blob, key, __functionAddress);
    }

    @NativeType(value="void *")
    public static long hb_blob_get_user_data(@NativeType(value="hb_blob_t const *") long blob, @NativeType(value="hb_user_data_key_t *") hb_user_data_key_t key) {
        return HarfBuzz.nhb_blob_get_user_data(blob, key.address());
    }

    public static void hb_blob_make_immutable(@NativeType(value="hb_blob_t *") long blob) {
        long __functionAddress = Functions.blob_make_immutable;
        if (Checks.CHECKS) {
            Checks.check(blob);
        }
        JNI.invokePV(blob, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_blob_is_immutable(@NativeType(value="hb_blob_t *") long blob) {
        long __functionAddress = Functions.blob_is_immutable;
        if (Checks.CHECKS) {
            Checks.check(blob);
        }
        return JNI.invokePI(blob, __functionAddress) != 0;
    }

    @NativeType(value="unsigned int")
    public static int hb_blob_get_length(@NativeType(value="hb_blob_t *") long blob) {
        long __functionAddress = Functions.blob_get_length;
        if (Checks.CHECKS) {
            Checks.check(blob);
        }
        return JNI.invokePI(blob, __functionAddress);
    }

    public static long nhb_blob_get_data(long blob, long length) {
        long __functionAddress = Functions.blob_get_data;
        if (Checks.CHECKS) {
            Checks.check(blob);
        }
        return JNI.invokePPP(blob, length, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static @Nullable ByteBuffer hb_blob_get_data(@NativeType(value="hb_blob_t *") long blob) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer length = stack.callocInt(1);
        try {
            long __result = HarfBuzz.nhb_blob_get_data(blob, MemoryUtil.memAddress(length));
            ByteBuffer byteBuffer = MemoryUtil.memByteBufferSafe(__result, length.get(0));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nhb_blob_get_data_writable(long blob, long length) {
        long __functionAddress = Functions.blob_get_data_writable;
        if (Checks.CHECKS) {
            Checks.check(blob);
        }
        return JNI.invokePPP(blob, length, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char *")
    public static @Nullable ByteBuffer hb_blob_get_data_writable(@NativeType(value="hb_blob_t *") long blob) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer length = stack.callocInt(1);
        try {
            long __result = HarfBuzz.nhb_blob_get_data_writable(blob, MemoryUtil.memAddress(length));
            ByteBuffer byteBuffer = MemoryUtil.memByteBufferSafe(__result, length.get(0));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nhb_segment_properties_equal(long a, long b) {
        long __functionAddress = Functions.segment_properties_equal;
        return JNI.invokePPI(a, b, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_segment_properties_equal(@NativeType(value="hb_segment_properties_t const *") hb_segment_properties_t a, @NativeType(value="hb_segment_properties_t const *") hb_segment_properties_t b) {
        return HarfBuzz.nhb_segment_properties_equal(a.address(), b.address()) != 0;
    }

    public static int nhb_segment_properties_hash(long p) {
        long __functionAddress = Functions.segment_properties_hash;
        return JNI.invokePI(p, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int hb_segment_properties_hash(@NativeType(value="hb_segment_properties_t const *") hb_segment_properties_t p) {
        return HarfBuzz.nhb_segment_properties_hash(p.address());
    }

    public static void nhb_segment_properties_overlay(long p, long src) {
        long __functionAddress = Functions.segment_properties_overlay;
        JNI.invokePPV(p, src, __functionAddress);
    }

    public static void hb_segment_properties_overlay(@NativeType(value="hb_segment_properties_t *") hb_segment_properties_t p, @NativeType(value="hb_segment_properties_t const *") hb_segment_properties_t src) {
        HarfBuzz.nhb_segment_properties_overlay(p.address(), src.address());
    }

    @NativeType(value="hb_buffer_t *")
    public static long hb_buffer_create() {
        long __functionAddress = Functions.buffer_create;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="hb_buffer_t *")
    public static long hb_buffer_create_similar(@NativeType(value="hb_buffer_t const *") long src) {
        long __functionAddress = Functions.buffer_create_similar;
        if (Checks.CHECKS) {
            Checks.check(src);
        }
        return JNI.invokePP(src, __functionAddress);
    }

    public static void hb_buffer_reset(@NativeType(value="hb_buffer_t *") long buffer) {
        long __functionAddress = Functions.buffer_reset;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePV(buffer, __functionAddress);
    }

    @NativeType(value="hb_buffer_t *")
    public static long hb_buffer_get_empty() {
        long __functionAddress = Functions.buffer_get_empty;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="hb_buffer_t *")
    public static long hb_buffer_reference(@NativeType(value="hb_buffer_t *") long buffer) {
        long __functionAddress = Functions.buffer_reference;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        return JNI.invokePP(buffer, __functionAddress);
    }

    public static void hb_buffer_destroy(@NativeType(value="hb_buffer_t *") long buffer) {
        long __functionAddress = Functions.buffer_destroy;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePV(buffer, __functionAddress);
    }

    public static int nhb_buffer_set_user_data(long buffer, long key, long data, long destroy, int replace) {
        long __functionAddress = Functions.buffer_set_user_data;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        return JNI.invokePPPPI(buffer, key, data, destroy, replace, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_buffer_set_user_data(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="hb_user_data_key_t *") hb_user_data_key_t key, @NativeType(value="void *") long data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy, @NativeType(value="hb_bool_t") boolean replace) {
        return HarfBuzz.nhb_buffer_set_user_data(buffer, key.address(), data, MemoryUtil.memAddressSafe(destroy), replace ? 1 : 0) != 0;
    }

    public static long nhb_buffer_get_user_data(long buffer, long key) {
        long __functionAddress = Functions.buffer_get_user_data;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        return JNI.invokePPP(buffer, key, __functionAddress);
    }

    @NativeType(value="void *")
    public static long hb_buffer_get_user_data(@NativeType(value="hb_buffer_t const *") long buffer, @NativeType(value="hb_user_data_key_t *") hb_user_data_key_t key) {
        return HarfBuzz.nhb_buffer_get_user_data(buffer, key.address());
    }

    public static void hb_buffer_set_content_type(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="hb_buffer_content_type_t") int content_type) {
        long __functionAddress = Functions.buffer_set_content_type;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePV(buffer, content_type, __functionAddress);
    }

    @NativeType(value="hb_buffer_content_type_t")
    public static int hb_buffer_get_content_type(@NativeType(value="hb_buffer_t const *") long buffer) {
        long __functionAddress = Functions.buffer_get_content_type;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        return JNI.invokePI(buffer, __functionAddress);
    }

    public static void hb_buffer_set_unicode_funcs(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="hb_unicode_funcs_t *") long unicode_funcs) {
        long __functionAddress = Functions.buffer_set_unicode_funcs;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePPV(buffer, unicode_funcs, __functionAddress);
    }

    @NativeType(value="hb_unicode_funcs_t *")
    public static long hb_buffer_get_unicode_funcs(@NativeType(value="hb_buffer_t const *") long buffer) {
        long __functionAddress = Functions.buffer_get_unicode_funcs;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        return JNI.invokePP(buffer, __functionAddress);
    }

    public static void hb_buffer_set_direction(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="hb_direction_t") int direction) {
        long __functionAddress = Functions.buffer_set_direction;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePV(buffer, direction, __functionAddress);
    }

    @NativeType(value="hb_direction_t")
    public static int hb_buffer_get_direction(@NativeType(value="hb_buffer_t const *") long buffer) {
        long __functionAddress = Functions.buffer_get_direction;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        return JNI.invokePI(buffer, __functionAddress);
    }

    public static void hb_buffer_set_script(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="hb_script_t") int script) {
        long __functionAddress = Functions.buffer_set_script;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePV(buffer, script, __functionAddress);
    }

    @NativeType(value="hb_script_t")
    public static int hb_buffer_get_script(@NativeType(value="hb_buffer_t const *") long buffer) {
        long __functionAddress = Functions.buffer_get_script;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        return JNI.invokePI(buffer, __functionAddress);
    }

    public static void hb_buffer_set_language(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="hb_language_t") long language) {
        long __functionAddress = Functions.buffer_set_language;
        if (Checks.CHECKS) {
            Checks.check(buffer);
            Checks.check(language);
        }
        JNI.invokePPV(buffer, language, __functionAddress);
    }

    @NativeType(value="hb_language_t")
    public static long hb_buffer_get_language(@NativeType(value="hb_buffer_t const *") long buffer) {
        long __functionAddress = Functions.buffer_get_language;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        return JNI.invokePP(buffer, __functionAddress);
    }

    public static void nhb_buffer_set_segment_properties(long buffer, long props) {
        long __functionAddress = Functions.buffer_set_segment_properties;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePPV(buffer, props, __functionAddress);
    }

    public static void hb_buffer_set_segment_properties(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="hb_segment_properties_t const *") hb_segment_properties_t props) {
        HarfBuzz.nhb_buffer_set_segment_properties(buffer, props.address());
    }

    public static void nhb_buffer_get_segment_properties(long buffer, long props) {
        long __functionAddress = Functions.buffer_get_segment_properties;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePPV(buffer, props, __functionAddress);
    }

    public static void hb_buffer_get_segment_properties(@NativeType(value="hb_buffer_t const *") long buffer, @NativeType(value="hb_segment_properties_t *") hb_segment_properties_t props) {
        HarfBuzz.nhb_buffer_get_segment_properties(buffer, props.address());
    }

    public static void hb_buffer_guess_segment_properties(@NativeType(value="hb_buffer_t *") long buffer) {
        long __functionAddress = Functions.buffer_guess_segment_properties;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePV(buffer, __functionAddress);
    }

    public static void hb_buffer_set_flags(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="hb_buffer_flags_t") int flags) {
        long __functionAddress = Functions.buffer_set_flags;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePV(buffer, flags, __functionAddress);
    }

    @NativeType(value="hb_buffer_flags_t")
    public static int hb_buffer_get_flags(@NativeType(value="hb_buffer_t const *") long buffer) {
        long __functionAddress = Functions.buffer_get_flags;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        return JNI.invokePI(buffer, __functionAddress);
    }

    public static void hb_buffer_set_cluster_level(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="hb_buffer_cluster_level_t") int cluster_level) {
        long __functionAddress = Functions.buffer_set_cluster_level;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePV(buffer, cluster_level, __functionAddress);
    }

    @NativeType(value="hb_buffer_cluster_level_t")
    public static int hb_buffer_get_cluster_level(@NativeType(value="hb_buffer_t const *") long buffer) {
        long __functionAddress = Functions.buffer_get_cluster_level;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        return JNI.invokePI(buffer, __functionAddress);
    }

    public static void hb_buffer_set_replacement_codepoint(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="hb_codepoint_t") int replacement) {
        long __functionAddress = Functions.buffer_set_replacement_codepoint;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePV(buffer, replacement, __functionAddress);
    }

    @NativeType(value="hb_codepoint_t")
    public static int hb_buffer_get_replacement_codepoint(@NativeType(value="hb_buffer_t const *") long buffer) {
        long __functionAddress = Functions.buffer_get_replacement_codepoint;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        return JNI.invokePI(buffer, __functionAddress);
    }

    public static void hb_buffer_set_invisible_glyph(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="hb_codepoint_t") int invisible) {
        long __functionAddress = Functions.buffer_set_invisible_glyph;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePV(buffer, invisible, __functionAddress);
    }

    @NativeType(value="hb_codepoint_t")
    public static int hb_buffer_get_invisible_glyph(@NativeType(value="hb_buffer_t const *") long buffer) {
        long __functionAddress = Functions.buffer_get_invisible_glyph;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        return JNI.invokePI(buffer, __functionAddress);
    }

    public static void hb_buffer_set_not_found_glyph(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="hb_codepoint_t") int not_found) {
        long __functionAddress = Functions.buffer_set_not_found_glyph;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePV(buffer, not_found, __functionAddress);
    }

    @NativeType(value="hb_codepoint_t")
    public static int hb_buffer_get_not_found_glyph(@NativeType(value="hb_buffer_t const *") long buffer) {
        long __functionAddress = Functions.buffer_get_not_found_glyph;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        return JNI.invokePI(buffer, __functionAddress);
    }

    public static void hb_buffer_set_not_found_variation_selector_glyph(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="hb_codepoint_t") int not_found_variation_selector) {
        long __functionAddress = Functions.buffer_set_not_found_variation_selector_glyph;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePV(buffer, not_found_variation_selector, __functionAddress);
    }

    @NativeType(value="hb_codepoint_t")
    public static int hb_buffer_get_not_found_variation_selector_glyph(@NativeType(value="hb_buffer_t const *") long buffer) {
        long __functionAddress = Functions.buffer_get_not_found_variation_selector_glyph;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        return JNI.invokePI(buffer, __functionAddress);
    }

    public static void hb_buffer_set_random_state(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="unsigned") int state) {
        long __functionAddress = Functions.buffer_set_random_state;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePV(buffer, state, __functionAddress);
    }

    @NativeType(value="unsigned")
    public static int hb_buffer_get_random_state(@NativeType(value="hb_buffer_t const *") long buffer) {
        long __functionAddress = Functions.buffer_get_random_state;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        return JNI.invokePI(buffer, __functionAddress);
    }

    public static void hb_buffer_clear_contents(@NativeType(value="hb_buffer_t *") long buffer) {
        long __functionAddress = Functions.buffer_clear_contents;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePV(buffer, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_buffer_pre_allocate(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="unsigned int") int size) {
        long __functionAddress = Functions.buffer_pre_allocate;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        return JNI.invokePI(buffer, size, __functionAddress) != 0;
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_buffer_allocation_successful(@NativeType(value="hb_buffer_t *") long buffer) {
        long __functionAddress = Functions.buffer_allocation_successful;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        return JNI.invokePI(buffer, __functionAddress) != 0;
    }

    public static void hb_buffer_reverse(@NativeType(value="hb_buffer_t *") long buffer) {
        long __functionAddress = Functions.buffer_reverse;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePV(buffer, __functionAddress);
    }

    public static void hb_buffer_reverse_range(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="unsigned int") int start, @NativeType(value="unsigned int") int end) {
        long __functionAddress = Functions.buffer_reverse_range;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePV(buffer, start, end, __functionAddress);
    }

    public static void hb_buffer_reverse_clusters(@NativeType(value="hb_buffer_t *") long buffer) {
        long __functionAddress = Functions.buffer_reverse_clusters;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePV(buffer, __functionAddress);
    }

    public static void hb_buffer_add(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="hb_codepoint_t") int codepoint, @NativeType(value="unsigned int") int cluster) {
        long __functionAddress = Functions.buffer_add;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePV(buffer, codepoint, cluster, __functionAddress);
    }

    public static void nhb_buffer_add_utf8(long buffer, long text, int text_length, int item_offset, int item_length) {
        long __functionAddress = Functions.buffer_add_utf8;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePPV(buffer, text, text_length, item_offset, item_length, __functionAddress);
    }

    public static void hb_buffer_add_utf8(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="char const *") ByteBuffer text, @NativeType(value="unsigned int") int item_offset, int item_length) {
        HarfBuzz.nhb_buffer_add_utf8(buffer, MemoryUtil.memAddress(text), text.remaining(), item_offset, item_length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hb_buffer_add_utf8(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="char const *") CharSequence text, @NativeType(value="unsigned int") int item_offset, int item_length) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int textEncodedLength = stack.nUTF8(text, false);
            long textEncoded = stack.getPointerAddress();
            HarfBuzz.nhb_buffer_add_utf8(buffer, textEncoded, textEncodedLength, item_offset, item_length);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nhb_buffer_add_utf16(long buffer, long text, int text_length, int item_offset, int item_length) {
        long __functionAddress = Functions.buffer_add_utf16;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePPV(buffer, text, text_length, item_offset, item_length, __functionAddress);
    }

    public static void hb_buffer_add_utf16(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="uint16_t const *") ByteBuffer text, @NativeType(value="unsigned int") int item_offset, int item_length) {
        HarfBuzz.nhb_buffer_add_utf16(buffer, MemoryUtil.memAddress(text), text.remaining() >> 1, item_offset, item_length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hb_buffer_add_utf16(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="uint16_t const *") CharSequence text, @NativeType(value="unsigned int") int item_offset, int item_length) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int textEncodedLength = stack.nUTF16(text, false);
            long textEncoded = stack.getPointerAddress();
            HarfBuzz.nhb_buffer_add_utf16(buffer, textEncoded, textEncodedLength >> 1, item_offset, item_length);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nhb_buffer_add_utf32(long buffer, long text, int text_length, int item_offset, int item_length) {
        long __functionAddress = Functions.buffer_add_utf32;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePPV(buffer, text, text_length, item_offset, item_length, __functionAddress);
    }

    public static void hb_buffer_add_utf32(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="uint32_t const *") IntBuffer text, @NativeType(value="unsigned int") int item_offset, int item_length) {
        HarfBuzz.nhb_buffer_add_utf32(buffer, MemoryUtil.memAddress(text), text.remaining(), item_offset, item_length);
    }

    public static void nhb_buffer_add_latin1(long buffer, long text, int text_length, int item_offset, int item_length) {
        long __functionAddress = Functions.buffer_add_latin1;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePPV(buffer, text, text_length, item_offset, item_length, __functionAddress);
    }

    public static void hb_buffer_add_latin1(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="uint8_t const *") ByteBuffer text, @NativeType(value="unsigned int") int item_offset, int item_length) {
        HarfBuzz.nhb_buffer_add_latin1(buffer, MemoryUtil.memAddress(text), text.remaining(), item_offset, item_length);
    }

    public static void nhb_buffer_add_codepoints(long buffer, long text, int text_length, int item_offset, int item_length) {
        long __functionAddress = Functions.buffer_add_codepoints;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePPV(buffer, text, text_length, item_offset, item_length, __functionAddress);
    }

    public static void hb_buffer_add_codepoints(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="hb_codepoint_t const *") IntBuffer text, @NativeType(value="unsigned int") int item_offset, int item_length) {
        HarfBuzz.nhb_buffer_add_codepoints(buffer, MemoryUtil.memAddress(text), text.remaining(), item_offset, item_length);
    }

    public static void hb_buffer_append(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="hb_buffer_t const *") long source, @NativeType(value="unsigned int") int start, @NativeType(value="unsigned int") int end) {
        long __functionAddress = Functions.buffer_append;
        if (Checks.CHECKS) {
            Checks.check(buffer);
            Checks.check(source);
        }
        JNI.invokePPV(buffer, source, start, end, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_buffer_set_length(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="unsigned int") int length) {
        long __functionAddress = Functions.buffer_set_length;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        return JNI.invokePI(buffer, length, __functionAddress) != 0;
    }

    @NativeType(value="unsigned int")
    public static int hb_buffer_get_length(@NativeType(value="hb_buffer_t const *") long buffer) {
        long __functionAddress = Functions.buffer_get_length;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        return JNI.invokePI(buffer, __functionAddress);
    }

    public static long nhb_buffer_get_glyph_infos(long buffer, long length) {
        long __functionAddress = Functions.buffer_get_glyph_infos;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        return JNI.invokePPP(buffer, length, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="hb_glyph_info_t *")
    public static @Nullable hb_glyph_info_t.Buffer hb_buffer_get_glyph_infos(@NativeType(value="hb_buffer_t *") long buffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer length = stack.callocInt(1);
        try {
            long __result = HarfBuzz.nhb_buffer_get_glyph_infos(buffer, MemoryUtil.memAddress(length));
            hb_glyph_info_t.Buffer buffer2 = hb_glyph_info_t.createSafe(__result, length.get(0));
            return buffer2;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nhb_buffer_get_glyph_positions(long buffer, long length) {
        long __functionAddress = Functions.buffer_get_glyph_positions;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        return JNI.invokePPP(buffer, length, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="hb_glyph_position_t *")
    public static @Nullable hb_glyph_position_t.Buffer hb_buffer_get_glyph_positions(@NativeType(value="hb_buffer_t *") long buffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer length = stack.callocInt(1);
        try {
            long __result = HarfBuzz.nhb_buffer_get_glyph_positions(buffer, MemoryUtil.memAddress(length));
            hb_glyph_position_t.Buffer buffer2 = hb_glyph_position_t.createSafe(__result, length.get(0));
            return buffer2;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_buffer_has_positions(@NativeType(value="hb_buffer_t *") long buffer) {
        long __functionAddress = Functions.buffer_has_positions;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        return JNI.invokePI(buffer, __functionAddress) != 0;
    }

    public static void hb_buffer_normalize_glyphs(@NativeType(value="hb_buffer_t *") long buffer) {
        long __functionAddress = Functions.buffer_normalize_glyphs;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePV(buffer, __functionAddress);
    }

    public static int nhb_buffer_serialize_format_from_string(long str, int len) {
        long __functionAddress = Functions.buffer_serialize_format_from_string;
        return JNI.invokePI(str, len, __functionAddress);
    }

    @NativeType(value="hb_buffer_serialize_format_t")
    public static int hb_buffer_serialize_format_from_string(@NativeType(value="char const *") ByteBuffer str) {
        return HarfBuzz.nhb_buffer_serialize_format_from_string(MemoryUtil.memAddress(str), str.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="hb_buffer_serialize_format_t")
    public static int hb_buffer_serialize_format_from_string(@NativeType(value="char const *") CharSequence str) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int strEncodedLength = stack.nASCII(str, false);
            long strEncoded = stack.getPointerAddress();
            int n = HarfBuzz.nhb_buffer_serialize_format_from_string(strEncoded, strEncodedLength);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nhb_buffer_serialize_format_to_string(int format) {
        long __functionAddress = Functions.buffer_serialize_format_to_string;
        return JNI.invokeP(format, __functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String hb_buffer_serialize_format_to_string(@NativeType(value="hb_buffer_serialize_format_t") int format) {
        long __result = HarfBuzz.nhb_buffer_serialize_format_to_string(format);
        return MemoryUtil.memASCIISafe(__result);
    }

    public static long nhb_buffer_serialize_list_formats() {
        long __functionAddress = Functions.buffer_serialize_list_formats;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="char const **")
    public static @Nullable PointerBuffer hb_buffer_serialize_list_formats() {
        long __result = HarfBuzz.nhb_buffer_serialize_list_formats();
        return MemoryUtil.memPointerBufferSafe(__result, buffer_serialize_list_formats_COUNT);
    }

    @NativeType(value="char const **")
    public static @Nullable PointerBuffer hb_buffer_serialize_list_formats(long length) {
        long __result = HarfBuzz.nhb_buffer_serialize_list_formats();
        return MemoryUtil.memPointerBufferSafe(__result, (int)length);
    }

    public static int nhb_buffer_serialize_glyphs(long buffer, int start, int end, long buf, int buf_size, long buf_consumed, long font, int format, int flags) {
        long __functionAddress = Functions.buffer_serialize_glyphs;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        return JNI.invokePPPPI(buffer, start, end, buf, buf_size, buf_consumed, font, format, flags, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int hb_buffer_serialize_glyphs(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="unsigned int") int start, @NativeType(value="unsigned int") int end, @NativeType(value="char *") ByteBuffer buf, @NativeType(value="unsigned int *") @Nullable IntBuffer buf_consumed, @NativeType(value="hb_font_t *") long font, @NativeType(value="hb_buffer_serialize_format_t") int format, @NativeType(value="hb_buffer_serialize_flags_t") int flags) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)buf_consumed, 1);
        }
        return HarfBuzz.nhb_buffer_serialize_glyphs(buffer, start, end, MemoryUtil.memAddress(buf), buf.remaining(), MemoryUtil.memAddressSafe(buf_consumed), font, format, flags);
    }

    public static int nhb_buffer_serialize_unicode(long buffer, int start, int end, long buf, int buf_size, long buf_consumed, int format, int flags) {
        long __functionAddress = Functions.buffer_serialize_unicode;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        return JNI.invokePPPI(buffer, start, end, buf, buf_size, buf_consumed, format, flags, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int hb_buffer_serialize_unicode(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="unsigned int") int start, @NativeType(value="unsigned int") int end, @NativeType(value="char *") ByteBuffer buf, @NativeType(value="unsigned int *") @Nullable IntBuffer buf_consumed, @NativeType(value="hb_buffer_serialize_format_t") int format, @NativeType(value="hb_buffer_serialize_flags_t") int flags) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)buf_consumed, 1);
        }
        return HarfBuzz.nhb_buffer_serialize_unicode(buffer, start, end, MemoryUtil.memAddress(buf), buf.remaining(), MemoryUtil.memAddressSafe(buf_consumed), format, flags);
    }

    public static int nhb_buffer_serialize(long buffer, int start, int end, long buf, int buf_size, long buf_consumed, long font, int format, int flags) {
        long __functionAddress = Functions.buffer_serialize;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        return JNI.invokePPPPI(buffer, start, end, buf, buf_size, buf_consumed, font, format, flags, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int hb_buffer_serialize(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="unsigned int") int start, @NativeType(value="unsigned int") int end, @NativeType(value="char *") ByteBuffer buf, @NativeType(value="unsigned int *") @Nullable IntBuffer buf_consumed, @NativeType(value="hb_font_t *") long font, @NativeType(value="hb_buffer_serialize_format_t") int format, @NativeType(value="hb_buffer_serialize_flags_t") int flags) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)buf_consumed, 1);
        }
        return HarfBuzz.nhb_buffer_serialize(buffer, start, end, MemoryUtil.memAddress(buf), buf.remaining(), MemoryUtil.memAddressSafe(buf_consumed), font, format, flags);
    }

    public static int nhb_buffer_deserialize_glyphs(long buffer, long buf, int buf_len, long end_ptr, long font, int format) {
        long __functionAddress = Functions.buffer_deserialize_glyphs;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        return JNI.invokePPPPI(buffer, buf, buf_len, end_ptr, font, format, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_buffer_deserialize_glyphs(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="char const *") ByteBuffer buf, @NativeType(value="char const **") @Nullable PointerBuffer end_ptr, @NativeType(value="hb_font_t *") long font, @NativeType(value="hb_buffer_serialize_format_t") int format) {
        if (Checks.CHECKS) {
            Checks.checkSafe(end_ptr, 1);
        }
        return HarfBuzz.nhb_buffer_deserialize_glyphs(buffer, MemoryUtil.memAddress(buf), buf.remaining(), MemoryUtil.memAddressSafe(end_ptr), font, format) != 0;
    }

    public static int nhb_buffer_deserialize_unicode(long buffer, long buf, int buf_len, long end_ptr, int format) {
        long __functionAddress = Functions.buffer_deserialize_unicode;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        return JNI.invokePPPI(buffer, buf, buf_len, end_ptr, format, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_buffer_deserialize_unicode(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="char const *") ByteBuffer buf, @NativeType(value="char const **") @Nullable PointerBuffer end_ptr, @NativeType(value="hb_buffer_serialize_format_t") int format) {
        if (Checks.CHECKS) {
            Checks.checkSafe(end_ptr, 1);
        }
        return HarfBuzz.nhb_buffer_deserialize_unicode(buffer, MemoryUtil.memAddress(buf), buf.remaining(), MemoryUtil.memAddressSafe(end_ptr), format) != 0;
    }

    @NativeType(value="hb_buffer_diff_flags_t")
    public static int hb_buffer_diff(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="hb_buffer_t *") long reference, @NativeType(value="hb_codepoint_t") int dottedcircle_glyph, @NativeType(value="unsigned int") int position_fuzz) {
        long __functionAddress = Functions.buffer_diff;
        if (Checks.CHECKS) {
            Checks.check(buffer);
            Checks.check(reference);
        }
        return JNI.invokePPI(buffer, reference, dottedcircle_glyph, position_fuzz, __functionAddress);
    }

    public static void nhb_buffer_set_message_func(long buffer, long func, long user_data, long destroy) {
        long __functionAddress = Functions.buffer_set_message_func;
        if (Checks.CHECKS) {
            Checks.check(buffer);
        }
        JNI.invokePPPPV(buffer, func, user_data, destroy, __functionAddress);
    }

    public static void hb_buffer_set_message_func(@NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="hb_buffer_message_func_t") hb_buffer_message_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_buffer_set_message_func(buffer, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_draw_funcs_set_move_to_func(long dfuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.draw_funcs_set_move_to_func;
        if (Checks.CHECKS) {
            Checks.check(dfuncs);
        }
        JNI.invokePPPPV(dfuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_draw_funcs_set_move_to_func(@NativeType(value="hb_draw_funcs_t *") long dfuncs, @NativeType(value="hb_draw_move_to_func_t") hb_draw_move_to_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_draw_funcs_set_move_to_func(dfuncs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_draw_funcs_set_line_to_func(long dfuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.draw_funcs_set_line_to_func;
        if (Checks.CHECKS) {
            Checks.check(dfuncs);
        }
        JNI.invokePPPPV(dfuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_draw_funcs_set_line_to_func(@NativeType(value="hb_draw_funcs_t *") long dfuncs, @NativeType(value="hb_draw_line_to_func_t") hb_draw_line_to_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_draw_funcs_set_line_to_func(dfuncs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_draw_funcs_set_quadratic_to_func(long dfuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.draw_funcs_set_quadratic_to_func;
        if (Checks.CHECKS) {
            Checks.check(dfuncs);
        }
        JNI.invokePPPPV(dfuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_draw_funcs_set_quadratic_to_func(@NativeType(value="hb_draw_funcs_t *") long dfuncs, @NativeType(value="hb_draw_quadratic_to_func_t") hb_draw_quadratic_to_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_draw_funcs_set_quadratic_to_func(dfuncs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_draw_funcs_set_cubic_to_func(long dfuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.draw_funcs_set_cubic_to_func;
        if (Checks.CHECKS) {
            Checks.check(dfuncs);
        }
        JNI.invokePPPPV(dfuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_draw_funcs_set_cubic_to_func(@NativeType(value="hb_draw_funcs_t *") long dfuncs, @NativeType(value="hb_draw_cubic_to_func_t") hb_draw_cubic_to_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_draw_funcs_set_cubic_to_func(dfuncs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_draw_funcs_set_close_path_func(long dfuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.draw_funcs_set_close_path_func;
        if (Checks.CHECKS) {
            Checks.check(dfuncs);
        }
        JNI.invokePPPPV(dfuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_draw_funcs_set_close_path_func(@NativeType(value="hb_draw_funcs_t *") long dfuncs, @NativeType(value="hb_draw_close_path_func_t") hb_draw_close_path_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_draw_funcs_set_close_path_func(dfuncs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    @NativeType(value="hb_draw_funcs_t *")
    public static long hb_draw_funcs_create() {
        long __functionAddress = Functions.draw_funcs_create;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="hb_draw_funcs_t *")
    public static long hb_draw_funcs_get_empty() {
        long __functionAddress = Functions.draw_funcs_get_empty;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="hb_draw_funcs_t *")
    public static long hb_draw_funcs_reference(@NativeType(value="hb_draw_funcs_t *") long dfuncs) {
        long __functionAddress = Functions.draw_funcs_reference;
        if (Checks.CHECKS) {
            Checks.check(dfuncs);
        }
        return JNI.invokePP(dfuncs, __functionAddress);
    }

    public static void hb_draw_funcs_destroy(@NativeType(value="hb_draw_funcs_t *") long dfuncs) {
        long __functionAddress = Functions.draw_funcs_destroy;
        if (Checks.CHECKS) {
            Checks.check(dfuncs);
        }
        JNI.invokePV(dfuncs, __functionAddress);
    }

    public static int nhb_draw_funcs_set_user_data(long dfuncs, long key, long data, long destroy, int replace) {
        long __functionAddress = Functions.draw_funcs_set_user_data;
        if (Checks.CHECKS) {
            Checks.check(dfuncs);
        }
        return JNI.invokePPPPI(dfuncs, key, data, destroy, replace, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_draw_funcs_set_user_data(@NativeType(value="hb_draw_funcs_t *") long dfuncs, @NativeType(value="hb_user_data_key_t *") hb_user_data_key_t key, @NativeType(value="void *") long data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy, @NativeType(value="hb_bool_t") boolean replace) {
        return HarfBuzz.nhb_draw_funcs_set_user_data(dfuncs, key.address(), data, MemoryUtil.memAddressSafe(destroy), replace ? 1 : 0) != 0;
    }

    public static long nhb_draw_funcs_get_user_data(long dfuncs, long key) {
        long __functionAddress = Functions.draw_funcs_get_user_data;
        if (Checks.CHECKS) {
            Checks.check(dfuncs);
        }
        return JNI.invokePPP(dfuncs, key, __functionAddress);
    }

    @NativeType(value="void *")
    public static long hb_draw_funcs_get_user_data(@NativeType(value="hb_draw_funcs_t const *") long dfuncs, @NativeType(value="hb_user_data_key_t *") hb_user_data_key_t key) {
        return HarfBuzz.nhb_draw_funcs_get_user_data(dfuncs, key.address());
    }

    public static void hb_draw_funcs_make_immutable(@NativeType(value="hb_draw_funcs_t *") long dfuncs) {
        long __functionAddress = Functions.draw_funcs_make_immutable;
        if (Checks.CHECKS) {
            Checks.check(dfuncs);
        }
        JNI.invokePV(dfuncs, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_draw_funcs_is_immutable(@NativeType(value="hb_draw_funcs_t *") long dfuncs) {
        long __functionAddress = Functions.draw_funcs_is_immutable;
        if (Checks.CHECKS) {
            Checks.check(dfuncs);
        }
        return JNI.invokePI(dfuncs, __functionAddress) != 0;
    }

    public static void nhb_draw_move_to(long dfuncs, long draw_data, long st, float to_x, float to_y) {
        long __functionAddress = Functions.draw_move_to;
        if (Checks.CHECKS) {
            Checks.check(dfuncs);
        }
        JNI.invokePPPV(dfuncs, draw_data, st, to_x, to_y, __functionAddress);
    }

    public static void hb_draw_move_to(@NativeType(value="hb_draw_funcs_t *") long dfuncs, @NativeType(value="void *") ByteBuffer draw_data, @NativeType(value="hb_draw_state_t *") hb_draw_state_t st, float to_x, float to_y) {
        HarfBuzz.nhb_draw_move_to(dfuncs, MemoryUtil.memAddress(draw_data), st.address(), to_x, to_y);
    }

    public static void nhb_draw_line_to(long dfuncs, long draw_data, long st, float to_x, float to_y) {
        long __functionAddress = Functions.draw_line_to;
        if (Checks.CHECKS) {
            Checks.check(dfuncs);
        }
        JNI.invokePPPV(dfuncs, draw_data, st, to_x, to_y, __functionAddress);
    }

    public static void hb_draw_line_to(@NativeType(value="hb_draw_funcs_t *") long dfuncs, @NativeType(value="void *") ByteBuffer draw_data, @NativeType(value="hb_draw_state_t *") hb_draw_state_t st, float to_x, float to_y) {
        HarfBuzz.nhb_draw_line_to(dfuncs, MemoryUtil.memAddress(draw_data), st.address(), to_x, to_y);
    }

    public static void nhb_draw_quadratic_to(long dfuncs, long draw_data, long st, float control_x, float control_y, float to_x, float to_y) {
        long __functionAddress = Functions.draw_quadratic_to;
        if (Checks.CHECKS) {
            Checks.check(dfuncs);
        }
        JNI.invokePPPV(dfuncs, draw_data, st, control_x, control_y, to_x, to_y, __functionAddress);
    }

    public static void hb_draw_quadratic_to(@NativeType(value="hb_draw_funcs_t *") long dfuncs, @NativeType(value="void *") ByteBuffer draw_data, @NativeType(value="hb_draw_state_t *") hb_draw_state_t st, float control_x, float control_y, float to_x, float to_y) {
        HarfBuzz.nhb_draw_quadratic_to(dfuncs, MemoryUtil.memAddress(draw_data), st.address(), control_x, control_y, to_x, to_y);
    }

    public static void nhb_draw_cubic_to(long dfuncs, long draw_data, long st, float control1_x, float control1_y, float control2_x, float control2_y, float to_x, float to_y) {
        long __functionAddress = Functions.draw_cubic_to;
        if (Checks.CHECKS) {
            Checks.check(dfuncs);
        }
        JNI.invokePPPV(dfuncs, draw_data, st, control1_x, control1_y, control2_x, control2_y, to_x, to_y, __functionAddress);
    }

    public static void hb_draw_cubic_to(@NativeType(value="hb_draw_funcs_t *") long dfuncs, @NativeType(value="void *") ByteBuffer draw_data, @NativeType(value="hb_draw_state_t *") hb_draw_state_t st, float control1_x, float control1_y, float control2_x, float control2_y, float to_x, float to_y) {
        HarfBuzz.nhb_draw_cubic_to(dfuncs, MemoryUtil.memAddress(draw_data), st.address(), control1_x, control1_y, control2_x, control2_y, to_x, to_y);
    }

    public static void nhb_draw_close_path(long dfuncs, long draw_data, long st) {
        long __functionAddress = Functions.draw_close_path;
        if (Checks.CHECKS) {
            Checks.check(dfuncs);
        }
        JNI.invokePPPV(dfuncs, draw_data, st, __functionAddress);
    }

    public static void hb_draw_close_path(@NativeType(value="hb_draw_funcs_t *") long dfuncs, @NativeType(value="void *") ByteBuffer draw_data, @NativeType(value="hb_draw_state_t *") hb_draw_state_t st) {
        HarfBuzz.nhb_draw_close_path(dfuncs, MemoryUtil.memAddress(draw_data), st.address());
    }

    @NativeType(value="unsigned int")
    public static int hb_face_count(@NativeType(value="hb_blob_t *") long blob) {
        long __functionAddress = Functions.face_count;
        if (Checks.CHECKS) {
            Checks.check(blob);
        }
        return JNI.invokePI(blob, __functionAddress);
    }

    @NativeType(value="hb_face_t *")
    public static long hb_face_create(@NativeType(value="hb_blob_t *") long blob, @NativeType(value="unsigned int") int index) {
        long __functionAddress = Functions.face_create;
        if (Checks.CHECKS) {
            Checks.check(blob);
        }
        return JNI.invokePP(blob, index, __functionAddress);
    }

    @NativeType(value="hb_face_t *")
    public static long hb_face_create_or_fail(@NativeType(value="hb_blob_t *") long blob, @NativeType(value="unsigned int") int index) {
        long __functionAddress = Functions.face_create_or_fail;
        if (Checks.CHECKS) {
            Checks.check(blob);
        }
        return JNI.invokePP(blob, index, __functionAddress);
    }

    public static long nhb_face_create_from_file_or_fail(long file_name, int index) {
        long __functionAddress = Functions.face_create_from_file_or_fail;
        return JNI.invokePP(file_name, index, __functionAddress);
    }

    @NativeType(value="hb_face_t *")
    public static long hb_face_create_from_file_or_fail(@NativeType(value="char const *") ByteBuffer file_name, @NativeType(value="unsigned int") int index) {
        if (Checks.CHECKS) {
            Checks.checkNT1(file_name);
        }
        return HarfBuzz.nhb_face_create_from_file_or_fail(MemoryUtil.memAddress(file_name), index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="hb_face_t *")
    public static long hb_face_create_from_file_or_fail(@NativeType(value="char const *") CharSequence file_name, @NativeType(value="unsigned int") int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(file_name, true);
            long file_nameEncoded = stack.getPointerAddress();
            long l = HarfBuzz.nhb_face_create_from_file_or_fail(file_nameEncoded, index);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nhb_face_create_for_tables(long reference_table_func, long user_data, long destroy) {
        long __functionAddress = Functions.face_create_for_tables;
        return JNI.invokePPPP(reference_table_func, user_data, destroy, __functionAddress);
    }

    @NativeType(value="hb_face_t *")
    public static long hb_face_create_for_tables(@NativeType(value="hb_reference_table_func_t") hb_reference_table_func_tI reference_table_func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        return HarfBuzz.nhb_face_create_for_tables(reference_table_func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    @NativeType(value="hb_face_t *")
    public static long hb_face_get_empty() {
        long __functionAddress = Functions.face_get_empty;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="hb_face_t *")
    public static long hb_face_reference(@NativeType(value="hb_face_t *") long face) {
        long __functionAddress = Functions.face_reference;
        if (Checks.CHECKS) {
            Checks.check(face);
        }
        return JNI.invokePP(face, __functionAddress);
    }

    public static void hb_face_destroy(@NativeType(value="hb_face_t *") long face) {
        long __functionAddress = Functions.face_destroy;
        if (Checks.CHECKS) {
            Checks.check(face);
        }
        JNI.invokePV(face, __functionAddress);
    }

    public static int nhb_face_set_user_data(long face, long key, long data, long destroy, int replace) {
        long __functionAddress = Functions.face_set_user_data;
        if (Checks.CHECKS) {
            Checks.check(face);
        }
        return JNI.invokePPPPI(face, key, data, destroy, replace, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_face_set_user_data(@NativeType(value="hb_face_t *") long face, @NativeType(value="hb_user_data_key_t *") hb_user_data_key_t key, @NativeType(value="void *") long data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy, @NativeType(value="hb_bool_t") boolean replace) {
        return HarfBuzz.nhb_face_set_user_data(face, key.address(), data, MemoryUtil.memAddressSafe(destroy), replace ? 1 : 0) != 0;
    }

    public static long nhb_face_get_user_data(long face, long key) {
        long __functionAddress = Functions.face_get_user_data;
        if (Checks.CHECKS) {
            Checks.check(face);
        }
        return JNI.invokePPP(face, key, __functionAddress);
    }

    @NativeType(value="void *")
    public static long hb_face_get_user_data(@NativeType(value="hb_face_t const *") long face, @NativeType(value="hb_user_data_key_t *") hb_user_data_key_t key) {
        return HarfBuzz.nhb_face_get_user_data(face, key.address());
    }

    public static void hb_face_make_immutable(@NativeType(value="hb_face_t *") long face) {
        long __functionAddress = Functions.face_make_immutable;
        if (Checks.CHECKS) {
            Checks.check(face);
        }
        JNI.invokePV(face, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_face_is_immutable(@NativeType(value="hb_face_t const *") long face) {
        long __functionAddress = Functions.face_is_immutable;
        if (Checks.CHECKS) {
            Checks.check(face);
        }
        return JNI.invokePI(face, __functionAddress) != 0;
    }

    @NativeType(value="hb_blob_t *")
    public static long hb_face_reference_table(@NativeType(value="hb_face_t const *") long face, @NativeType(value="hb_tag_t") int tag) {
        long __functionAddress = Functions.face_reference_table;
        if (Checks.CHECKS) {
            Checks.check(face);
        }
        return JNI.invokePP(face, tag, __functionAddress);
    }

    @NativeType(value="hb_blob_t *")
    public static long hb_face_reference_blob(@NativeType(value="hb_face_t *") long face) {
        long __functionAddress = Functions.face_reference_blob;
        if (Checks.CHECKS) {
            Checks.check(face);
        }
        return JNI.invokePP(face, __functionAddress);
    }

    public static void hb_face_set_index(@NativeType(value="hb_face_t *") long face, @NativeType(value="unsigned int") int index) {
        long __functionAddress = Functions.face_set_index;
        if (Checks.CHECKS) {
            Checks.check(face);
        }
        JNI.invokePV(face, index, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int hb_face_get_index(@NativeType(value="hb_face_t const *") long face) {
        long __functionAddress = Functions.face_get_index;
        if (Checks.CHECKS) {
            Checks.check(face);
        }
        return JNI.invokePI(face, __functionAddress);
    }

    public static void hb_face_set_upem(@NativeType(value="hb_face_t *") long face, @NativeType(value="unsigned int") int upem) {
        long __functionAddress = Functions.face_set_upem;
        if (Checks.CHECKS) {
            Checks.check(face);
        }
        JNI.invokePV(face, upem, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int hb_face_get_upem(@NativeType(value="hb_face_t const *") long face) {
        long __functionAddress = Functions.face_get_upem;
        if (Checks.CHECKS) {
            Checks.check(face);
        }
        return JNI.invokePI(face, __functionAddress);
    }

    public static void hb_face_set_glyph_count(@NativeType(value="hb_face_t *") long face, @NativeType(value="unsigned int") int glyph_count) {
        long __functionAddress = Functions.face_set_glyph_count;
        if (Checks.CHECKS) {
            Checks.check(face);
        }
        JNI.invokePV(face, glyph_count, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int hb_face_get_glyph_count(@NativeType(value="hb_face_t const *") long face) {
        long __functionAddress = Functions.face_get_glyph_count;
        if (Checks.CHECKS) {
            Checks.check(face);
        }
        return JNI.invokePI(face, __functionAddress);
    }

    public static void nhb_face_set_get_table_tags_func(long face, long func, long user_data, long destroy) {
        long __functionAddress = Functions.face_set_get_table_tags_func;
        if (Checks.CHECKS) {
            Checks.check(face);
        }
        JNI.invokePPPPV(face, func, user_data, destroy, __functionAddress);
    }

    public static void hb_face_set_get_table_tags_func(@NativeType(value="hb_face_t *") long face, @NativeType(value="hb_get_table_tags_func_t") hb_get_table_tags_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_face_set_get_table_tags_func(face, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static int nhb_face_get_table_tags(long face, int start_offset, long table_count, long table_tags) {
        long __functionAddress = Functions.face_get_table_tags;
        if (Checks.CHECKS) {
            Checks.check(face);
        }
        return JNI.invokePPPI(face, start_offset, table_count, table_tags, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int hb_face_get_table_tags(@NativeType(value="hb_face_t const *") long face, @NativeType(value="unsigned int") int start_offset, @NativeType(value="unsigned int *") IntBuffer table_count, @NativeType(value="hb_tag_t *") IntBuffer table_tags) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)table_count, 1);
            Checks.check((Buffer)table_tags, table_count.get(table_count.position()));
        }
        return HarfBuzz.nhb_face_get_table_tags(face, start_offset, MemoryUtil.memAddress(table_count), MemoryUtil.memAddress(table_tags));
    }

    public static void hb_face_collect_unicodes(@NativeType(value="hb_face_t *") long face, @NativeType(value="hb_set_t *") long out) {
        long __functionAddress = Functions.face_collect_unicodes;
        if (Checks.CHECKS) {
            Checks.check(face);
            Checks.check(out);
        }
        JNI.invokePPV(face, out, __functionAddress);
    }

    public static void hb_face_collect_nominal_glyph_mapping(@NativeType(value="hb_face_t *") long face, @NativeType(value="hb_map_t *") long mapping, @NativeType(value="hb_set_t *") long unicodes) {
        long __functionAddress = Functions.face_collect_nominal_glyph_mapping;
        if (Checks.CHECKS) {
            Checks.check(face);
            Checks.check(mapping);
        }
        JNI.invokePPPV(face, mapping, unicodes, __functionAddress);
    }

    public static void hb_face_collect_variation_selectors(@NativeType(value="hb_face_t *") long face, @NativeType(value="hb_set_t *") long out) {
        long __functionAddress = Functions.face_collect_variation_selectors;
        if (Checks.CHECKS) {
            Checks.check(face);
            Checks.check(out);
        }
        JNI.invokePPV(face, out, __functionAddress);
    }

    public static void hb_face_collect_variation_unicodes(@NativeType(value="hb_face_t *") long face, @NativeType(value="hb_codepoint_t") int variation_selector, @NativeType(value="hb_set_t *") long out) {
        long __functionAddress = Functions.face_collect_variation_unicodes;
        if (Checks.CHECKS) {
            Checks.check(face);
            Checks.check(out);
        }
        JNI.invokePPV(face, variation_selector, out, __functionAddress);
    }

    @NativeType(value="hb_face_t *")
    public static long hb_face_builder_create() {
        long __functionAddress = Functions.face_builder_create;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_face_builder_add_table(@NativeType(value="hb_face_t *") long face, @NativeType(value="hb_tag_t") int tag, @NativeType(value="hb_blob_t *") long blob) {
        long __functionAddress = Functions.face_builder_add_table;
        if (Checks.CHECKS) {
            Checks.check(face);
            Checks.check(blob);
        }
        return JNI.invokePPI(face, tag, blob, __functionAddress) != 0;
    }

    public static void nhb_face_builder_sort_tables(long face, long tags) {
        long __functionAddress = Functions.face_builder_sort_tables;
        if (Checks.CHECKS) {
            Checks.check(face);
        }
        JNI.invokePPV(face, tags, __functionAddress);
    }

    public static void hb_face_builder_sort_tables(@NativeType(value="hb_face_t *") long face, @NativeType(value="hb_tag_t const *") IntBuffer tags) {
        if (Checks.CHECKS) {
            Checks.checkNT(tags);
        }
        HarfBuzz.nhb_face_builder_sort_tables(face, MemoryUtil.memAddress(tags));
    }

    @NativeType(value="hb_font_funcs_t *")
    public static long hb_font_funcs_create() {
        long __functionAddress = Functions.font_funcs_create;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="hb_font_funcs_t *")
    public static long hb_font_funcs_get_empty() {
        long __functionAddress = Functions.font_funcs_get_empty;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="hb_font_funcs_t *")
    public static long hb_font_funcs_reference(@NativeType(value="hb_font_funcs_t *") long ffuncs) {
        long __functionAddress = Functions.font_funcs_reference;
        if (Checks.CHECKS) {
            Checks.check(ffuncs);
        }
        return JNI.invokePP(ffuncs, __functionAddress);
    }

    public static void hb_font_funcs_destroy(@NativeType(value="hb_font_funcs_t *") long ffuncs) {
        long __functionAddress = Functions.font_funcs_destroy;
        if (Checks.CHECKS) {
            Checks.check(ffuncs);
        }
        JNI.invokePV(ffuncs, __functionAddress);
    }

    public static int nhb_font_funcs_set_user_data(long ffuncs, long key, long data, long destroy, int replace) {
        long __functionAddress = Functions.font_funcs_set_user_data;
        if (Checks.CHECKS) {
            Checks.check(ffuncs);
        }
        return JNI.invokePPPPI(ffuncs, key, data, destroy, replace, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_font_funcs_set_user_data(@NativeType(value="hb_font_funcs_t *") long ffuncs, @NativeType(value="hb_user_data_key_t *") hb_user_data_key_t key, @NativeType(value="void *") long data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy, @NativeType(value="hb_bool_t") boolean replace) {
        return HarfBuzz.nhb_font_funcs_set_user_data(ffuncs, key.address(), data, MemoryUtil.memAddressSafe(destroy), replace ? 1 : 0) != 0;
    }

    public static long nhb_font_funcs_get_user_data(long ffuncs, long key) {
        long __functionAddress = Functions.font_funcs_get_user_data;
        if (Checks.CHECKS) {
            Checks.check(ffuncs);
        }
        return JNI.invokePPP(ffuncs, key, __functionAddress);
    }

    @NativeType(value="void *")
    public static long hb_font_funcs_get_user_data(@NativeType(value="hb_font_funcs_t const *") long ffuncs, @NativeType(value="hb_user_data_key_t *") hb_user_data_key_t key) {
        return HarfBuzz.nhb_font_funcs_get_user_data(ffuncs, key.address());
    }

    public static void hb_font_funcs_make_immutable(@NativeType(value="hb_font_funcs_t *") long ffuncs) {
        long __functionAddress = Functions.font_funcs_make_immutable;
        if (Checks.CHECKS) {
            Checks.check(ffuncs);
        }
        JNI.invokePV(ffuncs, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_font_funcs_is_immutable(@NativeType(value="hb_font_funcs_t *") long ffuncs) {
        long __functionAddress = Functions.font_funcs_is_immutable;
        if (Checks.CHECKS) {
            Checks.check(ffuncs);
        }
        return JNI.invokePI(ffuncs, __functionAddress) != 0;
    }

    public static void nhb_font_funcs_set_font_h_extents_func(long ffuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.font_funcs_set_font_h_extents_func;
        if (Checks.CHECKS) {
            Checks.check(ffuncs);
            Checks.check(func);
        }
        JNI.invokePPPPV(ffuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_font_funcs_set_font_h_extents_func(@NativeType(value="hb_font_funcs_t *") long ffuncs, @NativeType(value="hb_font_get_font_h_extents_func_t") long func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_font_funcs_set_font_h_extents_func(ffuncs, func, user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_font_funcs_set_font_v_extents_func(long ffuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.font_funcs_set_font_v_extents_func;
        if (Checks.CHECKS) {
            Checks.check(ffuncs);
            Checks.check(func);
        }
        JNI.invokePPPPV(ffuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_font_funcs_set_font_v_extents_func(@NativeType(value="hb_font_funcs_t *") long ffuncs, @NativeType(value="hb_font_get_font_v_extents_func_t") long func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_font_funcs_set_font_v_extents_func(ffuncs, func, user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_font_funcs_set_nominal_glyph_func(long ffuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.font_funcs_set_nominal_glyph_func;
        if (Checks.CHECKS) {
            Checks.check(ffuncs);
        }
        JNI.invokePPPPV(ffuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_font_funcs_set_nominal_glyph_func(@NativeType(value="hb_font_funcs_t *") long ffuncs, @NativeType(value="hb_font_get_nominal_glyph_func_t") hb_font_get_nominal_glyph_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_font_funcs_set_nominal_glyph_func(ffuncs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_font_funcs_set_nominal_glyphs_func(long ffuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.font_funcs_set_nominal_glyphs_func;
        if (Checks.CHECKS) {
            Checks.check(ffuncs);
        }
        JNI.invokePPPPV(ffuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_font_funcs_set_nominal_glyphs_func(@NativeType(value="hb_font_funcs_t *") long ffuncs, @NativeType(value="hb_font_get_nominal_glyphs_func_t") hb_font_get_nominal_glyphs_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_font_funcs_set_nominal_glyphs_func(ffuncs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_font_funcs_set_variation_glyph_func(long ffuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.font_funcs_set_variation_glyph_func;
        if (Checks.CHECKS) {
            Checks.check(ffuncs);
        }
        JNI.invokePPPPV(ffuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_font_funcs_set_variation_glyph_func(@NativeType(value="hb_font_funcs_t *") long ffuncs, @NativeType(value="hb_font_get_variation_glyph_func_t") hb_font_get_variation_glyph_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_font_funcs_set_variation_glyph_func(ffuncs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_font_funcs_set_glyph_h_advance_func(long ffuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.font_funcs_set_glyph_h_advance_func;
        if (Checks.CHECKS) {
            Checks.check(ffuncs);
            Checks.check(func);
        }
        JNI.invokePPPPV(ffuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_font_funcs_set_glyph_h_advance_func(@NativeType(value="hb_font_funcs_t *") long ffuncs, @NativeType(value="hb_font_get_glyph_h_advance_func_t") long func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_font_funcs_set_glyph_h_advance_func(ffuncs, func, user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_font_funcs_set_glyph_v_advance_func(long ffuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.font_funcs_set_glyph_v_advance_func;
        if (Checks.CHECKS) {
            Checks.check(ffuncs);
            Checks.check(func);
        }
        JNI.invokePPPPV(ffuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_font_funcs_set_glyph_v_advance_func(@NativeType(value="hb_font_funcs_t *") long ffuncs, @NativeType(value="hb_font_get_glyph_v_advance_func_t") long func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_font_funcs_set_glyph_v_advance_func(ffuncs, func, user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_font_funcs_set_glyph_h_advances_func(long ffuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.font_funcs_set_glyph_h_advances_func;
        if (Checks.CHECKS) {
            Checks.check(ffuncs);
            Checks.check(func);
        }
        JNI.invokePPPPV(ffuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_font_funcs_set_glyph_h_advances_func(@NativeType(value="hb_font_funcs_t *") long ffuncs, @NativeType(value="hb_font_get_glyph_h_advances_func_t") long func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_font_funcs_set_glyph_h_advances_func(ffuncs, func, user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_font_funcs_set_glyph_v_advances_func(long ffuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.font_funcs_set_glyph_v_advances_func;
        if (Checks.CHECKS) {
            Checks.check(ffuncs);
            Checks.check(func);
        }
        JNI.invokePPPPV(ffuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_font_funcs_set_glyph_v_advances_func(@NativeType(value="hb_font_funcs_t *") long ffuncs, @NativeType(value="hb_font_get_glyph_v_advances_func_t") long func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_font_funcs_set_glyph_v_advances_func(ffuncs, func, user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_font_funcs_set_glyph_h_origin_func(long ffuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.font_funcs_set_glyph_h_origin_func;
        if (Checks.CHECKS) {
            Checks.check(ffuncs);
            Checks.check(func);
        }
        JNI.invokePPPPV(ffuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_font_funcs_set_glyph_h_origin_func(@NativeType(value="hb_font_funcs_t *") long ffuncs, @NativeType(value="hb_font_get_glyph_h_origin_func_t") long func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_font_funcs_set_glyph_h_origin_func(ffuncs, func, user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_font_funcs_set_glyph_v_origin_func(long ffuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.font_funcs_set_glyph_v_origin_func;
        if (Checks.CHECKS) {
            Checks.check(ffuncs);
            Checks.check(func);
        }
        JNI.invokePPPPV(ffuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_font_funcs_set_glyph_v_origin_func(@NativeType(value="hb_font_funcs_t *") long ffuncs, @NativeType(value="hb_font_get_glyph_v_origin_func_t") long func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_font_funcs_set_glyph_v_origin_func(ffuncs, func, user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_font_funcs_set_glyph_h_kerning_func(long ffuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.font_funcs_set_glyph_h_kerning_func;
        if (Checks.CHECKS) {
            Checks.check(ffuncs);
            Checks.check(func);
        }
        JNI.invokePPPPV(ffuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_font_funcs_set_glyph_h_kerning_func(@NativeType(value="hb_font_funcs_t *") long ffuncs, @NativeType(value="hb_font_get_glyph_h_kerning_func_t") long func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_font_funcs_set_glyph_h_kerning_func(ffuncs, func, user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_font_funcs_set_glyph_extents_func(long ffuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.font_funcs_set_glyph_extents_func;
        if (Checks.CHECKS) {
            Checks.check(ffuncs);
        }
        JNI.invokePPPPV(ffuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_font_funcs_set_glyph_extents_func(@NativeType(value="hb_font_funcs_t *") long ffuncs, @NativeType(value="hb_font_get_glyph_extents_func_t") hb_font_get_glyph_extents_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_font_funcs_set_glyph_extents_func(ffuncs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_font_funcs_set_glyph_contour_point_func(long ffuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.font_funcs_set_glyph_contour_point_func;
        if (Checks.CHECKS) {
            Checks.check(ffuncs);
        }
        JNI.invokePPPPV(ffuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_font_funcs_set_glyph_contour_point_func(@NativeType(value="hb_font_funcs_t *") long ffuncs, @NativeType(value="hb_font_get_glyph_contour_point_func_t") hb_font_get_glyph_contour_point_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_font_funcs_set_glyph_contour_point_func(ffuncs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_font_funcs_set_glyph_name_func(long ffuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.font_funcs_set_glyph_name_func;
        if (Checks.CHECKS) {
            Checks.check(ffuncs);
        }
        JNI.invokePPPPV(ffuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_font_funcs_set_glyph_name_func(@NativeType(value="hb_font_funcs_t *") long ffuncs, @NativeType(value="hb_font_get_glyph_name_func_t") hb_font_get_glyph_name_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_font_funcs_set_glyph_name_func(ffuncs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_font_funcs_set_glyph_from_name_func(long ffuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.font_funcs_set_glyph_from_name_func;
        if (Checks.CHECKS) {
            Checks.check(ffuncs);
        }
        JNI.invokePPPPV(ffuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_font_funcs_set_glyph_from_name_func(@NativeType(value="hb_font_funcs_t *") long ffuncs, @NativeType(value="hb_font_get_glyph_from_name_func_t") hb_font_get_glyph_from_name_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_font_funcs_set_glyph_from_name_func(ffuncs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_font_funcs_set_draw_glyph_func(long ffuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.font_funcs_set_draw_glyph_func;
        if (Checks.CHECKS) {
            Checks.check(ffuncs);
        }
        JNI.invokePPPPV(ffuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_font_funcs_set_draw_glyph_func(@NativeType(value="hb_font_funcs_t *") long ffuncs, @NativeType(value="hb_font_draw_glyph_func_t") hb_font_draw_glyph_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_font_funcs_set_draw_glyph_func(ffuncs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_font_funcs_set_paint_glyph_func(long ffuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.font_funcs_set_paint_glyph_func;
        if (Checks.CHECKS) {
            Checks.check(ffuncs);
        }
        JNI.invokePPPPV(ffuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_font_funcs_set_paint_glyph_func(@NativeType(value="hb_font_funcs_t *") long ffuncs, @NativeType(value="hb_font_paint_glyph_func_t") hb_font_paint_glyph_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_font_funcs_set_paint_glyph_func(ffuncs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static int nhb_font_get_h_extents(long font, long extents) {
        long __functionAddress = Functions.font_get_h_extents;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePPI(font, extents, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_font_get_h_extents(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_font_extents_t *") hb_font_extents_t extents) {
        return HarfBuzz.nhb_font_get_h_extents(font, extents.address()) != 0;
    }

    public static int nhb_font_get_v_extents(long font, long extents) {
        long __functionAddress = Functions.font_get_v_extents;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePPI(font, extents, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_font_get_v_extents(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_font_extents_t *") hb_font_extents_t extents) {
        return HarfBuzz.nhb_font_get_v_extents(font, extents.address()) != 0;
    }

    public static int nhb_font_get_nominal_glyph(long font, int unicode, long glyph) {
        long __functionAddress = Functions.font_get_nominal_glyph;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePPI(font, unicode, glyph, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_font_get_nominal_glyph(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_codepoint_t") int unicode, @NativeType(value="hb_codepoint_t *") IntBuffer glyph) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)glyph, 1);
        }
        return HarfBuzz.nhb_font_get_nominal_glyph(font, unicode, MemoryUtil.memAddress(glyph)) != 0;
    }

    public static int nhb_font_get_variation_glyph(long font, int unicode, int variation_selector, long glyph) {
        long __functionAddress = Functions.font_get_variation_glyph;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePPI(font, unicode, variation_selector, glyph, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_font_get_variation_glyph(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_codepoint_t") int unicode, @NativeType(value="hb_codepoint_t") int variation_selector, @NativeType(value="hb_codepoint_t *") IntBuffer glyph) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)glyph, 1);
        }
        return HarfBuzz.nhb_font_get_variation_glyph(font, unicode, variation_selector, MemoryUtil.memAddress(glyph)) != 0;
    }

    public static int nhb_font_get_nominal_glyphs(long font, int count, long first_unicode, int unicode_stride, long first_glyph, int glyph_stride) {
        long __functionAddress = Functions.font_get_nominal_glyphs;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePPPI(font, count, first_unicode, unicode_stride, first_glyph, glyph_stride, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int hb_font_get_nominal_glyphs(@NativeType(value="hb_font_t *") long font, @NativeType(value="unsigned int") int count, @NativeType(value="hb_codepoint_t const *") IntBuffer first_unicode, @NativeType(value="unsigned int") int unicode_stride, @NativeType(value="hb_codepoint_t *") IntBuffer first_glyph, @NativeType(value="unsigned int") int glyph_stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)first_unicode, count * unicode_stride >> 2);
            Checks.check((Buffer)first_glyph, count * glyph_stride >> 2);
        }
        return HarfBuzz.nhb_font_get_nominal_glyphs(font, count, MemoryUtil.memAddress(first_unicode), unicode_stride, MemoryUtil.memAddress(first_glyph), glyph_stride);
    }

    @NativeType(value="hb_position_t")
    public static int hb_font_get_glyph_h_advance(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_codepoint_t") int glyph) {
        long __functionAddress = Functions.font_get_glyph_h_advance;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePI(font, glyph, __functionAddress);
    }

    @NativeType(value="hb_position_t")
    public static int hb_font_get_glyph_v_advance(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_codepoint_t") int glyph) {
        long __functionAddress = Functions.font_get_glyph_v_advance;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePI(font, glyph, __functionAddress);
    }

    public static void nhb_font_get_glyph_h_advances(long font, int count, long first_glyph, int glyph_stride, long first_advance, int advance_stride) {
        long __functionAddress = Functions.font_get_glyph_h_advances;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePPPV(font, count, first_glyph, glyph_stride, first_advance, advance_stride, __functionAddress);
    }

    public static void hb_font_get_glyph_h_advances(@NativeType(value="hb_font_t *") long font, @NativeType(value="unsigned int") int count, @NativeType(value="hb_codepoint_t const *") IntBuffer first_glyph, @NativeType(value="unsigned int") int glyph_stride, @NativeType(value="hb_position_t *") IntBuffer first_advance, @NativeType(value="unsigned int") int advance_stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)first_glyph, count * glyph_stride >> 2);
            Checks.check((Buffer)first_advance, count * advance_stride >> 2);
        }
        HarfBuzz.nhb_font_get_glyph_h_advances(font, count, MemoryUtil.memAddress(first_glyph), glyph_stride, MemoryUtil.memAddress(first_advance), advance_stride);
    }

    public static void nhb_font_get_glyph_v_advances(long font, int count, long first_glyph, int glyph_stride, long first_advance, int advance_stride) {
        long __functionAddress = Functions.font_get_glyph_v_advances;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePPPV(font, count, first_glyph, glyph_stride, first_advance, advance_stride, __functionAddress);
    }

    public static void hb_font_get_glyph_v_advances(@NativeType(value="hb_font_t *") long font, @NativeType(value="unsigned int") int count, @NativeType(value="hb_codepoint_t const *") IntBuffer first_glyph, @NativeType(value="unsigned int") int glyph_stride, @NativeType(value="hb_position_t *") IntBuffer first_advance, @NativeType(value="unsigned int") int advance_stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)first_glyph, count * glyph_stride >> 2);
            Checks.check((Buffer)first_advance, count * advance_stride >> 2);
        }
        HarfBuzz.nhb_font_get_glyph_v_advances(font, count, MemoryUtil.memAddress(first_glyph), glyph_stride, MemoryUtil.memAddress(first_advance), advance_stride);
    }

    public static int nhb_font_get_glyph_h_origin(long font, int glyph, long x, long y) {
        long __functionAddress = Functions.font_get_glyph_h_origin;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePPPI(font, glyph, x, y, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_font_get_glyph_h_origin(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_codepoint_t") int glyph, @NativeType(value="hb_position_t *") IntBuffer x, @NativeType(value="hb_position_t *") IntBuffer y) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, 1);
            Checks.check((Buffer)y, 1);
        }
        return HarfBuzz.nhb_font_get_glyph_h_origin(font, glyph, MemoryUtil.memAddress(x), MemoryUtil.memAddress(y)) != 0;
    }

    public static int nhb_font_get_glyph_v_origin(long font, int glyph, long x, long y) {
        long __functionAddress = Functions.font_get_glyph_v_origin;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePPPI(font, glyph, x, y, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_font_get_glyph_v_origin(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_codepoint_t") int glyph, @NativeType(value="hb_position_t *") IntBuffer x, @NativeType(value="hb_position_t *") IntBuffer y) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, 1);
            Checks.check((Buffer)y, 1);
        }
        return HarfBuzz.nhb_font_get_glyph_v_origin(font, glyph, MemoryUtil.memAddress(x), MemoryUtil.memAddress(y)) != 0;
    }

    @NativeType(value="hb_position_t")
    public static int hb_font_get_glyph_h_kerning(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_codepoint_t") int left_glyph, @NativeType(value="hb_codepoint_t") int right_glyph) {
        long __functionAddress = Functions.font_get_glyph_h_kerning;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePI(font, left_glyph, right_glyph, __functionAddress);
    }

    public static int nhb_font_get_glyph_extents(long font, int glyph, long extents) {
        long __functionAddress = Functions.font_get_glyph_extents;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePPI(font, glyph, extents, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_font_get_glyph_extents(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_codepoint_t") int glyph, @NativeType(value="hb_glyph_extents_t *") hb_glyph_extents_t extents) {
        return HarfBuzz.nhb_font_get_glyph_extents(font, glyph, extents.address()) != 0;
    }

    public static int nhb_font_get_glyph_contour_point(long font, int glyph, int point_index, long x, long y) {
        long __functionAddress = Functions.font_get_glyph_contour_point;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePPPI(font, glyph, point_index, x, y, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_font_get_glyph_contour_point(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_codepoint_t") int glyph, @NativeType(value="unsigned int") int point_index, @NativeType(value="hb_position_t *") IntBuffer x, @NativeType(value="hb_position_t *") IntBuffer y) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, 1);
            Checks.check((Buffer)y, 1);
        }
        return HarfBuzz.nhb_font_get_glyph_contour_point(font, glyph, point_index, MemoryUtil.memAddress(x), MemoryUtil.memAddress(y)) != 0;
    }

    public static int nhb_font_get_glyph_name(long font, int glyph, long name, int size) {
        long __functionAddress = Functions.font_get_glyph_name;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePPI(font, glyph, name, size, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_font_get_glyph_name(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_codepoint_t") int glyph, @NativeType(value="char *") ByteBuffer name) {
        return HarfBuzz.nhb_font_get_glyph_name(font, glyph, MemoryUtil.memAddress(name), name.remaining()) != 0;
    }

    public static int nhb_font_get_glyph_from_name(long font, long name, int len, long glyph) {
        long __functionAddress = Functions.font_get_glyph_from_name;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePPPI(font, name, len, glyph, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_font_get_glyph_from_name(@NativeType(value="hb_font_t *") long font, @NativeType(value="char const *") ByteBuffer name, @NativeType(value="hb_codepoint_t *") IntBuffer glyph) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)glyph, 1);
        }
        return HarfBuzz.nhb_font_get_glyph_from_name(font, MemoryUtil.memAddress(name), name.remaining(), MemoryUtil.memAddress(glyph)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="hb_bool_t")
    public static boolean hb_font_get_glyph_from_name(@NativeType(value="hb_font_t *") long font, @NativeType(value="char const *") CharSequence name, @NativeType(value="hb_codepoint_t *") IntBuffer glyph) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)glyph, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int nameEncodedLength = stack.nASCII(name, false);
            long nameEncoded = stack.getPointerAddress();
            boolean bl = HarfBuzz.nhb_font_get_glyph_from_name(font, nameEncoded, nameEncodedLength, MemoryUtil.memAddress(glyph)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void hb_font_draw_glyph(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_codepoint_t") int glyph, @NativeType(value="hb_draw_funcs_t *") long dfuncs, @NativeType(value="void *") long draw_data) {
        long __functionAddress = Functions.font_draw_glyph;
        if (Checks.CHECKS) {
            Checks.check(font);
            Checks.check(dfuncs);
        }
        JNI.invokePPPV(font, glyph, dfuncs, draw_data, __functionAddress);
    }

    public static void hb_font_paint_glyph(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_codepoint_t") int glyph, @NativeType(value="hb_draw_funcs_t *") long pfuncs, @NativeType(value="void *") long paint_data, @NativeType(value="unsigned int") int palette_index, @NativeType(value="hb_color_t") int foreground) {
        long __functionAddress = Functions.font_paint_glyph;
        if (Checks.CHECKS) {
            Checks.check(font);
            Checks.check(pfuncs);
        }
        JNI.invokePPPV(font, glyph, pfuncs, paint_data, palette_index, foreground, __functionAddress);
    }

    public static int nhb_font_get_glyph(long font, int unicode, int variation_selector, long glyph) {
        long __functionAddress = Functions.font_get_glyph;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePPI(font, unicode, variation_selector, glyph, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_font_get_glyph(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_codepoint_t") int unicode, @NativeType(value="hb_codepoint_t") int variation_selector, @NativeType(value="hb_codepoint_t *") IntBuffer glyph) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)glyph, 1);
        }
        return HarfBuzz.nhb_font_get_glyph(font, unicode, variation_selector, MemoryUtil.memAddress(glyph)) != 0;
    }

    public static void nhb_font_get_extents_for_direction(long font, int direction, long extents) {
        long __functionAddress = Functions.font_get_extents_for_direction;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePPV(font, direction, extents, __functionAddress);
    }

    public static void hb_font_get_extents_for_direction(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_direction_t") int direction, @NativeType(value="hb_font_extents_t *") hb_font_extents_t extents) {
        HarfBuzz.nhb_font_get_extents_for_direction(font, direction, extents.address());
    }

    public static void nhb_font_get_glyph_advance_for_direction(long font, int glyph, int direction, long x, long y) {
        long __functionAddress = Functions.font_get_glyph_advance_for_direction;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePPPV(font, glyph, direction, x, y, __functionAddress);
    }

    public static void hb_font_get_glyph_advance_for_direction(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_codepoint_t") int glyph, @NativeType(value="hb_direction_t") int direction, @NativeType(value="hb_position_t *") IntBuffer x, @NativeType(value="hb_position_t *") IntBuffer y) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, 1);
            Checks.check((Buffer)y, 1);
        }
        HarfBuzz.nhb_font_get_glyph_advance_for_direction(font, glyph, direction, MemoryUtil.memAddress(x), MemoryUtil.memAddress(y));
    }

    public static void nhb_font_get_glyph_advances_for_direction(long font, int direction, int count, long first_glyph, int glyph_stride, long first_advance, int advance_stride) {
        long __functionAddress = Functions.font_get_glyph_advances_for_direction;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePPPV(font, direction, count, first_glyph, glyph_stride, first_advance, advance_stride, __functionAddress);
    }

    public static void hb_font_get_glyph_advances_for_direction(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_direction_t") int direction, @NativeType(value="unsigned int") int count, @NativeType(value="hb_codepoint_t const *") IntBuffer first_glyph, @NativeType(value="unsigned int") int glyph_stride, @NativeType(value="hb_position_t *") IntBuffer first_advance, @NativeType(value="unsigned int") int advance_stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)first_glyph, count * glyph_stride >> 2);
            Checks.check((Buffer)first_advance, count * advance_stride >> 2);
        }
        HarfBuzz.nhb_font_get_glyph_advances_for_direction(font, direction, count, MemoryUtil.memAddress(first_glyph), glyph_stride, MemoryUtil.memAddress(first_advance), advance_stride);
    }

    public static void nhb_font_get_glyph_origin_for_direction(long font, int glyph, int direction, long x, long y) {
        long __functionAddress = Functions.font_get_glyph_origin_for_direction;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePPPV(font, glyph, direction, x, y, __functionAddress);
    }

    public static void hb_font_get_glyph_origin_for_direction(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_codepoint_t") int glyph, @NativeType(value="hb_direction_t") int direction, @NativeType(value="hb_position_t *") IntBuffer x, @NativeType(value="hb_position_t *") IntBuffer y) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, 1);
            Checks.check((Buffer)y, 1);
        }
        HarfBuzz.nhb_font_get_glyph_origin_for_direction(font, glyph, direction, MemoryUtil.memAddress(x), MemoryUtil.memAddress(y));
    }

    public static void nhb_font_add_glyph_origin_for_direction(long font, int glyph, int direction, long x, long y) {
        long __functionAddress = Functions.font_add_glyph_origin_for_direction;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePPPV(font, glyph, direction, x, y, __functionAddress);
    }

    public static void hb_font_add_glyph_origin_for_direction(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_codepoint_t") int glyph, @NativeType(value="hb_direction_t") int direction, @NativeType(value="hb_position_t *") IntBuffer x, @NativeType(value="hb_position_t *") IntBuffer y) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, 1);
            Checks.check((Buffer)y, 1);
        }
        HarfBuzz.nhb_font_add_glyph_origin_for_direction(font, glyph, direction, MemoryUtil.memAddress(x), MemoryUtil.memAddress(y));
    }

    public static void nhb_font_subtract_glyph_origin_for_direction(long font, int glyph, int direction, long x, long y) {
        long __functionAddress = Functions.font_subtract_glyph_origin_for_direction;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePPPV(font, glyph, direction, x, y, __functionAddress);
    }

    public static void hb_font_subtract_glyph_origin_for_direction(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_codepoint_t") int glyph, @NativeType(value="hb_direction_t") int direction, @NativeType(value="hb_position_t *") IntBuffer x, @NativeType(value="hb_position_t *") IntBuffer y) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, 1);
            Checks.check((Buffer)y, 1);
        }
        HarfBuzz.nhb_font_subtract_glyph_origin_for_direction(font, glyph, direction, MemoryUtil.memAddress(x), MemoryUtil.memAddress(y));
    }

    public static void nhb_font_get_glyph_kerning_for_direction(long font, int first_glyph, int second_glyph, int direction, long x, long y) {
        long __functionAddress = Functions.font_get_glyph_kerning_for_direction;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePPPV(font, first_glyph, second_glyph, direction, x, y, __functionAddress);
    }

    public static void hb_font_get_glyph_kerning_for_direction(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_codepoint_t") int first_glyph, @NativeType(value="hb_codepoint_t") int second_glyph, @NativeType(value="hb_direction_t") int direction, @NativeType(value="hb_position_t *") IntBuffer x, @NativeType(value="hb_position_t *") IntBuffer y) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, 1);
            Checks.check((Buffer)y, 1);
        }
        HarfBuzz.nhb_font_get_glyph_kerning_for_direction(font, first_glyph, second_glyph, direction, MemoryUtil.memAddress(x), MemoryUtil.memAddress(y));
    }

    public static int nhb_font_get_glyph_extents_for_origin(long font, int glyph, int direction, long extents) {
        long __functionAddress = Functions.font_get_glyph_extents_for_origin;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePPI(font, glyph, direction, extents, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_font_get_glyph_extents_for_origin(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_codepoint_t") int glyph, @NativeType(value="hb_direction_t") int direction, @NativeType(value="hb_glyph_extents_t *") hb_glyph_extents_t extents) {
        return HarfBuzz.nhb_font_get_glyph_extents_for_origin(font, glyph, direction, extents.address()) != 0;
    }

    public static int nhb_font_get_glyph_contour_point_for_origin(long font, int glyph, int point_index, int direction, long x, long y) {
        long __functionAddress = Functions.font_get_glyph_contour_point_for_origin;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePPPI(font, glyph, point_index, direction, x, y, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_font_get_glyph_contour_point_for_origin(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_codepoint_t") int glyph, @NativeType(value="unsigned int") int point_index, @NativeType(value="hb_direction_t") int direction, @NativeType(value="hb_position_t *") IntBuffer x, @NativeType(value="hb_position_t *") IntBuffer y) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, 1);
            Checks.check((Buffer)y, 1);
        }
        return HarfBuzz.nhb_font_get_glyph_contour_point_for_origin(font, glyph, point_index, direction, MemoryUtil.memAddress(x), MemoryUtil.memAddress(y)) != 0;
    }

    public static void nhb_font_glyph_to_string(long font, int glyph, long s, int size) {
        long __functionAddress = Functions.font_glyph_to_string;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePPV(font, glyph, s, size, __functionAddress);
    }

    public static void hb_font_glyph_to_string(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_codepoint_t") int glyph, @NativeType(value="char *") ByteBuffer s) {
        HarfBuzz.nhb_font_glyph_to_string(font, glyph, MemoryUtil.memAddress(s), s.remaining());
    }

    public static int nhb_font_glyph_from_string(long font, long s, int len, long glyph) {
        long __functionAddress = Functions.font_glyph_from_string;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePPPI(font, s, len, glyph, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_font_glyph_from_string(@NativeType(value="hb_font_t *") long font, @NativeType(value="char const *") ByteBuffer s, @NativeType(value="hb_codepoint_t *") IntBuffer glyph) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)glyph, 1);
        }
        return HarfBuzz.nhb_font_glyph_from_string(font, MemoryUtil.memAddress(s), s.remaining(), MemoryUtil.memAddress(glyph)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="hb_bool_t")
    public static boolean hb_font_glyph_from_string(@NativeType(value="hb_font_t *") long font, @NativeType(value="char const *") CharSequence s, @NativeType(value="hb_codepoint_t *") IntBuffer glyph) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)glyph, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int sEncodedLength = stack.nASCII(s, false);
            long sEncoded = stack.getPointerAddress();
            boolean bl = HarfBuzz.nhb_font_glyph_from_string(font, sEncoded, sEncodedLength, MemoryUtil.memAddress(glyph)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="hb_font_t *")
    public static long hb_font_create(@NativeType(value="hb_face_t *") long face) {
        long __functionAddress = Functions.font_create;
        if (Checks.CHECKS) {
            Checks.check(face);
        }
        return JNI.invokePP(face, __functionAddress);
    }

    @NativeType(value="hb_font_t *")
    public static long hb_font_create_sub_font(@NativeType(value="hb_font_t *") long parent) {
        long __functionAddress = Functions.font_create_sub_font;
        if (Checks.CHECKS) {
            Checks.check(parent);
        }
        return JNI.invokePP(parent, __functionAddress);
    }

    @NativeType(value="hb_font_t *")
    public static long hb_font_get_empty() {
        long __functionAddress = Functions.font_get_empty;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="hb_font_t *")
    public static long hb_font_reference(@NativeType(value="hb_font_t *") long font) {
        long __functionAddress = Functions.font_reference;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePP(font, __functionAddress);
    }

    public static void hb_font_destroy(@NativeType(value="hb_font_t *") long font) {
        long __functionAddress = Functions.font_destroy;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePV(font, __functionAddress);
    }

    public static int nhb_font_set_user_data(long font, long key, long data, long destroy, int replace) {
        long __functionAddress = Functions.font_set_user_data;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePPPPI(font, key, data, destroy, replace, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_font_set_user_data(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_user_data_key_t *") hb_user_data_key_t key, @NativeType(value="void *") long data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy, @NativeType(value="hb_bool_t") boolean replace) {
        return HarfBuzz.nhb_font_set_user_data(font, key.address(), data, MemoryUtil.memAddressSafe(destroy), replace ? 1 : 0) != 0;
    }

    public static long nhb_font_get_user_data(long font, long key) {
        long __functionAddress = Functions.font_get_user_data;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePPP(font, key, __functionAddress);
    }

    @NativeType(value="void *")
    public static long hb_font_get_user_data(@NativeType(value="hb_font_t const *") long font, @NativeType(value="hb_user_data_key_t *") hb_user_data_key_t key) {
        return HarfBuzz.nhb_font_get_user_data(font, key.address());
    }

    public static void hb_font_make_immutable(@NativeType(value="hb_font_t *") long font) {
        long __functionAddress = Functions.font_make_immutable;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePV(font, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_font_is_immutable(@NativeType(value="hb_font_t *") long font) {
        long __functionAddress = Functions.font_is_immutable;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePI(font, __functionAddress) != 0;
    }

    @NativeType(value="unsigned int")
    public static int hb_font_get_serial(@NativeType(value="hb_font_t *") long font) {
        long __functionAddress = Functions.font_get_serial;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePI(font, __functionAddress);
    }

    public static void hb_font_changed(@NativeType(value="hb_font_t *") long font) {
        long __functionAddress = Functions.font_changed;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePV(font, __functionAddress);
    }

    public static void hb_font_set_parent(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_font_t *") long parent) {
        long __functionAddress = Functions.font_set_parent;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePPV(font, parent, __functionAddress);
    }

    @NativeType(value="hb_font_t *")
    public static long hb_font_get_parent(@NativeType(value="hb_font_t *") long font) {
        long __functionAddress = Functions.font_get_parent;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePP(font, __functionAddress);
    }

    public static void hb_font_set_face(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_face_t *") long face) {
        long __functionAddress = Functions.font_set_face;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePPV(font, face, __functionAddress);
    }

    @NativeType(value="hb_face_t *")
    public static long hb_font_get_face(@NativeType(value="hb_font_t *") long font) {
        long __functionAddress = Functions.font_get_face;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePP(font, __functionAddress);
    }

    public static void nhb_font_set_funcs(long font, long klass, long font_data, long destroy) {
        long __functionAddress = Functions.font_set_funcs;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePPPPV(font, klass, font_data, destroy, __functionAddress);
    }

    public static void hb_font_set_funcs(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_font_funcs_t *") long klass, @NativeType(value="void *") long font_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_font_set_funcs(font, klass, font_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_font_set_funcs_data(long font, long font_data, long destroy) {
        long __functionAddress = Functions.font_set_funcs_data;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePPPV(font, font_data, destroy, __functionAddress);
    }

    public static void hb_font_set_funcs_data(@NativeType(value="hb_font_t *") long font, @NativeType(value="void *") long font_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_font_set_funcs_data(font, font_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void hb_font_set_scale(@NativeType(value="hb_font_t *") long font, int x_scale, int y_scale) {
        long __functionAddress = Functions.font_set_scale;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePV(font, x_scale, y_scale, __functionAddress);
    }

    public static void nhb_font_get_scale(long font, long x_scale, long y_scale) {
        long __functionAddress = Functions.font_get_scale;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePPPV(font, x_scale, y_scale, __functionAddress);
    }

    public static void hb_font_get_scale(@NativeType(value="hb_font_t *") long font, @NativeType(value="int *") IntBuffer x_scale, @NativeType(value="int *") IntBuffer y_scale) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x_scale, 1);
            Checks.check((Buffer)y_scale, 1);
        }
        HarfBuzz.nhb_font_get_scale(font, MemoryUtil.memAddress(x_scale), MemoryUtil.memAddress(y_scale));
    }

    public static void hb_font_set_ppem(@NativeType(value="hb_font_t *") long font, @NativeType(value="unsigned int") int x_ppem, @NativeType(value="unsigned int") int y_ppem) {
        long __functionAddress = Functions.font_set_ppem;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePV(font, x_ppem, y_ppem, __functionAddress);
    }

    public static void nhb_font_get_ppem(long font, long x_ppem, long y_ppem) {
        long __functionAddress = Functions.font_get_ppem;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePPPV(font, x_ppem, y_ppem, __functionAddress);
    }

    public static void hb_font_get_ppem(@NativeType(value="hb_font_t *") long font, @NativeType(value="unsigned int *") IntBuffer x_ppem, @NativeType(value="unsigned int *") IntBuffer y_ppem) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x_ppem, 1);
            Checks.check((Buffer)y_ppem, 1);
        }
        HarfBuzz.nhb_font_get_ppem(font, MemoryUtil.memAddress(x_ppem), MemoryUtil.memAddress(y_ppem));
    }

    public static void hb_font_set_ptem(@NativeType(value="hb_font_t *") long font, float ptem) {
        long __functionAddress = Functions.font_set_ptem;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePV(font, ptem, __functionAddress);
    }

    public static float hb_font_get_ptem(@NativeType(value="hb_font_t *") long font) {
        long __functionAddress = Functions.font_get_ptem;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePF(font, __functionAddress);
    }

    public static void hb_font_set_synthetic_bold(@NativeType(value="hb_font_t *") long font, float x_embolden, float y_embolden, @NativeType(value="hb_bool_t") boolean in_place) {
        long __functionAddress = Functions.font_set_synthetic_bold;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePV(font, x_embolden, y_embolden, in_place ? 1 : 0, __functionAddress);
    }

    public static void nhb_font_get_synthetic_bold(long font, long x_embolden, long y_embolden, long in_place) {
        long __functionAddress = Functions.font_get_synthetic_bold;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePPPPV(font, x_embolden, y_embolden, in_place, __functionAddress);
    }

    public static void hb_font_get_synthetic_bold(@NativeType(value="hb_font_t *") long font, @NativeType(value="float *") @Nullable FloatBuffer x_embolden, @NativeType(value="float *") @Nullable FloatBuffer y_embolden, @NativeType(value="hb_bool_t *") @Nullable IntBuffer in_place) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)x_embolden, 1);
            Checks.checkSafe((Buffer)y_embolden, 1);
            Checks.checkSafe((Buffer)in_place, 1);
        }
        HarfBuzz.nhb_font_get_synthetic_bold(font, MemoryUtil.memAddressSafe(x_embolden), MemoryUtil.memAddressSafe(y_embolden), MemoryUtil.memAddressSafe(in_place));
    }

    public static void hb_font_set_synthetic_slant(@NativeType(value="hb_font_t *") long font, float slant) {
        long __functionAddress = Functions.font_set_synthetic_slant;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePV(font, slant, __functionAddress);
    }

    public static float hb_font_get_synthetic_slant(@NativeType(value="hb_font_t *") long font) {
        long __functionAddress = Functions.font_get_synthetic_slant;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePF(font, __functionAddress);
    }

    public static void nhb_font_set_variations(long font, long variations, int variations_length) {
        long __functionAddress = Functions.font_set_variations;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePPV(font, variations, variations_length, __functionAddress);
    }

    public static void hb_font_set_variations(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_variation_t const *") hb_variation_t.Buffer variations) {
        HarfBuzz.nhb_font_set_variations(font, variations.address(), variations.remaining());
    }

    public static void hb_font_set_variation(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_tag_t") int tag, float value) {
        long __functionAddress = Functions.font_set_variation;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePV(font, tag, value, __functionAddress);
    }

    public static void nhb_font_set_var_coords_design(long font, long coords, int coords_length) {
        long __functionAddress = Functions.font_set_var_coords_design;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePPV(font, coords, coords_length, __functionAddress);
    }

    public static void hb_font_set_var_coords_design(@NativeType(value="hb_font_t *") long font, @NativeType(value="float const *") FloatBuffer coords) {
        HarfBuzz.nhb_font_set_var_coords_design(font, MemoryUtil.memAddress(coords), coords.remaining());
    }

    public static long nhb_font_get_var_coords_design(long font, long length) {
        long __functionAddress = Functions.font_get_var_coords_design;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePPP(font, length, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="float const *")
    public static @Nullable FloatBuffer hb_font_get_var_coords_design(@NativeType(value="hb_font_t *") long font) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer length = stack.callocInt(1);
        try {
            long __result = HarfBuzz.nhb_font_get_var_coords_design(font, MemoryUtil.memAddress(length));
            FloatBuffer floatBuffer = MemoryUtil.memFloatBufferSafe(__result, length.get(0));
            return floatBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nhb_font_set_var_coords_normalized(long font, long coords, int coords_length) {
        long __functionAddress = Functions.font_set_var_coords_normalized;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePPV(font, coords, coords_length, __functionAddress);
    }

    public static void hb_font_set_var_coords_normalized(@NativeType(value="hb_font_t *") long font, @NativeType(value="int const *") IntBuffer coords) {
        HarfBuzz.nhb_font_set_var_coords_normalized(font, MemoryUtil.memAddress(coords), coords.remaining());
    }

    public static long nhb_font_get_var_coords_normalized(long font, long length) {
        long __functionAddress = Functions.font_get_var_coords_normalized;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePPP(font, length, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="int const *")
    public static @Nullable IntBuffer hb_font_get_var_coords_normalized(@NativeType(value="hb_font_t *") long font) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer length = stack.callocInt(1);
        try {
            long __result = HarfBuzz.nhb_font_get_var_coords_normalized(font, MemoryUtil.memAddress(length));
            IntBuffer intBuffer = MemoryUtil.memIntBufferSafe(__result, length.get(0));
            return intBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void hb_font_set_var_named_instance(@NativeType(value="hb_font_t *") long font, @NativeType(value="unsigned int") int instance_index) {
        long __functionAddress = Functions.font_set_var_named_instance;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        JNI.invokePV(font, instance_index, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int hb_font_get_var_named_instance(@NativeType(value="hb_font_t *") long font) {
        long __functionAddress = Functions.font_get_var_named_instance;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePI(font, __functionAddress);
    }

    public static long nhb_ft_face_create(long ft_face, long destroy) {
        long __functionAddress = Functions.ft_face_create;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(ft_face);
        }
        return JNI.invokePPP(ft_face, destroy, __functionAddress);
    }

    @NativeType(value="hb_face_t *")
    public static long hb_ft_face_create(@NativeType(value="FT_Face") long ft_face, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        return HarfBuzz.nhb_ft_face_create(ft_face, MemoryUtil.memAddressSafe(destroy));
    }

    @NativeType(value="hb_face_t *")
    public static long hb_ft_face_create_cached(@NativeType(value="FT_Face") long ft_face) {
        long __functionAddress = Functions.ft_face_create_cached;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(ft_face);
        }
        return JNI.invokePP(ft_face, __functionAddress);
    }

    @NativeType(value="hb_face_t *")
    public static long hb_ft_face_create_referenced(@NativeType(value="FT_Face") long ft_face) {
        long __functionAddress = Functions.ft_face_create_referenced;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(ft_face);
        }
        return JNI.invokePP(ft_face, __functionAddress);
    }

    public static long nhb_ft_face_create_from_file_or_fail(long file_name, int index) {
        long __functionAddress = Functions.ft_face_create_from_file_or_fail;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokePP(file_name, index, __functionAddress);
    }

    @NativeType(value="hb_face_t *")
    public static long hb_ft_face_create_from_file_or_fail(@NativeType(value="char const *") ByteBuffer file_name, @NativeType(value="unsigned int") int index) {
        if (Checks.CHECKS) {
            Checks.checkNT1(file_name);
        }
        return HarfBuzz.nhb_ft_face_create_from_file_or_fail(MemoryUtil.memAddress(file_name), index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="hb_face_t *")
    public static long hb_ft_face_create_from_file_or_fail(@NativeType(value="char const *") CharSequence file_name, @NativeType(value="unsigned int") int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(file_name, true);
            long file_nameEncoded = stack.getPointerAddress();
            long l = HarfBuzz.nhb_ft_face_create_from_file_or_fail(file_nameEncoded, index);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nhb_ft_font_create(long ft_face, long destroy) {
        long __functionAddress = Functions.ft_font_create;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(ft_face);
        }
        return JNI.invokePPP(ft_face, destroy, __functionAddress);
    }

    @NativeType(value="hb_font_t *")
    public static long hb_ft_font_create(@NativeType(value="FT_Face") long ft_face, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        return HarfBuzz.nhb_ft_font_create(ft_face, MemoryUtil.memAddressSafe(destroy));
    }

    @NativeType(value="hb_font_t *")
    public static long hb_ft_font_create_referenced(@NativeType(value="FT_Face") long ft_face) {
        long __functionAddress = Functions.ft_font_create_referenced;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(ft_face);
        }
        return JNI.invokePP(ft_face, __functionAddress);
    }

    @NativeType(value="FT_Face")
    public static long hb_ft_font_get_face(@NativeType(value="hb_font_t *") long font) {
        long __functionAddress = Functions.ft_font_get_face;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(font);
        }
        return JNI.invokePP(font, __functionAddress);
    }

    @NativeType(value="FT_Face")
    public static long hb_ft_font_lock_face(@NativeType(value="hb_font_t *") long font) {
        long __functionAddress = Functions.ft_font_lock_face;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(font);
        }
        return JNI.invokePP(font, __functionAddress);
    }

    public static void hb_ft_font_unlock_face(@NativeType(value="hb_font_t *") long font) {
        long __functionAddress = Functions.ft_font_unlock_face;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(font);
        }
        JNI.invokePV(font, __functionAddress);
    }

    public static void hb_ft_font_set_load_flags(@NativeType(value="hb_font_t *") long font, int load_flags) {
        long __functionAddress = Functions.ft_font_set_load_flags;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(font);
        }
        JNI.invokePV(font, load_flags, __functionAddress);
    }

    public static int hb_ft_font_get_load_flags(@NativeType(value="hb_font_t *") long font) {
        long __functionAddress = Functions.ft_font_get_load_flags;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(font);
        }
        return JNI.invokePI(font, __functionAddress);
    }

    public static void hb_ft_font_changed(@NativeType(value="hb_font_t *") long font) {
        long __functionAddress = Functions.ft_font_changed;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(font);
        }
        JNI.invokePV(font, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_ft_hb_font_changed(@NativeType(value="hb_font_t *") long font) {
        long __functionAddress = Functions.ft_hb_font_changed;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(font);
        }
        return JNI.invokePI(font, __functionAddress) != 0;
    }

    public static void hb_ft_font_set_funcs(@NativeType(value="hb_font_t *") long font) {
        long __functionAddress = Functions.ft_font_set_funcs;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(font);
        }
        JNI.invokePV(font, __functionAddress);
    }

    @NativeType(value="hb_map_t *")
    public static long hb_map_create() {
        long __functionAddress = Functions.map_create;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="hb_map_t *")
    public static long hb_map_get_empty() {
        long __functionAddress = Functions.map_get_empty;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="hb_map_t *")
    public static long hb_map_reference(@NativeType(value="hb_map_t *") long map) {
        long __functionAddress = Functions.map_reference;
        if (Checks.CHECKS) {
            Checks.check(map);
        }
        return JNI.invokePP(map, __functionAddress);
    }

    public static void hb_map_destroy(@NativeType(value="hb_map_t *") long map) {
        long __functionAddress = Functions.map_destroy;
        if (Checks.CHECKS) {
            Checks.check(map);
        }
        JNI.invokePV(map, __functionAddress);
    }

    public static int nhb_map_set_user_data(long map, long key, long data, long destroy, int replace) {
        long __functionAddress = Functions.map_set_user_data;
        if (Checks.CHECKS) {
            Checks.check(map);
        }
        return JNI.invokePPPPI(map, key, data, destroy, replace, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_map_set_user_data(@NativeType(value="hb_map_t *") long map, @NativeType(value="hb_user_data_key_t *") hb_user_data_key_t key, @NativeType(value="void *") long data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy, @NativeType(value="hb_bool_t") boolean replace) {
        return HarfBuzz.nhb_map_set_user_data(map, key.address(), data, MemoryUtil.memAddressSafe(destroy), replace ? 1 : 0) != 0;
    }

    public static long nhb_map_get_user_data(long map, long key) {
        long __functionAddress = Functions.map_get_user_data;
        if (Checks.CHECKS) {
            Checks.check(map);
        }
        return JNI.invokePPP(map, key, __functionAddress);
    }

    @NativeType(value="void *")
    public static long hb_map_get_user_data(@NativeType(value="hb_map_t const *") long map, @NativeType(value="hb_user_data_key_t *") hb_user_data_key_t key) {
        return HarfBuzz.nhb_map_get_user_data(map, key.address());
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_map_allocation_successful(@NativeType(value="hb_map_t const *") long map) {
        long __functionAddress = Functions.map_allocation_successful;
        if (Checks.CHECKS) {
            Checks.check(map);
        }
        return JNI.invokePI(map, __functionAddress) != 0;
    }

    @NativeType(value="hb_map_t *")
    public static long hb_map_copy(@NativeType(value="hb_map_t const *") long map) {
        long __functionAddress = Functions.map_copy;
        if (Checks.CHECKS) {
            Checks.check(map);
        }
        return JNI.invokePP(map, __functionAddress);
    }

    public static void hb_map_clear(@NativeType(value="hb_map_t *") long map) {
        long __functionAddress = Functions.map_clear;
        if (Checks.CHECKS) {
            Checks.check(map);
        }
        JNI.invokePV(map, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_map_is_empty(@NativeType(value="hb_map_t const *") long map) {
        long __functionAddress = Functions.map_is_empty;
        if (Checks.CHECKS) {
            Checks.check(map);
        }
        return JNI.invokePI(map, __functionAddress) != 0;
    }

    @NativeType(value="unsigned int")
    public static int hb_map_get_population(@NativeType(value="hb_map_t const *") long map) {
        long __functionAddress = Functions.map_get_population;
        if (Checks.CHECKS) {
            Checks.check(map);
        }
        return JNI.invokePI(map, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_map_is_equal(@NativeType(value="hb_map_t const *") long map, @NativeType(value="hb_map_t const *") long other) {
        long __functionAddress = Functions.map_is_equal;
        if (Checks.CHECKS) {
            Checks.check(map);
            Checks.check(other);
        }
        return JNI.invokePPI(map, other, __functionAddress) != 0;
    }

    @NativeType(value="unsigned int")
    public static int hb_map_hash(@NativeType(value="hb_map_t const *") long map) {
        long __functionAddress = Functions.map_hash;
        if (Checks.CHECKS) {
            Checks.check(map);
        }
        return JNI.invokePI(map, __functionAddress);
    }

    public static void hb_map_set(@NativeType(value="hb_map_t *") long map, @NativeType(value="hb_codepoint_t") int key, @NativeType(value="hb_codepoint_t") int value) {
        long __functionAddress = Functions.map_set;
        if (Checks.CHECKS) {
            Checks.check(map);
        }
        JNI.invokePV(map, key, value, __functionAddress);
    }

    @NativeType(value="hb_codepoint_t")
    public static int hb_map_get(@NativeType(value="hb_map_t const *") long map, @NativeType(value="hb_codepoint_t") int key) {
        long __functionAddress = Functions.map_get;
        if (Checks.CHECKS) {
            Checks.check(map);
        }
        return JNI.invokePI(map, key, __functionAddress);
    }

    public static void hb_map_del(@NativeType(value="hb_map_t *") long map, @NativeType(value="hb_codepoint_t") int key) {
        long __functionAddress = Functions.map_del;
        if (Checks.CHECKS) {
            Checks.check(map);
        }
        JNI.invokePV(map, key, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_map_has(@NativeType(value="hb_map_t const *") long map, @NativeType(value="hb_codepoint_t") int key) {
        long __functionAddress = Functions.map_has;
        if (Checks.CHECKS) {
            Checks.check(map);
        }
        return JNI.invokePI(map, key, __functionAddress) != 0;
    }

    public static void hb_map_update(@NativeType(value="hb_map_t *") long map, @NativeType(value="hb_map_t const *") long other) {
        long __functionAddress = Functions.map_update;
        if (Checks.CHECKS) {
            Checks.check(map);
            Checks.check(other);
        }
        JNI.invokePPV(map, other, __functionAddress);
    }

    public static int nhb_map_next(long map, long idx, long key, long value) {
        long __functionAddress = Functions.map_next;
        if (Checks.CHECKS) {
            Checks.check(map);
        }
        return JNI.invokePPPPI(map, idx, key, value, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_map_next(@NativeType(value="hb_map_t const *") long map, @NativeType(value="int *") IntBuffer idx, @NativeType(value="hb_codepoint_t *") IntBuffer key, @NativeType(value="hb_codepoint_t *") IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)idx, 1);
            Checks.check((Buffer)key, 1);
            Checks.check((Buffer)value, 1);
        }
        return HarfBuzz.nhb_map_next(map, MemoryUtil.memAddress(idx), MemoryUtil.memAddress(key), MemoryUtil.memAddress(value)) != 0;
    }

    public static void hb_map_keys(@NativeType(value="hb_map_t const *") long map, @NativeType(value="hb_set_t *") long keys) {
        long __functionAddress = Functions.map_keys;
        if (Checks.CHECKS) {
            Checks.check(map);
            Checks.check(keys);
        }
        JNI.invokePPV(map, keys, __functionAddress);
    }

    public static void hb_map_values(@NativeType(value="hb_map_t const *") long map, @NativeType(value="hb_set_t *") long values) {
        long __functionAddress = Functions.map_values;
        if (Checks.CHECKS) {
            Checks.check(map);
            Checks.check(values);
        }
        JNI.invokePPV(map, values, __functionAddress);
    }

    @NativeType(value="hb_paint_funcs_t *")
    public static long hb_paint_funcs_create() {
        long __functionAddress = Functions.paint_funcs_create;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="hb_paint_funcs_t *")
    public static long hb_paint_funcs_get_empty() {
        long __functionAddress = Functions.paint_funcs_get_empty;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="hb_paint_funcs_t *")
    public static long hb_paint_funcs_reference(@NativeType(value="hb_paint_funcs_t *") long funcs) {
        long __functionAddress = Functions.paint_funcs_reference;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        return JNI.invokePP(funcs, __functionAddress);
    }

    public static void hb_paint_funcs_destroy(@NativeType(value="hb_paint_funcs_t *") long funcs) {
        long __functionAddress = Functions.paint_funcs_destroy;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        JNI.invokePV(funcs, __functionAddress);
    }

    public static int nhb_paint_funcs_set_user_data(long funcs, long key, long data, long destroy, int replace) {
        long __functionAddress = Functions.paint_funcs_set_user_data;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        return JNI.invokePPPPI(funcs, key, data, destroy, replace, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_paint_funcs_set_user_data(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="hb_user_data_key_t *") hb_user_data_key_t key, @NativeType(value="void *") long data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy, @NativeType(value="hb_bool_t") boolean replace) {
        return HarfBuzz.nhb_paint_funcs_set_user_data(funcs, key.address(), data, MemoryUtil.memAddressSafe(destroy), replace ? 1 : 0) != 0;
    }

    public static long nhb_paint_funcs_get_user_data(long funcs, long key) {
        long __functionAddress = Functions.paint_funcs_get_user_data;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        return JNI.invokePPP(funcs, key, __functionAddress);
    }

    @NativeType(value="void *")
    public static long hb_paint_funcs_get_user_data(@NativeType(value="hb_paint_funcs_t const *") long funcs, @NativeType(value="hb_user_data_key_t *") hb_user_data_key_t key) {
        return HarfBuzz.nhb_paint_funcs_get_user_data(funcs, key.address());
    }

    public static void hb_paint_funcs_make_immutable(@NativeType(value="hb_paint_funcs_t *") long funcs) {
        long __functionAddress = Functions.paint_funcs_make_immutable;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        JNI.invokePV(funcs, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_paint_funcs_is_immutable(@NativeType(value="hb_paint_funcs_t *") long funcs) {
        long __functionAddress = Functions.paint_funcs_is_immutable;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        return JNI.invokePI(funcs, __functionAddress) != 0;
    }

    public static int nhb_color_line_get_color_stops(long color_line, int start, long count, long color_stops) {
        long __functionAddress = Functions.color_line_get_color_stops;
        return JNI.invokePPPI(color_line, start, count, color_stops, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int hb_color_line_get_color_stops(@NativeType(value="hb_color_line_t *") hb_color_line_t color_line, @NativeType(value="unsigned int") int start, @NativeType(value="unsigned int *") IntBuffer count, @NativeType(value="hb_color_stop_t *") hb_color_stop_t color_stops) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)count, 1);
        }
        return HarfBuzz.nhb_color_line_get_color_stops(color_line.address(), start, MemoryUtil.memAddress(count), color_stops.address());
    }

    public static int nhb_color_line_get_extend(long color_line) {
        long __functionAddress = Functions.color_line_get_extend;
        return JNI.invokePI(color_line, __functionAddress);
    }

    @NativeType(value="hb_paint_extend_t")
    public static int hb_color_line_get_extend(@NativeType(value="hb_color_line_t *") hb_color_line_t color_line) {
        return HarfBuzz.nhb_color_line_get_extend(color_line.address());
    }

    public static void nhb_paint_funcs_set_push_transform_func(long funcs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.paint_funcs_set_push_transform_func;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        JNI.invokePPPPV(funcs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_paint_funcs_set_push_transform_func(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="hb_paint_push_transform_func_t") hb_paint_push_transform_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_paint_funcs_set_push_transform_func(funcs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_paint_funcs_set_pop_transform_func(long funcs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.paint_funcs_set_pop_transform_func;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        JNI.invokePPPPV(funcs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_paint_funcs_set_pop_transform_func(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="hb_paint_pop_transform_func_t") hb_paint_pop_transform_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_paint_funcs_set_pop_transform_func(funcs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_paint_funcs_set_color_glyph_func(long funcs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.paint_funcs_set_color_glyph_func;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        JNI.invokePPPPV(funcs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_paint_funcs_set_color_glyph_func(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="hb_paint_color_glyph_func_t") hb_paint_color_glyph_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_paint_funcs_set_color_glyph_func(funcs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_paint_funcs_set_push_clip_glyph_func(long funcs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.paint_funcs_set_push_clip_glyph_func;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        JNI.invokePPPPV(funcs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_paint_funcs_set_push_clip_glyph_func(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="hb_paint_push_clip_glyph_func_t") hb_paint_push_clip_glyph_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_paint_funcs_set_push_clip_glyph_func(funcs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_paint_funcs_set_push_clip_rectangle_func(long funcs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.paint_funcs_set_push_clip_rectangle_func;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        JNI.invokePPPPV(funcs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_paint_funcs_set_push_clip_rectangle_func(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="hb_paint_push_clip_rectangle_func_t") hb_paint_push_clip_rectangle_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_paint_funcs_set_push_clip_rectangle_func(funcs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_paint_funcs_set_pop_clip_func(long funcs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.paint_funcs_set_pop_clip_func;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        JNI.invokePPPPV(funcs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_paint_funcs_set_pop_clip_func(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="hb_paint_pop_clip_func_t") hb_paint_pop_clip_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_paint_funcs_set_pop_clip_func(funcs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_paint_funcs_set_color_func(long funcs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.paint_funcs_set_color_func;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        JNI.invokePPPPV(funcs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_paint_funcs_set_color_func(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="hb_paint_color_func_t") hb_paint_color_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_paint_funcs_set_color_func(funcs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_paint_funcs_set_image_func(long funcs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.paint_funcs_set_image_func;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        JNI.invokePPPPV(funcs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_paint_funcs_set_image_func(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="hb_paint_image_func_t") hb_paint_image_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_paint_funcs_set_image_func(funcs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_paint_funcs_set_linear_gradient_func(long funcs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.paint_funcs_set_linear_gradient_func;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        JNI.invokePPPPV(funcs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_paint_funcs_set_linear_gradient_func(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="hb_paint_linear_gradient_func_t") hb_paint_linear_gradient_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_paint_funcs_set_linear_gradient_func(funcs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_paint_funcs_set_radial_gradient_func(long funcs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.paint_funcs_set_radial_gradient_func;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        JNI.invokePPPPV(funcs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_paint_funcs_set_radial_gradient_func(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="hb_paint_radial_gradient_func_t") hb_paint_radial_gradient_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_paint_funcs_set_radial_gradient_func(funcs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_paint_funcs_set_sweep_gradient_func(long funcs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.paint_funcs_set_sweep_gradient_func;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        JNI.invokePPPPV(funcs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_paint_funcs_set_sweep_gradient_func(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="hb_paint_sweep_gradient_func_t") hb_paint_sweep_gradient_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_paint_funcs_set_sweep_gradient_func(funcs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_paint_funcs_set_push_group_func(long funcs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.paint_funcs_set_push_group_func;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        JNI.invokePPPPV(funcs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_paint_funcs_set_push_group_func(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="hb_paint_push_group_func_t") hb_paint_push_group_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_paint_funcs_set_push_group_func(funcs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_paint_funcs_set_pop_group_func(long funcs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.paint_funcs_set_pop_group_func;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        JNI.invokePPPPV(funcs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_paint_funcs_set_pop_group_func(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="hb_paint_pop_group_func_t") hb_paint_pop_group_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_paint_funcs_set_pop_group_func(funcs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_paint_funcs_set_custom_palette_color_func(long funcs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.paint_funcs_set_custom_palette_color_func;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        JNI.invokePPPPV(funcs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_paint_funcs_set_custom_palette_color_func(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="hb_paint_custom_palette_color_func_t") hb_paint_custom_palette_color_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_paint_funcs_set_custom_palette_color_func(funcs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void hb_paint_push_transform(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="void *") long paint_data, float xx, float yx, float xy, float yy, float dx, float dy) {
        long __functionAddress = Functions.paint_push_transform;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        JNI.invokePPV(funcs, paint_data, xx, yx, xy, yy, dx, dy, __functionAddress);
    }

    public static void hb_paint_pop_transform(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="void *") long paint_data) {
        long __functionAddress = Functions.paint_pop_transform;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        JNI.invokePPV(funcs, paint_data, __functionAddress);
    }

    public static void hb_paint_color_glyph(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="void *") long paint_data, @NativeType(value="hb_codepoint_t") int glyph, @NativeType(value="hb_font_t *") long font) {
        long __functionAddress = Functions.paint_color_glyph;
        if (Checks.CHECKS) {
            Checks.check(funcs);
            Checks.check(font);
        }
        JNI.invokePPPV(funcs, paint_data, glyph, font, __functionAddress);
    }

    public static void hb_paint_push_clip_glyph(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="void *") long paint_data, @NativeType(value="hb_codepoint_t") int glyph, @NativeType(value="hb_font_t *") long font) {
        long __functionAddress = Functions.paint_push_clip_glyph;
        if (Checks.CHECKS) {
            Checks.check(funcs);
            Checks.check(font);
        }
        JNI.invokePPPV(funcs, paint_data, glyph, font, __functionAddress);
    }

    public static void hb_paint_push_clip_rectangle(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="void *") long paint_data, float xmin, float ymin, float xmax, float ymax) {
        long __functionAddress = Functions.paint_push_clip_rectangle;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        JNI.invokePPV(funcs, paint_data, xmin, ymin, xmax, ymax, __functionAddress);
    }

    public static void hb_paint_pop_clip(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="void *") long paint_data) {
        long __functionAddress = Functions.paint_pop_clip;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        JNI.invokePPV(funcs, paint_data, __functionAddress);
    }

    public static void hb_paint_color(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="void *") long paint_data, @NativeType(value="hb_bool_t") boolean is_foreground, @NativeType(value="hb_color_t") int color) {
        long __functionAddress = Functions.paint_color;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        JNI.invokePPV(funcs, paint_data, is_foreground ? 1 : 0, color, __functionAddress);
    }

    public static void nhb_paint_image(long funcs, long paint_data, long image, int width, int height, int format, float slant, long extents) {
        long __functionAddress = Functions.paint_image;
        if (Checks.CHECKS) {
            Checks.check(funcs);
            Checks.check(image);
        }
        JNI.invokePPPPV(funcs, paint_data, image, width, height, format, slant, extents, __functionAddress);
    }

    public static void hb_paint_image(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="void *") long paint_data, @NativeType(value="hb_blob_t *") long image, @NativeType(value="unsigned int") int width, @NativeType(value="unsigned int") int height, @NativeType(value="hb_tag_t") int format, float slant, @NativeType(value="hb_glyph_extents_t *") hb_glyph_extents_t extents) {
        HarfBuzz.nhb_paint_image(funcs, paint_data, image, width, height, format, slant, extents.address());
    }

    public static void nhb_paint_linear_gradient(long funcs, long paint_data, long color_line, float x0, float yx0, float x1, float y1, float x2, float y2) {
        long __functionAddress = Functions.paint_linear_gradient;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        JNI.invokePPPV(funcs, paint_data, color_line, x0, yx0, x1, y1, x2, y2, __functionAddress);
    }

    public static void hb_paint_linear_gradient(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="void *") long paint_data, @NativeType(value="hb_color_line_t *") hb_color_line_t color_line, float x0, float yx0, float x1, float y1, float x2, float y2) {
        HarfBuzz.nhb_paint_linear_gradient(funcs, paint_data, color_line.address(), x0, yx0, x1, y1, x2, y2);
    }

    public static void nhb_paint_radial_gradient(long funcs, long paint_data, long color_line, float x0, float y0, float r0, float x1, float y1, float r1) {
        long __functionAddress = Functions.paint_radial_gradient;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        JNI.invokePPPV(funcs, paint_data, color_line, x0, y0, r0, x1, y1, r1, __functionAddress);
    }

    public static void hb_paint_radial_gradient(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="void *") long paint_data, @NativeType(value="hb_color_line_t *") hb_color_line_t color_line, float x0, float y0, float r0, float x1, float y1, float r1) {
        HarfBuzz.nhb_paint_radial_gradient(funcs, paint_data, color_line.address(), x0, y0, r0, x1, y1, r1);
    }

    public static void nhb_paint_sweep_gradient(long funcs, long paint_data, long color_line, float x0, float y0, float start_angle, float end_angle) {
        long __functionAddress = Functions.paint_sweep_gradient;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        JNI.invokePPPV(funcs, paint_data, color_line, x0, y0, start_angle, end_angle, __functionAddress);
    }

    public static void hb_paint_sweep_gradient(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="void *") long paint_data, @NativeType(value="hb_color_line_t *") hb_color_line_t color_line, float x0, float y0, float start_angle, float end_angle) {
        HarfBuzz.nhb_paint_sweep_gradient(funcs, paint_data, color_line.address(), x0, y0, start_angle, end_angle);
    }

    public static void hb_paint_push_group(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="void *") long paint_data) {
        long __functionAddress = Functions.paint_push_group;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        JNI.invokePPV(funcs, paint_data, __functionAddress);
    }

    public static void hb_paint_pop_group(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="void *") long paint_data, @NativeType(value="hb_paint_composite_mode_t") int mode) {
        long __functionAddress = Functions.paint_pop_group;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        JNI.invokePPV(funcs, paint_data, mode, __functionAddress);
    }

    public static int nhb_paint_custom_palette_color(long funcs, long paint_data, int color_index, long color) {
        long __functionAddress = Functions.paint_custom_palette_color;
        if (Checks.CHECKS) {
            Checks.check(funcs);
        }
        return JNI.invokePPPI(funcs, paint_data, color_index, color, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_paint_custom_palette_color(@NativeType(value="hb_paint_funcs_t *") long funcs, @NativeType(value="void *") long paint_data, @NativeType(value="unsigned int") int color_index, @NativeType(value="hb_color_t *") IntBuffer color) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)color, 1);
        }
        return HarfBuzz.nhb_paint_custom_palette_color(funcs, paint_data, color_index, MemoryUtil.memAddress(color)) != 0;
    }

    @NativeType(value="hb_set_t *")
    public static long hb_set_create() {
        long __functionAddress = Functions.set_create;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="hb_set_t *")
    public static long hb_set_get_empty() {
        long __functionAddress = Functions.set_get_empty;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="hb_set_t *")
    public static long hb_set_reference(@NativeType(value="hb_set_t *") long set) {
        long __functionAddress = Functions.set_reference;
        if (Checks.CHECKS) {
            Checks.check(set);
        }
        return JNI.invokePP(set, __functionAddress);
    }

    public static void hb_set_destroy(@NativeType(value="hb_set_t *") long set) {
        long __functionAddress = Functions.set_destroy;
        if (Checks.CHECKS) {
            Checks.check(set);
        }
        JNI.invokePV(set, __functionAddress);
    }

    public static int nhb_set_set_user_data(long set, long key, long data, long destroy, int replace) {
        long __functionAddress = Functions.set_set_user_data;
        if (Checks.CHECKS) {
            Checks.check(set);
        }
        return JNI.invokePPPPI(set, key, data, destroy, replace, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_set_set_user_data(@NativeType(value="hb_set_t *") long set, @NativeType(value="hb_user_data_key_t *") hb_user_data_key_t key, @NativeType(value="void *") long data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy, @NativeType(value="hb_bool_t") boolean replace) {
        return HarfBuzz.nhb_set_set_user_data(set, key.address(), data, MemoryUtil.memAddressSafe(destroy), replace ? 1 : 0) != 0;
    }

    public static long nhb_set_get_user_data(long set, long key) {
        long __functionAddress = Functions.set_get_user_data;
        if (Checks.CHECKS) {
            Checks.check(set);
        }
        return JNI.invokePPP(set, key, __functionAddress);
    }

    @NativeType(value="void *")
    public static long hb_set_get_user_data(@NativeType(value="hb_set_t const *") long set, @NativeType(value="hb_user_data_key_t *") hb_user_data_key_t key) {
        return HarfBuzz.nhb_set_get_user_data(set, key.address());
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_set_allocation_successful(@NativeType(value="hb_set_t const *") long set) {
        long __functionAddress = Functions.set_allocation_successful;
        if (Checks.CHECKS) {
            Checks.check(set);
        }
        return JNI.invokePI(set, __functionAddress) != 0;
    }

    @NativeType(value="hb_set_t *")
    public static long hb_set_copy(@NativeType(value="hb_set_t const *") long set) {
        long __functionAddress = Functions.set_copy;
        if (Checks.CHECKS) {
            Checks.check(set);
        }
        return JNI.invokePP(set, __functionAddress);
    }

    public static void hb_set_clear(@NativeType(value="hb_set_t *") long set) {
        long __functionAddress = Functions.set_clear;
        if (Checks.CHECKS) {
            Checks.check(set);
        }
        JNI.invokePV(set, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_set_is_empty(@NativeType(value="hb_set_t const *") long set) {
        long __functionAddress = Functions.set_is_empty;
        if (Checks.CHECKS) {
            Checks.check(set);
        }
        return JNI.invokePI(set, __functionAddress) != 0;
    }

    public static void hb_set_invert(@NativeType(value="hb_set_t *") long set) {
        long __functionAddress = Functions.set_invert;
        if (Checks.CHECKS) {
            Checks.check(set);
        }
        JNI.invokePV(set, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_set_is_inverted(@NativeType(value="hb_set_t const *") long set) {
        long __functionAddress = Functions.set_is_inverted;
        if (Checks.CHECKS) {
            Checks.check(set);
        }
        return JNI.invokePI(set, __functionAddress) != 0;
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_set_has(@NativeType(value="hb_set_t const *") long set, @NativeType(value="hb_codepoint_t") int codepoint) {
        long __functionAddress = Functions.set_has;
        if (Checks.CHECKS) {
            Checks.check(set);
        }
        return JNI.invokePI(set, codepoint, __functionAddress) != 0;
    }

    public static void hb_set_add(@NativeType(value="hb_set_t *") long set, @NativeType(value="hb_codepoint_t") int codepoint) {
        long __functionAddress = Functions.set_add;
        if (Checks.CHECKS) {
            Checks.check(set);
        }
        JNI.invokePV(set, codepoint, __functionAddress);
    }

    public static void hb_set_add_range(@NativeType(value="hb_set_t *") long set, @NativeType(value="hb_codepoint_t") int first, @NativeType(value="hb_codepoint_t") int last) {
        long __functionAddress = Functions.set_add_range;
        if (Checks.CHECKS) {
            Checks.check(set);
        }
        JNI.invokePV(set, first, last, __functionAddress);
    }

    public static void nhb_set_add_sorted_array(long set, long sorted_codepoints, int num_codepoints) {
        long __functionAddress = Functions.set_add_sorted_array;
        if (Checks.CHECKS) {
            Checks.check(set);
        }
        JNI.invokePPV(set, sorted_codepoints, num_codepoints, __functionAddress);
    }

    public static void hb_set_add_sorted_array(@NativeType(value="hb_set_t *") long set, @NativeType(value="hb_codepoint_t const *") IntBuffer sorted_codepoints) {
        HarfBuzz.nhb_set_add_sorted_array(set, MemoryUtil.memAddress(sorted_codepoints), sorted_codepoints.remaining());
    }

    public static void hb_set_del(@NativeType(value="hb_set_t *") long set, @NativeType(value="hb_codepoint_t") int codepoint) {
        long __functionAddress = Functions.set_del;
        if (Checks.CHECKS) {
            Checks.check(set);
        }
        JNI.invokePV(set, codepoint, __functionAddress);
    }

    public static void hb_set_del_range(@NativeType(value="hb_set_t *") long set, @NativeType(value="hb_codepoint_t") int first, @NativeType(value="hb_codepoint_t") int last) {
        long __functionAddress = Functions.set_del_range;
        if (Checks.CHECKS) {
            Checks.check(set);
        }
        JNI.invokePV(set, first, last, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_set_is_equal(@NativeType(value="hb_set_t const *") long set, @NativeType(value="hb_set_t const *") long other) {
        long __functionAddress = Functions.set_is_equal;
        if (Checks.CHECKS) {
            Checks.check(set);
            Checks.check(other);
        }
        return JNI.invokePPI(set, other, __functionAddress) != 0;
    }

    @NativeType(value="unsigned int")
    public static int hb_set_hash(@NativeType(value="hb_set_t const *") long set) {
        long __functionAddress = Functions.set_hash;
        if (Checks.CHECKS) {
            Checks.check(set);
        }
        return JNI.invokePI(set, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_set_is_subset(@NativeType(value="hb_set_t const *") long set, @NativeType(value="hb_set_t const *") long larger_set) {
        long __functionAddress = Functions.set_is_subset;
        if (Checks.CHECKS) {
            Checks.check(set);
            Checks.check(larger_set);
        }
        return JNI.invokePPI(set, larger_set, __functionAddress) != 0;
    }

    public static void hb_set_set(@NativeType(value="hb_set_t *") long set, @NativeType(value="hb_set_t const *") long other) {
        long __functionAddress = Functions.set_set;
        if (Checks.CHECKS) {
            Checks.check(set);
            Checks.check(other);
        }
        JNI.invokePPV(set, other, __functionAddress);
    }

    public static void hb_set_union(@NativeType(value="hb_set_t *") long set, @NativeType(value="hb_set_t const *") long other) {
        long __functionAddress = Functions.set_union;
        if (Checks.CHECKS) {
            Checks.check(set);
            Checks.check(other);
        }
        JNI.invokePPV(set, other, __functionAddress);
    }

    public static void hb_set_intersect(@NativeType(value="hb_set_t *") long set, @NativeType(value="hb_set_t const *") long other) {
        long __functionAddress = Functions.set_intersect;
        if (Checks.CHECKS) {
            Checks.check(set);
            Checks.check(other);
        }
        JNI.invokePPV(set, other, __functionAddress);
    }

    public static void hb_set_subtract(@NativeType(value="hb_set_t *") long set, @NativeType(value="hb_set_t const *") long other) {
        long __functionAddress = Functions.set_subtract;
        if (Checks.CHECKS) {
            Checks.check(set);
            Checks.check(other);
        }
        JNI.invokePPV(set, other, __functionAddress);
    }

    public static void hb_set_symmetric_difference(@NativeType(value="hb_set_t *") long set, @NativeType(value="hb_set_t const *") long other) {
        long __functionAddress = Functions.set_symmetric_difference;
        if (Checks.CHECKS) {
            Checks.check(set);
            Checks.check(other);
        }
        JNI.invokePPV(set, other, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int hb_set_get_population(@NativeType(value="hb_set_t const *") long set) {
        long __functionAddress = Functions.set_get_population;
        if (Checks.CHECKS) {
            Checks.check(set);
        }
        return JNI.invokePI(set, __functionAddress);
    }

    @NativeType(value="hb_codepoint_t")
    public static int hb_set_get_min(@NativeType(value="hb_set_t const *") long set) {
        long __functionAddress = Functions.set_get_min;
        if (Checks.CHECKS) {
            Checks.check(set);
        }
        return JNI.invokePI(set, __functionAddress);
    }

    @NativeType(value="hb_codepoint_t")
    public static int hb_set_get_max(@NativeType(value="hb_set_t const *") long set) {
        long __functionAddress = Functions.set_get_max;
        if (Checks.CHECKS) {
            Checks.check(set);
        }
        return JNI.invokePI(set, __functionAddress);
    }

    public static int nhb_set_next(long set, long codepoint) {
        long __functionAddress = Functions.set_next;
        if (Checks.CHECKS) {
            Checks.check(set);
        }
        return JNI.invokePPI(set, codepoint, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_set_next(@NativeType(value="hb_set_t const *") long set, @NativeType(value="hb_codepoint_t *") IntBuffer codepoint) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)codepoint, 1);
        }
        return HarfBuzz.nhb_set_next(set, MemoryUtil.memAddress(codepoint)) != 0;
    }

    public static int nhb_set_previous(long set, long codepoint) {
        long __functionAddress = Functions.set_previous;
        if (Checks.CHECKS) {
            Checks.check(set);
        }
        return JNI.invokePPI(set, codepoint, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_set_previous(@NativeType(value="hb_set_t const *") long set, @NativeType(value="hb_codepoint_t *") IntBuffer codepoint) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)codepoint, 1);
        }
        return HarfBuzz.nhb_set_previous(set, MemoryUtil.memAddress(codepoint)) != 0;
    }

    public static int nhb_set_next_range(long set, long first, long last) {
        long __functionAddress = Functions.set_next_range;
        if (Checks.CHECKS) {
            Checks.check(set);
        }
        return JNI.invokePPPI(set, first, last, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_set_next_range(@NativeType(value="hb_set_t const *") long set, @NativeType(value="hb_codepoint_t *") IntBuffer first, @NativeType(value="hb_codepoint_t *") IntBuffer last) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)first, 1);
            Checks.check((Buffer)last, 1);
        }
        return HarfBuzz.nhb_set_next_range(set, MemoryUtil.memAddress(first), MemoryUtil.memAddress(last)) != 0;
    }

    public static int nhb_set_previous_range(long set, long first, long last) {
        long __functionAddress = Functions.set_previous_range;
        if (Checks.CHECKS) {
            Checks.check(set);
        }
        return JNI.invokePPPI(set, first, last, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_set_previous_range(@NativeType(value="hb_set_t const *") long set, @NativeType(value="hb_codepoint_t *") IntBuffer first, @NativeType(value="hb_codepoint_t *") IntBuffer last) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)first, 1);
            Checks.check((Buffer)last, 1);
        }
        return HarfBuzz.nhb_set_previous_range(set, MemoryUtil.memAddress(first), MemoryUtil.memAddress(last)) != 0;
    }

    public static int nhb_set_next_many(long set, int codepoint, long out, int size) {
        long __functionAddress = Functions.set_next_many;
        if (Checks.CHECKS) {
            Checks.check(set);
        }
        return JNI.invokePPI(set, codepoint, out, size, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int hb_set_next_many(@NativeType(value="hb_set_t const *") long set, @NativeType(value="hb_codepoint_t") int codepoint, @NativeType(value="hb_codepoint_t *") IntBuffer out) {
        return HarfBuzz.nhb_set_next_many(set, codepoint, MemoryUtil.memAddress(out), out.remaining());
    }

    public static void nhb_shape(long font, long buffer, long features, int num_features) {
        long __functionAddress = Functions.shape;
        if (Checks.CHECKS) {
            Checks.check(font);
            Checks.check(buffer);
        }
        JNI.invokePPPV(font, buffer, features, num_features, __functionAddress);
    }

    public static void hb_shape(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="hb_feature_t const *") @Nullable hb_feature_t.Buffer features) {
        HarfBuzz.nhb_shape(font, buffer, MemoryUtil.memAddressSafe(features), Checks.remainingSafe(features));
    }

    public static int nhb_shape_full(long font, long buffer, long features, int num_features, long shaper_list) {
        long __functionAddress = Functions.shape_full;
        if (Checks.CHECKS) {
            Checks.check(font);
            Checks.check(buffer);
        }
        return JNI.invokePPPPI(font, buffer, features, num_features, shaper_list, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_shape_full(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="hb_feature_t const *") @Nullable hb_feature_t.Buffer features, @NativeType(value="char const * const *") @Nullable PointerBuffer shaper_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(shaper_list);
        }
        return HarfBuzz.nhb_shape_full(font, buffer, MemoryUtil.memAddressSafe(features), Checks.remainingSafe(features), MemoryUtil.memAddressSafe(shaper_list)) != 0;
    }

    public static int nhb_shape_justify(long font, long buffer, long features, int num_features, long shaper_list, float min_target_advance, float max_target_advance, long advance, long var_tag, long var_value) {
        long __functionAddress = Functions.shape_justify;
        if (Checks.CHECKS) {
            Checks.check(font);
            Checks.check(buffer);
        }
        return JNI.invokePPPPPPPI(font, buffer, features, num_features, shaper_list, min_target_advance, max_target_advance, advance, var_tag, var_value, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_shape_justify(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="hb_feature_t const *") @Nullable hb_feature_t.Buffer features, @NativeType(value="char const * const *") @Nullable PointerBuffer shaper_list, float min_target_advance, float max_target_advance, @NativeType(value="float *") FloatBuffer advance, @NativeType(value="hb_tag_t *") IntBuffer var_tag, @NativeType(value="float *") FloatBuffer var_value) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(shaper_list);
            Checks.check((Buffer)advance, 1);
            Checks.check((Buffer)var_tag, 1);
            Checks.check((Buffer)var_value, 1);
        }
        return HarfBuzz.nhb_shape_justify(font, buffer, MemoryUtil.memAddressSafe(features), Checks.remainingSafe(features), MemoryUtil.memAddressSafe(shaper_list), min_target_advance, max_target_advance, MemoryUtil.memAddress(advance), MemoryUtil.memAddress(var_tag), MemoryUtil.memAddress(var_value)) != 0;
    }

    public static long nhb_shape_list_shapers() {
        long __functionAddress = Functions.shape_list_shapers;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="char const **")
    public static @Nullable PointerBuffer hb_shape_list_shapers() {
        long __result = HarfBuzz.nhb_shape_list_shapers();
        return MemoryUtil.memPointerBufferSafe(__result, shape_list_shapers_COUNT);
    }

    @NativeType(value="char const **")
    public static @Nullable PointerBuffer hb_shape_list_shapers(long length) {
        long __result = HarfBuzz.nhb_shape_list_shapers();
        return MemoryUtil.memPointerBufferSafe(__result, (int)length);
    }

    public static long nhb_shape_plan_create(long face, long props, long user_features, int num_user_features, long shaper_list) {
        long __functionAddress = Functions.shape_plan_create;
        return JNI.invokePPPPP(face, props, user_features, num_user_features, shaper_list, __functionAddress);
    }

    @NativeType(value="hb_shape_plan_t *")
    public static long hb_shape_plan_create(@NativeType(value="hb_face_t *") long face, @NativeType(value="hb_segment_properties_t const *") hb_segment_properties_t props, @NativeType(value="hb_feature_t const *") @Nullable hb_feature_t.Buffer user_features, @NativeType(value="char const * const *") @Nullable PointerBuffer shaper_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(shaper_list);
        }
        return HarfBuzz.nhb_shape_plan_create(face, props.address(), MemoryUtil.memAddressSafe(user_features), Checks.remainingSafe(user_features), MemoryUtil.memAddressSafe(shaper_list));
    }

    public static long nhb_shape_plan_create_cached(long face, long props, long user_features, int num_user_features, long shaper_list) {
        long __functionAddress = Functions.shape_plan_create_cached;
        return JNI.invokePPPPP(face, props, user_features, num_user_features, shaper_list, __functionAddress);
    }

    @NativeType(value="hb_shape_plan_t *")
    public static long hb_shape_plan_create_cached(@NativeType(value="hb_face_t *") long face, @NativeType(value="hb_segment_properties_t const *") hb_segment_properties_t props, @NativeType(value="hb_feature_t const *") @Nullable hb_feature_t.Buffer user_features, @NativeType(value="char const * const *") @Nullable PointerBuffer shaper_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(shaper_list);
        }
        return HarfBuzz.nhb_shape_plan_create_cached(face, props.address(), MemoryUtil.memAddressSafe(user_features), Checks.remainingSafe(user_features), MemoryUtil.memAddressSafe(shaper_list));
    }

    public static long nhb_shape_plan_create2(long face, long props, long user_features, int num_user_features, long coords, int num_coords, long shaper_list) {
        long __functionAddress = Functions.shape_plan_create2;
        return JNI.invokePPPPPP(face, props, user_features, num_user_features, coords, num_coords, shaper_list, __functionAddress);
    }

    @NativeType(value="hb_shape_plan_t *")
    public static long hb_shape_plan_create2(@NativeType(value="hb_face_t *") long face, @NativeType(value="hb_segment_properties_t const *") hb_segment_properties_t props, @NativeType(value="hb_feature_t const *") @Nullable hb_feature_t.Buffer user_features, @NativeType(value="int const *") @Nullable IntBuffer coords, @NativeType(value="char const * const *") @Nullable PointerBuffer shaper_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(shaper_list);
        }
        return HarfBuzz.nhb_shape_plan_create2(face, props.address(), MemoryUtil.memAddressSafe(user_features), Checks.remainingSafe(user_features), MemoryUtil.memAddressSafe(coords), Checks.remainingSafe(coords), MemoryUtil.memAddressSafe(shaper_list));
    }

    public static long nhb_shape_plan_create_cached2(long face, long props, long user_features, int num_user_features, long coords, int num_coords, long shaper_list) {
        long __functionAddress = Functions.shape_plan_create_cached2;
        return JNI.invokePPPPPP(face, props, user_features, num_user_features, coords, num_coords, shaper_list, __functionAddress);
    }

    @NativeType(value="hb_shape_plan_t *")
    public static long hb_shape_plan_create_cached2(@NativeType(value="hb_face_t *") long face, @NativeType(value="hb_segment_properties_t const *") hb_segment_properties_t props, @NativeType(value="hb_feature_t const *") @Nullable hb_feature_t.Buffer user_features, @NativeType(value="int const *") @Nullable IntBuffer coords, @NativeType(value="char const * const *") @Nullable PointerBuffer shaper_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(shaper_list);
        }
        return HarfBuzz.nhb_shape_plan_create_cached2(face, props.address(), MemoryUtil.memAddressSafe(user_features), Checks.remainingSafe(user_features), MemoryUtil.memAddressSafe(coords), Checks.remainingSafe(coords), MemoryUtil.memAddressSafe(shaper_list));
    }

    @NativeType(value="hb_shape_plan_t *")
    public static long hb_shape_plan_get_empty() {
        long __functionAddress = Functions.shape_plan_get_empty;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="hb_shape_plan_t *")
    public static long hb_shape_plan_reference(@NativeType(value="hb_shape_plan_t *") long shape_plan) {
        long __functionAddress = Functions.shape_plan_reference;
        if (Checks.CHECKS) {
            Checks.check(shape_plan);
        }
        return JNI.invokePP(shape_plan, __functionAddress);
    }

    public static void hb_shape_plan_destroy(@NativeType(value="hb_shape_plan_t *") long shape_plan) {
        long __functionAddress = Functions.shape_plan_destroy;
        if (Checks.CHECKS) {
            Checks.check(shape_plan);
        }
        JNI.invokePV(shape_plan, __functionAddress);
    }

    public static int nhb_shape_plan_set_user_data(long shape_plan, long key, long data, long destroy, int replace) {
        long __functionAddress = Functions.shape_plan_set_user_data;
        if (Checks.CHECKS) {
            Checks.check(shape_plan);
        }
        return JNI.invokePPPPI(shape_plan, key, data, destroy, replace, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_shape_plan_set_user_data(@NativeType(value="hb_shape_plan_t *") long shape_plan, @NativeType(value="hb_user_data_key_t *") hb_user_data_key_t key, @NativeType(value="void *") long data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy, @NativeType(value="hb_bool_t") boolean replace) {
        return HarfBuzz.nhb_shape_plan_set_user_data(shape_plan, key.address(), data, MemoryUtil.memAddressSafe(destroy), replace ? 1 : 0) != 0;
    }

    public static long nhb_shape_plan_get_user_data(long shape_plan, long key) {
        long __functionAddress = Functions.shape_plan_get_user_data;
        if (Checks.CHECKS) {
            Checks.check(shape_plan);
        }
        return JNI.invokePPP(shape_plan, key, __functionAddress);
    }

    @NativeType(value="void *")
    public static long hb_shape_plan_get_user_data(@NativeType(value="hb_shape_plan_t const *") long shape_plan, @NativeType(value="hb_user_data_key_t *") hb_user_data_key_t key) {
        return HarfBuzz.nhb_shape_plan_get_user_data(shape_plan, key.address());
    }

    public static int nhb_shape_plan_execute(long shape_plan, long font, long buffer, long features, int num_features) {
        long __functionAddress = Functions.shape_plan_execute;
        if (Checks.CHECKS) {
            Checks.check(shape_plan);
            Checks.check(font);
            Checks.check(buffer);
        }
        return JNI.invokePPPPI(shape_plan, font, buffer, features, num_features, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_shape_plan_execute(@NativeType(value="hb_shape_plan_t *") long shape_plan, @NativeType(value="hb_font_t *") long font, @NativeType(value="hb_buffer_t *") long buffer, @NativeType(value="hb_feature_t const *") @Nullable hb_feature_t.Buffer features) {
        return HarfBuzz.nhb_shape_plan_execute(shape_plan, font, buffer, MemoryUtil.memAddressSafe(features), Checks.remainingSafe(features)) != 0;
    }

    public static long nhb_shape_plan_get_shaper(long shape_plan) {
        long __functionAddress = Functions.shape_plan_get_shaper;
        if (Checks.CHECKS) {
            Checks.check(shape_plan);
        }
        return JNI.invokePP(shape_plan, __functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String hb_shape_plan_get_shaper(@NativeType(value="hb_shape_plan_t *") long shape_plan) {
        long __result = HarfBuzz.nhb_shape_plan_get_shaper(shape_plan);
        return MemoryUtil.memASCIISafe(__result);
    }

    public static float hb_style_get_value(@NativeType(value="hb_font_t *") long font, @NativeType(value="hb_style_tag_t") int style_tag) {
        long __functionAddress = Functions.style_get_value;
        if (Checks.CHECKS) {
            Checks.check(font);
        }
        return JNI.invokePF(font, style_tag, __functionAddress);
    }

    @NativeType(value="hb_unicode_funcs_t *")
    public static long hb_unicode_funcs_get_default() {
        long __functionAddress = Functions.unicode_funcs_get_default;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="hb_unicode_funcs_t *")
    public static long hb_unicode_funcs_create(@NativeType(value="hb_unicode_funcs_t *") long parent) {
        long __functionAddress = Functions.unicode_funcs_create;
        if (Checks.CHECKS) {
            Checks.check(parent);
        }
        return JNI.invokePP(parent, __functionAddress);
    }

    @NativeType(value="hb_unicode_funcs_t *")
    public static long hb_unicode_funcs_get_empty() {
        long __functionAddress = Functions.unicode_funcs_get_empty;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="hb_unicode_funcs_t *")
    public static long hb_unicode_funcs_reference(@NativeType(value="hb_unicode_funcs_t *") long ufuncs) {
        long __functionAddress = Functions.unicode_funcs_reference;
        if (Checks.CHECKS) {
            Checks.check(ufuncs);
        }
        return JNI.invokePP(ufuncs, __functionAddress);
    }

    public static void hb_unicode_funcs_destroy(@NativeType(value="hb_unicode_funcs_t *") long ufuncs) {
        long __functionAddress = Functions.unicode_funcs_destroy;
        if (Checks.CHECKS) {
            Checks.check(ufuncs);
        }
        JNI.invokePV(ufuncs, __functionAddress);
    }

    public static int nhb_unicode_funcs_set_user_data(long ufuncs, long key, long data, long destroy, int replace) {
        long __functionAddress = Functions.unicode_funcs_set_user_data;
        if (Checks.CHECKS) {
            Checks.check(ufuncs);
        }
        return JNI.invokePPPPI(ufuncs, key, data, destroy, replace, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_unicode_funcs_set_user_data(@NativeType(value="hb_unicode_funcs_t *") long ufuncs, @NativeType(value="hb_user_data_key_t *") hb_user_data_key_t key, @NativeType(value="void *") long data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy, @NativeType(value="hb_bool_t") boolean replace) {
        return HarfBuzz.nhb_unicode_funcs_set_user_data(ufuncs, key.address(), data, MemoryUtil.memAddressSafe(destroy), replace ? 1 : 0) != 0;
    }

    public static long nhb_unicode_funcs_get_user_data(long ufuncs, long key) {
        long __functionAddress = Functions.unicode_funcs_get_user_data;
        if (Checks.CHECKS) {
            Checks.check(ufuncs);
        }
        return JNI.invokePPP(ufuncs, key, __functionAddress);
    }

    @NativeType(value="void *")
    public static long hb_unicode_funcs_get_user_data(@NativeType(value="hb_unicode_funcs_t const *") long ufuncs, @NativeType(value="hb_user_data_key_t *") hb_user_data_key_t key) {
        return HarfBuzz.nhb_unicode_funcs_get_user_data(ufuncs, key.address());
    }

    public static void hb_unicode_funcs_make_immutable(@NativeType(value="hb_unicode_funcs_t *") long ufuncs) {
        long __functionAddress = Functions.unicode_funcs_make_immutable;
        if (Checks.CHECKS) {
            Checks.check(ufuncs);
        }
        JNI.invokePV(ufuncs, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_unicode_funcs_is_immutable(@NativeType(value="hb_unicode_funcs_t *") long ufuncs) {
        long __functionAddress = Functions.unicode_funcs_is_immutable;
        if (Checks.CHECKS) {
            Checks.check(ufuncs);
        }
        return JNI.invokePI(ufuncs, __functionAddress) != 0;
    }

    @NativeType(value="hb_unicode_funcs_t *")
    public static long hb_unicode_funcs_get_parent(@NativeType(value="hb_unicode_funcs_t *") long ufuncs) {
        long __functionAddress = Functions.unicode_funcs_get_parent;
        if (Checks.CHECKS) {
            Checks.check(ufuncs);
        }
        return JNI.invokePP(ufuncs, __functionAddress);
    }

    public static void nhb_unicode_funcs_set_combining_class_func(long ufuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.unicode_funcs_set_combining_class_func;
        if (Checks.CHECKS) {
            Checks.check(ufuncs);
        }
        JNI.invokePPPPV(ufuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_unicode_funcs_set_combining_class_func(@NativeType(value="hb_unicode_funcs_t *") long ufuncs, @NativeType(value="hb_unicode_combining_class_func_t") hb_unicode_combining_class_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_unicode_funcs_set_combining_class_func(ufuncs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_unicode_funcs_set_general_category_func(long ufuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.unicode_funcs_set_general_category_func;
        if (Checks.CHECKS) {
            Checks.check(ufuncs);
        }
        JNI.invokePPPPV(ufuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_unicode_funcs_set_general_category_func(@NativeType(value="hb_unicode_funcs_t *") long ufuncs, @NativeType(value="hb_unicode_general_category_func_t") hb_unicode_general_category_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_unicode_funcs_set_general_category_func(ufuncs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_unicode_funcs_set_mirroring_func(long ufuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.unicode_funcs_set_mirroring_func;
        if (Checks.CHECKS) {
            Checks.check(ufuncs);
        }
        JNI.invokePPPPV(ufuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_unicode_funcs_set_mirroring_func(@NativeType(value="hb_unicode_funcs_t *") long ufuncs, @NativeType(value="hb_unicode_mirroring_func_t") hb_unicode_mirroring_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_unicode_funcs_set_mirroring_func(ufuncs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_unicode_funcs_set_script_func(long ufuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.unicode_funcs_set_script_func;
        if (Checks.CHECKS) {
            Checks.check(ufuncs);
        }
        JNI.invokePPPPV(ufuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_unicode_funcs_set_script_func(@NativeType(value="hb_unicode_funcs_t *") long ufuncs, @NativeType(value="hb_unicode_script_func_t") hb_unicode_script_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_unicode_funcs_set_script_func(ufuncs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_unicode_funcs_set_compose_func(long ufuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.unicode_funcs_set_compose_func;
        if (Checks.CHECKS) {
            Checks.check(ufuncs);
        }
        JNI.invokePPPPV(ufuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_unicode_funcs_set_compose_func(@NativeType(value="hb_unicode_funcs_t *") long ufuncs, @NativeType(value="hb_unicode_compose_func_t") hb_unicode_compose_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_unicode_funcs_set_compose_func(ufuncs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    public static void nhb_unicode_funcs_set_decompose_func(long ufuncs, long func, long user_data, long destroy) {
        long __functionAddress = Functions.unicode_funcs_set_decompose_func;
        if (Checks.CHECKS) {
            Checks.check(ufuncs);
        }
        JNI.invokePPPPV(ufuncs, func, user_data, destroy, __functionAddress);
    }

    public static void hb_unicode_funcs_set_decompose_func(@NativeType(value="hb_unicode_funcs_t *") long ufuncs, @NativeType(value="hb_unicode_decompose_func_t") hb_unicode_decompose_func_tI func, @NativeType(value="void *") long user_data, @NativeType(value="hb_destroy_func_t") @Nullable hb_destroy_func_tI destroy) {
        HarfBuzz.nhb_unicode_funcs_set_decompose_func(ufuncs, func.address(), user_data, MemoryUtil.memAddressSafe(destroy));
    }

    @NativeType(value="hb_unicode_combining_class_t")
    public static int hb_unicode_combining_class(@NativeType(value="hb_unicode_funcs_t *") long ufuncs, @NativeType(value="hb_codepoint_t") int unicode) {
        long __functionAddress = Functions.unicode_combining_class;
        if (Checks.CHECKS) {
            Checks.check(ufuncs);
        }
        return JNI.invokePI(ufuncs, unicode, __functionAddress);
    }

    @NativeType(value="hb_unicode_general_category_t")
    public static int hb_unicode_general_category(@NativeType(value="hb_unicode_funcs_t *") long ufuncs, @NativeType(value="hb_codepoint_t") int unicode) {
        long __functionAddress = Functions.unicode_general_category;
        if (Checks.CHECKS) {
            Checks.check(ufuncs);
        }
        return JNI.invokePI(ufuncs, unicode, __functionAddress);
    }

    @NativeType(value="hb_codepoint_t")
    public static int hb_unicode_mirroring(@NativeType(value="hb_unicode_funcs_t *") long ufuncs, @NativeType(value="hb_codepoint_t") int unicode) {
        long __functionAddress = Functions.unicode_mirroring;
        if (Checks.CHECKS) {
            Checks.check(ufuncs);
        }
        return JNI.invokePI(ufuncs, unicode, __functionAddress);
    }

    @NativeType(value="hb_script_t")
    public static int hb_unicode_script(@NativeType(value="hb_unicode_funcs_t *") long ufuncs, @NativeType(value="hb_codepoint_t") int unicode) {
        long __functionAddress = Functions.unicode_script;
        if (Checks.CHECKS) {
            Checks.check(ufuncs);
        }
        return JNI.invokePI(ufuncs, unicode, __functionAddress);
    }

    public static int nhb_unicode_compose(long ufuncs, int a, int b, long ab) {
        long __functionAddress = Functions.unicode_compose;
        if (Checks.CHECKS) {
            Checks.check(ufuncs);
        }
        return JNI.invokePPI(ufuncs, a, b, ab, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_unicode_compose(@NativeType(value="hb_unicode_funcs_t *") long ufuncs, @NativeType(value="hb_codepoint_t") int a, @NativeType(value="hb_codepoint_t") int b, @NativeType(value="hb_codepoint_t *") IntBuffer ab) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)ab, 1);
        }
        return HarfBuzz.nhb_unicode_compose(ufuncs, a, b, MemoryUtil.memAddress(ab)) != 0;
    }

    public static int nhb_unicode_decompose(long ufuncs, int ab, long a, long b) {
        long __functionAddress = Functions.unicode_decompose;
        if (Checks.CHECKS) {
            Checks.check(ufuncs);
        }
        return JNI.invokePPPI(ufuncs, ab, a, b, __functionAddress);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_unicode_decompose(@NativeType(value="hb_unicode_funcs_t *") long ufuncs, @NativeType(value="hb_codepoint_t") int ab, @NativeType(value="hb_codepoint_t *") IntBuffer a, @NativeType(value="hb_codepoint_t *") IntBuffer b) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)a, 1);
            Checks.check((Buffer)b, 1);
        }
        return HarfBuzz.nhb_unicode_decompose(ufuncs, ab, MemoryUtil.memAddress(a), MemoryUtil.memAddress(b)) != 0;
    }

    public static void nhb_version(long major, long minor, long micro) {
        long __functionAddress = Functions.version;
        JNI.invokePPPV(major, minor, micro, __functionAddress);
    }

    public static void hb_version(@NativeType(value="unsigned int *") IntBuffer major, @NativeType(value="unsigned int *") IntBuffer minor, @NativeType(value="unsigned int *") IntBuffer micro) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)major, 1);
            Checks.check((Buffer)minor, 1);
            Checks.check((Buffer)micro, 1);
        }
        HarfBuzz.nhb_version(MemoryUtil.memAddress(major), MemoryUtil.memAddress(minor), MemoryUtil.memAddress(micro));
    }

    public static long nhb_version_string() {
        long __functionAddress = Functions.version_string;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String hb_version_string() {
        long __result = HarfBuzz.nhb_version_string();
        return MemoryUtil.memASCIISafe(__result);
    }

    @NativeType(value="hb_bool_t")
    public static boolean hb_version_atleast(@NativeType(value="unsigned int") int major, @NativeType(value="unsigned int") int minor, @NativeType(value="unsigned int") int micro) {
        long __functionAddress = Functions.version_atleast;
        return JNI.invokeI(major, minor, micro, __functionAddress) != 0;
    }

    public static int HB_TAG(int c1, int c2, int c3, int c4) {
        return (c1 & 0xFF) << 24 | (c2 & 0xFF) << 16 | (c3 & 0xFF) << 8 | c4 & 0xFF;
    }

    public static boolean HB_DIRECTION_IS_VALID(@NativeType(value="hb_direction_t") int dir) {
        return (dir & 0xFFFFFFFC) == 4;
    }

    public static boolean HB_DIRECTION_IS_HORIZONTAL(@NativeType(value="hb_direction_t") int dir) {
        return (dir & 0xFFFFFFFE) == 4;
    }

    public static boolean HB_DIRECTION_IS_VERTICAL(@NativeType(value="hb_direction_t") int dir) {
        return (dir & 0xFFFFFFFE) == 6;
    }

    public static boolean HB_DIRECTION_IS_FORWARD(@NativeType(value="hb_direction_t") int dir) {
        return (dir & 0xFFFFFFFD) == 4;
    }

    public static boolean HB_DIRECTION_IS_BACKWARD(@NativeType(value="hb_direction_t") int dir) {
        return (dir & 0xFFFFFFFD) == 5;
    }

    @NativeType(value="hb_direction_t")
    public static int HB_DIRECTION_REVERSE(@NativeType(value="hb_direction_t") int dir) {
        return dir ^ 1;
    }

    public static int HB_COLOR(int b, int g, int r, int a) {
        return HarfBuzz.HB_TAG(b, g, r, a);
    }

    @NativeType(value="hb_glyph_flags_t")
    public static int hb_glyph_info_get_glyph_flags(@NativeType(value="hb_glyph_info_t const *") hb_glyph_info_t info) {
        return info.mask() & 7;
    }

    public static boolean HB_VERSION_ATLEAST(int major, int minor, int micro) {
        return major * 10000 + minor * 100 + micro <= 100100;
    }

    static /* synthetic */ SharedLibrary access$000() {
        return HARFBUZZ;
    }

    static {
        SharedLibrary library;
        Object value = Configuration.HARFBUZZ_LIBRARY_NAME.get(Platform.mapLibraryNameBundled("harfbuzz"));
        if (value instanceof SharedLibrary) {
            library = (SharedLibrary)value;
        } else {
            String name = (String)value;
            if ("freetype".equals(name)) {
                try {
                    library = (SharedLibrary)Class.forName("org.lwjgl.util.freetype.FreeType").getMethod("getLibrary", new Class[0]).invoke(null, (Object[])null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                library = Library.loadNative(HarfBuzz.class, "org.lwjgl.harfbuzz", name, true);
            }
        }
        HARFBUZZ = library;
        HB_TAG_NONE = HarfBuzz.HB_TAG(0, 0, 0, 0);
        HB_TAG_MAX = HarfBuzz.HB_TAG(255, 255, 255, 255);
        HB_TAG_MAX_SIGNED = HarfBuzz.HB_TAG(127, 255, 255, 255);
        HB_SCRIPT_COMMON = HarfBuzz.HB_TAG(90, 121, 121, 121);
        HB_SCRIPT_INHERITED = HarfBuzz.HB_TAG(90, 105, 110, 104);
        HB_SCRIPT_UNKNOWN = HarfBuzz.HB_TAG(90, 122, 122, 122);
        HB_SCRIPT_ARABIC = HarfBuzz.HB_TAG(65, 114, 97, 98);
        HB_SCRIPT_ARMENIAN = HarfBuzz.HB_TAG(65, 114, 109, 110);
        HB_SCRIPT_BENGALI = HarfBuzz.HB_TAG(66, 101, 110, 103);
        HB_SCRIPT_CYRILLIC = HarfBuzz.HB_TAG(67, 121, 114, 108);
        HB_SCRIPT_DEVANAGARI = HarfBuzz.HB_TAG(68, 101, 118, 97);
        HB_SCRIPT_GEORGIAN = HarfBuzz.HB_TAG(71, 101, 111, 114);
        HB_SCRIPT_GREEK = HarfBuzz.HB_TAG(71, 114, 101, 107);
        HB_SCRIPT_GUJARATI = HarfBuzz.HB_TAG(71, 117, 106, 114);
        HB_SCRIPT_GURMUKHI = HarfBuzz.HB_TAG(71, 117, 114, 117);
        HB_SCRIPT_HANGUL = HarfBuzz.HB_TAG(72, 97, 110, 103);
        HB_SCRIPT_HAN = HarfBuzz.HB_TAG(72, 97, 110, 105);
        HB_SCRIPT_HEBREW = HarfBuzz.HB_TAG(72, 101, 98, 114);
        HB_SCRIPT_HIRAGANA = HarfBuzz.HB_TAG(72, 105, 114, 97);
        HB_SCRIPT_KANNADA = HarfBuzz.HB_TAG(75, 110, 100, 97);
        HB_SCRIPT_KATAKANA = HarfBuzz.HB_TAG(75, 97, 110, 97);
        HB_SCRIPT_LAO = HarfBuzz.HB_TAG(76, 97, 111, 111);
        HB_SCRIPT_LATIN = HarfBuzz.HB_TAG(76, 97, 116, 110);
        HB_SCRIPT_MALAYALAM = HarfBuzz.HB_TAG(77, 108, 121, 109);
        HB_SCRIPT_ORIYA = HarfBuzz.HB_TAG(79, 114, 121, 97);
        HB_SCRIPT_TAMIL = HarfBuzz.HB_TAG(84, 97, 109, 108);
        HB_SCRIPT_TELUGU = HarfBuzz.HB_TAG(84, 101, 108, 117);
        HB_SCRIPT_THAI = HarfBuzz.HB_TAG(84, 104, 97, 105);
        HB_SCRIPT_TIBETAN = HarfBuzz.HB_TAG(84, 105, 98, 116);
        HB_SCRIPT_BOPOMOFO = HarfBuzz.HB_TAG(66, 111, 112, 111);
        HB_SCRIPT_BRAILLE = HarfBuzz.HB_TAG(66, 114, 97, 105);
        HB_SCRIPT_CANADIAN_SYLLABICS = HarfBuzz.HB_TAG(67, 97, 110, 115);
        HB_SCRIPT_CHEROKEE = HarfBuzz.HB_TAG(67, 104, 101, 114);
        HB_SCRIPT_ETHIOPIC = HarfBuzz.HB_TAG(69, 116, 104, 105);
        HB_SCRIPT_KHMER = HarfBuzz.HB_TAG(75, 104, 109, 114);
        HB_SCRIPT_MONGOLIAN = HarfBuzz.HB_TAG(77, 111, 110, 103);
        HB_SCRIPT_MYANMAR = HarfBuzz.HB_TAG(77, 121, 109, 114);
        HB_SCRIPT_OGHAM = HarfBuzz.HB_TAG(79, 103, 97, 109);
        HB_SCRIPT_RUNIC = HarfBuzz.HB_TAG(82, 117, 110, 114);
        HB_SCRIPT_SINHALA = HarfBuzz.HB_TAG(83, 105, 110, 104);
        HB_SCRIPT_SYRIAC = HarfBuzz.HB_TAG(83, 121, 114, 99);
        HB_SCRIPT_THAANA = HarfBuzz.HB_TAG(84, 104, 97, 97);
        HB_SCRIPT_YI = HarfBuzz.HB_TAG(89, 105, 105, 105);
        HB_SCRIPT_DESERET = HarfBuzz.HB_TAG(68, 115, 114, 116);
        HB_SCRIPT_GOTHIC = HarfBuzz.HB_TAG(71, 111, 116, 104);
        HB_SCRIPT_OLD_ITALIC = HarfBuzz.HB_TAG(73, 116, 97, 108);
        HB_SCRIPT_BUHID = HarfBuzz.HB_TAG(66, 117, 104, 100);
        HB_SCRIPT_HANUNOO = HarfBuzz.HB_TAG(72, 97, 110, 111);
        HB_SCRIPT_TAGALOG = HarfBuzz.HB_TAG(84, 103, 108, 103);
        HB_SCRIPT_TAGBANWA = HarfBuzz.HB_TAG(84, 97, 103, 98);
        HB_SCRIPT_CYPRIOT = HarfBuzz.HB_TAG(67, 112, 114, 116);
        HB_SCRIPT_LIMBU = HarfBuzz.HB_TAG(76, 105, 109, 98);
        HB_SCRIPT_LINEAR_B = HarfBuzz.HB_TAG(76, 105, 110, 98);
        HB_SCRIPT_OSMANYA = HarfBuzz.HB_TAG(79, 115, 109, 97);
        HB_SCRIPT_SHAVIAN = HarfBuzz.HB_TAG(83, 104, 97, 119);
        HB_SCRIPT_TAI_LE = HarfBuzz.HB_TAG(84, 97, 108, 101);
        HB_SCRIPT_UGARITIC = HarfBuzz.HB_TAG(85, 103, 97, 114);
        HB_SCRIPT_BUGINESE = HarfBuzz.HB_TAG(66, 117, 103, 105);
        HB_SCRIPT_COPTIC = HarfBuzz.HB_TAG(67, 111, 112, 116);
        HB_SCRIPT_GLAGOLITIC = HarfBuzz.HB_TAG(71, 108, 97, 103);
        HB_SCRIPT_KHAROSHTHI = HarfBuzz.HB_TAG(75, 104, 97, 114);
        HB_SCRIPT_NEW_TAI_LUE = HarfBuzz.HB_TAG(84, 97, 108, 117);
        HB_SCRIPT_OLD_PERSIAN = HarfBuzz.HB_TAG(88, 112, 101, 111);
        HB_SCRIPT_SYLOTI_NAGRI = HarfBuzz.HB_TAG(83, 121, 108, 111);
        HB_SCRIPT_TIFINAGH = HarfBuzz.HB_TAG(84, 102, 110, 103);
        HB_SCRIPT_BALINESE = HarfBuzz.HB_TAG(66, 97, 108, 105);
        HB_SCRIPT_CUNEIFORM = HarfBuzz.HB_TAG(88, 115, 117, 120);
        HB_SCRIPT_NKO = HarfBuzz.HB_TAG(78, 107, 111, 111);
        HB_SCRIPT_PHAGS_PA = HarfBuzz.HB_TAG(80, 104, 97, 103);
        HB_SCRIPT_PHOENICIAN = HarfBuzz.HB_TAG(80, 104, 110, 120);
        HB_SCRIPT_CARIAN = HarfBuzz.HB_TAG(67, 97, 114, 105);
        HB_SCRIPT_CHAM = HarfBuzz.HB_TAG(67, 104, 97, 109);
        HB_SCRIPT_KAYAH_LI = HarfBuzz.HB_TAG(75, 97, 108, 105);
        HB_SCRIPT_LEPCHA = HarfBuzz.HB_TAG(76, 101, 112, 99);
        HB_SCRIPT_LYCIAN = HarfBuzz.HB_TAG(76, 121, 99, 105);
        HB_SCRIPT_LYDIAN = HarfBuzz.HB_TAG(76, 121, 100, 105);
        HB_SCRIPT_OL_CHIKI = HarfBuzz.HB_TAG(79, 108, 99, 107);
        HB_SCRIPT_REJANG = HarfBuzz.HB_TAG(82, 106, 110, 103);
        HB_SCRIPT_SAURASHTRA = HarfBuzz.HB_TAG(83, 97, 117, 114);
        HB_SCRIPT_SUNDANESE = HarfBuzz.HB_TAG(83, 117, 110, 100);
        HB_SCRIPT_VAI = HarfBuzz.HB_TAG(86, 97, 105, 105);
        HB_SCRIPT_AVESTAN = HarfBuzz.HB_TAG(65, 118, 115, 116);
        HB_SCRIPT_BAMUM = HarfBuzz.HB_TAG(66, 97, 109, 117);
        HB_SCRIPT_EGYPTIAN_HIEROGLYPHS = HarfBuzz.HB_TAG(69, 103, 121, 112);
        HB_SCRIPT_IMPERIAL_ARAMAIC = HarfBuzz.HB_TAG(65, 114, 109, 105);
        HB_SCRIPT_INSCRIPTIONAL_PAHLAVI = HarfBuzz.HB_TAG(80, 104, 108, 105);
        HB_SCRIPT_INSCRIPTIONAL_PARTHIAN = HarfBuzz.HB_TAG(80, 114, 116, 105);
        HB_SCRIPT_JAVANESE = HarfBuzz.HB_TAG(74, 97, 118, 97);
        HB_SCRIPT_KAITHI = HarfBuzz.HB_TAG(75, 116, 104, 105);
        HB_SCRIPT_LISU = HarfBuzz.HB_TAG(76, 105, 115, 117);
        HB_SCRIPT_MEETEI_MAYEK = HarfBuzz.HB_TAG(77, 116, 101, 105);
        HB_SCRIPT_OLD_SOUTH_ARABIAN = HarfBuzz.HB_TAG(83, 97, 114, 98);
        HB_SCRIPT_OLD_TURKIC = HarfBuzz.HB_TAG(79, 114, 107, 104);
        HB_SCRIPT_SAMARITAN = HarfBuzz.HB_TAG(83, 97, 109, 114);
        HB_SCRIPT_TAI_THAM = HarfBuzz.HB_TAG(76, 97, 110, 97);
        HB_SCRIPT_TAI_VIET = HarfBuzz.HB_TAG(84, 97, 118, 116);
        HB_SCRIPT_BATAK = HarfBuzz.HB_TAG(66, 97, 116, 107);
        HB_SCRIPT_BRAHMI = HarfBuzz.HB_TAG(66, 114, 97, 104);
        HB_SCRIPT_MANDAIC = HarfBuzz.HB_TAG(77, 97, 110, 100);
        HB_SCRIPT_CHAKMA = HarfBuzz.HB_TAG(67, 97, 107, 109);
        HB_SCRIPT_MEROITIC_CURSIVE = HarfBuzz.HB_TAG(77, 101, 114, 99);
        HB_SCRIPT_MEROITIC_HIEROGLYPHS = HarfBuzz.HB_TAG(77, 101, 114, 111);
        HB_SCRIPT_MIAO = HarfBuzz.HB_TAG(80, 108, 114, 100);
        HB_SCRIPT_SHARADA = HarfBuzz.HB_TAG(83, 104, 114, 100);
        HB_SCRIPT_SORA_SOMPENG = HarfBuzz.HB_TAG(83, 111, 114, 97);
        HB_SCRIPT_TAKRI = HarfBuzz.HB_TAG(84, 97, 107, 114);
        HB_SCRIPT_BASSA_VAH = HarfBuzz.HB_TAG(66, 97, 115, 115);
        HB_SCRIPT_CAUCASIAN_ALBANIAN = HarfBuzz.HB_TAG(65, 103, 104, 98);
        HB_SCRIPT_DUPLOYAN = HarfBuzz.HB_TAG(68, 117, 112, 108);
        HB_SCRIPT_ELBASAN = HarfBuzz.HB_TAG(69, 108, 98, 97);
        HB_SCRIPT_GRANTHA = HarfBuzz.HB_TAG(71, 114, 97, 110);
        HB_SCRIPT_KHOJKI = HarfBuzz.HB_TAG(75, 104, 111, 106);
        HB_SCRIPT_KHUDAWADI = HarfBuzz.HB_TAG(83, 105, 110, 100);
        HB_SCRIPT_LINEAR_A = HarfBuzz.HB_TAG(76, 105, 110, 97);
        HB_SCRIPT_MAHAJANI = HarfBuzz.HB_TAG(77, 97, 104, 106);
        HB_SCRIPT_MANICHAEAN = HarfBuzz.HB_TAG(77, 97, 110, 105);
        HB_SCRIPT_MENDE_KIKAKUI = HarfBuzz.HB_TAG(77, 101, 110, 100);
        HB_SCRIPT_MODI = HarfBuzz.HB_TAG(77, 111, 100, 105);
        HB_SCRIPT_MRO = HarfBuzz.HB_TAG(77, 114, 111, 111);
        HB_SCRIPT_NABATAEAN = HarfBuzz.HB_TAG(78, 98, 97, 116);
        HB_SCRIPT_OLD_NORTH_ARABIAN = HarfBuzz.HB_TAG(78, 97, 114, 98);
        HB_SCRIPT_OLD_PERMIC = HarfBuzz.HB_TAG(80, 101, 114, 109);
        HB_SCRIPT_PAHAWH_HMONG = HarfBuzz.HB_TAG(72, 109, 110, 103);
        HB_SCRIPT_PALMYRENE = HarfBuzz.HB_TAG(80, 97, 108, 109);
        HB_SCRIPT_PAU_CIN_HAU = HarfBuzz.HB_TAG(80, 97, 117, 99);
        HB_SCRIPT_PSALTER_PAHLAVI = HarfBuzz.HB_TAG(80, 104, 108, 112);
        HB_SCRIPT_SIDDHAM = HarfBuzz.HB_TAG(83, 105, 100, 100);
        HB_SCRIPT_TIRHUTA = HarfBuzz.HB_TAG(84, 105, 114, 104);
        HB_SCRIPT_WARANG_CITI = HarfBuzz.HB_TAG(87, 97, 114, 97);
        HB_SCRIPT_AHOM = HarfBuzz.HB_TAG(65, 104, 111, 109);
        HB_SCRIPT_ANATOLIAN_HIEROGLYPHS = HarfBuzz.HB_TAG(72, 108, 117, 119);
        HB_SCRIPT_HATRAN = HarfBuzz.HB_TAG(72, 97, 116, 114);
        HB_SCRIPT_MULTANI = HarfBuzz.HB_TAG(77, 117, 108, 116);
        HB_SCRIPT_OLD_HUNGARIAN = HarfBuzz.HB_TAG(72, 117, 110, 103);
        HB_SCRIPT_SIGNWRITING = HarfBuzz.HB_TAG(83, 103, 110, 119);
        HB_SCRIPT_ADLAM = HarfBuzz.HB_TAG(65, 100, 108, 109);
        HB_SCRIPT_BHAIKSUKI = HarfBuzz.HB_TAG(66, 104, 107, 115);
        HB_SCRIPT_MARCHEN = HarfBuzz.HB_TAG(77, 97, 114, 99);
        HB_SCRIPT_OSAGE = HarfBuzz.HB_TAG(79, 115, 103, 101);
        HB_SCRIPT_TANGUT = HarfBuzz.HB_TAG(84, 97, 110, 103);
        HB_SCRIPT_NEWA = HarfBuzz.HB_TAG(78, 101, 119, 97);
        HB_SCRIPT_MASARAM_GONDI = HarfBuzz.HB_TAG(71, 111, 110, 109);
        HB_SCRIPT_NUSHU = HarfBuzz.HB_TAG(78, 115, 104, 117);
        HB_SCRIPT_SOYOMBO = HarfBuzz.HB_TAG(83, 111, 121, 111);
        HB_SCRIPT_ZANABAZAR_SQUARE = HarfBuzz.HB_TAG(90, 97, 110, 98);
        HB_SCRIPT_DOGRA = HarfBuzz.HB_TAG(68, 111, 103, 114);
        HB_SCRIPT_GUNJALA_GONDI = HarfBuzz.HB_TAG(71, 111, 110, 103);
        HB_SCRIPT_HANIFI_ROHINGYA = HarfBuzz.HB_TAG(82, 111, 104, 103);
        HB_SCRIPT_MAKASAR = HarfBuzz.HB_TAG(77, 97, 107, 97);
        HB_SCRIPT_MEDEFAIDRIN = HarfBuzz.HB_TAG(77, 101, 100, 102);
        HB_SCRIPT_OLD_SOGDIAN = HarfBuzz.HB_TAG(83, 111, 103, 111);
        HB_SCRIPT_SOGDIAN = HarfBuzz.HB_TAG(83, 111, 103, 100);
        HB_SCRIPT_ELYMAIC = HarfBuzz.HB_TAG(69, 108, 121, 109);
        HB_SCRIPT_NANDINAGARI = HarfBuzz.HB_TAG(78, 97, 110, 100);
        HB_SCRIPT_NYIAKENG_PUACHUE_HMONG = HarfBuzz.HB_TAG(72, 109, 110, 112);
        HB_SCRIPT_WANCHO = HarfBuzz.HB_TAG(87, 99, 104, 111);
        HB_SCRIPT_CHORASMIAN = HarfBuzz.HB_TAG(67, 104, 114, 115);
        HB_SCRIPT_DIVES_AKURU = HarfBuzz.HB_TAG(68, 105, 97, 107);
        HB_SCRIPT_KHITAN_SMALL_SCRIPT = HarfBuzz.HB_TAG(75, 105, 116, 115);
        HB_SCRIPT_YEZIDI = HarfBuzz.HB_TAG(89, 101, 122, 105);
        HB_SCRIPT_CYPRO_MINOAN = HarfBuzz.HB_TAG(67, 112, 109, 110);
        HB_SCRIPT_OLD_UYGHUR = HarfBuzz.HB_TAG(79, 117, 103, 114);
        HB_SCRIPT_TANGSA = HarfBuzz.HB_TAG(84, 110, 115, 97);
        HB_SCRIPT_TOTO = HarfBuzz.HB_TAG(84, 111, 116, 111);
        HB_SCRIPT_VITHKUQI = HarfBuzz.HB_TAG(86, 105, 116, 104);
        HB_SCRIPT_MATH = HarfBuzz.HB_TAG(90, 109, 116, 104);
        HB_SCRIPT_KAWI = HarfBuzz.HB_TAG(75, 97, 119, 105);
        HB_SCRIPT_NAG_MUNDARI = HarfBuzz.HB_TAG(78, 97, 103, 109);
        HB_SCRIPT_GARAY = HarfBuzz.HB_TAG(71, 97, 114, 97);
        HB_SCRIPT_GURUNG_KHEMA = HarfBuzz.HB_TAG(71, 117, 107, 104);
        HB_SCRIPT_KIRAT_RAI = HarfBuzz.HB_TAG(75, 114, 97, 105);
        HB_SCRIPT_OL_ONAL = HarfBuzz.HB_TAG(79, 110, 97, 111);
        HB_SCRIPT_SUNUWAR = HarfBuzz.HB_TAG(83, 117, 110, 117);
        HB_SCRIPT_TODHRI = HarfBuzz.HB_TAG(84, 111, 100, 114);
        HB_SCRIPT_TULU_TIGALARI = HarfBuzz.HB_TAG(84, 117, 116, 103);
        HB_SCRIPT_INVALID = HB_TAG_NONE;
        HB_BUFFER_SERIALIZE_FORMAT_TEXT = HarfBuzz.HB_TAG(84, 69, 88, 84);
        HB_BUFFER_SERIALIZE_FORMAT_JSON = HarfBuzz.HB_TAG(74, 83, 79, 78);
        HB_BUFFER_SERIALIZE_FORMAT_INVALID = HB_TAG_NONE;
        HB_PAINT_IMAGE_FORMAT_PNG = HarfBuzz.HB_TAG(112, 110, 103, 32);
        HB_PAINT_IMAGE_FORMAT_SVG = HarfBuzz.HB_TAG(115, 118, 103, 32);
        HB_PAINT_IMAGE_FORMAT_BGRA = HarfBuzz.HB_TAG(66, 71, 82, 65);
        STYLE_TAG_ITALIC = HarfBuzz.HB_TAG(105, 116, 97, 108);
        STYLE_TAG_OPTICAL_SIZE = HarfBuzz.HB_TAG(111, 112, 115, 122);
        STYLE_TAG_SLANT_ANGLE = HarfBuzz.HB_TAG(115, 108, 110, 116);
        STYLE_TAG_SLANT_RATIO = HarfBuzz.HB_TAG(83, 108, 110, 116);
        STYLE_TAG_WIDTH = HarfBuzz.HB_TAG(119, 100, 116, 104);
        STYLE_TAG_WEIGHT = HarfBuzz.HB_TAG(119, 103, 104, 116);
        HB_SEGMENT_PROPERTIES_DEFAULT = hb_segment_properties_t.create().set(0, HB_SCRIPT_INVALID, 0L);
        long formats = HarfBuzz.nhb_buffer_serialize_list_formats();
        int count = 0;
        while (MemoryUtil.memGetAddress(formats) != 0L) {
            ++count;
            formats += (long)MemoryStack.POINTER_SIZE;
        }
        buffer_serialize_list_formats_COUNT = count;
        HB_DRAW_STATE_DEFAULT = hb_draw_state_t.create();
        long shapers = HarfBuzz.nhb_shape_list_shapers();
        count = 0;
        while (MemoryUtil.memGetAddress(shapers) != 0L) {
            ++count;
            shapers += (long)MemoryStack.POINTER_SIZE;
        }
        shape_list_shapers_COUNT = count;
    }

    public static final class Functions {
        public static final long tag_from_string = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_tag_from_string");
        public static final long tag_to_string = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_tag_to_string");
        public static final long direction_from_string = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_direction_from_string");
        public static final long direction_to_string = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_direction_to_string");
        public static final long language_from_string = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_language_from_string");
        public static final long language_to_string = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_language_to_string");
        public static final long language_get_default = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_language_get_default");
        public static final long language_matches = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_language_matches");
        public static final long script_from_iso15924_tag = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_script_from_iso15924_tag");
        public static final long script_from_string = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_script_from_string");
        public static final long script_to_iso15924_tag = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_script_to_iso15924_tag");
        public static final long script_get_horizontal_direction = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_script_get_horizontal_direction");
        public static final long feature_from_string = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_feature_from_string");
        public static final long feature_to_string = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_feature_to_string");
        public static final long variation_from_string = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_variation_from_string");
        public static final long variation_to_string = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_variation_to_string");
        public static final long color_get_alpha = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_color_get_alpha");
        public static final long color_get_red = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_color_get_red");
        public static final long color_get_green = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_color_get_green");
        public static final long color_get_blue = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_color_get_blue");
        public static final long blob_create = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_blob_create");
        public static final long blob_create_or_fail = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_blob_create_or_fail");
        public static final long blob_create_from_file = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_blob_create_from_file");
        public static final long blob_create_from_file_or_fail = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_blob_create_from_file_or_fail");
        public static final long blob_create_sub_blob = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_blob_create_sub_blob");
        public static final long blob_copy_writable_or_fail = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_blob_copy_writable_or_fail");
        public static final long blob_get_empty = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_blob_get_empty");
        public static final long blob_reference = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_blob_reference");
        public static final long blob_destroy = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_blob_destroy");
        public static final long blob_set_user_data = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_blob_set_user_data");
        public static final long blob_get_user_data = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_blob_get_user_data");
        public static final long blob_make_immutable = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_blob_make_immutable");
        public static final long blob_is_immutable = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_blob_is_immutable");
        public static final long blob_get_length = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_blob_get_length");
        public static final long blob_get_data = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_blob_get_data");
        public static final long blob_get_data_writable = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_blob_get_data_writable");
        public static final long segment_properties_equal = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_segment_properties_equal");
        public static final long segment_properties_hash = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_segment_properties_hash");
        public static final long segment_properties_overlay = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_segment_properties_overlay");
        public static final long buffer_create = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_create");
        public static final long buffer_create_similar = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_create_similar");
        public static final long buffer_reset = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_reset");
        public static final long buffer_get_empty = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_get_empty");
        public static final long buffer_reference = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_reference");
        public static final long buffer_destroy = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_destroy");
        public static final long buffer_set_user_data = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_set_user_data");
        public static final long buffer_get_user_data = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_get_user_data");
        public static final long buffer_set_content_type = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_set_content_type");
        public static final long buffer_get_content_type = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_get_content_type");
        public static final long buffer_set_unicode_funcs = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_set_unicode_funcs");
        public static final long buffer_get_unicode_funcs = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_get_unicode_funcs");
        public static final long buffer_set_direction = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_set_direction");
        public static final long buffer_get_direction = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_get_direction");
        public static final long buffer_set_script = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_set_script");
        public static final long buffer_get_script = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_get_script");
        public static final long buffer_set_language = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_set_language");
        public static final long buffer_get_language = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_get_language");
        public static final long buffer_set_segment_properties = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_set_segment_properties");
        public static final long buffer_get_segment_properties = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_get_segment_properties");
        public static final long buffer_guess_segment_properties = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_guess_segment_properties");
        public static final long buffer_set_flags = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_set_flags");
        public static final long buffer_get_flags = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_get_flags");
        public static final long buffer_set_cluster_level = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_set_cluster_level");
        public static final long buffer_get_cluster_level = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_get_cluster_level");
        public static final long buffer_set_replacement_codepoint = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_set_replacement_codepoint");
        public static final long buffer_get_replacement_codepoint = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_get_replacement_codepoint");
        public static final long buffer_set_invisible_glyph = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_set_invisible_glyph");
        public static final long buffer_get_invisible_glyph = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_get_invisible_glyph");
        public static final long buffer_set_not_found_glyph = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_set_not_found_glyph");
        public static final long buffer_get_not_found_glyph = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_get_not_found_glyph");
        public static final long buffer_set_not_found_variation_selector_glyph = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_set_not_found_variation_selector_glyph");
        public static final long buffer_get_not_found_variation_selector_glyph = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_get_not_found_variation_selector_glyph");
        public static final long buffer_set_random_state = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_set_random_state");
        public static final long buffer_get_random_state = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_get_random_state");
        public static final long buffer_clear_contents = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_clear_contents");
        public static final long buffer_pre_allocate = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_pre_allocate");
        public static final long buffer_allocation_successful = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_allocation_successful");
        public static final long buffer_reverse = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_reverse");
        public static final long buffer_reverse_range = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_reverse_range");
        public static final long buffer_reverse_clusters = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_reverse_clusters");
        public static final long buffer_add = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_add");
        public static final long buffer_add_utf8 = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_add_utf8");
        public static final long buffer_add_utf16 = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_add_utf16");
        public static final long buffer_add_utf32 = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_add_utf32");
        public static final long buffer_add_latin1 = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_add_latin1");
        public static final long buffer_add_codepoints = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_add_codepoints");
        public static final long buffer_append = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_append");
        public static final long buffer_set_length = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_set_length");
        public static final long buffer_get_length = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_get_length");
        public static final long buffer_get_glyph_infos = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_get_glyph_infos");
        public static final long buffer_get_glyph_positions = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_get_glyph_positions");
        public static final long buffer_has_positions = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_has_positions");
        public static final long buffer_normalize_glyphs = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_normalize_glyphs");
        public static final long buffer_serialize_format_from_string = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_serialize_format_from_string");
        public static final long buffer_serialize_format_to_string = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_serialize_format_to_string");
        public static final long buffer_serialize_list_formats = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_serialize_list_formats");
        public static final long buffer_serialize_glyphs = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_serialize_glyphs");
        public static final long buffer_serialize_unicode = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_serialize_unicode");
        public static final long buffer_serialize = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_serialize");
        public static final long buffer_deserialize_glyphs = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_deserialize_glyphs");
        public static final long buffer_deserialize_unicode = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_deserialize_unicode");
        public static final long buffer_diff = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_diff");
        public static final long buffer_set_message_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_buffer_set_message_func");
        public static final long draw_funcs_set_move_to_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_draw_funcs_set_move_to_func");
        public static final long draw_funcs_set_line_to_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_draw_funcs_set_line_to_func");
        public static final long draw_funcs_set_quadratic_to_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_draw_funcs_set_quadratic_to_func");
        public static final long draw_funcs_set_cubic_to_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_draw_funcs_set_cubic_to_func");
        public static final long draw_funcs_set_close_path_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_draw_funcs_set_close_path_func");
        public static final long draw_funcs_create = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_draw_funcs_create");
        public static final long draw_funcs_get_empty = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_draw_funcs_get_empty");
        public static final long draw_funcs_reference = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_draw_funcs_reference");
        public static final long draw_funcs_destroy = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_draw_funcs_destroy");
        public static final long draw_funcs_set_user_data = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_draw_funcs_set_user_data");
        public static final long draw_funcs_get_user_data = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_draw_funcs_get_user_data");
        public static final long draw_funcs_make_immutable = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_draw_funcs_make_immutable");
        public static final long draw_funcs_is_immutable = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_draw_funcs_is_immutable");
        public static final long draw_move_to = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_draw_move_to");
        public static final long draw_line_to = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_draw_line_to");
        public static final long draw_quadratic_to = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_draw_quadratic_to");
        public static final long draw_cubic_to = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_draw_cubic_to");
        public static final long draw_close_path = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_draw_close_path");
        public static final long face_count = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_count");
        public static final long face_create = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_create");
        public static final long face_create_or_fail = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_create_or_fail");
        public static final long face_create_from_file_or_fail = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_create_from_file_or_fail");
        public static final long face_create_for_tables = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_create_for_tables");
        public static final long face_get_empty = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_get_empty");
        public static final long face_reference = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_reference");
        public static final long face_destroy = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_destroy");
        public static final long face_set_user_data = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_set_user_data");
        public static final long face_get_user_data = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_get_user_data");
        public static final long face_make_immutable = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_make_immutable");
        public static final long face_is_immutable = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_is_immutable");
        public static final long face_reference_table = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_reference_table");
        public static final long face_reference_blob = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_reference_blob");
        public static final long face_set_index = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_set_index");
        public static final long face_get_index = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_get_index");
        public static final long face_set_upem = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_set_upem");
        public static final long face_get_upem = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_get_upem");
        public static final long face_set_glyph_count = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_set_glyph_count");
        public static final long face_get_glyph_count = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_get_glyph_count");
        public static final long face_set_get_table_tags_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_set_get_table_tags_func");
        public static final long face_get_table_tags = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_get_table_tags");
        public static final long face_collect_unicodes = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_collect_unicodes");
        public static final long face_collect_nominal_glyph_mapping = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_collect_nominal_glyph_mapping");
        public static final long face_collect_variation_selectors = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_collect_variation_selectors");
        public static final long face_collect_variation_unicodes = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_collect_variation_unicodes");
        public static final long face_builder_create = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_builder_create");
        public static final long face_builder_add_table = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_builder_add_table");
        public static final long face_builder_sort_tables = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_face_builder_sort_tables");
        public static final long font_funcs_create = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_funcs_create");
        public static final long font_funcs_get_empty = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_funcs_get_empty");
        public static final long font_funcs_reference = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_funcs_reference");
        public static final long font_funcs_destroy = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_funcs_destroy");
        public static final long font_funcs_set_user_data = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_funcs_set_user_data");
        public static final long font_funcs_get_user_data = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_funcs_get_user_data");
        public static final long font_funcs_make_immutable = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_funcs_make_immutable");
        public static final long font_funcs_is_immutable = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_funcs_is_immutable");
        public static final long font_funcs_set_font_h_extents_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_funcs_set_font_h_extents_func");
        public static final long font_funcs_set_font_v_extents_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_funcs_set_font_v_extents_func");
        public static final long font_funcs_set_nominal_glyph_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_funcs_set_nominal_glyph_func");
        public static final long font_funcs_set_nominal_glyphs_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_funcs_set_nominal_glyphs_func");
        public static final long font_funcs_set_variation_glyph_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_funcs_set_variation_glyph_func");
        public static final long font_funcs_set_glyph_h_advance_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_funcs_set_glyph_h_advance_func");
        public static final long font_funcs_set_glyph_v_advance_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_funcs_set_glyph_v_advance_func");
        public static final long font_funcs_set_glyph_h_advances_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_funcs_set_glyph_h_advances_func");
        public static final long font_funcs_set_glyph_v_advances_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_funcs_set_glyph_v_advances_func");
        public static final long font_funcs_set_glyph_h_origin_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_funcs_set_glyph_h_origin_func");
        public static final long font_funcs_set_glyph_v_origin_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_funcs_set_glyph_v_origin_func");
        public static final long font_funcs_set_glyph_h_kerning_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_funcs_set_glyph_h_kerning_func");
        public static final long font_funcs_set_glyph_extents_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_funcs_set_glyph_extents_func");
        public static final long font_funcs_set_glyph_contour_point_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_funcs_set_glyph_contour_point_func");
        public static final long font_funcs_set_glyph_name_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_funcs_set_glyph_name_func");
        public static final long font_funcs_set_glyph_from_name_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_funcs_set_glyph_from_name_func");
        public static final long font_funcs_set_draw_glyph_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_funcs_set_draw_glyph_func");
        public static final long font_funcs_set_paint_glyph_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_funcs_set_paint_glyph_func");
        public static final long font_get_h_extents = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_h_extents");
        public static final long font_get_v_extents = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_v_extents");
        public static final long font_get_nominal_glyph = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_nominal_glyph");
        public static final long font_get_variation_glyph = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_variation_glyph");
        public static final long font_get_nominal_glyphs = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_nominal_glyphs");
        public static final long font_get_glyph_h_advance = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_glyph_h_advance");
        public static final long font_get_glyph_v_advance = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_glyph_v_advance");
        public static final long font_get_glyph_h_advances = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_glyph_h_advances");
        public static final long font_get_glyph_v_advances = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_glyph_v_advances");
        public static final long font_get_glyph_h_origin = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_glyph_h_origin");
        public static final long font_get_glyph_v_origin = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_glyph_v_origin");
        public static final long font_get_glyph_h_kerning = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_glyph_h_kerning");
        public static final long font_get_glyph_extents = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_glyph_extents");
        public static final long font_get_glyph_contour_point = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_glyph_contour_point");
        public static final long font_get_glyph_name = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_glyph_name");
        public static final long font_get_glyph_from_name = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_glyph_from_name");
        public static final long font_draw_glyph = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_draw_glyph");
        public static final long font_paint_glyph = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_paint_glyph");
        public static final long font_get_glyph = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_glyph");
        public static final long font_get_extents_for_direction = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_extents_for_direction");
        public static final long font_get_glyph_advance_for_direction = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_glyph_advance_for_direction");
        public static final long font_get_glyph_advances_for_direction = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_glyph_advances_for_direction");
        public static final long font_get_glyph_origin_for_direction = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_glyph_origin_for_direction");
        public static final long font_add_glyph_origin_for_direction = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_add_glyph_origin_for_direction");
        public static final long font_subtract_glyph_origin_for_direction = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_subtract_glyph_origin_for_direction");
        public static final long font_get_glyph_kerning_for_direction = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_glyph_kerning_for_direction");
        public static final long font_get_glyph_extents_for_origin = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_glyph_extents_for_origin");
        public static final long font_get_glyph_contour_point_for_origin = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_glyph_contour_point_for_origin");
        public static final long font_glyph_to_string = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_glyph_to_string");
        public static final long font_glyph_from_string = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_glyph_from_string");
        public static final long font_create = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_create");
        public static final long font_create_sub_font = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_create_sub_font");
        public static final long font_get_empty = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_empty");
        public static final long font_reference = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_reference");
        public static final long font_destroy = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_destroy");
        public static final long font_set_user_data = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_set_user_data");
        public static final long font_get_user_data = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_user_data");
        public static final long font_make_immutable = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_make_immutable");
        public static final long font_is_immutable = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_is_immutable");
        public static final long font_get_serial = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_serial");
        public static final long font_changed = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_changed");
        public static final long font_set_parent = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_set_parent");
        public static final long font_get_parent = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_parent");
        public static final long font_set_face = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_set_face");
        public static final long font_get_face = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_face");
        public static final long font_set_funcs = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_set_funcs");
        public static final long font_set_funcs_data = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_set_funcs_data");
        public static final long font_set_scale = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_set_scale");
        public static final long font_get_scale = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_scale");
        public static final long font_set_ppem = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_set_ppem");
        public static final long font_get_ppem = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_ppem");
        public static final long font_set_ptem = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_set_ptem");
        public static final long font_get_ptem = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_ptem");
        public static final long font_set_synthetic_bold = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_set_synthetic_bold");
        public static final long font_get_synthetic_bold = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_synthetic_bold");
        public static final long font_set_synthetic_slant = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_set_synthetic_slant");
        public static final long font_get_synthetic_slant = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_synthetic_slant");
        public static final long font_set_variations = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_set_variations");
        public static final long font_set_variation = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_set_variation");
        public static final long font_set_var_coords_design = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_set_var_coords_design");
        public static final long font_get_var_coords_design = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_var_coords_design");
        public static final long font_set_var_coords_normalized = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_set_var_coords_normalized");
        public static final long font_get_var_coords_normalized = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_var_coords_normalized");
        public static final long font_set_var_named_instance = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_set_var_named_instance");
        public static final long font_get_var_named_instance = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_font_get_var_named_instance");
        public static final long ft_face_create = APIUtil.apiGetFunctionAddressOptional(HarfBuzz.access$000(), "hb_ft_face_create");
        public static final long ft_face_create_cached = APIUtil.apiGetFunctionAddressOptional(HarfBuzz.access$000(), "hb_ft_face_create_cached");
        public static final long ft_face_create_referenced = APIUtil.apiGetFunctionAddressOptional(HarfBuzz.access$000(), "hb_ft_face_create_referenced");
        public static final long ft_face_create_from_file_or_fail = APIUtil.apiGetFunctionAddressOptional(HarfBuzz.access$000(), "hb_ft_face_create_from_file_or_fail");
        public static final long ft_font_create = APIUtil.apiGetFunctionAddressOptional(HarfBuzz.access$000(), "hb_ft_font_create");
        public static final long ft_font_create_referenced = APIUtil.apiGetFunctionAddressOptional(HarfBuzz.access$000(), "hb_ft_font_create_referenced");
        public static final long ft_font_get_face = APIUtil.apiGetFunctionAddressOptional(HarfBuzz.access$000(), "hb_ft_font_get_face");
        public static final long ft_font_lock_face = APIUtil.apiGetFunctionAddressOptional(HarfBuzz.access$000(), "hb_ft_font_lock_face");
        public static final long ft_font_unlock_face = APIUtil.apiGetFunctionAddressOptional(HarfBuzz.access$000(), "hb_ft_font_unlock_face");
        public static final long ft_font_set_load_flags = APIUtil.apiGetFunctionAddressOptional(HarfBuzz.access$000(), "hb_ft_font_set_load_flags");
        public static final long ft_font_get_load_flags = APIUtil.apiGetFunctionAddressOptional(HarfBuzz.access$000(), "hb_ft_font_get_load_flags");
        public static final long ft_font_changed = APIUtil.apiGetFunctionAddressOptional(HarfBuzz.access$000(), "hb_ft_font_changed");
        public static final long ft_hb_font_changed = APIUtil.apiGetFunctionAddressOptional(HarfBuzz.access$000(), "hb_ft_hb_font_changed");
        public static final long ft_font_set_funcs = APIUtil.apiGetFunctionAddressOptional(HarfBuzz.access$000(), "hb_ft_font_set_funcs");
        public static final long map_create = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_map_create");
        public static final long map_get_empty = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_map_get_empty");
        public static final long map_reference = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_map_reference");
        public static final long map_destroy = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_map_destroy");
        public static final long map_set_user_data = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_map_set_user_data");
        public static final long map_get_user_data = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_map_get_user_data");
        public static final long map_allocation_successful = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_map_allocation_successful");
        public static final long map_copy = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_map_copy");
        public static final long map_clear = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_map_clear");
        public static final long map_is_empty = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_map_is_empty");
        public static final long map_get_population = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_map_get_population");
        public static final long map_is_equal = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_map_is_equal");
        public static final long map_hash = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_map_hash");
        public static final long map_set = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_map_set");
        public static final long map_get = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_map_get");
        public static final long map_del = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_map_del");
        public static final long map_has = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_map_has");
        public static final long map_update = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_map_update");
        public static final long map_next = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_map_next");
        public static final long map_keys = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_map_keys");
        public static final long map_values = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_map_values");
        public static final long paint_funcs_create = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_funcs_create");
        public static final long paint_funcs_get_empty = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_funcs_get_empty");
        public static final long paint_funcs_reference = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_funcs_reference");
        public static final long paint_funcs_destroy = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_funcs_destroy");
        public static final long paint_funcs_set_user_data = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_funcs_set_user_data");
        public static final long paint_funcs_get_user_data = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_funcs_get_user_data");
        public static final long paint_funcs_make_immutable = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_funcs_make_immutable");
        public static final long paint_funcs_is_immutable = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_funcs_is_immutable");
        public static final long color_line_get_color_stops = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_color_line_get_color_stops");
        public static final long color_line_get_extend = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_color_line_get_extend");
        public static final long paint_funcs_set_push_transform_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_funcs_set_push_transform_func");
        public static final long paint_funcs_set_pop_transform_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_funcs_set_pop_transform_func");
        public static final long paint_funcs_set_color_glyph_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_funcs_set_color_glyph_func");
        public static final long paint_funcs_set_push_clip_glyph_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_funcs_set_push_clip_glyph_func");
        public static final long paint_funcs_set_push_clip_rectangle_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_funcs_set_push_clip_rectangle_func");
        public static final long paint_funcs_set_pop_clip_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_funcs_set_pop_clip_func");
        public static final long paint_funcs_set_color_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_funcs_set_color_func");
        public static final long paint_funcs_set_image_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_funcs_set_image_func");
        public static final long paint_funcs_set_linear_gradient_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_funcs_set_linear_gradient_func");
        public static final long paint_funcs_set_radial_gradient_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_funcs_set_radial_gradient_func");
        public static final long paint_funcs_set_sweep_gradient_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_funcs_set_sweep_gradient_func");
        public static final long paint_funcs_set_push_group_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_funcs_set_push_group_func");
        public static final long paint_funcs_set_pop_group_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_funcs_set_pop_group_func");
        public static final long paint_funcs_set_custom_palette_color_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_funcs_set_custom_palette_color_func");
        public static final long paint_push_transform = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_push_transform");
        public static final long paint_pop_transform = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_pop_transform");
        public static final long paint_color_glyph = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_color_glyph");
        public static final long paint_push_clip_glyph = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_push_clip_glyph");
        public static final long paint_push_clip_rectangle = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_push_clip_rectangle");
        public static final long paint_pop_clip = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_pop_clip");
        public static final long paint_color = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_color");
        public static final long paint_image = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_image");
        public static final long paint_linear_gradient = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_linear_gradient");
        public static final long paint_radial_gradient = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_radial_gradient");
        public static final long paint_sweep_gradient = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_sweep_gradient");
        public static final long paint_push_group = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_push_group");
        public static final long paint_pop_group = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_pop_group");
        public static final long paint_custom_palette_color = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_paint_custom_palette_color");
        public static final long set_create = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_create");
        public static final long set_get_empty = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_get_empty");
        public static final long set_reference = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_reference");
        public static final long set_destroy = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_destroy");
        public static final long set_set_user_data = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_set_user_data");
        public static final long set_get_user_data = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_get_user_data");
        public static final long set_allocation_successful = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_allocation_successful");
        public static final long set_copy = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_copy");
        public static final long set_clear = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_clear");
        public static final long set_is_empty = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_is_empty");
        public static final long set_invert = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_invert");
        public static final long set_is_inverted = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_is_inverted");
        public static final long set_has = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_has");
        public static final long set_add = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_add");
        public static final long set_add_range = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_add_range");
        public static final long set_add_sorted_array = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_add_sorted_array");
        public static final long set_del = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_del");
        public static final long set_del_range = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_del_range");
        public static final long set_is_equal = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_is_equal");
        public static final long set_hash = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_hash");
        public static final long set_is_subset = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_is_subset");
        public static final long set_set = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_set");
        public static final long set_union = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_union");
        public static final long set_intersect = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_intersect");
        public static final long set_subtract = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_subtract");
        public static final long set_symmetric_difference = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_symmetric_difference");
        public static final long set_get_population = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_get_population");
        public static final long set_get_min = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_get_min");
        public static final long set_get_max = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_get_max");
        public static final long set_next = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_next");
        public static final long set_previous = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_previous");
        public static final long set_next_range = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_next_range");
        public static final long set_previous_range = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_previous_range");
        public static final long set_next_many = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_set_next_many");
        public static final long shape = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_shape");
        public static final long shape_full = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_shape_full");
        public static final long shape_justify = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_shape_justify");
        public static final long shape_list_shapers = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_shape_list_shapers");
        public static final long shape_plan_create = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_shape_plan_create");
        public static final long shape_plan_create_cached = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_shape_plan_create_cached");
        public static final long shape_plan_create2 = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_shape_plan_create2");
        public static final long shape_plan_create_cached2 = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_shape_plan_create_cached2");
        public static final long shape_plan_get_empty = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_shape_plan_get_empty");
        public static final long shape_plan_reference = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_shape_plan_reference");
        public static final long shape_plan_destroy = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_shape_plan_destroy");
        public static final long shape_plan_set_user_data = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_shape_plan_set_user_data");
        public static final long shape_plan_get_user_data = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_shape_plan_get_user_data");
        public static final long shape_plan_execute = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_shape_plan_execute");
        public static final long shape_plan_get_shaper = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_shape_plan_get_shaper");
        public static final long style_get_value = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_style_get_value");
        public static final long unicode_funcs_get_default = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_unicode_funcs_get_default");
        public static final long unicode_funcs_create = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_unicode_funcs_create");
        public static final long unicode_funcs_get_empty = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_unicode_funcs_get_empty");
        public static final long unicode_funcs_reference = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_unicode_funcs_reference");
        public static final long unicode_funcs_destroy = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_unicode_funcs_destroy");
        public static final long unicode_funcs_set_user_data = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_unicode_funcs_set_user_data");
        public static final long unicode_funcs_get_user_data = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_unicode_funcs_get_user_data");
        public static final long unicode_funcs_make_immutable = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_unicode_funcs_make_immutable");
        public static final long unicode_funcs_is_immutable = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_unicode_funcs_is_immutable");
        public static final long unicode_funcs_get_parent = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_unicode_funcs_get_parent");
        public static final long unicode_funcs_set_combining_class_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_unicode_funcs_set_combining_class_func");
        public static final long unicode_funcs_set_general_category_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_unicode_funcs_set_general_category_func");
        public static final long unicode_funcs_set_mirroring_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_unicode_funcs_set_mirroring_func");
        public static final long unicode_funcs_set_script_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_unicode_funcs_set_script_func");
        public static final long unicode_funcs_set_compose_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_unicode_funcs_set_compose_func");
        public static final long unicode_funcs_set_decompose_func = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_unicode_funcs_set_decompose_func");
        public static final long unicode_combining_class = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_unicode_combining_class");
        public static final long unicode_general_category = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_unicode_general_category");
        public static final long unicode_mirroring = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_unicode_mirroring");
        public static final long unicode_script = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_unicode_script");
        public static final long unicode_compose = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_unicode_compose");
        public static final long unicode_decompose = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_unicode_decompose");
        public static final long version = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_version");
        public static final long version_string = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_version_string");
        public static final long version_atleast = APIUtil.apiGetFunctionAddress(HarfBuzz.access$000(), "hb_version_atleast");

        private Functions() {
        }
    }
}

