/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.harfbuzz;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class hb_feature_t
extends Struct<hb_feature_t>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TAG;
    public static final int VALUE;
    public static final int START;
    public static final int END;

    protected hb_feature_t(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected hb_feature_t create(long address, @Nullable ByteBuffer container) {
        return new hb_feature_t(address, container);
    }

    public hb_feature_t(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), hb_feature_t.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="hb_tag_t")
    public int tag() {
        return hb_feature_t.ntag(this.address());
    }

    @NativeType(value="uint32_t")
    public int value() {
        return hb_feature_t.nvalue(this.address());
    }

    @NativeType(value="unsigned int")
    public int start() {
        return hb_feature_t.nstart(this.address());
    }

    @NativeType(value="unsigned int")
    public int end() {
        return hb_feature_t.nend(this.address());
    }

    public hb_feature_t tag(@NativeType(value="hb_tag_t") int value) {
        hb_feature_t.ntag(this.address(), value);
        return this;
    }

    public hb_feature_t value(@NativeType(value="uint32_t") int value) {
        hb_feature_t.nvalue(this.address(), value);
        return this;
    }

    public hb_feature_t start(@NativeType(value="unsigned int") int value) {
        hb_feature_t.nstart(this.address(), value);
        return this;
    }

    public hb_feature_t end(@NativeType(value="unsigned int") int value) {
        hb_feature_t.nend(this.address(), value);
        return this;
    }

    public hb_feature_t set(int tag, int value, int start, int end) {
        this.tag(tag);
        this.value(value);
        this.start(start);
        this.end(end);
        return this;
    }

    public hb_feature_t set(hb_feature_t src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static hb_feature_t malloc() {
        return new hb_feature_t(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static hb_feature_t calloc() {
        return new hb_feature_t(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static hb_feature_t create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new hb_feature_t(MemoryUtil.memAddress(container), container);
    }

    public static hb_feature_t create(long address) {
        return new hb_feature_t(address, null);
    }

    public static @Nullable hb_feature_t createSafe(long address) {
        return address == 0L ? null : new hb_feature_t(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(hb_feature_t.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = hb_feature_t.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static hb_feature_t malloc(MemoryStack stack) {
        return new hb_feature_t(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static hb_feature_t calloc(MemoryStack stack) {
        return new hb_feature_t(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntag(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TAG);
    }

    public static int nvalue(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VALUE);
    }

    public static int nstart(long struct) {
        return MemoryUtil.memGetInt(struct + (long)START);
    }

    public static int nend(long struct) {
        return MemoryUtil.memGetInt(struct + (long)END);
    }

    public static void ntag(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TAG, value);
    }

    public static void nvalue(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VALUE, value);
    }

    public static void nstart(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)START, value);
    }

    public static void nend(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)END, value);
    }

    static {
        Struct.Layout layout = hb_feature_t.__struct(hb_feature_t.__member(4), hb_feature_t.__member(4), hb_feature_t.__member(4), hb_feature_t.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TAG = layout.offsetof(0);
        VALUE = layout.offsetof(1);
        START = layout.offsetof(2);
        END = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<hb_feature_t, Buffer>
    implements NativeResource {
        private static final hb_feature_t ELEMENT_FACTORY = hb_feature_t.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected hb_feature_t getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="hb_tag_t")
        public int tag() {
            return hb_feature_t.ntag(this.address());
        }

        @NativeType(value="uint32_t")
        public int value() {
            return hb_feature_t.nvalue(this.address());
        }

        @NativeType(value="unsigned int")
        public int start() {
            return hb_feature_t.nstart(this.address());
        }

        @NativeType(value="unsigned int")
        public int end() {
            return hb_feature_t.nend(this.address());
        }

        public Buffer tag(@NativeType(value="hb_tag_t") int value) {
            hb_feature_t.ntag(this.address(), value);
            return this;
        }

        public Buffer value(@NativeType(value="uint32_t") int value) {
            hb_feature_t.nvalue(this.address(), value);
            return this;
        }

        public Buffer start(@NativeType(value="unsigned int") int value) {
            hb_feature_t.nstart(this.address(), value);
            return this;
        }

        public Buffer end(@NativeType(value="unsigned int") int value) {
            hb_feature_t.nend(this.address(), value);
            return this;
        }
    }
}

