/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.hwloc;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.hwloc.hwloc_location_u;

@NativeType(value="struct hwloc_location")
public class hwloc_location
extends Struct<hwloc_location>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int LOCATION;

    protected hwloc_location(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected hwloc_location create(long address, @Nullable ByteBuffer container) {
        return new hwloc_location(address, container);
    }

    public hwloc_location(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), hwloc_location.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="enum hwloc_location_type_e")
    public int type() {
        return hwloc_location.ntype(this.address());
    }

    public hwloc_location_u location() {
        return hwloc_location.nlocation(this.address());
    }

    public static hwloc_location malloc() {
        return new hwloc_location(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static hwloc_location calloc() {
        return new hwloc_location(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static hwloc_location create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new hwloc_location(MemoryUtil.memAddress(container), container);
    }

    public static hwloc_location create(long address) {
        return new hwloc_location(address, null);
    }

    public static @Nullable hwloc_location createSafe(long address) {
        return address == 0L ? null : new hwloc_location(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(hwloc_location.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = hwloc_location.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static hwloc_location malloc(MemoryStack stack) {
        return new hwloc_location(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static hwloc_location calloc(MemoryStack stack) {
        return new hwloc_location(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static hwloc_location_u nlocation(long struct) {
        return hwloc_location_u.create(struct + (long)LOCATION);
    }

    static {
        Struct.Layout layout = hwloc_location.__struct(hwloc_location.__member(4), hwloc_location.__member(hwloc_location_u.SIZEOF, hwloc_location_u.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        LOCATION = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<hwloc_location, Buffer>
    implements NativeResource {
        private static final hwloc_location ELEMENT_FACTORY = hwloc_location.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected hwloc_location getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="enum hwloc_location_type_e")
        public int type() {
            return hwloc_location.ntype(this.address());
        }

        public hwloc_location_u location() {
            return hwloc_location.nlocation(this.address());
        }
    }
}

