/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.ktx;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.util.ktx.PFNKTXITERCBI;
import org.lwjgl.util.ktx.ktxAstcParams;
import org.lwjgl.util.ktx.ktxBasisParams;
import org.lwjgl.util.ktx.ktxStream;
import org.lwjgl.util.ktx.ktxTexture;
import org.lwjgl.util.ktx.ktxTexture1;
import org.lwjgl.util.ktx.ktxTexture2;
import org.lwjgl.util.ktx.ktxTextureCreateInfo;

public class KTX {
    private static final SharedLibrary KTX = Library.loadNative(KTX.class, "org.lwjgl.ktx", Configuration.KTX_LIBRARY_NAME.get(Platform.mapLibraryNameBundled("ktx")), true);
    public static final String KTX_ANIMDATA_KEY = "KTXanimData";
    public static final String KTX_ORIENTATION_KEY = "KTXorientation";
    public static final String KTX_SWIZZLE_KEY = "KTXswizzle";
    public static final String KTX_WRITER_KEY = "KTXwriter";
    public static final String KTX_WRITER_SCPARAMS_KEY = "KTXwriterScParams";
    public static final String KTX_ORIENTATION1_FMT = "S=%c";
    public static final String KTX_ORIENTATION2_FMT = "S=%c,T=%c";
    public static final String KTX_ORIENTATION3_FMT = "S=%c,T=%c,R=%c";
    public static final int KTX_GL_UNPACK_ALIGNMENT = 4;
    public static final int KTX_FACESLICE_WHOLE_LEVEL = -1;
    public static final int KTX_TRUE = 1;
    public static final int KTX_FALSE = 0;
    public static final int KTX_ENDIAN_REF = 67305985;
    public static final int KTX_ENDIAN_REF_REV = 16909060;
    public static final int KTX_HEADER_SIZE = 64;
    public static final int KTX_SUCCESS = 0;
    public static final int KTX_FILE_DATA_ERROR = 1;
    public static final int KTX_FILE_ISPIPE = 2;
    public static final int KTX_FILE_OPEN_FAILED = 3;
    public static final int KTX_FILE_OVERFLOW = 4;
    public static final int KTX_FILE_READ_ERROR = 5;
    public static final int KTX_FILE_SEEK_ERROR = 6;
    public static final int KTX_FILE_UNEXPECTED_EOF = 7;
    public static final int KTX_FILE_WRITE_ERROR = 8;
    public static final int KTX_GL_ERROR = 9;
    public static final int KTX_INVALID_OPERATION = 10;
    public static final int KTX_INVALID_VALUE = 11;
    public static final int KTX_NOT_FOUND = 12;
    public static final int KTX_OUT_OF_MEMORY = 13;
    public static final int KTX_TRANSCODE_FAILED = 14;
    public static final int KTX_UNKNOWN_FILE_FORMAT = 15;
    public static final int KTX_UNSUPPORTED_TEXTURE_TYPE = 16;
    public static final int KTX_UNSUPPORTED_FEATURE = 17;
    public static final int KTX_LIBRARY_NOT_LINKED = 18;
    public static final int KTX_DECOMPRESS_LENGTH_ERROR = 19;
    public static final int KTX_DECOMPRESS_CHECKSUM_ERROR = 20;
    public static final int KTX_ORIENT_X_LEFT = 108;
    public static final int KTX_ORIENT_X_RIGHT = 114;
    public static final int KTX_ORIENT_Y_UP = 117;
    public static final int KTX_ORIENT_Y_DOWN = 100;
    public static final int KTX_ORIENT_Z_IN = 105;
    public static final int KTX_ORIENT_Z_OUT = 111;
    public static final int ktxTexture1_c = 1;
    public static final int ktxTexture2_c = 2;
    public static final int KTX_SS_NONE = 0;
    public static final int KTX_SS_BASIS_LZ = 1;
    public static final int KTX_SS_ZSTD = 2;
    public static final int KTX_SS_ZLIB = 3;
    public static final int KTX_SS_BEGIN_RANGE = 0;
    public static final int KTX_SS_END_RANGE = 3;
    public static final int KTX_SS_BEGIN_VENDOR_RANGE = 65536;
    public static final int KTX_SS_END_VENDOR_RANGE = 131071;
    public static final int KTX_SS_BEGIN_RESERVED = 131072;
    public static final int KTX_TEXTURE_CREATE_NO_STORAGE = 0;
    public static final int KTX_TEXTURE_CREATE_ALLOC_STORAGE = 1;
    public static final int KTX_TEXTURE_CREATE_NO_FLAGS = 0;
    public static final int KTX_TEXTURE_CREATE_LOAD_IMAGE_DATA_BIT = 1;
    public static final int KTX_TEXTURE_CREATE_RAW_KVDATA_BIT = 2;
    public static final int KTX_TEXTURE_CREATE_SKIP_KVDATA_BIT = 4;
    public static final int KTX_TEXTURE_CREATE_CHECK_GLTF_BASISU_BIT = 8;
    public static final int eStreamTypeFile = 1;
    public static final int eStreamTypeMemory = 2;
    public static final int eStreamTypeCustom = 3;
    public static final int KTX_PACK_UASTC_LEVEL_FASTEST = 0;
    public static final int KTX_PACK_UASTC_LEVEL_FASTER = 1;
    public static final int KTX_PACK_UASTC_LEVEL_DEFAULT = 2;
    public static final int KTX_PACK_UASTC_LEVEL_SLOWER = 3;
    public static final int KTX_PACK_UASTC_LEVEL_VERYSLOW = 4;
    public static final int KTX_PACK_UASTC_MAX_LEVEL = 4;
    public static final int KTX_PACK_UASTC_LEVEL_MASK = 15;
    public static final int KTX_PACK_UASTC_FAVOR_UASTC_ERROR = 8;
    public static final int KTX_PACK_UASTC_FAVOR_BC7_ERROR = 16;
    public static final int KTX_PACK_UASTC_ETC1_FASTER_HINTS = 64;
    public static final int KTX_PACK_UASTC_ETC1_FASTEST_HINTS = 128;
    public static final int KTX_PACK_UASTC__ETC1_DISABLE_FLIP_AND_INDIVIDUAL = 256;
    public static final int KTX_PACK_ASTC_QUALITY_LEVEL_FASTEST = 0;
    public static final int KTX_PACK_ASTC_QUALITY_LEVEL_FAST = 10;
    public static final int KTX_PACK_ASTC_QUALITY_LEVEL_MEDIUM = 60;
    public static final int KTX_PACK_ASTC_QUALITY_LEVEL_THOROUGH = 98;
    public static final int KTX_PACK_ASTC_QUALITY_LEVEL_EXHAUSTIVE = 100;
    public static final int KTX_PACK_ASTC_QUALITY_LEVEL_MAX = 100;
    public static final int KTX_PACK_ASTC_BLOCK_DIMENSION_4x4 = 0;
    public static final int KTX_PACK_ASTC_BLOCK_DIMENSION_5x4 = 1;
    public static final int KTX_PACK_ASTC_BLOCK_DIMENSION_5x5 = 2;
    public static final int KTX_PACK_ASTC_BLOCK_DIMENSION_6x5 = 3;
    public static final int KTX_PACK_ASTC_BLOCK_DIMENSION_6x6 = 4;
    public static final int KTX_PACK_ASTC_BLOCK_DIMENSION_8x5 = 5;
    public static final int KTX_PACK_ASTC_BLOCK_DIMENSION_8x6 = 6;
    public static final int KTX_PACK_ASTC_BLOCK_DIMENSION_10x5 = 7;
    public static final int KTX_PACK_ASTC_BLOCK_DIMENSION_10x6 = 8;
    public static final int KTX_PACK_ASTC_BLOCK_DIMENSION_8x8 = 9;
    public static final int KTX_PACK_ASTC_BLOCK_DIMENSION_10x8 = 10;
    public static final int KTX_PACK_ASTC_BLOCK_DIMENSION_10x10 = 11;
    public static final int KTX_PACK_ASTC_BLOCK_DIMENSION_12x10 = 12;
    public static final int KTX_PACK_ASTC_BLOCK_DIMENSION_12x12 = 13;
    public static final int KTX_PACK_ASTC_BLOCK_DIMENSION_3x3x3 = 14;
    public static final int KTX_PACK_ASTC_BLOCK_DIMENSION_4x3x3 = 15;
    public static final int KTX_PACK_ASTC_BLOCK_DIMENSION_4x4x3 = 16;
    public static final int KTX_PACK_ASTC_BLOCK_DIMENSION_4x4x4 = 17;
    public static final int KTX_PACK_ASTC_BLOCK_DIMENSION_5x4x4 = 18;
    public static final int KTX_PACK_ASTC_BLOCK_DIMENSION_5x5x4 = 19;
    public static final int KTX_PACK_ASTC_BLOCK_DIMENSION_5x5x5 = 20;
    public static final int KTX_PACK_ASTC_BLOCK_DIMENSION_6x5x5 = 21;
    public static final int KTX_PACK_ASTC_BLOCK_DIMENSION_6x6x5 = 22;
    public static final int KTX_PACK_ASTC_BLOCK_DIMENSION_6x6x6 = 23;
    public static final int KTX_PACK_ASTC_BLOCK_DIMENSION_MAX = 23;
    public static final int KTX_PACK_ASTC_ENCODER_MODE_DEFAULT = 0;
    public static final int KTX_PACK_ASTC_ENCODER_MODE_LDR = 1;
    public static final int KTX_PACK_ASTC_ENCODER_MODE_HDR = 2;
    public static final int KTX_PACK_ASTC_ENCODER_MODE_MAX = 2;
    public static final int KTX_TTF_ETC1_RGB = 0;
    public static final int KTX_TTF_ETC2_RGBA = 1;
    public static final int KTX_TTF_BC1_RGB = 2;
    public static final int KTX_TTF_BC3_RGBA = 3;
    public static final int KTX_TTF_BC4_R = 4;
    public static final int KTX_TTF_BC5_RG = 5;
    public static final int KTX_TTF_BC7_RGBA = 6;
    public static final int KTX_TTF_PVRTC1_4_RGB = 8;
    public static final int KTX_TTF_PVRTC1_4_RGBA = 9;
    public static final int KTX_TTF_ASTC_4x4_RGBA = 10;
    public static final int KTX_TTF_PVRTC2_4_RGB = 18;
    public static final int KTX_TTF_PVRTC2_4_RGBA = 19;
    public static final int KTX_TTF_ETC2_EAC_R11 = 20;
    public static final int KTX_TTF_ETC2_EAC_RG11 = 21;
    public static final int KTX_TTF_RGBA32 = 13;
    public static final int KTX_TTF_RGB565 = 14;
    public static final int KTX_TTF_BGR565 = 15;
    public static final int KTX_TTF_RGBA4444 = 16;
    public static final int KTX_TTF_ETC = 22;
    public static final int KTX_TTF_BC1_OR_3 = 23;
    public static final int KTX_TTF_NOSELECTION = Integer.MAX_VALUE;
    public static final int KTX_TF_PVRTC_DECODE_TO_NEXT_POW2 = 2;
    public static final int KTX_TF_TRANSCODE_ALPHA_DATA_TO_OPAQUE_FORMATS = 4;
    public static final int KTX_TF_HIGH_QUALITY = 32;
    public static final byte[] KTX_IDENTIFIER_REF = new byte[]{-85, 75, 84, 88, 32, 49, 49, -69, 13, 10, 26, 10};
    public static final int KTX_ETC1S_DEFAULT_COMPRESSION_LEVEL;

    public static SharedLibrary getLibrary() {
        return KTX;
    }

    protected KTX() {
        throw new UnsupportedOperationException();
    }

    public static int nktxTexture_CreateFromNamedFile(long filename, int createFlags, long newTex) {
        long __functionAddress = Functions.Texture_CreateFromNamedFile;
        return JNI.callPPI(filename, createFlags, newTex, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture_CreateFromNamedFile(@NativeType(value="char const * const") ByteBuffer filename, @NativeType(value="ktxTextureCreateFlags") int createFlags, @NativeType(value="ktxTexture **") PointerBuffer newTex) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.check(newTex, 1);
        }
        return org.lwjgl.util.ktx.KTX.nktxTexture_CreateFromNamedFile(MemoryUtil.memAddress(filename), createFlags, MemoryUtil.memAddress(newTex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="KTX_error_code")
    public static int ktxTexture_CreateFromNamedFile(@NativeType(value="char const * const") CharSequence filename, @NativeType(value="ktxTextureCreateFlags") int createFlags, @NativeType(value="ktxTexture **") PointerBuffer newTex) {
        if (Checks.CHECKS) {
            Checks.check(newTex, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(filename, true);
            long filenameEncoded = stack.getPointerAddress();
            int n = org.lwjgl.util.ktx.KTX.nktxTexture_CreateFromNamedFile(filenameEncoded, createFlags, MemoryUtil.memAddress(newTex));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nktxTexture_CreateFromMemory(long bytes, long size, int createFlags, long newTex) {
        long __functionAddress = Functions.Texture_CreateFromMemory;
        return JNI.callPPPI(bytes, size, createFlags, newTex, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture_CreateFromMemory(@NativeType(value="ktx_uint8_t const *") ByteBuffer bytes, @NativeType(value="ktxTextureCreateFlags") int createFlags, @NativeType(value="ktxTexture **") PointerBuffer newTex) {
        if (Checks.CHECKS) {
            Checks.check(newTex, 1);
        }
        return org.lwjgl.util.ktx.KTX.nktxTexture_CreateFromMemory(MemoryUtil.memAddress(bytes), bytes.remaining(), createFlags, MemoryUtil.memAddress(newTex));
    }

    public static int nktxTexture_CreateFromStream(long stream, int createFlags, long newTex) {
        long __functionAddress = Functions.Texture_CreateFromStream;
        return JNI.callPPI(stream, createFlags, newTex, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture_CreateFromStream(@NativeType(value="struct ktxStream *") ktxStream stream, @NativeType(value="ktxTextureCreateFlags") int createFlags, @NativeType(value="ktxTexture **") PointerBuffer newTex) {
        if (Checks.CHECKS) {
            Checks.check(newTex, 1);
        }
        return org.lwjgl.util.ktx.KTX.nktxTexture_CreateFromStream(stream.address(), createFlags, MemoryUtil.memAddress(newTex));
    }

    public static long nktxTexture_GetData(long This) {
        long __functionAddress = Functions.Texture_GetData;
        return JNI.callPP(This, __functionAddress);
    }

    @NativeType(value="ktx_uint8_t *")
    public static @Nullable ByteBuffer ktxTexture_GetData(@NativeType(value="ktxTexture *") ktxTexture This) {
        long __result = org.lwjgl.util.ktx.KTX.nktxTexture_GetData(This.address());
        return MemoryUtil.memByteBufferSafe(__result, (int)org.lwjgl.util.ktx.KTX.ktxTexture_GetDataSize(This));
    }

    @NativeType(value="ktx_uint8_t *")
    public static @Nullable ByteBuffer ktxTexture_GetData(@NativeType(value="ktxTexture *") ktxTexture This, long length) {
        long __result = org.lwjgl.util.ktx.KTX.nktxTexture_GetData(This.address());
        return MemoryUtil.memByteBufferSafe(__result, (int)length);
    }

    public static int nktxTexture_GetRowPitch(long This, int level) {
        long __functionAddress = Functions.Texture_GetRowPitch;
        return JNI.callPI(This, level, __functionAddress);
    }

    @NativeType(value="ktx_uint32_t")
    public static int ktxTexture_GetRowPitch(@NativeType(value="ktxTexture *") ktxTexture This, @NativeType(value="ktx_uint32_t") int level) {
        return org.lwjgl.util.ktx.KTX.nktxTexture_GetRowPitch(This.address(), level);
    }

    public static int nktxTexture_GetElementSize(long This) {
        long __functionAddress = Functions.Texture_GetElementSize;
        return JNI.callPI(This, __functionAddress);
    }

    @NativeType(value="ktx_uint32_t")
    public static int ktxTexture_GetElementSize(@NativeType(value="ktxTexture *") ktxTexture This) {
        return org.lwjgl.util.ktx.KTX.nktxTexture_GetElementSize(This.address());
    }

    public static long nktxTexture_GetDataSize(long This) {
        long __functionAddress = Functions.Texture_GetDataSize;
        return JNI.callPP(This, __functionAddress);
    }

    @NativeType(value="ktx_size_t")
    public static long ktxTexture_GetDataSize(@NativeType(value="ktxTexture *") ktxTexture This) {
        return org.lwjgl.util.ktx.KTX.nktxTexture_GetDataSize(This.address());
    }

    public static int nktxTexture_GLUpload(long This, long pTexture, long pTarget, long pGlerror) {
        long __functionAddress = Functions.Texture_GLUpload;
        return JNI.callPPPPI(This, pTexture, pTarget, pGlerror, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture_GLUpload(@NativeType(value="ktxTexture *") ktxTexture This, @NativeType(value="GLuint *") IntBuffer pTexture, @NativeType(value="GLenum *") IntBuffer pTarget, @NativeType(value="GLenum *") IntBuffer pGlerror) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pTexture, 1);
            Checks.check((Buffer)pTarget, 1);
            Checks.check((Buffer)pGlerror, 1);
        }
        return org.lwjgl.util.ktx.KTX.nktxTexture_GLUpload(This.address(), MemoryUtil.memAddress(pTexture), MemoryUtil.memAddress(pTarget), MemoryUtil.memAddress(pGlerror));
    }

    public static int nktxTexture_IterateLevelFaces(long This, long iterCb, long userdata) {
        long __functionAddress = Functions.Texture_IterateLevelFaces;
        return JNI.callPPPI(This, iterCb, userdata, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture_IterateLevelFaces(@NativeType(value="ktxTexture *") ktxTexture This, @NativeType(value="PFNKTXITERCB") PFNKTXITERCBI iterCb, @NativeType(value="void *") long userdata) {
        return org.lwjgl.util.ktx.KTX.nktxTexture_IterateLevelFaces(This.address(), iterCb.address(), userdata);
    }

    public static int nktxTexture1_Create(long createInfo, int storageAllocation, long newTex) {
        long __functionAddress = Functions.Texture1_Create;
        return JNI.callPPI(createInfo, storageAllocation, newTex, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture1_Create(@NativeType(value="ktxTextureCreateInfo *") ktxTextureCreateInfo createInfo, @NativeType(value="ktxTextureCreateStorageEnum") int storageAllocation, @NativeType(value="ktxTexture1 **") PointerBuffer newTex) {
        if (Checks.CHECKS) {
            Checks.check(newTex, 1);
        }
        return org.lwjgl.util.ktx.KTX.nktxTexture1_Create(createInfo.address(), storageAllocation, MemoryUtil.memAddress(newTex));
    }

    public static int nktxTexture1_CreateFromNamedFile(long filename, int createFlags, long newTex) {
        long __functionAddress = Functions.Texture1_CreateFromNamedFile;
        return JNI.callPPI(filename, createFlags, newTex, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture1_CreateFromNamedFile(@NativeType(value="char const * const") ByteBuffer filename, @NativeType(value="ktxTextureCreateFlags") int createFlags, @NativeType(value="ktxTexture1 **") PointerBuffer newTex) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.check(newTex, 1);
        }
        return org.lwjgl.util.ktx.KTX.nktxTexture1_CreateFromNamedFile(MemoryUtil.memAddress(filename), createFlags, MemoryUtil.memAddress(newTex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="KTX_error_code")
    public static int ktxTexture1_CreateFromNamedFile(@NativeType(value="char const * const") CharSequence filename, @NativeType(value="ktxTextureCreateFlags") int createFlags, @NativeType(value="ktxTexture1 **") PointerBuffer newTex) {
        if (Checks.CHECKS) {
            Checks.check(newTex, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(filename, true);
            long filenameEncoded = stack.getPointerAddress();
            int n = org.lwjgl.util.ktx.KTX.nktxTexture1_CreateFromNamedFile(filenameEncoded, createFlags, MemoryUtil.memAddress(newTex));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nktxTexture1_CreateFromMemory(long bytes, long size, int createFlags, long newTex) {
        long __functionAddress = Functions.Texture1_CreateFromMemory;
        return JNI.callPPPI(bytes, size, createFlags, newTex, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture1_CreateFromMemory(@NativeType(value="ktx_uint8_t const *") ByteBuffer bytes, @NativeType(value="ktxTextureCreateFlags") int createFlags, @NativeType(value="ktxTexture1 **") PointerBuffer newTex) {
        if (Checks.CHECKS) {
            Checks.check(newTex, 1);
        }
        return org.lwjgl.util.ktx.KTX.nktxTexture1_CreateFromMemory(MemoryUtil.memAddress(bytes), bytes.remaining(), createFlags, MemoryUtil.memAddress(newTex));
    }

    public static int nktxTexture1_CreateFromStream(long stream, int createFlags, long newTex) {
        long __functionAddress = Functions.Texture1_CreateFromStream;
        return JNI.callPPI(stream, createFlags, newTex, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture1_CreateFromStream(@NativeType(value="struct ktxStream *") ktxStream stream, @NativeType(value="ktxTextureCreateFlags") int createFlags, @NativeType(value="ktxTexture1 **") PointerBuffer newTex) {
        if (Checks.CHECKS) {
            Checks.check(newTex, 1);
        }
        return org.lwjgl.util.ktx.KTX.nktxTexture1_CreateFromStream(stream.address(), createFlags, MemoryUtil.memAddress(newTex));
    }

    public static boolean nktxTexture1_NeedsTranscoding(long This) {
        long __functionAddress = Functions.Texture1_NeedsTranscoding;
        return JNI.callPZ(This, __functionAddress);
    }

    @NativeType(value="ktx_bool_t")
    public static boolean ktxTexture1_NeedsTranscoding(@NativeType(value="ktxTexture1 *") ktxTexture1 This) {
        return org.lwjgl.util.ktx.KTX.nktxTexture1_NeedsTranscoding(This.address());
    }

    public static int nktxTexture1_WriteKTX2ToNamedFile(long This, long dstname) {
        long __functionAddress = Functions.Texture1_WriteKTX2ToNamedFile;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(This, dstname, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture1_WriteKTX2ToNamedFile(@NativeType(value="ktxTexture1 *") ktxTexture1 This, @NativeType(value="char const * const") ByteBuffer dstname) {
        if (Checks.CHECKS) {
            Checks.checkNT1(dstname);
        }
        return org.lwjgl.util.ktx.KTX.nktxTexture1_WriteKTX2ToNamedFile(This.address(), MemoryUtil.memAddress(dstname));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="KTX_error_code")
    public static int ktxTexture1_WriteKTX2ToNamedFile(@NativeType(value="ktxTexture1 *") ktxTexture1 This, @NativeType(value="char const * const") CharSequence dstname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(dstname, true);
            long dstnameEncoded = stack.getPointerAddress();
            int n = org.lwjgl.util.ktx.KTX.nktxTexture1_WriteKTX2ToNamedFile(This.address(), dstnameEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nktxTexture1_WriteKTX2ToMemory(long This, long bytes, long size) {
        long __functionAddress = Functions.Texture1_WriteKTX2ToMemory;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(This, bytes, size, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture1_WriteKTX2ToMemory(@NativeType(value="ktxTexture1 *") ktxTexture1 This, @NativeType(value="ktx_uint8_t **") PointerBuffer bytes, @NativeType(value="ktx_size_t *") PointerBuffer size) {
        if (Checks.CHECKS) {
            Checks.check(bytes, 1);
            Checks.check(size, 1);
        }
        return org.lwjgl.util.ktx.KTX.nktxTexture1_WriteKTX2ToMemory(This.address(), MemoryUtil.memAddress(bytes), MemoryUtil.memAddress(size));
    }

    public static int nktxTexture1_WriteKTX2ToStream(long This, long dststr) {
        long __functionAddress = Functions.Texture1_WriteKTX2ToStream;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(This, dststr, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture1_WriteKTX2ToStream(@NativeType(value="ktxTexture1 *") ktxTexture1 This, @NativeType(value="struct ktxStream *") ktxStream dststr) {
        return org.lwjgl.util.ktx.KTX.nktxTexture1_WriteKTX2ToStream(This.address(), dststr.address());
    }

    public static int nktxTexture2_Create(long createInfo, int storageAllocation, long newTex) {
        long __functionAddress = Functions.Texture2_Create;
        return JNI.callPPI(createInfo, storageAllocation, newTex, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture2_Create(@NativeType(value="ktxTextureCreateInfo *") ktxTextureCreateInfo createInfo, @NativeType(value="ktxTextureCreateStorageEnum") int storageAllocation, @NativeType(value="ktxTexture2 **") PointerBuffer newTex) {
        if (Checks.CHECKS) {
            Checks.check(newTex, 1);
        }
        return org.lwjgl.util.ktx.KTX.nktxTexture2_Create(createInfo.address(), storageAllocation, MemoryUtil.memAddress(newTex));
    }

    public static int nktxTexture2_CreateCopy(long orig, long newTex) {
        long __functionAddress = Functions.Texture2_CreateCopy;
        return JNI.callPPI(orig, newTex, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture2_CreateCopy(@NativeType(value="ktxTexture2 *") ktxTexture2 orig, @NativeType(value="ktxTexture2 **") PointerBuffer newTex) {
        if (Checks.CHECKS) {
            Checks.check(newTex, 1);
        }
        return org.lwjgl.util.ktx.KTX.nktxTexture2_CreateCopy(orig.address(), MemoryUtil.memAddress(newTex));
    }

    public static int nktxTexture2_CreateFromNamedFile(long filename, int createFlags, long newTex) {
        long __functionAddress = Functions.Texture2_CreateFromNamedFile;
        return JNI.callPPI(filename, createFlags, newTex, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture2_CreateFromNamedFile(@NativeType(value="char const * const") ByteBuffer filename, @NativeType(value="ktxTextureCreateFlags") int createFlags, @NativeType(value="ktxTexture2 **") PointerBuffer newTex) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.check(newTex, 1);
        }
        return org.lwjgl.util.ktx.KTX.nktxTexture2_CreateFromNamedFile(MemoryUtil.memAddress(filename), createFlags, MemoryUtil.memAddress(newTex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="KTX_error_code")
    public static int ktxTexture2_CreateFromNamedFile(@NativeType(value="char const * const") CharSequence filename, @NativeType(value="ktxTextureCreateFlags") int createFlags, @NativeType(value="ktxTexture2 **") PointerBuffer newTex) {
        if (Checks.CHECKS) {
            Checks.check(newTex, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(filename, true);
            long filenameEncoded = stack.getPointerAddress();
            int n = org.lwjgl.util.ktx.KTX.nktxTexture2_CreateFromNamedFile(filenameEncoded, createFlags, MemoryUtil.memAddress(newTex));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nktxTexture2_CreateFromMemory(long bytes, long size, int createFlags, long newTex) {
        long __functionAddress = Functions.Texture2_CreateFromMemory;
        return JNI.callPPPI(bytes, size, createFlags, newTex, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture2_CreateFromMemory(@NativeType(value="ktx_uint8_t const *") ByteBuffer bytes, @NativeType(value="ktxTextureCreateFlags") int createFlags, @NativeType(value="ktxTexture2 **") PointerBuffer newTex) {
        if (Checks.CHECKS) {
            Checks.check(newTex, 1);
        }
        return org.lwjgl.util.ktx.KTX.nktxTexture2_CreateFromMemory(MemoryUtil.memAddress(bytes), bytes.remaining(), createFlags, MemoryUtil.memAddress(newTex));
    }

    public static int nktxTexture2_CreateFromStream(long stream, int createFlags, long newTex) {
        long __functionAddress = Functions.Texture2_CreateFromStream;
        return JNI.callPPI(stream, createFlags, newTex, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture2_CreateFromStream(@NativeType(value="struct ktxStream *") ktxStream stream, @NativeType(value="ktxTextureCreateFlags") int createFlags, @NativeType(value="ktxTexture2 **") PointerBuffer newTex) {
        if (Checks.CHECKS) {
            Checks.check(newTex, 1);
        }
        return org.lwjgl.util.ktx.KTX.nktxTexture2_CreateFromStream(stream.address(), createFlags, MemoryUtil.memAddress(newTex));
    }

    public static int nktxTexture2_CompressBasis(long This, int quality) {
        long __functionAddress = Functions.Texture2_CompressBasis;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(This, quality, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture2_CompressBasis(@NativeType(value="ktxTexture2 *") ktxTexture2 This, @NativeType(value="ktx_uint32_t") int quality) {
        return org.lwjgl.util.ktx.KTX.nktxTexture2_CompressBasis(This.address(), quality);
    }

    public static int nktxTexture2_DeflateZstd(long This, int level) {
        long __functionAddress = Functions.Texture2_DeflateZstd;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(This, level, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture2_DeflateZstd(@NativeType(value="ktxTexture2 *") ktxTexture2 This, @NativeType(value="ktx_uint32_t") int level) {
        return org.lwjgl.util.ktx.KTX.nktxTexture2_DeflateZstd(This.address(), level);
    }

    public static int nktxTexture2_DeflateZLIB(long This, int level) {
        long __functionAddress = Functions.Texture2_DeflateZLIB;
        return JNI.callPI(This, level, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture2_DeflateZLIB(@NativeType(value="ktxTexture2 *") ktxTexture2 This, @NativeType(value="ktx_uint32_t") int level) {
        return org.lwjgl.util.ktx.KTX.nktxTexture2_DeflateZLIB(This.address(), level);
    }

    public static void nktxTexture2_GetComponentInfo(long This, long numComponents, long componentByteLength) {
        long __functionAddress = Functions.Texture2_GetComponentInfo;
        JNI.callPPPV(This, numComponents, componentByteLength, __functionAddress);
    }

    public static void ktxTexture2_GetComponentInfo(@NativeType(value="ktxTexture2 *") ktxTexture2 This, @NativeType(value="ktx_uint32_t *") IntBuffer numComponents, @NativeType(value="ktx_uint32_t *") IntBuffer componentByteLength) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)numComponents, 1);
            Checks.check((Buffer)componentByteLength, 1);
        }
        org.lwjgl.util.ktx.KTX.nktxTexture2_GetComponentInfo(This.address(), MemoryUtil.memAddress(numComponents), MemoryUtil.memAddress(componentByteLength));
    }

    public static int nktxTexture2_GetNumComponents(long This) {
        long __functionAddress = Functions.Texture2_GetNumComponents;
        return JNI.callPI(This, __functionAddress);
    }

    @NativeType(value="ktx_uint32_t")
    public static int ktxTexture2_GetNumComponents(@NativeType(value="ktxTexture2 *") ktxTexture2 This) {
        return org.lwjgl.util.ktx.KTX.nktxTexture2_GetNumComponents(This.address());
    }

    public static int nktxTexture2_GetOETF_e(long This) {
        long __functionAddress = Functions.Texture2_GetOETF_e;
        return JNI.callPI(This, __functionAddress);
    }

    @NativeType(value="khr_df_transfer_e")
    public static int ktxTexture2_GetOETF_e(@NativeType(value="ktxTexture2 *") ktxTexture2 This) {
        return org.lwjgl.util.ktx.KTX.nktxTexture2_GetOETF_e(This.address());
    }

    public static int nktxTexture2_GetOETF(long This) {
        long __functionAddress = Functions.Texture2_GetOETF;
        return JNI.callPI(This, __functionAddress);
    }

    @NativeType(value="ktx_uint32_t")
    public static int ktxTexture2_GetOETF(@NativeType(value="ktxTexture2 *") ktxTexture2 This) {
        return org.lwjgl.util.ktx.KTX.nktxTexture2_GetOETF(This.address());
    }

    public static int nktxTexture2_GetColorModel_e(long This) {
        long __functionAddress = Functions.Texture2_GetColorModel_e;
        return JNI.callPI(This, __functionAddress);
    }

    @NativeType(value="khr_df_model_e")
    public static int ktxTexture2_GetColorModel_e(@NativeType(value="ktxTexture2 *") ktxTexture2 This) {
        return org.lwjgl.util.ktx.KTX.nktxTexture2_GetColorModel_e(This.address());
    }

    public static boolean nktxTexture2_GetPremultipliedAlpha(long This) {
        long __functionAddress = Functions.Texture2_GetPremultipliedAlpha;
        return JNI.callPZ(This, __functionAddress);
    }

    @NativeType(value="ktx_bool_t")
    public static boolean ktxTexture2_GetPremultipliedAlpha(@NativeType(value="ktxTexture2 *") ktxTexture2 This) {
        return org.lwjgl.util.ktx.KTX.nktxTexture2_GetPremultipliedAlpha(This.address());
    }

    public static boolean nktxTexture2_NeedsTranscoding(long This) {
        long __functionAddress = Functions.Texture2_NeedsTranscoding;
        return JNI.callPZ(This, __functionAddress);
    }

    @NativeType(value="ktx_bool_t")
    public static boolean ktxTexture2_NeedsTranscoding(@NativeType(value="ktxTexture2 *") ktxTexture2 This) {
        return org.lwjgl.util.ktx.KTX.nktxTexture2_NeedsTranscoding(This.address());
    }

    public static int nktxTexture2_CompressAstcEx(long This, long params) {
        long __functionAddress = Functions.Texture2_CompressAstcEx;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(This, params, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture2_CompressAstcEx(@NativeType(value="ktxTexture2 *") ktxTexture2 This, @NativeType(value="ktxAstcParams *") ktxAstcParams params) {
        return org.lwjgl.util.ktx.KTX.nktxTexture2_CompressAstcEx(This.address(), params.address());
    }

    public static int nktxTexture2_CompressAstc(long This, int quality) {
        long __functionAddress = Functions.Texture2_CompressAstc;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(This, quality, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture2_CompressAstc(@NativeType(value="ktxTexture2 *") ktxTexture2 This, @NativeType(value="ktx_uint32_t") int quality) {
        return org.lwjgl.util.ktx.KTX.nktxTexture2_CompressAstc(This.address(), quality);
    }

    public static int nktxTexture2_CompressBasisEx(long This, long params) {
        long __functionAddress = Functions.Texture2_CompressBasisEx;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(This, params, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture2_CompressBasisEx(@NativeType(value="ktxTexture2 *") ktxTexture2 This, @NativeType(value="ktxBasisParams *") ktxBasisParams params) {
        return org.lwjgl.util.ktx.KTX.nktxTexture2_CompressBasisEx(This.address(), params.address());
    }

    public static int nktxTexture2_TranscodeBasis(long This, int fmt, int transcodeFlags) {
        long __functionAddress = Functions.Texture2_TranscodeBasis;
        return JNI.callPI(This, fmt, transcodeFlags, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture2_TranscodeBasis(@NativeType(value="ktxTexture2 *") ktxTexture2 This, @NativeType(value="ktx_transcode_fmt_e") int fmt, @NativeType(value="ktx_transcode_flags") int transcodeFlags) {
        return org.lwjgl.util.ktx.KTX.nktxTexture2_TranscodeBasis(This.address(), fmt, transcodeFlags);
    }

    public static long nktxErrorString(int error) {
        long __functionAddress = Functions.ErrorString;
        return JNI.callP(error, __functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String ktxErrorString(@NativeType(value="KTX_error_code") int error) {
        long __result = org.lwjgl.util.ktx.KTX.nktxErrorString(error);
        return MemoryUtil.memASCIISafe(__result);
    }

    public static long nktxSupercompressionSchemeString(int scheme) {
        long __functionAddress = Functions.SupercompressionSchemeString;
        return JNI.callP(scheme, __functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String ktxSupercompressionSchemeString(@NativeType(value="ktxSupercmpScheme") int scheme) {
        long __result = org.lwjgl.util.ktx.KTX.nktxSupercompressionSchemeString(scheme);
        return MemoryUtil.memASCIISafe(__result);
    }

    public static long nktxTranscodeFormatString(int format) {
        long __functionAddress = Functions.TranscodeFormatString;
        return JNI.callP(format, __functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String ktxTranscodeFormatString(@NativeType(value="ktx_transcode_fmt_e") int format) {
        long __result = org.lwjgl.util.ktx.KTX.nktxTranscodeFormatString(format);
        return MemoryUtil.memASCIISafe(__result);
    }

    public static int nktxHashList_Create(long ppHl) {
        long __functionAddress = Functions.HashList_Create;
        return JNI.callPI(ppHl, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxHashList_Create(@NativeType(value="ktxHashList**") PointerBuffer ppHl) {
        if (Checks.CHECKS) {
            Checks.check(ppHl, 1);
        }
        return org.lwjgl.util.ktx.KTX.nktxHashList_Create(MemoryUtil.memAddress(ppHl));
    }

    public static int nktxHashList_CreateCopy(long ppHl, long orig) {
        long __functionAddress = Functions.HashList_CreateCopy;
        if (Checks.CHECKS) {
            Checks.check(orig);
        }
        return JNI.callPPI(ppHl, orig, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxHashList_CreateCopy(@NativeType(value="ktxHashList**") PointerBuffer ppHl, @NativeType(value="ktxHashList") long orig) {
        if (Checks.CHECKS) {
            Checks.check(ppHl, 1);
        }
        return org.lwjgl.util.ktx.KTX.nktxHashList_CreateCopy(MemoryUtil.memAddress(ppHl), orig);
    }

    public static void ktxHashList_Construct(@NativeType(value="ktxHashList*") long pHl) {
        long __functionAddress = Functions.HashList_Construct;
        if (Checks.CHECKS) {
            Checks.check(pHl);
        }
        JNI.callPV(pHl, __functionAddress);
    }

    public static void ktxHashList_ConstructCopy(@NativeType(value="ktxHashList*") long pHl, @NativeType(value="ktxHashList") long orig) {
        long __functionAddress = Functions.HashList_ConstructCopy;
        if (Checks.CHECKS) {
            Checks.check(pHl);
            Checks.check(orig);
        }
        JNI.callPPV(pHl, orig, __functionAddress);
    }

    public static void ktxHashList_Destroy(@NativeType(value="ktxHashList*") long head) {
        long __functionAddress = Functions.HashList_Destroy;
        if (Checks.CHECKS) {
            Checks.check(head);
        }
        JNI.callPV(head, __functionAddress);
    }

    public static void ktxHashList_Destruct(@NativeType(value="ktxHashList*") long head) {
        long __functionAddress = Functions.HashList_Destruct;
        if (Checks.CHECKS) {
            Checks.check(head);
        }
        JNI.callPV(head, __functionAddress);
    }

    public static int nktxHashList_AddKVPair(long pHead, long key, int valueLen, long value) {
        long __functionAddress = Functions.HashList_AddKVPair;
        if (Checks.CHECKS) {
            Checks.check(pHead);
        }
        return JNI.callPPPI(pHead, key, valueLen, value, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxHashList_AddKVPair(@NativeType(value="ktxHashList*") long pHead, @NativeType(value="char const *") ByteBuffer key, @NativeType(value="void const *") ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(key);
        }
        return org.lwjgl.util.ktx.KTX.nktxHashList_AddKVPair(pHead, MemoryUtil.memAddress(key), value.remaining(), MemoryUtil.memAddress(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="KTX_error_code")
    public static int ktxHashList_AddKVPair(@NativeType(value="ktxHashList*") long pHead, @NativeType(value="char const *") CharSequence key, @NativeType(value="void const *") ByteBuffer value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(key, true);
            long keyEncoded = stack.getPointerAddress();
            int n = org.lwjgl.util.ktx.KTX.nktxHashList_AddKVPair(pHead, keyEncoded, value.remaining(), MemoryUtil.memAddress(value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="KTX_error_code")
    public static int ktxHashList_DeleteEntry(@NativeType(value="ktxHashList*") long pHead, @NativeType(value="ktxHashListEntry *") long pEntry) {
        long __functionAddress = Functions.HashList_DeleteEntry;
        if (Checks.CHECKS) {
            Checks.check(pHead);
            Checks.check(pEntry);
        }
        return JNI.callPPI(pHead, pEntry, __functionAddress);
    }

    public static int nktxHashList_DeleteKVPair(long pHead, long key) {
        long __functionAddress = Functions.HashList_DeleteKVPair;
        if (Checks.CHECKS) {
            Checks.check(pHead);
        }
        return JNI.callPPI(pHead, key, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxHashList_DeleteKVPair(@NativeType(value="ktxHashList*") long pHead, @NativeType(value="char const *") ByteBuffer key) {
        if (Checks.CHECKS) {
            Checks.checkNT1(key);
        }
        return org.lwjgl.util.ktx.KTX.nktxHashList_DeleteKVPair(pHead, MemoryUtil.memAddress(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="KTX_error_code")
    public static int ktxHashList_DeleteKVPair(@NativeType(value="ktxHashList*") long pHead, @NativeType(value="char const *") CharSequence key) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(key, true);
            long keyEncoded = stack.getPointerAddress();
            int n = org.lwjgl.util.ktx.KTX.nktxHashList_DeleteKVPair(pHead, keyEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nktxHashList_FindEntry(long pHead, long key, long ppEntry) {
        long __functionAddress = Functions.HashList_FindEntry;
        if (Checks.CHECKS) {
            Checks.check(pHead);
        }
        return JNI.callPPPI(pHead, key, ppEntry, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxHashList_FindEntry(@NativeType(value="ktxHashList*") long pHead, @NativeType(value="char const *") ByteBuffer key, @NativeType(value="ktxHashListEntry **") PointerBuffer ppEntry) {
        if (Checks.CHECKS) {
            Checks.checkNT1(key);
            Checks.check(ppEntry, 1);
        }
        return org.lwjgl.util.ktx.KTX.nktxHashList_FindEntry(pHead, MemoryUtil.memAddress(key), MemoryUtil.memAddress(ppEntry));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="KTX_error_code")
    public static int ktxHashList_FindEntry(@NativeType(value="ktxHashList*") long pHead, @NativeType(value="char const *") CharSequence key, @NativeType(value="ktxHashListEntry **") PointerBuffer ppEntry) {
        if (Checks.CHECKS) {
            Checks.check(ppEntry, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(key, true);
            long keyEncoded = stack.getPointerAddress();
            int n = org.lwjgl.util.ktx.KTX.nktxHashList_FindEntry(pHead, keyEncoded, MemoryUtil.memAddress(ppEntry));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nktxHashList_FindValue(long pHead, long key, long pValueLen, long pValue) {
        long __functionAddress = Functions.HashList_FindValue;
        if (Checks.CHECKS) {
            Checks.check(pHead);
        }
        return JNI.callPPPPI(pHead, key, pValueLen, pValue, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxHashList_FindValue(@NativeType(value="ktxHashList*") long pHead, @NativeType(value="char const *") ByteBuffer key, @NativeType(value="unsigned int *") IntBuffer pValueLen, @NativeType(value="void **") PointerBuffer pValue) {
        if (Checks.CHECKS) {
            Checks.checkNT1(key);
            Checks.check((Buffer)pValueLen, 1);
            Checks.check(pValue, 1);
        }
        return org.lwjgl.util.ktx.KTX.nktxHashList_FindValue(pHead, MemoryUtil.memAddress(key), MemoryUtil.memAddress(pValueLen), MemoryUtil.memAddress(pValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="KTX_error_code")
    public static int ktxHashList_FindValue(@NativeType(value="ktxHashList*") long pHead, @NativeType(value="char const *") CharSequence key, @NativeType(value="unsigned int *") IntBuffer pValueLen, @NativeType(value="void **") PointerBuffer pValue) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pValueLen, 1);
            Checks.check(pValue, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(key, true);
            long keyEncoded = stack.getPointerAddress();
            int n = org.lwjgl.util.ktx.KTX.nktxHashList_FindValue(pHead, keyEncoded, MemoryUtil.memAddress(pValueLen), MemoryUtil.memAddress(pValue));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="ktxHashListEntry *")
    public static long ktxHashList_Next(@NativeType(value="ktxHashListEntry *") long entry) {
        long __functionAddress = Functions.HashList_Next;
        if (Checks.CHECKS) {
            Checks.check(entry);
        }
        return JNI.callPP(entry, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxHashList_Sort(@NativeType(value="ktxHashList*") long pHead) {
        long __functionAddress = Functions.HashList_Sort;
        if (Checks.CHECKS) {
            Checks.check(pHead);
        }
        return JNI.callPI(pHead, __functionAddress);
    }

    public static int nktxHashList_Serialize(long pHead, long kvdLen, long kvd) {
        long __functionAddress = Functions.HashList_Serialize;
        if (Checks.CHECKS) {
            Checks.check(pHead);
        }
        return JNI.callPPPI(pHead, kvdLen, kvd, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxHashList_Serialize(@NativeType(value="ktxHashList*") long pHead, @NativeType(value="unsigned int *") IntBuffer kvdLen, @NativeType(value="unsigned char **") PointerBuffer kvd) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)kvdLen, 1);
            Checks.check(kvd, 1);
        }
        return org.lwjgl.util.ktx.KTX.nktxHashList_Serialize(pHead, MemoryUtil.memAddress(kvdLen), MemoryUtil.memAddress(kvd));
    }

    public static int nktxHashList_Deserialize(long pHead, int kvdLen, long kvd) {
        long __functionAddress = Functions.HashList_Deserialize;
        if (Checks.CHECKS) {
            Checks.check(pHead);
        }
        return JNI.callPPI(pHead, kvdLen, kvd, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxHashList_Deserialize(@NativeType(value="ktxHashList*") long pHead, @NativeType(value="void *") ByteBuffer kvd) {
        return org.lwjgl.util.ktx.KTX.nktxHashList_Deserialize(pHead, kvd.remaining(), MemoryUtil.memAddress(kvd));
    }

    public static int nktxHashListEntry_GetKey(long This, long pKeyLen, long ppKey) {
        long __functionAddress = Functions.HashListEntry_GetKey;
        if (Checks.CHECKS) {
            Checks.check(This);
        }
        return JNI.callPPPI(This, pKeyLen, ppKey, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxHashListEntry_GetKey(@NativeType(value="ktxHashListEntry *") long This, @NativeType(value="unsigned int *") IntBuffer pKeyLen, @NativeType(value="char **") PointerBuffer ppKey) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pKeyLen, 1);
            Checks.check(ppKey, 1);
        }
        return org.lwjgl.util.ktx.KTX.nktxHashListEntry_GetKey(This, MemoryUtil.memAddress(pKeyLen), MemoryUtil.memAddress(ppKey));
    }

    public static int nktxHashListEntry_GetValue(long This, long pValueLen, long ppValue) {
        long __functionAddress = Functions.HashListEntry_GetValue;
        if (Checks.CHECKS) {
            Checks.check(This);
        }
        return JNI.callPPPI(This, pValueLen, ppValue, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxHashListEntry_GetValue(@NativeType(value="ktxHashListEntry *") long This, @NativeType(value="unsigned int *") IntBuffer pValueLen, @NativeType(value="void **") PointerBuffer ppValue) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pValueLen, 1);
            Checks.check(ppValue, 1);
        }
        return org.lwjgl.util.ktx.KTX.nktxHashListEntry_GetValue(This, MemoryUtil.memAddress(pValueLen), MemoryUtil.memAddress(ppValue));
    }

    public static int nktxPrintInfoForNamedFile(long filename) {
        long __functionAddress = Functions.PrintInfoForNamedFile;
        return JNI.callPI(filename, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxPrintInfoForNamedFile(@NativeType(value="char const * const") ByteBuffer filename) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
        }
        return org.lwjgl.util.ktx.KTX.nktxPrintInfoForNamedFile(MemoryUtil.memAddress(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="KTX_error_code")
    public static int ktxPrintInfoForNamedFile(@NativeType(value="char const * const") CharSequence filename) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(filename, true);
            long filenameEncoded = stack.getPointerAddress();
            int n = org.lwjgl.util.ktx.KTX.nktxPrintInfoForNamedFile(filenameEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nktxPrintInfoForMemory(long bytes, long size) {
        long __functionAddress = Functions.PrintInfoForMemory;
        return JNI.callPPI(bytes, size, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxPrintInfoForMemory(@NativeType(value="ktx_uint8_t const *") ByteBuffer bytes) {
        return org.lwjgl.util.ktx.KTX.nktxPrintInfoForMemory(MemoryUtil.memAddress(bytes), bytes.remaining());
    }

    public static int nktxPrintKTX2InfoTextForMemory(long bytes, long size) {
        long __functionAddress = Functions.PrintKTX2InfoTextForMemory;
        return JNI.callPPI(bytes, size, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxPrintKTX2InfoTextForMemory(@NativeType(value="ktx_uint8_t const *") ByteBuffer bytes) {
        return org.lwjgl.util.ktx.KTX.nktxPrintKTX2InfoTextForMemory(MemoryUtil.memAddress(bytes), bytes.remaining());
    }

    public static int nktxPrintKTX2InfoTextForNamedFile(long filename) {
        long __functionAddress = Functions.PrintKTX2InfoTextForNamedFile;
        return JNI.callPI(filename, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxPrintKTX2InfoTextForNamedFile(@NativeType(value="char const * const") ByteBuffer filename) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
        }
        return org.lwjgl.util.ktx.KTX.nktxPrintKTX2InfoTextForNamedFile(MemoryUtil.memAddress(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="KTX_error_code")
    public static int ktxPrintKTX2InfoTextForNamedFile(@NativeType(value="char const * const") CharSequence filename) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(filename, true);
            long filenameEncoded = stack.getPointerAddress();
            int n = org.lwjgl.util.ktx.KTX.nktxPrintKTX2InfoTextForNamedFile(filenameEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nktxPrintKTX2InfoTextForStream(long stream) {
        long __functionAddress = Functions.PrintKTX2InfoTextForStream;
        return JNI.callPI(stream, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxPrintKTX2InfoTextForStream(@NativeType(value="struct ktxStream *") ktxStream stream) {
        return org.lwjgl.util.ktx.KTX.nktxPrintKTX2InfoTextForStream(stream.address());
    }

    public static int nktxPrintKTX2InfoJSONForMemory(long bytes, long size, int base_indent, int indent_width, boolean minified) {
        long __functionAddress = Functions.PrintKTX2InfoJSONForMemory;
        return JNI.callPPI(bytes, size, base_indent, indent_width, minified, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxPrintKTX2InfoJSONForMemory(@NativeType(value="ktx_uint8_t const *") ByteBuffer bytes, @NativeType(value="ktx_uint32_t") int base_indent, @NativeType(value="ktx_uint32_t") int indent_width, @NativeType(value="bool") boolean minified) {
        return org.lwjgl.util.ktx.KTX.nktxPrintKTX2InfoJSONForMemory(MemoryUtil.memAddress(bytes), bytes.remaining(), base_indent, indent_width, minified);
    }

    public static int nktxPrintKTX2InfoJSONForNamedFile(long filename, int base_indent, int indent_width, boolean minified) {
        long __functionAddress = Functions.PrintKTX2InfoJSONForNamedFile;
        return JNI.callPI(filename, base_indent, indent_width, minified, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxPrintKTX2InfoJSONForNamedFile(@NativeType(value="char const * const") ByteBuffer filename, @NativeType(value="ktx_uint32_t") int base_indent, @NativeType(value="ktx_uint32_t") int indent_width, @NativeType(value="bool") boolean minified) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
        }
        return org.lwjgl.util.ktx.KTX.nktxPrintKTX2InfoJSONForNamedFile(MemoryUtil.memAddress(filename), base_indent, indent_width, minified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="KTX_error_code")
    public static int ktxPrintKTX2InfoJSONForNamedFile(@NativeType(value="char const * const") CharSequence filename, @NativeType(value="ktx_uint32_t") int base_indent, @NativeType(value="ktx_uint32_t") int indent_width, @NativeType(value="bool") boolean minified) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(filename, true);
            long filenameEncoded = stack.getPointerAddress();
            int n = org.lwjgl.util.ktx.KTX.nktxPrintKTX2InfoJSONForNamedFile(filenameEncoded, base_indent, indent_width, minified);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nktxPrintKTX2InfoJSONForStream(long stream, int base_indent, int indent_width, boolean minified) {
        long __functionAddress = Functions.PrintKTX2InfoJSONForStream;
        return JNI.callPI(stream, base_indent, indent_width, minified, __functionAddress);
    }

    @NativeType(value="KTX_error_code")
    public static int ktxPrintKTX2InfoJSONForStream(@NativeType(value="struct ktxStream *") ktxStream stream, @NativeType(value="ktx_uint32_t") int base_indent, @NativeType(value="ktx_uint32_t") int indent_width, @NativeType(value="bool") boolean minified) {
        return org.lwjgl.util.ktx.KTX.nktxPrintKTX2InfoJSONForStream(stream.address(), base_indent, indent_width, minified);
    }

    public static void ktxTexture_Destroy(@NativeType(value="ktxTexture *") ktxTexture This) {
        JNI.callPV(This.address(), This.vtbl().Destroy());
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture_GetImageOffset(@NativeType(value="ktxTexture *") ktxTexture This, @NativeType(value="ktx_uint32_t") int level, @NativeType(value="ktx_uint32_t") int layer, @NativeType(value="ktx_uint32_t") int faceSlice, @NativeType(value="ktx_size_t *") PointerBuffer pOffset) {
        if (Checks.CHECKS) {
            Checks.check(pOffset, 1);
        }
        return JNI.callPPI(This.address(), level, layer, faceSlice, MemoryUtil.memAddress(pOffset), This.vtbl().GetImageOffset());
    }

    @NativeType(value="ktx_size_t")
    public static long ktxTexture_GetDataSizeUncompressed(@NativeType(value="ktxTexture *") ktxTexture This) {
        return JNI.callPP(This.address(), This.vtbl().GetDataSizeUncompressed());
    }

    @NativeType(value="ktx_size_t")
    public static long ktxTexture_GetImageSize(@NativeType(value="ktxTexture *") ktxTexture This, @NativeType(value="ktx_uint32_t") int level) {
        return JNI.callPP(This.address(), level, This.vtbl().GetImageSize());
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture_IterateLevels(@NativeType(value="ktxTexture *") ktxTexture This, @NativeType(value="PFNKTXITERCB") PFNKTXITERCBI iterCb, @NativeType(value="void *") long userdata) {
        return JNI.callPPPI(This.address(), iterCb.address(), userdata, This.vtbl().IterateLevels());
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture_IterateLoadLevelFaces(@NativeType(value="ktxTexture *") ktxTexture This, @NativeType(value="PFNKTXITERCB") PFNKTXITERCBI iterCb, @NativeType(value="void *") long userdata) {
        return JNI.callPPPI(This.address(), iterCb.address(), userdata, This.vtbl().IterateLoadLevelFaces());
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture_LoadImageData(@NativeType(value="ktxTexture *") ktxTexture This, @NativeType(value="ktx_uint8_t *") ByteBuffer pBuffer) {
        return JNI.callPPPI(This.address(), MemoryUtil.memAddress(pBuffer), (long)pBuffer.remaining(), This.vtbl().LoadImageData());
    }

    @NativeType(value="ktx_bool_t")
    public static boolean ktxTexture_NeedsTranscoding(@NativeType(value="ktxTexture *") ktxTexture This) {
        return JNI.callPZ(This.address(), This.vtbl().NeedsTranscoding());
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture_SetImageFromMemory(@NativeType(value="ktxTexture *") ktxTexture This, @NativeType(value="ktx_uint32_t") int level, @NativeType(value="ktx_uint32_t") int layer, @NativeType(value="ktx_uint32_t") int faceSlice, @NativeType(value="ktx_uint8_t const *") ByteBuffer src) {
        return JNI.callPPPI(This.address(), level, layer, faceSlice, MemoryUtil.memAddress(src), (long)src.remaining(), This.vtbl().SetImageFromMemory());
    }

    @NativeType(value="KTX_error_code")
    public static int ktxWriteToNamedFile(@NativeType(value="ktxTexture *") ktxTexture This, @NativeType(value="char const * const") ByteBuffer dstname) {
        if (Checks.CHECKS) {
            Checks.checkNT1(dstname);
        }
        return JNI.callPPI(This.address(), MemoryUtil.memAddress(dstname), This.vtbl().WriteToNamedFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="KTX_error_code")
    public static int ktxWriteToNamedFile(@NativeType(value="ktxTexture *") ktxTexture This, @NativeType(value="char const * const") CharSequence dstname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(dstname, true);
            long dstnameEncoded = stack.getPointerAddress();
            int n = JNI.callPPI(This.address(), dstnameEncoded, This.vtbl().WriteToNamedFile());
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture_WriteToMemory(@NativeType(value="ktxTexture *") ktxTexture This, @NativeType(value="ktx_uint8_t **") PointerBuffer bytes, @NativeType(value="ktx_size_t *") PointerBuffer size) {
        if (Checks.CHECKS) {
            Checks.check(bytes, 1);
            Checks.check(size, 1);
        }
        return JNI.callPPPI(This.address(), MemoryUtil.memAddress(bytes), MemoryUtil.memAddress(size), This.vtbl().WriteToMemory());
    }

    @NativeType(value="KTX_error_code")
    public static int ktxTexture_WriteToStream(@NativeType(value="ktxTexture *") ktxTexture This, @NativeType(value="ktxStream *") long dststr) {
        if (Checks.CHECKS) {
            Checks.check(dststr);
        }
        return JNI.callPPI(This.address(), dststr, This.vtbl().WriteToStream());
    }

    static /* synthetic */ SharedLibrary access$000() {
        return KTX;
    }

    static {
        long p = KTX.getFunctionAddress("KTX_ETC1S_DEFAULT_COMPRESSION_LEVEL");
        KTX_ETC1S_DEFAULT_COMPRESSION_LEVEL = p == 0L ? 0 : MemoryUtil.memGetInt(p);
    }

    public static final class Functions {
        public static final long Texture_CreateFromNamedFile = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture_CreateFromNamedFile");
        public static final long Texture_CreateFromMemory = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture_CreateFromMemory");
        public static final long Texture_CreateFromStream = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture_CreateFromStream");
        public static final long Texture_GetData = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture_GetData");
        public static final long Texture_GetRowPitch = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture_GetRowPitch");
        public static final long Texture_GetElementSize = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture_GetElementSize");
        public static final long Texture_GetDataSize = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture_GetDataSize");
        public static final long Texture_GLUpload = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture_GLUpload");
        public static final long Texture_IterateLevelFaces = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture_IterateLevelFaces");
        public static final long Texture1_Create = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture1_Create");
        public static final long Texture1_CreateFromNamedFile = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture1_CreateFromNamedFile");
        public static final long Texture1_CreateFromMemory = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture1_CreateFromMemory");
        public static final long Texture1_CreateFromStream = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture1_CreateFromStream");
        public static final long Texture1_NeedsTranscoding = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture1_NeedsTranscoding");
        public static final long Texture1_WriteKTX2ToNamedFile = APIUtil.apiGetFunctionAddressOptional(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture1_WriteKTX2ToNamedFile");
        public static final long Texture1_WriteKTX2ToMemory = APIUtil.apiGetFunctionAddressOptional(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture1_WriteKTX2ToMemory");
        public static final long Texture1_WriteKTX2ToStream = APIUtil.apiGetFunctionAddressOptional(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture1_WriteKTX2ToStream");
        public static final long Texture2_Create = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture2_Create");
        public static final long Texture2_CreateCopy = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture2_CreateCopy");
        public static final long Texture2_CreateFromNamedFile = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture2_CreateFromNamedFile");
        public static final long Texture2_CreateFromMemory = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture2_CreateFromMemory");
        public static final long Texture2_CreateFromStream = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture2_CreateFromStream");
        public static final long Texture2_CompressBasis = APIUtil.apiGetFunctionAddressOptional(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture2_CompressBasis");
        public static final long Texture2_DeflateZstd = APIUtil.apiGetFunctionAddressOptional(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture2_DeflateZstd");
        public static final long Texture2_DeflateZLIB = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture2_DeflateZLIB");
        public static final long Texture2_GetComponentInfo = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture2_GetComponentInfo");
        public static final long Texture2_GetNumComponents = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture2_GetNumComponents");
        public static final long Texture2_GetOETF_e = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture2_GetOETF_e");
        public static final long Texture2_GetOETF = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture2_GetOETF");
        public static final long Texture2_GetColorModel_e = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture2_GetColorModel_e");
        public static final long Texture2_GetPremultipliedAlpha = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture2_GetPremultipliedAlpha");
        public static final long Texture2_NeedsTranscoding = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture2_NeedsTranscoding");
        public static final long Texture2_CompressAstcEx = APIUtil.apiGetFunctionAddressOptional(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture2_CompressAstcEx");
        public static final long Texture2_CompressAstc = APIUtil.apiGetFunctionAddressOptional(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture2_CompressAstc");
        public static final long Texture2_CompressBasisEx = APIUtil.apiGetFunctionAddressOptional(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture2_CompressBasisEx");
        public static final long Texture2_TranscodeBasis = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTexture2_TranscodeBasis");
        public static final long ErrorString = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxErrorString");
        public static final long SupercompressionSchemeString = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxSupercompressionSchemeString");
        public static final long TranscodeFormatString = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxTranscodeFormatString");
        public static final long HashList_Create = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxHashList_Create");
        public static final long HashList_CreateCopy = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxHashList_CreateCopy");
        public static final long HashList_Construct = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxHashList_Construct");
        public static final long HashList_ConstructCopy = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxHashList_ConstructCopy");
        public static final long HashList_Destroy = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxHashList_Destroy");
        public static final long HashList_Destruct = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxHashList_Destruct");
        public static final long HashList_AddKVPair = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxHashList_AddKVPair");
        public static final long HashList_DeleteEntry = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxHashList_DeleteEntry");
        public static final long HashList_DeleteKVPair = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxHashList_DeleteKVPair");
        public static final long HashList_FindEntry = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxHashList_FindEntry");
        public static final long HashList_FindValue = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxHashList_FindValue");
        public static final long HashList_Next = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxHashList_Next");
        public static final long HashList_Sort = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxHashList_Sort");
        public static final long HashList_Serialize = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxHashList_Serialize");
        public static final long HashList_Deserialize = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxHashList_Deserialize");
        public static final long HashListEntry_GetKey = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxHashListEntry_GetKey");
        public static final long HashListEntry_GetValue = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxHashListEntry_GetValue");
        public static final long PrintInfoForNamedFile = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxPrintInfoForNamedFile");
        public static final long PrintInfoForMemory = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxPrintInfoForMemory");
        public static final long PrintKTX2InfoTextForMemory = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxPrintKTX2InfoTextForMemory");
        public static final long PrintKTX2InfoTextForNamedFile = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxPrintKTX2InfoTextForNamedFile");
        public static final long PrintKTX2InfoTextForStream = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxPrintKTX2InfoTextForStream");
        public static final long PrintKTX2InfoJSONForMemory = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxPrintKTX2InfoJSONForMemory");
        public static final long PrintKTX2InfoJSONForNamedFile = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxPrintKTX2InfoJSONForNamedFile");
        public static final long PrintKTX2InfoJSONForStream = APIUtil.apiGetFunctionAddress(org.lwjgl.util.ktx.KTX.access$000(), "ktxPrintKTX2InfoJSONForStream");

        private Functions() {
        }
    }
}

