/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.ktx;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VKCapabilitiesDevice;
import org.lwjgl.vulkan.VKCapabilitiesInstance;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkInstance;

public class ktxVulkanFunctions
extends Struct<ktxVulkanFunctions>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VKGETINSTANCEPROCADDR;
    public static final int VKGETDEVICEPROCADDR;
    public static final int VKALLOCATECOMMANDBUFFERS;
    public static final int VKALLOCATEMEMORY;
    public static final int VKBEGINCOMMANDBUFFER;
    public static final int VKBINDBUFFERMEMORY;
    public static final int VKBINDIMAGEMEMORY;
    public static final int VKCMDBLITIMAGE;
    public static final int VKCMDCOPYBUFFERTOIMAGE;
    public static final int VKCMDPIPELINEBARRIER;
    public static final int VKCREATEIMAGE;
    public static final int VKDESTROYIMAGE;
    public static final int VKCREATEBUFFER;
    public static final int VKDESTROYBUFFER;
    public static final int VKCREATEFENCE;
    public static final int VKDESTROYFENCE;
    public static final int VKENDCOMMANDBUFFER;
    public static final int VKFREECOMMANDBUFFERS;
    public static final int VKFREEMEMORY;
    public static final int VKGETBUFFERMEMORYREQUIREMENTS;
    public static final int VKGETIMAGEMEMORYREQUIREMENTS;
    public static final int VKGETIMAGESUBRESOURCELAYOUT;
    public static final int VKGETPHYSICALDEVICEIMAGEFORMATPROPERTIES;
    public static final int VKGETPHYSICALDEVICEFORMATPROPERTIES;
    public static final int VKGETPHYSICALDEVICEMEMORYPROPERTIES;
    public static final int VKMAPMEMORY;
    public static final int VKQUEUESUBMIT;
    public static final int VKQUEUEWAITIDLE;
    public static final int VKUNMAPMEMORY;
    public static final int VKWAITFORFENCES;

    protected ktxVulkanFunctions(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected ktxVulkanFunctions create(long address, @Nullable ByteBuffer container) {
        return new ktxVulkanFunctions(address, container);
    }

    public ktxVulkanFunctions(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), ktxVulkanFunctions.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="PFN_vkGetInstanceProcAddr")
    public long vkGetInstanceProcAddr() {
        return ktxVulkanFunctions.nvkGetInstanceProcAddr(this.address());
    }

    @NativeType(value="PFN_vkGetDeviceProcAddr")
    public long vkGetDeviceProcAddr() {
        return ktxVulkanFunctions.nvkGetDeviceProcAddr(this.address());
    }

    @NativeType(value="PFN_vkAllocateCommandBuffers")
    public long vkAllocateCommandBuffers() {
        return ktxVulkanFunctions.nvkAllocateCommandBuffers(this.address());
    }

    @NativeType(value="PFN_vkAllocateMemory")
    public long vkAllocateMemory() {
        return ktxVulkanFunctions.nvkAllocateMemory(this.address());
    }

    @NativeType(value="PFN_vkBeginCommandBuffer")
    public long vkBeginCommandBuffer() {
        return ktxVulkanFunctions.nvkBeginCommandBuffer(this.address());
    }

    @NativeType(value="PFN_vkBindBufferMemory")
    public long vkBindBufferMemory() {
        return ktxVulkanFunctions.nvkBindBufferMemory(this.address());
    }

    @NativeType(value="PFN_vkBindImageMemory")
    public long vkBindImageMemory() {
        return ktxVulkanFunctions.nvkBindImageMemory(this.address());
    }

    @NativeType(value="PFN_vkCmdBlitImage")
    public long vkCmdBlitImage() {
        return ktxVulkanFunctions.nvkCmdBlitImage(this.address());
    }

    @NativeType(value="PFN_vkCmdCopyBufferToImage")
    public long vkCmdCopyBufferToImage() {
        return ktxVulkanFunctions.nvkCmdCopyBufferToImage(this.address());
    }

    @NativeType(value="PFN_vkCmdPipelineBarrier")
    public long vkCmdPipelineBarrier() {
        return ktxVulkanFunctions.nvkCmdPipelineBarrier(this.address());
    }

    @NativeType(value="PFN_vkCreateImage")
    public long vkCreateImage() {
        return ktxVulkanFunctions.nvkCreateImage(this.address());
    }

    @NativeType(value="PFN_vkDestroyImage")
    public long vkDestroyImage() {
        return ktxVulkanFunctions.nvkDestroyImage(this.address());
    }

    @NativeType(value="PFN_vkCreateBuffer")
    public long vkCreateBuffer() {
        return ktxVulkanFunctions.nvkCreateBuffer(this.address());
    }

    @NativeType(value="PFN_vkDestroyBuffer")
    public long vkDestroyBuffer() {
        return ktxVulkanFunctions.nvkDestroyBuffer(this.address());
    }

    @NativeType(value="PFN_vkCreateFence")
    public long vkCreateFence() {
        return ktxVulkanFunctions.nvkCreateFence(this.address());
    }

    @NativeType(value="PFN_vkDestroyFence")
    public long vkDestroyFence() {
        return ktxVulkanFunctions.nvkDestroyFence(this.address());
    }

    @NativeType(value="PFN_vkEndCommandBuffer")
    public long vkEndCommandBuffer() {
        return ktxVulkanFunctions.nvkEndCommandBuffer(this.address());
    }

    @NativeType(value="PFN_vkFreeCommandBuffers")
    public long vkFreeCommandBuffers() {
        return ktxVulkanFunctions.nvkFreeCommandBuffers(this.address());
    }

    @NativeType(value="PFN_vkFreeMemory")
    public long vkFreeMemory() {
        return ktxVulkanFunctions.nvkFreeMemory(this.address());
    }

    @NativeType(value="PFN_vkGetBufferMemoryRequirements")
    public long vkGetBufferMemoryRequirements() {
        return ktxVulkanFunctions.nvkGetBufferMemoryRequirements(this.address());
    }

    @NativeType(value="PFN_vkGetImageMemoryRequirements")
    public long vkGetImageMemoryRequirements() {
        return ktxVulkanFunctions.nvkGetImageMemoryRequirements(this.address());
    }

    @NativeType(value="PFN_vkGetImageSubresourceLayout")
    public long vkGetImageSubresourceLayout() {
        return ktxVulkanFunctions.nvkGetImageSubresourceLayout(this.address());
    }

    @NativeType(value="PFN_vkGetPhysicalDeviceImageFormatProperties")
    public long vkGetPhysicalDeviceImageFormatProperties() {
        return ktxVulkanFunctions.nvkGetPhysicalDeviceImageFormatProperties(this.address());
    }

    @NativeType(value="PFN_vkGetPhysicalDeviceFormatProperties")
    public long vkGetPhysicalDeviceFormatProperties() {
        return ktxVulkanFunctions.nvkGetPhysicalDeviceFormatProperties(this.address());
    }

    @NativeType(value="PFN_vkGetPhysicalDeviceMemoryProperties")
    public long vkGetPhysicalDeviceMemoryProperties() {
        return ktxVulkanFunctions.nvkGetPhysicalDeviceMemoryProperties(this.address());
    }

    @NativeType(value="PFN_vkMapMemory")
    public long vkMapMemory() {
        return ktxVulkanFunctions.nvkMapMemory(this.address());
    }

    @NativeType(value="PFN_vkQueueSubmit")
    public long vkQueueSubmit() {
        return ktxVulkanFunctions.nvkQueueSubmit(this.address());
    }

    @NativeType(value="PFN_vkQueueWaitIdle")
    public long vkQueueWaitIdle() {
        return ktxVulkanFunctions.nvkQueueWaitIdle(this.address());
    }

    @NativeType(value="PFN_vkUnmapMemory")
    public long vkUnmapMemory() {
        return ktxVulkanFunctions.nvkUnmapMemory(this.address());
    }

    @NativeType(value="PFN_vkWaitForFences")
    public long vkWaitForFences() {
        return ktxVulkanFunctions.nvkWaitForFences(this.address());
    }

    public ktxVulkanFunctions vkGetInstanceProcAddr(@NativeType(value="PFN_vkGetInstanceProcAddr") long value) {
        ktxVulkanFunctions.nvkGetInstanceProcAddr(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkGetDeviceProcAddr(@NativeType(value="PFN_vkGetDeviceProcAddr") long value) {
        ktxVulkanFunctions.nvkGetDeviceProcAddr(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkAllocateCommandBuffers(@NativeType(value="PFN_vkAllocateCommandBuffers") long value) {
        ktxVulkanFunctions.nvkAllocateCommandBuffers(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkAllocateMemory(@NativeType(value="PFN_vkAllocateMemory") long value) {
        ktxVulkanFunctions.nvkAllocateMemory(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkBeginCommandBuffer(@NativeType(value="PFN_vkBeginCommandBuffer") long value) {
        ktxVulkanFunctions.nvkBeginCommandBuffer(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkBindBufferMemory(@NativeType(value="PFN_vkBindBufferMemory") long value) {
        ktxVulkanFunctions.nvkBindBufferMemory(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkBindImageMemory(@NativeType(value="PFN_vkBindImageMemory") long value) {
        ktxVulkanFunctions.nvkBindImageMemory(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkCmdBlitImage(@NativeType(value="PFN_vkCmdBlitImage") long value) {
        ktxVulkanFunctions.nvkCmdBlitImage(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkCmdCopyBufferToImage(@NativeType(value="PFN_vkCmdCopyBufferToImage") long value) {
        ktxVulkanFunctions.nvkCmdCopyBufferToImage(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkCmdPipelineBarrier(@NativeType(value="PFN_vkCmdPipelineBarrier") long value) {
        ktxVulkanFunctions.nvkCmdPipelineBarrier(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkCreateImage(@NativeType(value="PFN_vkCreateImage") long value) {
        ktxVulkanFunctions.nvkCreateImage(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkDestroyImage(@NativeType(value="PFN_vkDestroyImage") long value) {
        ktxVulkanFunctions.nvkDestroyImage(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkCreateBuffer(@NativeType(value="PFN_vkCreateBuffer") long value) {
        ktxVulkanFunctions.nvkCreateBuffer(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkDestroyBuffer(@NativeType(value="PFN_vkDestroyBuffer") long value) {
        ktxVulkanFunctions.nvkDestroyBuffer(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkCreateFence(@NativeType(value="PFN_vkCreateFence") long value) {
        ktxVulkanFunctions.nvkCreateFence(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkDestroyFence(@NativeType(value="PFN_vkDestroyFence") long value) {
        ktxVulkanFunctions.nvkDestroyFence(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkEndCommandBuffer(@NativeType(value="PFN_vkEndCommandBuffer") long value) {
        ktxVulkanFunctions.nvkEndCommandBuffer(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkFreeCommandBuffers(@NativeType(value="PFN_vkFreeCommandBuffers") long value) {
        ktxVulkanFunctions.nvkFreeCommandBuffers(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkFreeMemory(@NativeType(value="PFN_vkFreeMemory") long value) {
        ktxVulkanFunctions.nvkFreeMemory(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkGetBufferMemoryRequirements(@NativeType(value="PFN_vkGetBufferMemoryRequirements") long value) {
        ktxVulkanFunctions.nvkGetBufferMemoryRequirements(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkGetImageMemoryRequirements(@NativeType(value="PFN_vkGetImageMemoryRequirements") long value) {
        ktxVulkanFunctions.nvkGetImageMemoryRequirements(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkGetImageSubresourceLayout(@NativeType(value="PFN_vkGetImageSubresourceLayout") long value) {
        ktxVulkanFunctions.nvkGetImageSubresourceLayout(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkGetPhysicalDeviceImageFormatProperties(@NativeType(value="PFN_vkGetPhysicalDeviceImageFormatProperties") long value) {
        ktxVulkanFunctions.nvkGetPhysicalDeviceImageFormatProperties(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkGetPhysicalDeviceFormatProperties(@NativeType(value="PFN_vkGetPhysicalDeviceFormatProperties") long value) {
        ktxVulkanFunctions.nvkGetPhysicalDeviceFormatProperties(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkGetPhysicalDeviceMemoryProperties(@NativeType(value="PFN_vkGetPhysicalDeviceMemoryProperties") long value) {
        ktxVulkanFunctions.nvkGetPhysicalDeviceMemoryProperties(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkMapMemory(@NativeType(value="PFN_vkMapMemory") long value) {
        ktxVulkanFunctions.nvkMapMemory(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkQueueSubmit(@NativeType(value="PFN_vkQueueSubmit") long value) {
        ktxVulkanFunctions.nvkQueueSubmit(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkQueueWaitIdle(@NativeType(value="PFN_vkQueueWaitIdle") long value) {
        ktxVulkanFunctions.nvkQueueWaitIdle(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkUnmapMemory(@NativeType(value="PFN_vkUnmapMemory") long value) {
        ktxVulkanFunctions.nvkUnmapMemory(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions vkWaitForFences(@NativeType(value="PFN_vkWaitForFences") long value) {
        ktxVulkanFunctions.nvkWaitForFences(this.address(), value);
        return this;
    }

    public ktxVulkanFunctions set(long vkGetInstanceProcAddr, long vkGetDeviceProcAddr, long vkAllocateCommandBuffers, long vkAllocateMemory, long vkBeginCommandBuffer, long vkBindBufferMemory, long vkBindImageMemory, long vkCmdBlitImage, long vkCmdCopyBufferToImage, long vkCmdPipelineBarrier, long vkCreateImage, long vkDestroyImage, long vkCreateBuffer, long vkDestroyBuffer, long vkCreateFence, long vkDestroyFence, long vkEndCommandBuffer, long vkFreeCommandBuffers, long vkFreeMemory, long vkGetBufferMemoryRequirements, long vkGetImageMemoryRequirements, long vkGetImageSubresourceLayout, long vkGetPhysicalDeviceImageFormatProperties, long vkGetPhysicalDeviceFormatProperties, long vkGetPhysicalDeviceMemoryProperties, long vkMapMemory, long vkQueueSubmit, long vkQueueWaitIdle, long vkUnmapMemory, long vkWaitForFences) {
        this.vkGetInstanceProcAddr(vkGetInstanceProcAddr);
        this.vkGetDeviceProcAddr(vkGetDeviceProcAddr);
        this.vkAllocateCommandBuffers(vkAllocateCommandBuffers);
        this.vkAllocateMemory(vkAllocateMemory);
        this.vkBeginCommandBuffer(vkBeginCommandBuffer);
        this.vkBindBufferMemory(vkBindBufferMemory);
        this.vkBindImageMemory(vkBindImageMemory);
        this.vkCmdBlitImage(vkCmdBlitImage);
        this.vkCmdCopyBufferToImage(vkCmdCopyBufferToImage);
        this.vkCmdPipelineBarrier(vkCmdPipelineBarrier);
        this.vkCreateImage(vkCreateImage);
        this.vkDestroyImage(vkDestroyImage);
        this.vkCreateBuffer(vkCreateBuffer);
        this.vkDestroyBuffer(vkDestroyBuffer);
        this.vkCreateFence(vkCreateFence);
        this.vkDestroyFence(vkDestroyFence);
        this.vkEndCommandBuffer(vkEndCommandBuffer);
        this.vkFreeCommandBuffers(vkFreeCommandBuffers);
        this.vkFreeMemory(vkFreeMemory);
        this.vkGetBufferMemoryRequirements(vkGetBufferMemoryRequirements);
        this.vkGetImageMemoryRequirements(vkGetImageMemoryRequirements);
        this.vkGetImageSubresourceLayout(vkGetImageSubresourceLayout);
        this.vkGetPhysicalDeviceImageFormatProperties(vkGetPhysicalDeviceImageFormatProperties);
        this.vkGetPhysicalDeviceFormatProperties(vkGetPhysicalDeviceFormatProperties);
        this.vkGetPhysicalDeviceMemoryProperties(vkGetPhysicalDeviceMemoryProperties);
        this.vkMapMemory(vkMapMemory);
        this.vkQueueSubmit(vkQueueSubmit);
        this.vkQueueWaitIdle(vkQueueWaitIdle);
        this.vkUnmapMemory(vkUnmapMemory);
        this.vkWaitForFences(vkWaitForFences);
        return this;
    }

    public ktxVulkanFunctions set(ktxVulkanFunctions src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static ktxVulkanFunctions malloc() {
        return new ktxVulkanFunctions(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static ktxVulkanFunctions calloc() {
        return new ktxVulkanFunctions(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static ktxVulkanFunctions create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new ktxVulkanFunctions(MemoryUtil.memAddress(container), container);
    }

    public static ktxVulkanFunctions create(long address) {
        return new ktxVulkanFunctions(address, null);
    }

    public static @Nullable ktxVulkanFunctions createSafe(long address) {
        return address == 0L ? null : new ktxVulkanFunctions(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(ktxVulkanFunctions.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ktxVulkanFunctions.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static ktxVulkanFunctions malloc(MemoryStack stack) {
        return new ktxVulkanFunctions(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ktxVulkanFunctions calloc(MemoryStack stack) {
        return new ktxVulkanFunctions(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nvkGetInstanceProcAddr(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKGETINSTANCEPROCADDR);
    }

    public static long nvkGetDeviceProcAddr(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKGETDEVICEPROCADDR);
    }

    public static long nvkAllocateCommandBuffers(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKALLOCATECOMMANDBUFFERS);
    }

    public static long nvkAllocateMemory(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKALLOCATEMEMORY);
    }

    public static long nvkBeginCommandBuffer(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKBEGINCOMMANDBUFFER);
    }

    public static long nvkBindBufferMemory(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKBINDBUFFERMEMORY);
    }

    public static long nvkBindImageMemory(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKBINDIMAGEMEMORY);
    }

    public static long nvkCmdBlitImage(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKCMDBLITIMAGE);
    }

    public static long nvkCmdCopyBufferToImage(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKCMDCOPYBUFFERTOIMAGE);
    }

    public static long nvkCmdPipelineBarrier(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKCMDPIPELINEBARRIER);
    }

    public static long nvkCreateImage(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKCREATEIMAGE);
    }

    public static long nvkDestroyImage(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKDESTROYIMAGE);
    }

    public static long nvkCreateBuffer(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKCREATEBUFFER);
    }

    public static long nvkDestroyBuffer(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKDESTROYBUFFER);
    }

    public static long nvkCreateFence(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKCREATEFENCE);
    }

    public static long nvkDestroyFence(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKDESTROYFENCE);
    }

    public static long nvkEndCommandBuffer(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKENDCOMMANDBUFFER);
    }

    public static long nvkFreeCommandBuffers(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKFREECOMMANDBUFFERS);
    }

    public static long nvkFreeMemory(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKFREEMEMORY);
    }

    public static long nvkGetBufferMemoryRequirements(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKGETBUFFERMEMORYREQUIREMENTS);
    }

    public static long nvkGetImageMemoryRequirements(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKGETIMAGEMEMORYREQUIREMENTS);
    }

    public static long nvkGetImageSubresourceLayout(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKGETIMAGESUBRESOURCELAYOUT);
    }

    public static long nvkGetPhysicalDeviceImageFormatProperties(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKGETPHYSICALDEVICEIMAGEFORMATPROPERTIES);
    }

    public static long nvkGetPhysicalDeviceFormatProperties(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKGETPHYSICALDEVICEFORMATPROPERTIES);
    }

    public static long nvkGetPhysicalDeviceMemoryProperties(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKGETPHYSICALDEVICEMEMORYPROPERTIES);
    }

    public static long nvkMapMemory(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKMAPMEMORY);
    }

    public static long nvkQueueSubmit(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKQUEUESUBMIT);
    }

    public static long nvkQueueWaitIdle(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKQUEUEWAITIDLE);
    }

    public static long nvkUnmapMemory(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKUNMAPMEMORY);
    }

    public static long nvkWaitForFences(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKWAITFORFENCES);
    }

    public static void nvkGetInstanceProcAddr(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKGETINSTANCEPROCADDR, Checks.check(value));
    }

    public static void nvkGetDeviceProcAddr(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKGETDEVICEPROCADDR, Checks.check(value));
    }

    public static void nvkAllocateCommandBuffers(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKALLOCATECOMMANDBUFFERS, value);
    }

    public static void nvkAllocateMemory(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKALLOCATEMEMORY, value);
    }

    public static void nvkBeginCommandBuffer(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKBEGINCOMMANDBUFFER, value);
    }

    public static void nvkBindBufferMemory(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKBINDBUFFERMEMORY, value);
    }

    public static void nvkBindImageMemory(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKBINDIMAGEMEMORY, value);
    }

    public static void nvkCmdBlitImage(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKCMDBLITIMAGE, value);
    }

    public static void nvkCmdCopyBufferToImage(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKCMDCOPYBUFFERTOIMAGE, value);
    }

    public static void nvkCmdPipelineBarrier(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKCMDPIPELINEBARRIER, value);
    }

    public static void nvkCreateImage(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKCREATEIMAGE, value);
    }

    public static void nvkDestroyImage(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKDESTROYIMAGE, value);
    }

    public static void nvkCreateBuffer(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKCREATEBUFFER, value);
    }

    public static void nvkDestroyBuffer(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKDESTROYBUFFER, value);
    }

    public static void nvkCreateFence(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKCREATEFENCE, value);
    }

    public static void nvkDestroyFence(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKDESTROYFENCE, value);
    }

    public static void nvkEndCommandBuffer(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKENDCOMMANDBUFFER, value);
    }

    public static void nvkFreeCommandBuffers(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKFREECOMMANDBUFFERS, value);
    }

    public static void nvkFreeMemory(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKFREEMEMORY, value);
    }

    public static void nvkGetBufferMemoryRequirements(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKGETBUFFERMEMORYREQUIREMENTS, value);
    }

    public static void nvkGetImageMemoryRequirements(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKGETIMAGEMEMORYREQUIREMENTS, value);
    }

    public static void nvkGetImageSubresourceLayout(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKGETIMAGESUBRESOURCELAYOUT, value);
    }

    public static void nvkGetPhysicalDeviceImageFormatProperties(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKGETPHYSICALDEVICEIMAGEFORMATPROPERTIES, value);
    }

    public static void nvkGetPhysicalDeviceFormatProperties(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKGETPHYSICALDEVICEFORMATPROPERTIES, value);
    }

    public static void nvkGetPhysicalDeviceMemoryProperties(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKGETPHYSICALDEVICEMEMORYPROPERTIES, value);
    }

    public static void nvkMapMemory(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKMAPMEMORY, value);
    }

    public static void nvkQueueSubmit(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKQUEUESUBMIT, value);
    }

    public static void nvkQueueWaitIdle(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKQUEUEWAITIDLE, value);
    }

    public static void nvkUnmapMemory(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKUNMAPMEMORY, value);
    }

    public static void nvkWaitForFences(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKWAITFORFENCES, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VKGETINSTANCEPROCADDR));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VKGETDEVICEPROCADDR));
    }

    public ktxVulkanFunctions set(VkInstance instance, VkDevice device) {
        VKCapabilitiesInstance ic = instance.getCapabilities();
        VKCapabilitiesDevice dc = device.getCapabilities();
        this.vkGetInstanceProcAddr(VK.getFunctionProvider().getFunctionAddress("vkGetInstanceProcAddr")).vkGetDeviceProcAddr(dc.vkGetDeviceProcAddr).vkAllocateCommandBuffers(dc.vkAllocateCommandBuffers).vkAllocateMemory(dc.vkAllocateMemory).vkBeginCommandBuffer(dc.vkBeginCommandBuffer).vkBindBufferMemory(dc.vkBindBufferMemory).vkBindImageMemory(dc.vkBindImageMemory).vkCmdBlitImage(dc.vkCmdBlitImage).vkCmdCopyBufferToImage(dc.vkCmdCopyBufferToImage).vkCmdPipelineBarrier(dc.vkCmdPipelineBarrier).vkCreateImage(dc.vkCreateImage).vkDestroyImage(dc.vkDestroyImage).vkCreateBuffer(dc.vkCreateBuffer).vkDestroyBuffer(dc.vkDestroyBuffer).vkCreateFence(dc.vkCreateFence).vkDestroyFence(dc.vkDestroyFence).vkEndCommandBuffer(dc.vkEndCommandBuffer).vkFreeCommandBuffers(dc.vkFreeCommandBuffers).vkFreeMemory(dc.vkFreeMemory).vkGetBufferMemoryRequirements(dc.vkGetBufferMemoryRequirements).vkGetImageMemoryRequirements(dc.vkGetImageMemoryRequirements).vkGetImageSubresourceLayout(dc.vkGetImageSubresourceLayout).vkGetPhysicalDeviceImageFormatProperties(ic.vkGetPhysicalDeviceImageFormatProperties).vkGetPhysicalDeviceFormatProperties(ic.vkGetPhysicalDeviceFormatProperties).vkGetPhysicalDeviceMemoryProperties(ic.vkGetPhysicalDeviceMemoryProperties).vkMapMemory(dc.vkMapMemory).vkQueueSubmit(dc.vkQueueSubmit).vkQueueWaitIdle(dc.vkQueueWaitIdle).vkUnmapMemory(dc.vkUnmapMemory).vkWaitForFences(dc.vkWaitForFences);
        return this;
    }

    static {
        Struct.Layout layout = ktxVulkanFunctions.__struct(ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE), ktxVulkanFunctions.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VKGETINSTANCEPROCADDR = layout.offsetof(0);
        VKGETDEVICEPROCADDR = layout.offsetof(1);
        VKALLOCATECOMMANDBUFFERS = layout.offsetof(2);
        VKALLOCATEMEMORY = layout.offsetof(3);
        VKBEGINCOMMANDBUFFER = layout.offsetof(4);
        VKBINDBUFFERMEMORY = layout.offsetof(5);
        VKBINDIMAGEMEMORY = layout.offsetof(6);
        VKCMDBLITIMAGE = layout.offsetof(7);
        VKCMDCOPYBUFFERTOIMAGE = layout.offsetof(8);
        VKCMDPIPELINEBARRIER = layout.offsetof(9);
        VKCREATEIMAGE = layout.offsetof(10);
        VKDESTROYIMAGE = layout.offsetof(11);
        VKCREATEBUFFER = layout.offsetof(12);
        VKDESTROYBUFFER = layout.offsetof(13);
        VKCREATEFENCE = layout.offsetof(14);
        VKDESTROYFENCE = layout.offsetof(15);
        VKENDCOMMANDBUFFER = layout.offsetof(16);
        VKFREECOMMANDBUFFERS = layout.offsetof(17);
        VKFREEMEMORY = layout.offsetof(18);
        VKGETBUFFERMEMORYREQUIREMENTS = layout.offsetof(19);
        VKGETIMAGEMEMORYREQUIREMENTS = layout.offsetof(20);
        VKGETIMAGESUBRESOURCELAYOUT = layout.offsetof(21);
        VKGETPHYSICALDEVICEIMAGEFORMATPROPERTIES = layout.offsetof(22);
        VKGETPHYSICALDEVICEFORMATPROPERTIES = layout.offsetof(23);
        VKGETPHYSICALDEVICEMEMORYPROPERTIES = layout.offsetof(24);
        VKMAPMEMORY = layout.offsetof(25);
        VKQUEUESUBMIT = layout.offsetof(26);
        VKQUEUEWAITIDLE = layout.offsetof(27);
        VKUNMAPMEMORY = layout.offsetof(28);
        VKWAITFORFENCES = layout.offsetof(29);
    }

    public static class Buffer
    extends StructBuffer<ktxVulkanFunctions, Buffer>
    implements NativeResource {
        private static final ktxVulkanFunctions ELEMENT_FACTORY = ktxVulkanFunctions.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected ktxVulkanFunctions getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="PFN_vkGetInstanceProcAddr")
        public long vkGetInstanceProcAddr() {
            return ktxVulkanFunctions.nvkGetInstanceProcAddr(this.address());
        }

        @NativeType(value="PFN_vkGetDeviceProcAddr")
        public long vkGetDeviceProcAddr() {
            return ktxVulkanFunctions.nvkGetDeviceProcAddr(this.address());
        }

        @NativeType(value="PFN_vkAllocateCommandBuffers")
        public long vkAllocateCommandBuffers() {
            return ktxVulkanFunctions.nvkAllocateCommandBuffers(this.address());
        }

        @NativeType(value="PFN_vkAllocateMemory")
        public long vkAllocateMemory() {
            return ktxVulkanFunctions.nvkAllocateMemory(this.address());
        }

        @NativeType(value="PFN_vkBeginCommandBuffer")
        public long vkBeginCommandBuffer() {
            return ktxVulkanFunctions.nvkBeginCommandBuffer(this.address());
        }

        @NativeType(value="PFN_vkBindBufferMemory")
        public long vkBindBufferMemory() {
            return ktxVulkanFunctions.nvkBindBufferMemory(this.address());
        }

        @NativeType(value="PFN_vkBindImageMemory")
        public long vkBindImageMemory() {
            return ktxVulkanFunctions.nvkBindImageMemory(this.address());
        }

        @NativeType(value="PFN_vkCmdBlitImage")
        public long vkCmdBlitImage() {
            return ktxVulkanFunctions.nvkCmdBlitImage(this.address());
        }

        @NativeType(value="PFN_vkCmdCopyBufferToImage")
        public long vkCmdCopyBufferToImage() {
            return ktxVulkanFunctions.nvkCmdCopyBufferToImage(this.address());
        }

        @NativeType(value="PFN_vkCmdPipelineBarrier")
        public long vkCmdPipelineBarrier() {
            return ktxVulkanFunctions.nvkCmdPipelineBarrier(this.address());
        }

        @NativeType(value="PFN_vkCreateImage")
        public long vkCreateImage() {
            return ktxVulkanFunctions.nvkCreateImage(this.address());
        }

        @NativeType(value="PFN_vkDestroyImage")
        public long vkDestroyImage() {
            return ktxVulkanFunctions.nvkDestroyImage(this.address());
        }

        @NativeType(value="PFN_vkCreateBuffer")
        public long vkCreateBuffer() {
            return ktxVulkanFunctions.nvkCreateBuffer(this.address());
        }

        @NativeType(value="PFN_vkDestroyBuffer")
        public long vkDestroyBuffer() {
            return ktxVulkanFunctions.nvkDestroyBuffer(this.address());
        }

        @NativeType(value="PFN_vkCreateFence")
        public long vkCreateFence() {
            return ktxVulkanFunctions.nvkCreateFence(this.address());
        }

        @NativeType(value="PFN_vkDestroyFence")
        public long vkDestroyFence() {
            return ktxVulkanFunctions.nvkDestroyFence(this.address());
        }

        @NativeType(value="PFN_vkEndCommandBuffer")
        public long vkEndCommandBuffer() {
            return ktxVulkanFunctions.nvkEndCommandBuffer(this.address());
        }

        @NativeType(value="PFN_vkFreeCommandBuffers")
        public long vkFreeCommandBuffers() {
            return ktxVulkanFunctions.nvkFreeCommandBuffers(this.address());
        }

        @NativeType(value="PFN_vkFreeMemory")
        public long vkFreeMemory() {
            return ktxVulkanFunctions.nvkFreeMemory(this.address());
        }

        @NativeType(value="PFN_vkGetBufferMemoryRequirements")
        public long vkGetBufferMemoryRequirements() {
            return ktxVulkanFunctions.nvkGetBufferMemoryRequirements(this.address());
        }

        @NativeType(value="PFN_vkGetImageMemoryRequirements")
        public long vkGetImageMemoryRequirements() {
            return ktxVulkanFunctions.nvkGetImageMemoryRequirements(this.address());
        }

        @NativeType(value="PFN_vkGetImageSubresourceLayout")
        public long vkGetImageSubresourceLayout() {
            return ktxVulkanFunctions.nvkGetImageSubresourceLayout(this.address());
        }

        @NativeType(value="PFN_vkGetPhysicalDeviceImageFormatProperties")
        public long vkGetPhysicalDeviceImageFormatProperties() {
            return ktxVulkanFunctions.nvkGetPhysicalDeviceImageFormatProperties(this.address());
        }

        @NativeType(value="PFN_vkGetPhysicalDeviceFormatProperties")
        public long vkGetPhysicalDeviceFormatProperties() {
            return ktxVulkanFunctions.nvkGetPhysicalDeviceFormatProperties(this.address());
        }

        @NativeType(value="PFN_vkGetPhysicalDeviceMemoryProperties")
        public long vkGetPhysicalDeviceMemoryProperties() {
            return ktxVulkanFunctions.nvkGetPhysicalDeviceMemoryProperties(this.address());
        }

        @NativeType(value="PFN_vkMapMemory")
        public long vkMapMemory() {
            return ktxVulkanFunctions.nvkMapMemory(this.address());
        }

        @NativeType(value="PFN_vkQueueSubmit")
        public long vkQueueSubmit() {
            return ktxVulkanFunctions.nvkQueueSubmit(this.address());
        }

        @NativeType(value="PFN_vkQueueWaitIdle")
        public long vkQueueWaitIdle() {
            return ktxVulkanFunctions.nvkQueueWaitIdle(this.address());
        }

        @NativeType(value="PFN_vkUnmapMemory")
        public long vkUnmapMemory() {
            return ktxVulkanFunctions.nvkUnmapMemory(this.address());
        }

        @NativeType(value="PFN_vkWaitForFences")
        public long vkWaitForFences() {
            return ktxVulkanFunctions.nvkWaitForFences(this.address());
        }

        public Buffer vkGetInstanceProcAddr(@NativeType(value="PFN_vkGetInstanceProcAddr") long value) {
            ktxVulkanFunctions.nvkGetInstanceProcAddr(this.address(), value);
            return this;
        }

        public Buffer vkGetDeviceProcAddr(@NativeType(value="PFN_vkGetDeviceProcAddr") long value) {
            ktxVulkanFunctions.nvkGetDeviceProcAddr(this.address(), value);
            return this;
        }

        public Buffer vkAllocateCommandBuffers(@NativeType(value="PFN_vkAllocateCommandBuffers") long value) {
            ktxVulkanFunctions.nvkAllocateCommandBuffers(this.address(), value);
            return this;
        }

        public Buffer vkAllocateMemory(@NativeType(value="PFN_vkAllocateMemory") long value) {
            ktxVulkanFunctions.nvkAllocateMemory(this.address(), value);
            return this;
        }

        public Buffer vkBeginCommandBuffer(@NativeType(value="PFN_vkBeginCommandBuffer") long value) {
            ktxVulkanFunctions.nvkBeginCommandBuffer(this.address(), value);
            return this;
        }

        public Buffer vkBindBufferMemory(@NativeType(value="PFN_vkBindBufferMemory") long value) {
            ktxVulkanFunctions.nvkBindBufferMemory(this.address(), value);
            return this;
        }

        public Buffer vkBindImageMemory(@NativeType(value="PFN_vkBindImageMemory") long value) {
            ktxVulkanFunctions.nvkBindImageMemory(this.address(), value);
            return this;
        }

        public Buffer vkCmdBlitImage(@NativeType(value="PFN_vkCmdBlitImage") long value) {
            ktxVulkanFunctions.nvkCmdBlitImage(this.address(), value);
            return this;
        }

        public Buffer vkCmdCopyBufferToImage(@NativeType(value="PFN_vkCmdCopyBufferToImage") long value) {
            ktxVulkanFunctions.nvkCmdCopyBufferToImage(this.address(), value);
            return this;
        }

        public Buffer vkCmdPipelineBarrier(@NativeType(value="PFN_vkCmdPipelineBarrier") long value) {
            ktxVulkanFunctions.nvkCmdPipelineBarrier(this.address(), value);
            return this;
        }

        public Buffer vkCreateImage(@NativeType(value="PFN_vkCreateImage") long value) {
            ktxVulkanFunctions.nvkCreateImage(this.address(), value);
            return this;
        }

        public Buffer vkDestroyImage(@NativeType(value="PFN_vkDestroyImage") long value) {
            ktxVulkanFunctions.nvkDestroyImage(this.address(), value);
            return this;
        }

        public Buffer vkCreateBuffer(@NativeType(value="PFN_vkCreateBuffer") long value) {
            ktxVulkanFunctions.nvkCreateBuffer(this.address(), value);
            return this;
        }

        public Buffer vkDestroyBuffer(@NativeType(value="PFN_vkDestroyBuffer") long value) {
            ktxVulkanFunctions.nvkDestroyBuffer(this.address(), value);
            return this;
        }

        public Buffer vkCreateFence(@NativeType(value="PFN_vkCreateFence") long value) {
            ktxVulkanFunctions.nvkCreateFence(this.address(), value);
            return this;
        }

        public Buffer vkDestroyFence(@NativeType(value="PFN_vkDestroyFence") long value) {
            ktxVulkanFunctions.nvkDestroyFence(this.address(), value);
            return this;
        }

        public Buffer vkEndCommandBuffer(@NativeType(value="PFN_vkEndCommandBuffer") long value) {
            ktxVulkanFunctions.nvkEndCommandBuffer(this.address(), value);
            return this;
        }

        public Buffer vkFreeCommandBuffers(@NativeType(value="PFN_vkFreeCommandBuffers") long value) {
            ktxVulkanFunctions.nvkFreeCommandBuffers(this.address(), value);
            return this;
        }

        public Buffer vkFreeMemory(@NativeType(value="PFN_vkFreeMemory") long value) {
            ktxVulkanFunctions.nvkFreeMemory(this.address(), value);
            return this;
        }

        public Buffer vkGetBufferMemoryRequirements(@NativeType(value="PFN_vkGetBufferMemoryRequirements") long value) {
            ktxVulkanFunctions.nvkGetBufferMemoryRequirements(this.address(), value);
            return this;
        }

        public Buffer vkGetImageMemoryRequirements(@NativeType(value="PFN_vkGetImageMemoryRequirements") long value) {
            ktxVulkanFunctions.nvkGetImageMemoryRequirements(this.address(), value);
            return this;
        }

        public Buffer vkGetImageSubresourceLayout(@NativeType(value="PFN_vkGetImageSubresourceLayout") long value) {
            ktxVulkanFunctions.nvkGetImageSubresourceLayout(this.address(), value);
            return this;
        }

        public Buffer vkGetPhysicalDeviceImageFormatProperties(@NativeType(value="PFN_vkGetPhysicalDeviceImageFormatProperties") long value) {
            ktxVulkanFunctions.nvkGetPhysicalDeviceImageFormatProperties(this.address(), value);
            return this;
        }

        public Buffer vkGetPhysicalDeviceFormatProperties(@NativeType(value="PFN_vkGetPhysicalDeviceFormatProperties") long value) {
            ktxVulkanFunctions.nvkGetPhysicalDeviceFormatProperties(this.address(), value);
            return this;
        }

        public Buffer vkGetPhysicalDeviceMemoryProperties(@NativeType(value="PFN_vkGetPhysicalDeviceMemoryProperties") long value) {
            ktxVulkanFunctions.nvkGetPhysicalDeviceMemoryProperties(this.address(), value);
            return this;
        }

        public Buffer vkMapMemory(@NativeType(value="PFN_vkMapMemory") long value) {
            ktxVulkanFunctions.nvkMapMemory(this.address(), value);
            return this;
        }

        public Buffer vkQueueSubmit(@NativeType(value="PFN_vkQueueSubmit") long value) {
            ktxVulkanFunctions.nvkQueueSubmit(this.address(), value);
            return this;
        }

        public Buffer vkQueueWaitIdle(@NativeType(value="PFN_vkQueueWaitIdle") long value) {
            ktxVulkanFunctions.nvkQueueWaitIdle(this.address(), value);
            return this;
        }

        public Buffer vkUnmapMemory(@NativeType(value="PFN_vkUnmapMemory") long value) {
            ktxVulkanFunctions.nvkUnmapMemory(this.address(), value);
            return this;
        }

        public Buffer vkWaitForFences(@NativeType(value="PFN_vkWaitForFences") long value) {
            ktxVulkanFunctions.nvkWaitForFences(this.address(), value);
            return this;
        }
    }
}

