/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lmdb;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct MDB_val")
public class MDBVal
extends Struct<MDBVal>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MV_SIZE;
    public static final int MV_DATA;

    protected MDBVal(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected MDBVal create(long address, @Nullable ByteBuffer container) {
        return new MDBVal(address, container);
    }

    public MDBVal(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), MDBVal.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long mv_size() {
        return MDBVal.nmv_size(this.address());
    }

    @NativeType(value="void *")
    public @Nullable ByteBuffer mv_data() {
        return MDBVal.nmv_data(this.address());
    }

    public MDBVal mv_size(@NativeType(value="size_t") long value) {
        MDBVal.nmv_size(this.address(), value);
        return this;
    }

    public MDBVal mv_data(@NativeType(value="void *") @Nullable ByteBuffer value) {
        MDBVal.nmv_data(this.address(), value);
        return this;
    }

    public MDBVal set(long mv_size, @Nullable ByteBuffer mv_data) {
        this.mv_size(mv_size);
        this.mv_data(mv_data);
        return this;
    }

    public MDBVal set(MDBVal src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static MDBVal malloc() {
        return new MDBVal(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static MDBVal calloc() {
        return new MDBVal(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static MDBVal create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new MDBVal(MemoryUtil.memAddress(container), container);
    }

    public static MDBVal create(long address) {
        return new MDBVal(address, null);
    }

    public static @Nullable MDBVal createSafe(long address) {
        return address == 0L ? null : new MDBVal(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(MDBVal.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MDBVal.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static MDBVal mallocStack() {
        return MDBVal.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static MDBVal callocStack() {
        return MDBVal.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static MDBVal mallocStack(MemoryStack stack) {
        return MDBVal.malloc(stack);
    }

    @Deprecated
    public static MDBVal callocStack(MemoryStack stack) {
        return MDBVal.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return MDBVal.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return MDBVal.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return MDBVal.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return MDBVal.calloc(capacity, stack);
    }

    public static MDBVal malloc(MemoryStack stack) {
        return new MDBVal(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static MDBVal calloc(MemoryStack stack) {
        return new MDBVal(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nmv_size(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)MV_SIZE);
    }

    public static @Nullable ByteBuffer nmv_data(long struct) {
        return MemoryUtil.memByteBufferSafe(MemoryUtil.memGetAddress(struct + (long)MV_DATA), (int)MDBVal.nmv_size(struct));
    }

    public static void nmv_size(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)MV_SIZE, value);
    }

    public static void nmv_data(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MV_DATA, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            MDBVal.nmv_size(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = MDBVal.__struct(MDBVal.__member(POINTER_SIZE), MDBVal.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MV_SIZE = layout.offsetof(0);
        MV_DATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<MDBVal, Buffer>
    implements NativeResource {
        private static final MDBVal ELEMENT_FACTORY = MDBVal.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected MDBVal getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="size_t")
        public long mv_size() {
            return MDBVal.nmv_size(this.address());
        }

        @NativeType(value="void *")
        public @Nullable ByteBuffer mv_data() {
            return MDBVal.nmv_data(this.address());
        }

        public Buffer mv_size(@NativeType(value="size_t") long value) {
            MDBVal.nmv_size(this.address(), value);
            return this;
        }

        public Buffer mv_data(@NativeType(value="void *") @Nullable ByteBuffer value) {
            MDBVal.nmv_data(this.address(), value);
            return this;
        }
    }
}

