/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lz4;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.lz4.LZ4StreamDecodeInternal;

@NativeType(value="union LZ4_streamDecode_t")
public class LZ4StreamDecode
extends Struct<LZ4StreamDecode> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MINSTATESIZE;
    public static final int INTERNAL_DONOTUSE;

    protected LZ4StreamDecode(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected LZ4StreamDecode create(long address, @Nullable ByteBuffer container) {
        return new LZ4StreamDecode(address, container);
    }

    public LZ4StreamDecode(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), LZ4StreamDecode.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[LZ4_STREAMDECODE_MINSIZE]")
    public ByteBuffer minStateSize() {
        return LZ4StreamDecode.nminStateSize(this.address());
    }

    @NativeType(value="char")
    public byte minStateSize(int index) {
        return LZ4StreamDecode.nminStateSize(this.address(), index);
    }

    @NativeType(value="LZ4_streamDecode_t_internal")
    public LZ4StreamDecodeInternal internal_donotuse() {
        return LZ4StreamDecode.ninternal_donotuse(this.address());
    }

    public static LZ4StreamDecode create(long address) {
        return new LZ4StreamDecode(address, null);
    }

    public static @Nullable LZ4StreamDecode createSafe(long address) {
        return address == 0L ? null : new LZ4StreamDecode(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static ByteBuffer nminStateSize(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)MINSTATESIZE, 32);
    }

    public static byte nminStateSize(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)MINSTATESIZE + Checks.check(index, 32) * 1L);
    }

    public static LZ4StreamDecodeInternal ninternal_donotuse(long struct) {
        return LZ4StreamDecodeInternal.create(struct + (long)INTERNAL_DONOTUSE);
    }

    static {
        Struct.Layout layout = LZ4StreamDecode.__union(LZ4StreamDecode.__array(1, 32), LZ4StreamDecode.__member(LZ4StreamDecodeInternal.SIZEOF, LZ4StreamDecodeInternal.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MINSTATESIZE = layout.offsetof(0);
        INTERNAL_DONOTUSE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LZ4StreamDecode, Buffer> {
        private static final LZ4StreamDecode ELEMENT_FACTORY = LZ4StreamDecode.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected LZ4StreamDecode getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[LZ4_STREAMDECODE_MINSIZE]")
        public ByteBuffer minStateSize() {
            return LZ4StreamDecode.nminStateSize(this.address());
        }

        @NativeType(value="char")
        public byte minStateSize(int index) {
            return LZ4StreamDecode.nminStateSize(this.address(), index);
        }

        @NativeType(value="LZ4_streamDecode_t_internal")
        public LZ4StreamDecodeInternal internal_donotuse() {
            return LZ4StreamDecode.ninternal_donotuse(this.address());
        }
    }
}

