/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.meshoptimizer;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct meshopt_Meshlet")
public class MeshoptMeshlet
extends Struct<MeshoptMeshlet>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VERTEX_OFFSET;
    public static final int TRIANGLE_OFFSET;
    public static final int VERTEX_COUNT;
    public static final int TRIANGLE_COUNT;

    protected MeshoptMeshlet(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected MeshoptMeshlet create(long address, @Nullable ByteBuffer container) {
        return new MeshoptMeshlet(address, container);
    }

    public MeshoptMeshlet(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), MeshoptMeshlet.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int vertex_offset() {
        return MeshoptMeshlet.nvertex_offset(this.address());
    }

    @NativeType(value="unsigned int")
    public int triangle_offset() {
        return MeshoptMeshlet.ntriangle_offset(this.address());
    }

    @NativeType(value="unsigned int")
    public int vertex_count() {
        return MeshoptMeshlet.nvertex_count(this.address());
    }

    @NativeType(value="unsigned int")
    public int triangle_count() {
        return MeshoptMeshlet.ntriangle_count(this.address());
    }

    public static MeshoptMeshlet malloc() {
        return new MeshoptMeshlet(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static MeshoptMeshlet calloc() {
        return new MeshoptMeshlet(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static MeshoptMeshlet create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new MeshoptMeshlet(MemoryUtil.memAddress(container), container);
    }

    public static MeshoptMeshlet create(long address) {
        return new MeshoptMeshlet(address, null);
    }

    public static @Nullable MeshoptMeshlet createSafe(long address) {
        return address == 0L ? null : new MeshoptMeshlet(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(MeshoptMeshlet.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MeshoptMeshlet.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static MeshoptMeshlet malloc(MemoryStack stack) {
        return new MeshoptMeshlet(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static MeshoptMeshlet calloc(MemoryStack stack) {
        return new MeshoptMeshlet(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nvertex_offset(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VERTEX_OFFSET);
    }

    public static int ntriangle_offset(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TRIANGLE_OFFSET);
    }

    public static int nvertex_count(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VERTEX_COUNT);
    }

    public static int ntriangle_count(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TRIANGLE_COUNT);
    }

    static {
        Struct.Layout layout = MeshoptMeshlet.__struct(MeshoptMeshlet.__member(4), MeshoptMeshlet.__member(4), MeshoptMeshlet.__member(4), MeshoptMeshlet.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VERTEX_OFFSET = layout.offsetof(0);
        TRIANGLE_OFFSET = layout.offsetof(1);
        VERTEX_COUNT = layout.offsetof(2);
        TRIANGLE_COUNT = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<MeshoptMeshlet, Buffer>
    implements NativeResource {
        private static final MeshoptMeshlet ELEMENT_FACTORY = MeshoptMeshlet.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected MeshoptMeshlet getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int vertex_offset() {
            return MeshoptMeshlet.nvertex_offset(this.address());
        }

        @NativeType(value="unsigned int")
        public int triangle_offset() {
            return MeshoptMeshlet.ntriangle_offset(this.address());
        }

        @NativeType(value="unsigned int")
        public int vertex_count() {
            return MeshoptMeshlet.nvertex_count(this.address());
        }

        @NativeType(value="unsigned int")
        public int triangle_count() {
            return MeshoptMeshlet.ntriangle_count(this.address());
        }
    }
}

