/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.meshoptimizer;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct meshopt_VertexCacheStatistics")
public class MeshoptVertexCacheStatistics
extends Struct<MeshoptVertexCacheStatistics>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VERTICES_TRANSFORMED;
    public static final int WARPS_EXECUTED;
    public static final int ACMR;
    public static final int ATVR;

    protected MeshoptVertexCacheStatistics(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected MeshoptVertexCacheStatistics create(long address, @Nullable ByteBuffer container) {
        return new MeshoptVertexCacheStatistics(address, container);
    }

    public MeshoptVertexCacheStatistics(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), MeshoptVertexCacheStatistics.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int vertices_transformed() {
        return MeshoptVertexCacheStatistics.nvertices_transformed(this.address());
    }

    @NativeType(value="unsigned int")
    public int warps_executed() {
        return MeshoptVertexCacheStatistics.nwarps_executed(this.address());
    }

    public float acmr() {
        return MeshoptVertexCacheStatistics.nacmr(this.address());
    }

    public float atvr() {
        return MeshoptVertexCacheStatistics.natvr(this.address());
    }

    public static MeshoptVertexCacheStatistics malloc() {
        return new MeshoptVertexCacheStatistics(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static MeshoptVertexCacheStatistics calloc() {
        return new MeshoptVertexCacheStatistics(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static MeshoptVertexCacheStatistics create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new MeshoptVertexCacheStatistics(MemoryUtil.memAddress(container), container);
    }

    public static MeshoptVertexCacheStatistics create(long address) {
        return new MeshoptVertexCacheStatistics(address, null);
    }

    public static @Nullable MeshoptVertexCacheStatistics createSafe(long address) {
        return address == 0L ? null : new MeshoptVertexCacheStatistics(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(MeshoptVertexCacheStatistics.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MeshoptVertexCacheStatistics.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static MeshoptVertexCacheStatistics malloc(MemoryStack stack) {
        return new MeshoptVertexCacheStatistics(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static MeshoptVertexCacheStatistics calloc(MemoryStack stack) {
        return new MeshoptVertexCacheStatistics(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nvertices_transformed(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VERTICES_TRANSFORMED);
    }

    public static int nwarps_executed(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WARPS_EXECUTED);
    }

    public static float nacmr(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)ACMR);
    }

    public static float natvr(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)ATVR);
    }

    static {
        Struct.Layout layout = MeshoptVertexCacheStatistics.__struct(MeshoptVertexCacheStatistics.__member(4), MeshoptVertexCacheStatistics.__member(4), MeshoptVertexCacheStatistics.__member(4), MeshoptVertexCacheStatistics.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VERTICES_TRANSFORMED = layout.offsetof(0);
        WARPS_EXECUTED = layout.offsetof(1);
        ACMR = layout.offsetof(2);
        ATVR = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<MeshoptVertexCacheStatistics, Buffer>
    implements NativeResource {
        private static final MeshoptVertexCacheStatistics ELEMENT_FACTORY = MeshoptVertexCacheStatistics.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected MeshoptVertexCacheStatistics getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int vertices_transformed() {
            return MeshoptVertexCacheStatistics.nvertices_transformed(this.address());
        }

        @NativeType(value="unsigned int")
        public int warps_executed() {
            return MeshoptVertexCacheStatistics.nwarps_executed(this.address());
        }

        public float acmr() {
            return MeshoptVertexCacheStatistics.nacmr(this.address());
        }

        public float atvr() {
            return MeshoptVertexCacheStatistics.natvr(this.address());
        }
    }
}

