/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.msdfgen;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct msdf_bitmap")
public class MSDFGenBitmap
extends Struct<MSDFGenBitmap>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int HANDLE;

    protected MSDFGenBitmap(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected MSDFGenBitmap create(long address, @Nullable ByteBuffer container) {
        return new MSDFGenBitmap(address, container);
    }

    public MSDFGenBitmap(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), MSDFGenBitmap.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int type() {
        return MSDFGenBitmap.ntype(this.address());
    }

    public int width() {
        return MSDFGenBitmap.nwidth(this.address());
    }

    public int height() {
        return MSDFGenBitmap.nheight(this.address());
    }

    @NativeType(value="void *")
    public long handle() {
        return MSDFGenBitmap.nhandle(this.address());
    }

    public MSDFGenBitmap type(int value) {
        MSDFGenBitmap.ntype(this.address(), value);
        return this;
    }

    public MSDFGenBitmap width(int value) {
        MSDFGenBitmap.nwidth(this.address(), value);
        return this;
    }

    public MSDFGenBitmap height(int value) {
        MSDFGenBitmap.nheight(this.address(), value);
        return this;
    }

    public MSDFGenBitmap handle(@NativeType(value="void *") long value) {
        MSDFGenBitmap.nhandle(this.address(), value);
        return this;
    }

    public MSDFGenBitmap set(int type, int width, int height, long handle) {
        this.type(type);
        this.width(width);
        this.height(height);
        this.handle(handle);
        return this;
    }

    public MSDFGenBitmap set(MSDFGenBitmap src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static MSDFGenBitmap malloc() {
        return new MSDFGenBitmap(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static MSDFGenBitmap calloc() {
        return new MSDFGenBitmap(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static MSDFGenBitmap create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new MSDFGenBitmap(MemoryUtil.memAddress(container), container);
    }

    public static MSDFGenBitmap create(long address) {
        return new MSDFGenBitmap(address, null);
    }

    public static @Nullable MSDFGenBitmap createSafe(long address) {
        return address == 0L ? null : new MSDFGenBitmap(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(MSDFGenBitmap.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MSDFGenBitmap.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static MSDFGenBitmap malloc(MemoryStack stack) {
        return new MSDFGenBitmap(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static MSDFGenBitmap calloc(MemoryStack stack) {
        return new MSDFGenBitmap(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static int nwidth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HEIGHT);
    }

    public static long nhandle(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HANDLE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nwidth(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HEIGHT, value);
    }

    public static void nhandle(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HANDLE, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)HANDLE));
    }

    static {
        Struct.Layout layout = MSDFGenBitmap.__struct(MSDFGenBitmap.__member(4), MSDFGenBitmap.__member(4), MSDFGenBitmap.__member(4), MSDFGenBitmap.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        WIDTH = layout.offsetof(1);
        HEIGHT = layout.offsetof(2);
        HANDLE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<MSDFGenBitmap, Buffer>
    implements NativeResource {
        private static final MSDFGenBitmap ELEMENT_FACTORY = MSDFGenBitmap.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected MSDFGenBitmap getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int type() {
            return MSDFGenBitmap.ntype(this.address());
        }

        public int width() {
            return MSDFGenBitmap.nwidth(this.address());
        }

        public int height() {
            return MSDFGenBitmap.nheight(this.address());
        }

        @NativeType(value="void *")
        public long handle() {
            return MSDFGenBitmap.nhandle(this.address());
        }

        public Buffer type(int value) {
            MSDFGenBitmap.ntype(this.address(), value);
            return this;
        }

        public Buffer width(int value) {
            MSDFGenBitmap.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(int value) {
            MSDFGenBitmap.nheight(this.address(), value);
            return this;
        }

        public Buffer handle(@NativeType(value="void *") long value) {
            MSDFGenBitmap.nhandle(this.address(), value);
            return this;
        }
    }
}

