/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.msdfgen;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct msdf_multichannel_config")
public class MSDFGenMultichannelConfig
extends Struct<MSDFGenMultichannelConfig>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OVERLAP_SUPPORT;
    public static final int MODE;
    public static final int DISTANCE_CHECK_MODE;
    public static final int MIN_DEVIATION_RATIO;
    public static final int MIN_IMPROVE_RATIO;

    protected MSDFGenMultichannelConfig(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected MSDFGenMultichannelConfig create(long address, @Nullable ByteBuffer container) {
        return new MSDFGenMultichannelConfig(address, container);
    }

    public MSDFGenMultichannelConfig(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), MSDFGenMultichannelConfig.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int overlap_support() {
        return MSDFGenMultichannelConfig.noverlap_support(this.address());
    }

    public int mode() {
        return MSDFGenMultichannelConfig.nmode(this.address());
    }

    public int distance_check_mode() {
        return MSDFGenMultichannelConfig.ndistance_check_mode(this.address());
    }

    public double min_deviation_ratio() {
        return MSDFGenMultichannelConfig.nmin_deviation_ratio(this.address());
    }

    public double min_improve_ratio() {
        return MSDFGenMultichannelConfig.nmin_improve_ratio(this.address());
    }

    public MSDFGenMultichannelConfig overlap_support(int value) {
        MSDFGenMultichannelConfig.noverlap_support(this.address(), value);
        return this;
    }

    public MSDFGenMultichannelConfig mode(int value) {
        MSDFGenMultichannelConfig.nmode(this.address(), value);
        return this;
    }

    public MSDFGenMultichannelConfig distance_check_mode(int value) {
        MSDFGenMultichannelConfig.ndistance_check_mode(this.address(), value);
        return this;
    }

    public MSDFGenMultichannelConfig min_deviation_ratio(double value) {
        MSDFGenMultichannelConfig.nmin_deviation_ratio(this.address(), value);
        return this;
    }

    public MSDFGenMultichannelConfig min_improve_ratio(double value) {
        MSDFGenMultichannelConfig.nmin_improve_ratio(this.address(), value);
        return this;
    }

    public MSDFGenMultichannelConfig set(int overlap_support, int mode, int distance_check_mode, double min_deviation_ratio, double min_improve_ratio) {
        this.overlap_support(overlap_support);
        this.mode(mode);
        this.distance_check_mode(distance_check_mode);
        this.min_deviation_ratio(min_deviation_ratio);
        this.min_improve_ratio(min_improve_ratio);
        return this;
    }

    public MSDFGenMultichannelConfig set(MSDFGenMultichannelConfig src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static MSDFGenMultichannelConfig malloc() {
        return new MSDFGenMultichannelConfig(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static MSDFGenMultichannelConfig calloc() {
        return new MSDFGenMultichannelConfig(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static MSDFGenMultichannelConfig create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new MSDFGenMultichannelConfig(MemoryUtil.memAddress(container), container);
    }

    public static MSDFGenMultichannelConfig create(long address) {
        return new MSDFGenMultichannelConfig(address, null);
    }

    public static @Nullable MSDFGenMultichannelConfig createSafe(long address) {
        return address == 0L ? null : new MSDFGenMultichannelConfig(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(MSDFGenMultichannelConfig.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MSDFGenMultichannelConfig.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static MSDFGenMultichannelConfig malloc(MemoryStack stack) {
        return new MSDFGenMultichannelConfig(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static MSDFGenMultichannelConfig calloc(MemoryStack stack) {
        return new MSDFGenMultichannelConfig(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int noverlap_support(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OVERLAP_SUPPORT);
    }

    public static int nmode(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MODE);
    }

    public static int ndistance_check_mode(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DISTANCE_CHECK_MODE);
    }

    public static double nmin_deviation_ratio(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)MIN_DEVIATION_RATIO);
    }

    public static double nmin_improve_ratio(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)MIN_IMPROVE_RATIO);
    }

    public static void noverlap_support(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)OVERLAP_SUPPORT, value);
    }

    public static void nmode(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MODE, value);
    }

    public static void ndistance_check_mode(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DISTANCE_CHECK_MODE, value);
    }

    public static void nmin_deviation_ratio(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)MIN_DEVIATION_RATIO, value);
    }

    public static void nmin_improve_ratio(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)MIN_IMPROVE_RATIO, value);
    }

    static {
        Struct.Layout layout = MSDFGenMultichannelConfig.__struct(MSDFGenMultichannelConfig.__member(4), MSDFGenMultichannelConfig.__member(4), MSDFGenMultichannelConfig.__member(4), MSDFGenMultichannelConfig.__member(8), MSDFGenMultichannelConfig.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OVERLAP_SUPPORT = layout.offsetof(0);
        MODE = layout.offsetof(1);
        DISTANCE_CHECK_MODE = layout.offsetof(2);
        MIN_DEVIATION_RATIO = layout.offsetof(3);
        MIN_IMPROVE_RATIO = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<MSDFGenMultichannelConfig, Buffer>
    implements NativeResource {
        private static final MSDFGenMultichannelConfig ELEMENT_FACTORY = MSDFGenMultichannelConfig.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected MSDFGenMultichannelConfig getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int overlap_support() {
            return MSDFGenMultichannelConfig.noverlap_support(this.address());
        }

        public int mode() {
            return MSDFGenMultichannelConfig.nmode(this.address());
        }

        public int distance_check_mode() {
            return MSDFGenMultichannelConfig.ndistance_check_mode(this.address());
        }

        public double min_deviation_ratio() {
            return MSDFGenMultichannelConfig.nmin_deviation_ratio(this.address());
        }

        public double min_improve_ratio() {
            return MSDFGenMultichannelConfig.nmin_improve_ratio(this.address());
        }

        public Buffer overlap_support(int value) {
            MSDFGenMultichannelConfig.noverlap_support(this.address(), value);
            return this;
        }

        public Buffer mode(int value) {
            MSDFGenMultichannelConfig.nmode(this.address(), value);
            return this;
        }

        public Buffer distance_check_mode(int value) {
            MSDFGenMultichannelConfig.ndistance_check_mode(this.address(), value);
            return this;
        }

        public Buffer min_deviation_ratio(double value) {
            MSDFGenMultichannelConfig.nmin_deviation_ratio(this.address(), value);
            return this;
        }

        public Buffer min_improve_ratio(double value) {
            MSDFGenMultichannelConfig.nmin_improve_ratio(this.address(), value);
            return this;
        }
    }
}

