/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.opus;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OpusHead
extends Struct<OpusHead>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VERSION;
    public static final int CHANNEL_COUNT;
    public static final int PRE_SKIP;
    public static final int INPUT_SAMPLE_RATE;
    public static final int OUTPUT_GAIN;
    public static final int MAPPING_FAMILY;
    public static final int STREAM_COUNT;
    public static final int COUPLED_COUNT;
    public static final int MAPPING;

    protected OpusHead(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected OpusHead create(long address, @Nullable ByteBuffer container) {
        return new OpusHead(address, container);
    }

    public OpusHead(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), OpusHead.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int version() {
        return OpusHead.nversion(this.address());
    }

    public int channel_count() {
        return OpusHead.nchannel_count(this.address());
    }

    @NativeType(value="unsigned int")
    public int pre_skip() {
        return OpusHead.npre_skip(this.address());
    }

    @NativeType(value="opus_uint32")
    public int input_sample_rate() {
        return OpusHead.ninput_sample_rate(this.address());
    }

    public int output_gain() {
        return OpusHead.noutput_gain(this.address());
    }

    public int mapping_family() {
        return OpusHead.nmapping_family(this.address());
    }

    public int stream_count() {
        return OpusHead.nstream_count(this.address());
    }

    public int coupled_count() {
        return OpusHead.ncoupled_count(this.address());
    }

    @NativeType(value="unsigned char[255]")
    public ByteBuffer mapping() {
        return OpusHead.nmapping(this.address());
    }

    @NativeType(value="unsigned char")
    public byte mapping(int index) {
        return OpusHead.nmapping(this.address(), index);
    }

    public static OpusHead malloc() {
        return new OpusHead(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static OpusHead calloc() {
        return new OpusHead(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static OpusHead create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new OpusHead(MemoryUtil.memAddress(container), container);
    }

    public static OpusHead create(long address) {
        return new OpusHead(address, null);
    }

    public static @Nullable OpusHead createSafe(long address) {
        return address == 0L ? null : new OpusHead(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(OpusHead.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OpusHead.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static OpusHead malloc(MemoryStack stack) {
        return new OpusHead(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OpusHead calloc(MemoryStack stack) {
        return new OpusHead(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nversion(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VERSION);
    }

    public static int nchannel_count(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CHANNEL_COUNT);
    }

    public static int npre_skip(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PRE_SKIP);
    }

    public static int ninput_sample_rate(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INPUT_SAMPLE_RATE);
    }

    public static int noutput_gain(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OUTPUT_GAIN);
    }

    public static int nmapping_family(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAPPING_FAMILY);
    }

    public static int nstream_count(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STREAM_COUNT);
    }

    public static int ncoupled_count(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COUPLED_COUNT);
    }

    public static ByteBuffer nmapping(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)MAPPING, 255);
    }

    public static byte nmapping(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)MAPPING + Checks.check(index, 255) * 1L);
    }

    static {
        Struct.Layout layout = OpusHead.__struct(OpusHead.__member(4), OpusHead.__member(4), OpusHead.__member(4), OpusHead.__member(4), OpusHead.__member(4), OpusHead.__member(4), OpusHead.__member(4), OpusHead.__member(4), OpusHead.__array(1, 255));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VERSION = layout.offsetof(0);
        CHANNEL_COUNT = layout.offsetof(1);
        PRE_SKIP = layout.offsetof(2);
        INPUT_SAMPLE_RATE = layout.offsetof(3);
        OUTPUT_GAIN = layout.offsetof(4);
        MAPPING_FAMILY = layout.offsetof(5);
        STREAM_COUNT = layout.offsetof(6);
        COUPLED_COUNT = layout.offsetof(7);
        MAPPING = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<OpusHead, Buffer>
    implements NativeResource {
        private static final OpusHead ELEMENT_FACTORY = OpusHead.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected OpusHead getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int version() {
            return OpusHead.nversion(this.address());
        }

        public int channel_count() {
            return OpusHead.nchannel_count(this.address());
        }

        @NativeType(value="unsigned int")
        public int pre_skip() {
            return OpusHead.npre_skip(this.address());
        }

        @NativeType(value="opus_uint32")
        public int input_sample_rate() {
            return OpusHead.ninput_sample_rate(this.address());
        }

        public int output_gain() {
            return OpusHead.noutput_gain(this.address());
        }

        public int mapping_family() {
            return OpusHead.nmapping_family(this.address());
        }

        public int stream_count() {
            return OpusHead.nstream_count(this.address());
        }

        public int coupled_count() {
            return OpusHead.ncoupled_count(this.address());
        }

        @NativeType(value="unsigned char[255]")
        public ByteBuffer mapping() {
            return OpusHead.nmapping(this.address());
        }

        @NativeType(value="unsigned char")
        public byte mapping(int index) {
            return OpusHead.nmapping(this.address(), index);
        }
    }
}

