/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.opus;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.util.opus.Opus;

public class OpusMultistream {
    public static final int OPUS_MULTISTREAM_GET_ENCODER_STATE_REQUEST = 5120;
    public static final int OPUS_MULTISTREAM_GET_DECODER_STATE_REQUEST = 5122;

    protected OpusMultistream() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="opus_int32")
    public static int opus_multistream_encoder_get_size(int streams, int coupled_streams) {
        long __functionAddress = Functions.multistream_encoder_get_size;
        return JNI.invokeI(streams, coupled_streams, __functionAddress);
    }

    @NativeType(value="opus_int32")
    public static int opus_multistream_surround_encoder_get_size(int channels, int mapping_family) {
        long __functionAddress = Functions.multistream_surround_encoder_get_size;
        return JNI.invokeI(channels, mapping_family, __functionAddress);
    }

    public static long nopus_multistream_encoder_create(int Fs2, int channels, int streams, int coupled_streams, long mapping, int application, long error) {
        long __functionAddress = Functions.multistream_encoder_create;
        return JNI.invokePPP(Fs2, channels, streams, coupled_streams, mapping, application, error, __functionAddress);
    }

    @NativeType(value="OpusMSEncoder *")
    public static long opus_multistream_encoder_create(@NativeType(value="opus_int32") int Fs2, int streams, int coupled_streams, @NativeType(value="unsigned char const *") ByteBuffer mapping, int application, @NativeType(value="int *") @Nullable IntBuffer error) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)error, 1);
        }
        return OpusMultistream.nopus_multistream_encoder_create(Fs2, mapping.remaining(), streams, coupled_streams, MemoryUtil.memAddress(mapping), application, MemoryUtil.memAddressSafe(error));
    }

    public static long nopus_multistream_surround_encoder_create(int Fs2, int channels, int mapping_family, long streams, long coupled_streams, long mapping, int application, long error) {
        long __functionAddress = Functions.multistream_surround_encoder_create;
        return JNI.invokePPPPP(Fs2, channels, mapping_family, streams, coupled_streams, mapping, application, error, __functionAddress);
    }

    @NativeType(value="OpusMSEncoder *")
    public static long opus_multistream_surround_encoder_create(@NativeType(value="opus_int32") int Fs2, int mapping_family, @NativeType(value="int *") IntBuffer streams, @NativeType(value="int *") IntBuffer coupled_streams, @NativeType(value="unsigned char *") ByteBuffer mapping, int application, @NativeType(value="int *") @Nullable IntBuffer error) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)streams, 1);
            Checks.check((Buffer)coupled_streams, 1);
            Checks.checkSafe((Buffer)error, 1);
        }
        return OpusMultistream.nopus_multistream_surround_encoder_create(Fs2, mapping.remaining(), mapping_family, MemoryUtil.memAddress(streams), MemoryUtil.memAddress(coupled_streams), MemoryUtil.memAddress(mapping), application, MemoryUtil.memAddressSafe(error));
    }

    public static int nopus_multistream_encoder_init(long st, int Fs2, int channels, int streams, int coupled_streams, long mapping, int application) {
        long __functionAddress = Functions.multistream_encoder_init;
        if (Checks.CHECKS) {
            Checks.check(st);
        }
        return JNI.invokePPI(st, Fs2, channels, streams, coupled_streams, mapping, application, __functionAddress);
    }

    public static int opus_multistream_encoder_init(@NativeType(value="OpusMSEncoder *") long st, @NativeType(value="opus_int32") int Fs2, int streams, int coupled_streams, @NativeType(value="unsigned char const *") ByteBuffer mapping, int application) {
        return OpusMultistream.nopus_multistream_encoder_init(st, Fs2, mapping.remaining(), streams, coupled_streams, MemoryUtil.memAddress(mapping), application);
    }

    public static int nopus_multistream_surround_encoder_init(long st, int Fs2, int channels, long streams, long coupled_streams, long mapping, int application) {
        long __functionAddress = Functions.multistream_surround_encoder_init;
        if (Checks.CHECKS) {
            Checks.check(st);
        }
        return JNI.invokePPPPI(st, Fs2, channels, streams, coupled_streams, mapping, application, __functionAddress);
    }

    public static int opus_multistream_surround_encoder_init(@NativeType(value="OpusMSEncoder *") long st, @NativeType(value="opus_int32") int Fs2, @NativeType(value="int *") IntBuffer streams, @NativeType(value="int *") IntBuffer coupled_streams, @NativeType(value="unsigned char const *") ByteBuffer mapping, int application) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)streams, 1);
            Checks.check((Buffer)coupled_streams, 1);
        }
        return OpusMultistream.nopus_multistream_surround_encoder_init(st, Fs2, mapping.remaining(), MemoryUtil.memAddress(streams), MemoryUtil.memAddress(coupled_streams), MemoryUtil.memAddress(mapping), application);
    }

    public static int nopus_multistream_encode(long st, long pcm, int frame_size, long data, int max_data_bytes) {
        long __functionAddress = Functions.multistream_encode;
        if (Checks.CHECKS) {
            Checks.check(st);
        }
        return JNI.invokePPPI(st, pcm, frame_size, data, max_data_bytes, __functionAddress);
    }

    public static int opus_multistream_encode(@NativeType(value="OpusMSEncoder *") long st, @NativeType(value="opus_int16 const *") ShortBuffer pcm, int frame_size, @NativeType(value="unsigned char *") ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pcm, frame_size * MemoryUtil.memGetInt(st));
        }
        return OpusMultistream.nopus_multistream_encode(st, MemoryUtil.memAddress(pcm), frame_size, MemoryUtil.memAddress(data), data.remaining());
    }

    public static int nopus_multistream_encode_float(long st, long pcm, int frame_size, long data, int max_data_bytes) {
        long __functionAddress = Functions.multistream_encode_float;
        if (Checks.CHECKS) {
            Checks.check(st);
        }
        return JNI.invokePPPI(st, pcm, frame_size, data, max_data_bytes, __functionAddress);
    }

    public static int opus_multistream_encode_float(@NativeType(value="OpusMSEncoder *") long st, @NativeType(value="float const *") FloatBuffer pcm, int frame_size, @NativeType(value="unsigned char *") ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pcm, frame_size * MemoryUtil.memGetInt(st));
        }
        return OpusMultistream.nopus_multistream_encode_float(st, MemoryUtil.memAddress(pcm), frame_size, MemoryUtil.memAddress(data), data.remaining());
    }

    public static void opus_multistream_encoder_destroy(@NativeType(value="OpusMSEncoder *") long st) {
        long __functionAddress = Functions.multistream_encoder_destroy;
        if (Checks.CHECKS) {
            Checks.check(st);
        }
        JNI.invokePV(st, __functionAddress);
    }

    private static int opus_multistream_encoder_ctl(@NativeType(value="OpusMSEncoder *") long st) {
        long __functionAddress = Functions.multistream_encoder_ctl;
        if (Checks.CHECKS) {
            Checks.check(st);
        }
        return JNI.invokePI(st, __functionAddress);
    }

    @NativeType(value="opus_int32")
    public static int opus_multistream_decoder_get_size(int streams, int coupled_streams) {
        long __functionAddress = Functions.multistream_decoder_get_size;
        return JNI.invokeI(streams, coupled_streams, __functionAddress);
    }

    public static long nopus_multistream_decoder_create(int Fs2, int channels, int streams, int coupled_streams, long mapping, long error) {
        long __functionAddress = Functions.multistream_decoder_create;
        return JNI.invokePPP(Fs2, channels, streams, coupled_streams, mapping, error, __functionAddress);
    }

    @NativeType(value="OpusMSDecoder *")
    public static long opus_multistream_decoder_create(@NativeType(value="opus_int32") int Fs2, int streams, int coupled_streams, @NativeType(value="unsigned char const *") ByteBuffer mapping, @NativeType(value="int *") @Nullable IntBuffer error) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)error, 1);
        }
        return OpusMultistream.nopus_multistream_decoder_create(Fs2, mapping.remaining(), streams, coupled_streams, MemoryUtil.memAddress(mapping), MemoryUtil.memAddressSafe(error));
    }

    public static int nopus_multistream_decoder_init(long st, int Fs2, int channels, int streams, int coupled_streams, long mapping) {
        long __functionAddress = Functions.multistream_decoder_init;
        if (Checks.CHECKS) {
            Checks.check(st);
        }
        return JNI.invokePPI(st, Fs2, channels, streams, coupled_streams, mapping, __functionAddress);
    }

    public static int opus_multistream_decoder_init(@NativeType(value="OpusMSDecoder *") long st, @NativeType(value="opus_int32") int Fs2, int streams, int coupled_streams, @NativeType(value="unsigned char const *") ByteBuffer mapping) {
        return OpusMultistream.nopus_multistream_decoder_init(st, Fs2, mapping.remaining(), streams, coupled_streams, MemoryUtil.memAddress(mapping));
    }

    public static int nopus_multistream_decode(long st, long data, int len, long pcm, int frame_size, int decode_fec) {
        long __functionAddress = Functions.multistream_decode;
        if (Checks.CHECKS) {
            Checks.check(st);
        }
        return JNI.invokePPPI(st, data, len, pcm, frame_size, decode_fec, __functionAddress);
    }

    public static int opus_multistream_decode(@NativeType(value="OpusMSDecoder *") long st, @NativeType(value="unsigned char const *") @Nullable ByteBuffer data, @NativeType(value="opus_int16 *") ShortBuffer pcm, int frame_size, int decode_fec) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pcm, frame_size * MemoryUtil.memGetInt(st));
        }
        return OpusMultistream.nopus_multistream_decode(st, MemoryUtil.memAddressSafe(data), Checks.remainingSafe(data), MemoryUtil.memAddress(pcm), frame_size, decode_fec);
    }

    public static int nopus_multistream_decode_float(long st, long data, int len, long pcm, int frame_size, int decode_fec) {
        long __functionAddress = Functions.multistream_decode_float;
        if (Checks.CHECKS) {
            Checks.check(st);
        }
        return JNI.invokePPPI(st, data, len, pcm, frame_size, decode_fec, __functionAddress);
    }

    public static int opus_multistream_decode_float(@NativeType(value="OpusMSDecoder *") long st, @NativeType(value="unsigned char const *") @Nullable ByteBuffer data, @NativeType(value="float *") FloatBuffer pcm, int frame_size, int decode_fec) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pcm, frame_size * MemoryUtil.memGetInt(st));
        }
        return OpusMultistream.nopus_multistream_decode_float(st, MemoryUtil.memAddressSafe(data), Checks.remainingSafe(data), MemoryUtil.memAddress(pcm), frame_size, decode_fec);
    }

    private static int opus_multistream_decoder_ctl(@NativeType(value="OpusMSDecoder *") long st) {
        long __functionAddress = Functions.multistream_decoder_ctl;
        if (Checks.CHECKS) {
            Checks.check(st);
        }
        return JNI.invokePI(st, __functionAddress);
    }

    public static void opus_multistream_decoder_destroy(@NativeType(value="OpusMSDecoder *") long st) {
        long __functionAddress = Functions.multistream_decoder_destroy;
        if (Checks.CHECKS) {
            Checks.check(st);
        }
        JNI.invokePV(st, __functionAddress);
    }

    public static int opus_multistream_encoder_ctl(@NativeType(value="OpusMSEncoder *") long st, int request) {
        return new Opus.CTLRequestV(request).apply(st, Functions.multistream_encoder_ctl);
    }

    public static int opus_multistream_encoder_ctl(@NativeType(value="OpusMSEncoder *") long st, Opus.CTLRequest request) {
        return request.apply(st, Functions.multistream_encoder_ctl);
    }

    public static int opus_multistream_decoder_ctl(@NativeType(value="OpusMSDecoder *") long st, int request) {
        return new Opus.CTLRequestV(request).apply(st, Functions.multistream_decoder_ctl);
    }

    public static int opus_multistream_decoder_ctl(@NativeType(value="OpusMSDecoder *") long st, Opus.CTLRequest request) {
        return request.apply(st, Functions.multistream_decoder_ctl);
    }

    public static final class Functions {
        public static final long multistream_encoder_get_size = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_multistream_encoder_get_size");
        public static final long multistream_surround_encoder_get_size = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_multistream_surround_encoder_get_size");
        public static final long multistream_encoder_create = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_multistream_encoder_create");
        public static final long multistream_surround_encoder_create = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_multistream_surround_encoder_create");
        public static final long multistream_encoder_init = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_multistream_encoder_init");
        public static final long multistream_surround_encoder_init = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_multistream_surround_encoder_init");
        public static final long multistream_encode = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_multistream_encode");
        public static final long multistream_encode_float = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_multistream_encode_float");
        public static final long multistream_encoder_destroy = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_multistream_encoder_destroy");
        public static final long multistream_encoder_ctl = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_multistream_encoder_ctl");
        public static final long multistream_decoder_get_size = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_multistream_decoder_get_size");
        public static final long multistream_decoder_create = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_multistream_decoder_create");
        public static final long multistream_decoder_init = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_multistream_decoder_init");
        public static final long multistream_decode = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_multistream_decode");
        public static final long multistream_decode_float = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_multistream_decode_float");
        public static final long multistream_decoder_ctl = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_multistream_decoder_ctl");
        public static final long multistream_decoder_destroy = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_multistream_decoder_destroy");

        private Functions() {
        }
    }
}

