/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.opus;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OpusTags
extends Struct<OpusTags>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int USER_COMMENTS;
    public static final int COMMENT_LENGTHS;
    public static final int COMMENTS;
    public static final int VENDOR;

    protected OpusTags(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected OpusTags create(long address, @Nullable ByteBuffer container) {
        return new OpusTags(address, container);
    }

    public OpusTags(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), OpusTags.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char **")
    public PointerBuffer user_comments() {
        return OpusTags.nuser_comments(this.address());
    }

    @NativeType(value="int *")
    public IntBuffer comment_lengths() {
        return OpusTags.ncomment_lengths(this.address());
    }

    public int comments() {
        return OpusTags.ncomments(this.address());
    }

    @NativeType(value="char *")
    public ByteBuffer vendor() {
        return OpusTags.nvendor(this.address());
    }

    @NativeType(value="char *")
    public String vendorString() {
        return OpusTags.nvendorString(this.address());
    }

    public static OpusTags malloc() {
        return new OpusTags(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static OpusTags calloc() {
        return new OpusTags(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static OpusTags create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new OpusTags(MemoryUtil.memAddress(container), container);
    }

    public static OpusTags create(long address) {
        return new OpusTags(address, null);
    }

    public static @Nullable OpusTags createSafe(long address) {
        return address == 0L ? null : new OpusTags(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(OpusTags.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OpusTags.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static OpusTags malloc(MemoryStack stack) {
        return new OpusTags(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OpusTags calloc(MemoryStack stack) {
        return new OpusTags(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static PointerBuffer nuser_comments(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)USER_COMMENTS), OpusTags.ncomments(struct));
    }

    public static IntBuffer ncomment_lengths(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)COMMENT_LENGTHS), OpusTags.ncomments(struct));
    }

    public static int ncomments(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COMMENTS);
    }

    public static ByteBuffer nvendor(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)VENDOR));
    }

    public static String nvendorString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)VENDOR));
    }

    static {
        Struct.Layout layout = OpusTags.__struct(OpusTags.__member(POINTER_SIZE), OpusTags.__member(POINTER_SIZE), OpusTags.__member(4), OpusTags.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        USER_COMMENTS = layout.offsetof(0);
        COMMENT_LENGTHS = layout.offsetof(1);
        COMMENTS = layout.offsetof(2);
        VENDOR = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<OpusTags, Buffer>
    implements NativeResource {
        private static final OpusTags ELEMENT_FACTORY = OpusTags.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected OpusTags getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char **")
        public PointerBuffer user_comments() {
            return OpusTags.nuser_comments(this.address());
        }

        @NativeType(value="int *")
        public IntBuffer comment_lengths() {
            return OpusTags.ncomment_lengths(this.address());
        }

        public int comments() {
            return OpusTags.ncomments(this.address());
        }

        @NativeType(value="char *")
        public ByteBuffer vendor() {
            return OpusTags.nvendor(this.address());
        }

        @NativeType(value="char *")
        public String vendorString() {
            return OpusTags.nvendorString(this.address());
        }
    }
}

