/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.par;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct par_octasphere_config")
public class ParOctasphereConfig
extends Struct<ParOctasphereConfig>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CORNER_RADIUS;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int DEPTH;
    public static final int NUM_SUBDIVISIONS;
    public static final int UV_MODE;
    public static final int NORMALS_MODE;

    protected ParOctasphereConfig(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected ParOctasphereConfig create(long address, @Nullable ByteBuffer container) {
        return new ParOctasphereConfig(address, container);
    }

    public ParOctasphereConfig(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), ParOctasphereConfig.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float corner_radius() {
        return ParOctasphereConfig.ncorner_radius(this.address());
    }

    public float width() {
        return ParOctasphereConfig.nwidth(this.address());
    }

    public float height() {
        return ParOctasphereConfig.nheight(this.address());
    }

    public float depth() {
        return ParOctasphereConfig.ndepth(this.address());
    }

    public int num_subdivisions() {
        return ParOctasphereConfig.nnum_subdivisions(this.address());
    }

    @NativeType(value="par_octasphere_uv_mode")
    public int uv_mode() {
        return ParOctasphereConfig.nuv_mode(this.address());
    }

    @NativeType(value="par_octasphere_normals_mode")
    public int normals_mode() {
        return ParOctasphereConfig.nnormals_mode(this.address());
    }

    public ParOctasphereConfig corner_radius(float value) {
        ParOctasphereConfig.ncorner_radius(this.address(), value);
        return this;
    }

    public ParOctasphereConfig width(float value) {
        ParOctasphereConfig.nwidth(this.address(), value);
        return this;
    }

    public ParOctasphereConfig height(float value) {
        ParOctasphereConfig.nheight(this.address(), value);
        return this;
    }

    public ParOctasphereConfig depth(float value) {
        ParOctasphereConfig.ndepth(this.address(), value);
        return this;
    }

    public ParOctasphereConfig num_subdivisions(int value) {
        ParOctasphereConfig.nnum_subdivisions(this.address(), value);
        return this;
    }

    public ParOctasphereConfig uv_mode(@NativeType(value="par_octasphere_uv_mode") int value) {
        ParOctasphereConfig.nuv_mode(this.address(), value);
        return this;
    }

    public ParOctasphereConfig normals_mode(@NativeType(value="par_octasphere_normals_mode") int value) {
        ParOctasphereConfig.nnormals_mode(this.address(), value);
        return this;
    }

    public ParOctasphereConfig set(float corner_radius, float width, float height, float depth, int num_subdivisions, int uv_mode, int normals_mode) {
        this.corner_radius(corner_radius);
        this.width(width);
        this.height(height);
        this.depth(depth);
        this.num_subdivisions(num_subdivisions);
        this.uv_mode(uv_mode);
        this.normals_mode(normals_mode);
        return this;
    }

    public ParOctasphereConfig set(ParOctasphereConfig src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static ParOctasphereConfig malloc() {
        return new ParOctasphereConfig(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static ParOctasphereConfig calloc() {
        return new ParOctasphereConfig(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static ParOctasphereConfig create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new ParOctasphereConfig(MemoryUtil.memAddress(container), container);
    }

    public static ParOctasphereConfig create(long address) {
        return new ParOctasphereConfig(address, null);
    }

    public static @Nullable ParOctasphereConfig createSafe(long address) {
        return address == 0L ? null : new ParOctasphereConfig(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(ParOctasphereConfig.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ParOctasphereConfig.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static ParOctasphereConfig malloc(MemoryStack stack) {
        return new ParOctasphereConfig(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ParOctasphereConfig calloc(MemoryStack stack) {
        return new ParOctasphereConfig(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float ncorner_radius(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)CORNER_RADIUS);
    }

    public static float nwidth(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)WIDTH);
    }

    public static float nheight(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)HEIGHT);
    }

    public static float ndepth(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)DEPTH);
    }

    public static int nnum_subdivisions(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUM_SUBDIVISIONS);
    }

    public static int nuv_mode(long struct) {
        return MemoryUtil.memGetInt(struct + (long)UV_MODE);
    }

    public static int nnormals_mode(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NORMALS_MODE);
    }

    public static void ncorner_radius(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)CORNER_RADIUS, value);
    }

    public static void nwidth(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)HEIGHT, value);
    }

    public static void ndepth(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)DEPTH, value);
    }

    public static void nnum_subdivisions(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NUM_SUBDIVISIONS, value);
    }

    public static void nuv_mode(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)UV_MODE, value);
    }

    public static void nnormals_mode(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NORMALS_MODE, value);
    }

    static {
        Struct.Layout layout = ParOctasphereConfig.__struct(ParOctasphereConfig.__member(4), ParOctasphereConfig.__member(4), ParOctasphereConfig.__member(4), ParOctasphereConfig.__member(4), ParOctasphereConfig.__member(4), ParOctasphereConfig.__member(4), ParOctasphereConfig.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CORNER_RADIUS = layout.offsetof(0);
        WIDTH = layout.offsetof(1);
        HEIGHT = layout.offsetof(2);
        DEPTH = layout.offsetof(3);
        NUM_SUBDIVISIONS = layout.offsetof(4);
        UV_MODE = layout.offsetof(5);
        NORMALS_MODE = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<ParOctasphereConfig, Buffer>
    implements NativeResource {
        private static final ParOctasphereConfig ELEMENT_FACTORY = ParOctasphereConfig.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected ParOctasphereConfig getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float corner_radius() {
            return ParOctasphereConfig.ncorner_radius(this.address());
        }

        public float width() {
            return ParOctasphereConfig.nwidth(this.address());
        }

        public float height() {
            return ParOctasphereConfig.nheight(this.address());
        }

        public float depth() {
            return ParOctasphereConfig.ndepth(this.address());
        }

        public int num_subdivisions() {
            return ParOctasphereConfig.nnum_subdivisions(this.address());
        }

        @NativeType(value="par_octasphere_uv_mode")
        public int uv_mode() {
            return ParOctasphereConfig.nuv_mode(this.address());
        }

        @NativeType(value="par_octasphere_normals_mode")
        public int normals_mode() {
            return ParOctasphereConfig.nnormals_mode(this.address());
        }

        public Buffer corner_radius(float value) {
            ParOctasphereConfig.ncorner_radius(this.address(), value);
            return this;
        }

        public Buffer width(float value) {
            ParOctasphereConfig.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(float value) {
            ParOctasphereConfig.nheight(this.address(), value);
            return this;
        }

        public Buffer depth(float value) {
            ParOctasphereConfig.ndepth(this.address(), value);
            return this;
        }

        public Buffer num_subdivisions(int value) {
            ParOctasphereConfig.nnum_subdivisions(this.address(), value);
            return this;
        }

        public Buffer uv_mode(@NativeType(value="par_octasphere_uv_mode") int value) {
            ParOctasphereConfig.nuv_mode(this.address(), value);
            return this;
        }

        public Buffer normals_mode(@NativeType(value="par_octasphere_normals_mode") int value) {
            ParOctasphereConfig.nnormals_mode(this.address(), value);
            return this;
        }
    }
}

