/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.par;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct parsl_viewport")
public class ParSLViewport
extends Struct<ParSLViewport>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LEFT;
    public static final int TOP;
    public static final int RIGHT;
    public static final int BOTTOM;

    protected ParSLViewport(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected ParSLViewport create(long address, @Nullable ByteBuffer container) {
        return new ParSLViewport(address, container);
    }

    public ParSLViewport(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), ParSLViewport.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float left() {
        return ParSLViewport.nleft(this.address());
    }

    public float top() {
        return ParSLViewport.ntop(this.address());
    }

    public float right() {
        return ParSLViewport.nright(this.address());
    }

    public float bottom() {
        return ParSLViewport.nbottom(this.address());
    }

    public ParSLViewport left(float value) {
        ParSLViewport.nleft(this.address(), value);
        return this;
    }

    public ParSLViewport top(float value) {
        ParSLViewport.ntop(this.address(), value);
        return this;
    }

    public ParSLViewport right(float value) {
        ParSLViewport.nright(this.address(), value);
        return this;
    }

    public ParSLViewport bottom(float value) {
        ParSLViewport.nbottom(this.address(), value);
        return this;
    }

    public ParSLViewport set(float left, float top, float right, float bottom) {
        this.left(left);
        this.top(top);
        this.right(right);
        this.bottom(bottom);
        return this;
    }

    public ParSLViewport set(ParSLViewport src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static ParSLViewport malloc() {
        return new ParSLViewport(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static ParSLViewport calloc() {
        return new ParSLViewport(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static ParSLViewport create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new ParSLViewport(MemoryUtil.memAddress(container), container);
    }

    public static ParSLViewport create(long address) {
        return new ParSLViewport(address, null);
    }

    public static @Nullable ParSLViewport createSafe(long address) {
        return address == 0L ? null : new ParSLViewport(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(ParSLViewport.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ParSLViewport.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static ParSLViewport mallocStack() {
        return ParSLViewport.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ParSLViewport callocStack() {
        return ParSLViewport.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ParSLViewport mallocStack(MemoryStack stack) {
        return ParSLViewport.malloc(stack);
    }

    @Deprecated
    public static ParSLViewport callocStack(MemoryStack stack) {
        return ParSLViewport.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return ParSLViewport.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return ParSLViewport.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ParSLViewport.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ParSLViewport.calloc(capacity, stack);
    }

    public static ParSLViewport malloc(MemoryStack stack) {
        return new ParSLViewport(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ParSLViewport calloc(MemoryStack stack) {
        return new ParSLViewport(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nleft(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)LEFT);
    }

    public static float ntop(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)TOP);
    }

    public static float nright(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)RIGHT);
    }

    public static float nbottom(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)BOTTOM);
    }

    public static void nleft(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)LEFT, value);
    }

    public static void ntop(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)TOP, value);
    }

    public static void nright(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)RIGHT, value);
    }

    public static void nbottom(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)BOTTOM, value);
    }

    static {
        Struct.Layout layout = ParSLViewport.__struct(ParSLViewport.__member(4), ParSLViewport.__member(4), ParSLViewport.__member(4), ParSLViewport.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LEFT = layout.offsetof(0);
        TOP = layout.offsetof(1);
        RIGHT = layout.offsetof(2);
        BOTTOM = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<ParSLViewport, Buffer>
    implements NativeResource {
        private static final ParSLViewport ELEMENT_FACTORY = ParSLViewport.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected ParSLViewport getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float left() {
            return ParSLViewport.nleft(this.address());
        }

        public float top() {
            return ParSLViewport.ntop(this.address());
        }

        public float right() {
            return ParSLViewport.nright(this.address());
        }

        public float bottom() {
            return ParSLViewport.nbottom(this.address());
        }

        public Buffer left(float value) {
            ParSLViewport.nleft(this.address(), value);
            return this;
        }

        public Buffer top(float value) {
            ParSLViewport.ntop(this.address(), value);
            return this;
        }

        public Buffer right(float value) {
            ParSLViewport.nright(this.address(), value);
            return this;
        }

        public Buffer bottom(float value) {
            ParSLViewport.nbottom(this.address(), value);
            return this;
        }
    }
}

