/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.remotery;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct rmtVulkanBind")
public class RMTVulkanBind
extends Struct<RMTVulkanBind>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int INSTANCE;
    public static final int PHYSICAL_DEVICE;
    public static final int DEVICE;
    public static final int QUEUE;

    protected RMTVulkanBind(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected RMTVulkanBind create(long address, @Nullable ByteBuffer container) {
        return new RMTVulkanBind(address, container);
    }

    public RMTVulkanBind(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), RMTVulkanBind.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkInstance")
    public long instance() {
        return RMTVulkanBind.ninstance(this.address());
    }

    @NativeType(value="VkPhysicalDevice")
    public long physical_device() {
        return RMTVulkanBind.nphysical_device(this.address());
    }

    @NativeType(value="VkDevice")
    public long device() {
        return RMTVulkanBind.ndevice(this.address());
    }

    @NativeType(value="VkQueue")
    public long queue() {
        return RMTVulkanBind.nqueue(this.address());
    }

    public static RMTVulkanBind malloc() {
        return new RMTVulkanBind(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static RMTVulkanBind calloc() {
        return new RMTVulkanBind(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static RMTVulkanBind create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new RMTVulkanBind(MemoryUtil.memAddress(container), container);
    }

    public static RMTVulkanBind create(long address) {
        return new RMTVulkanBind(address, null);
    }

    public static @Nullable RMTVulkanBind createSafe(long address) {
        return address == 0L ? null : new RMTVulkanBind(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(RMTVulkanBind.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = RMTVulkanBind.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static RMTVulkanBind malloc(MemoryStack stack) {
        return new RMTVulkanBind(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static RMTVulkanBind calloc(MemoryStack stack) {
        return new RMTVulkanBind(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ninstance(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)INSTANCE);
    }

    public static long nphysical_device(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PHYSICAL_DEVICE);
    }

    public static long ndevice(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DEVICE);
    }

    public static long nqueue(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)QUEUE);
    }

    static {
        Struct.Layout layout = RMTVulkanBind.__struct(RMTVulkanBind.__member(POINTER_SIZE), RMTVulkanBind.__member(POINTER_SIZE), RMTVulkanBind.__member(POINTER_SIZE), RMTVulkanBind.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        INSTANCE = layout.offsetof(0);
        PHYSICAL_DEVICE = layout.offsetof(1);
        DEVICE = layout.offsetof(2);
        QUEUE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<RMTVulkanBind, Buffer>
    implements NativeResource {
        private static final RMTVulkanBind ELEMENT_FACTORY = RMTVulkanBind.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected RMTVulkanBind getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkInstance")
        public long instance() {
            return RMTVulkanBind.ninstance(this.address());
        }

        @NativeType(value="VkPhysicalDevice")
        public long physical_device() {
            return RMTVulkanBind.nphysical_device(this.address());
        }

        @NativeType(value="VkDevice")
        public long device() {
            return RMTVulkanBind.ndevice(this.address());
        }

        @NativeType(value="VkQueue")
        public long queue() {
            return RMTVulkanBind.nqueue(this.address());
        }
    }
}

