/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.remotery;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.util.remotery.LibRemotery;
import org.lwjgl.util.remotery.RMTProperty;
import org.lwjgl.util.remotery.RMTPropertyIterator;
import org.lwjgl.util.remotery.RMTPropertyValue;
import org.lwjgl.util.remotery.RMTSampleIterator;
import org.lwjgl.util.remotery.RMTSettings;

public class Remotery {
    public static final int RMT_TRUE = 1;
    public static final int RMT_FALSE = 0;
    public static final int RMT_SampleType_CPU = 0;
    public static final int RMT_SampleType_CUDA = 1;
    public static final int RMT_SampleType_D3D11 = 2;
    public static final int RMT_SampleType_D3D12 = 3;
    public static final int RMT_SampleType_OpenGL = 4;
    public static final int RMT_SampleType_Metal = 5;
    public static final int RMT_SampleType_Vulkan = 6;
    public static final int RMT_SampleType_Count = 7;
    public static final int RMT_ERROR_NONE = 0;
    public static final int RMT_ERROR_RECURSIVE_SAMPLE = 1;
    public static final int RMT_ERROR_UNKNOWN = 2;
    public static final int RMT_ERROR_INVALID_INPUT = 3;
    public static final int RMT_ERROR_RESOURCE_CREATE_FAIL = 4;
    public static final int RMT_ERROR_RESOURCE_ACCESS_FAIL = 5;
    public static final int RMT_ERROR_TIMEOUT = 6;
    public static final int RMT_ERROR_MALLOC_FAIL = 7;
    public static final int RMT_ERROR_TLS_ALLOC_FAIL = 8;
    public static final int RMT_ERROR_VIRTUAL_MEMORY_BUFFER_FAIL = 9;
    public static final int RMT_ERROR_CREATE_THREAD_FAIL = 10;
    public static final int RMT_ERROR_OPEN_THREAD_HANDLE_FAIL = 11;
    public static final int RMT_ERROR_SOCKET_INVALID_POLL = 12;
    public static final int RMT_ERROR_SOCKET_SELECT_FAIL = 13;
    public static final int RMT_ERROR_SOCKET_POLL_ERRORS = 14;
    public static final int RMT_ERROR_SOCKET_SEND_FAIL = 15;
    public static final int RMT_ERROR_SOCKET_RECV_NO_DATA = 16;
    public static final int RMT_ERROR_SOCKET_RECV_TIMEOUT = 17;
    public static final int RMT_ERROR_SOCKET_RECV_FAILED = 18;
    public static final int RMT_ERROR_WEBSOCKET_HANDSHAKE_NOT_GET = 19;
    public static final int RMT_ERROR_WEBSOCKET_HANDSHAKE_NO_VERSION = 20;
    public static final int RMT_ERROR_WEBSOCKET_HANDSHAKE_BAD_VERSION = 21;
    public static final int RMT_ERROR_WEBSOCKET_HANDSHAKE_NO_HOST = 22;
    public static final int RMT_ERROR_WEBSOCKET_HANDSHAKE_BAD_HOST = 23;
    public static final int RMT_ERROR_WEBSOCKET_HANDSHAKE_NO_KEY = 24;
    public static final int RMT_ERROR_WEBSOCKET_HANDSHAKE_BAD_KEY = 25;
    public static final int RMT_ERROR_WEBSOCKET_HANDSHAKE_STRING_FAIL = 26;
    public static final int RMT_ERROR_WEBSOCKET_DISCONNECTED = 27;
    public static final int RMT_ERROR_WEBSOCKET_BAD_FRAME_HEADER = 28;
    public static final int RMT_ERROR_WEBSOCKET_BAD_FRAME_HEADER_SIZE = 29;
    public static final int RMT_ERROR_WEBSOCKET_BAD_FRAME_HEADER_MASK = 30;
    public static final int RMT_ERROR_WEBSOCKET_RECEIVE_TIMEOUT = 31;
    public static final int RMT_ERROR_REMOTERY_NOT_CREATED = 32;
    public static final int RMT_ERROR_SEND_ON_INCOMPLETE_PROFILE = 33;
    public static final int RMT_ERROR_CUDA_DEINITIALIZED = 34;
    public static final int RMT_ERROR_CUDA_NOT_INITIALIZED = 35;
    public static final int RMT_ERROR_CUDA_INVALID_CONTEXT = 36;
    public static final int RMT_ERROR_CUDA_INVALID_VALUE = 37;
    public static final int RMT_ERROR_CUDA_INVALID_HANDLE = 38;
    public static final int RMT_ERROR_CUDA_OUT_OF_MEMORY = 39;
    public static final int RMT_ERROR_ERROR_NOT_READY = 40;
    public static final int RMT_ERROR_D3D11_FAILED_TO_CREATE_QUERY = 41;
    public static final int RMT_ERROR_OPENGL_ERROR = 42;
    public static final int RMT_ERROR_CUDA_UNKNOWN = 43;
    public static final int RMT_PropertyFlags_NoFlags = 0;
    public static final int RMT_PropertyFlags_FrameReset = 1;
    public static final int RMT_PropertyType_rmtGroup = 0;
    public static final int RMT_PropertyType_rmtBool = 1;
    public static final int RMT_PropertyType_rmtS32 = 2;
    public static final int RMT_PropertyType_rmtU32 = 3;
    public static final int RMT_PropertyType_rmtF32 = 4;
    public static final int RMT_PropertyType_rmtS64 = 5;
    public static final int RMT_PropertyType_rmtU64 = 6;
    public static final int RMT_PropertyType_rmtF64 = 7;
    public static final int RMTSF_None = 0;
    public static final int RMTSF_Aggregate = 1;
    public static final int RMTSF_Recursive = 2;
    public static final int RMTSF_Root = 4;
    public static final int RMTSF_SendOnClose = 8;
    private static final RMTPropertyValue NULL_VALUE;
    private static final RMTPropertyValue FALSE;
    private static final RMTPropertyValue TRUE;

    protected Remotery() {
        throw new UnsupportedOperationException();
    }

    public static native long nrmt_GetLastErrorMessage();

    @NativeType(value="rmtPStr")
    public static @Nullable String rmt_GetLastErrorMessage() {
        long __result = Remotery.nrmt_GetLastErrorMessage();
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static native long nrmt_Settings();

    @NativeType(value="rmtSettings *")
    public static @Nullable RMTSettings rmt_Settings() {
        long __result = Remotery.nrmt_Settings();
        return RMTSettings.createSafe(__result);
    }

    public static native int nrmt_CreateGlobalInstance(long var0);

    @NativeType(value="rmtError")
    public static int rmt_CreateGlobalInstance(@NativeType(value="Remotery **") PointerBuffer remotery) {
        if (Checks.CHECKS) {
            Checks.check(remotery, 1);
        }
        return Remotery.nrmt_CreateGlobalInstance(MemoryUtil.memAddress(remotery));
    }

    public static native void nrmt_DestroyGlobalInstance(long var0);

    public static void rmt_DestroyGlobalInstance(@NativeType(value="Remotery *") long remotery) {
        if (Checks.CHECKS) {
            Checks.check(remotery);
        }
        Remotery.nrmt_DestroyGlobalInstance(remotery);
    }

    public static native void nrmt_SetGlobalInstance(long var0);

    public static void rmt_SetGlobalInstance(@NativeType(value="Remotery *") long remotery) {
        if (Checks.CHECKS) {
            Checks.check(remotery);
        }
        Remotery.nrmt_SetGlobalInstance(remotery);
    }

    @NativeType(value="Remotery *")
    public static native long rmt_GetGlobalInstance();

    public static native void nrmt_SetCurrentThreadName(long var0);

    public static void rmt_SetCurrentThreadName(@NativeType(value="rmtPStr") ByteBuffer thread_name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(thread_name);
        }
        Remotery.nrmt_SetCurrentThreadName(MemoryUtil.memAddress(thread_name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rmt_SetCurrentThreadName(@NativeType(value="rmtPStr") CharSequence thread_name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(thread_name, true);
            long thread_nameEncoded = stack.getPointerAddress();
            Remotery.nrmt_SetCurrentThreadName(thread_nameEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nrmt_LogText(long var0);

    public static void rmt_LogText(@NativeType(value="rmtPStr") ByteBuffer text) {
        if (Checks.CHECKS) {
            Checks.checkNT1(text);
        }
        Remotery.nrmt_LogText(MemoryUtil.memAddress(text));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rmt_LogText(@NativeType(value="rmtPStr") CharSequence text) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(text, true);
            long textEncoded = stack.getPointerAddress();
            Remotery.nrmt_LogText(textEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nrmt_BeginCPUSample(long var0, int var2, long var3);

    public static void rmt_BeginCPUSample(@NativeType(value="rmtPStr") ByteBuffer name, @NativeType(value="rmtU32") int flags, @NativeType(value="rmtU32 *") @Nullable IntBuffer hash_cache) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
            Checks.checkSafe((Buffer)hash_cache, 1);
        }
        Remotery.nrmt_BeginCPUSample(MemoryUtil.memAddress(name), flags, MemoryUtil.memAddressSafe(hash_cache));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rmt_BeginCPUSample(@NativeType(value="rmtPStr") CharSequence name, @NativeType(value="rmtU32") int flags, @NativeType(value="rmtU32 *") @Nullable IntBuffer hash_cache) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)hash_cache, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(name, true);
            long nameEncoded = stack.getPointerAddress();
            Remotery.nrmt_BeginCPUSample(nameEncoded, flags, MemoryUtil.memAddressSafe(hash_cache));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void rmt_EndCPUSample();

    @NativeType(value="rmtError")
    public static native int rmt_MarkFrame();

    @NativeType(value="rmtError")
    public static native int rmt_PropertySnapshotAll();

    public static native void rmt_PropertyFrameResetAll();

    public static native void nrmt_IterateChildren(long var0, long var2);

    public static void rmt_IterateChildren(@NativeType(value="rmtSampleIterator *") RMTSampleIterator iter, @NativeType(value="rmtSample *") long sample) {
        Remotery.nrmt_IterateChildren(iter.address(), sample);
    }

    public static native int nrmt_IterateNext(long var0);

    @NativeType(value="rmtBool")
    public static boolean rmt_IterateNext(@NativeType(value="rmtSampleIterator *") RMTSampleIterator iter) {
        return Remotery.nrmt_IterateNext(iter.address()) != 0;
    }

    public static native long nrmt_SampleTreeGetThreadName(long var0);

    @NativeType(value="char const *")
    public static @Nullable String rmt_SampleTreeGetThreadName(@NativeType(value="rmtSampleTree *") long sample_tree) {
        if (Checks.CHECKS) {
            Checks.check(sample_tree);
        }
        long __result = Remotery.nrmt_SampleTreeGetThreadName(sample_tree);
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static native long nrmt_SampleTreeGetRootSample(long var0);

    @NativeType(value="rmtSample *")
    public static long rmt_SampleTreeGetRootSample(@NativeType(value="rmtSampleTree *") long sample_tree) {
        if (Checks.CHECKS) {
            Checks.check(sample_tree);
        }
        return Remotery.nrmt_SampleTreeGetRootSample(sample_tree);
    }

    public static native long nrmt_SampleGetName(long var0);

    @NativeType(value="char const *")
    public static @Nullable String rmt_SampleGetName(@NativeType(value="rmtSample *") long sample) {
        if (Checks.CHECKS) {
            Checks.check(sample);
        }
        long __result = Remotery.nrmt_SampleGetName(sample);
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static native int nrmt_SampleGetNameHash(long var0);

    @NativeType(value="rmtU32")
    public static int rmt_SampleGetNameHash(@NativeType(value="rmtSample *") long sample) {
        if (Checks.CHECKS) {
            Checks.check(sample);
        }
        return Remotery.nrmt_SampleGetNameHash(sample);
    }

    public static native int nrmt_SampleGetCallCount(long var0);

    @NativeType(value="rmtU32")
    public static int rmt_SampleGetCallCount(@NativeType(value="rmtSample *") long sample) {
        if (Checks.CHECKS) {
            Checks.check(sample);
        }
        return Remotery.nrmt_SampleGetCallCount(sample);
    }

    public static native long nrmt_SampleGetStart(long var0);

    @NativeType(value="rmtU64")
    public static long rmt_SampleGetStart(@NativeType(value="rmtSample *") long sample) {
        if (Checks.CHECKS) {
            Checks.check(sample);
        }
        return Remotery.nrmt_SampleGetStart(sample);
    }

    public static native long nrmt_SampleGetTime(long var0);

    @NativeType(value="rmtU64")
    public static long rmt_SampleGetTime(@NativeType(value="rmtSample *") long sample) {
        if (Checks.CHECKS) {
            Checks.check(sample);
        }
        return Remotery.nrmt_SampleGetTime(sample);
    }

    public static native long nrmt_SampleGetSelfTime(long var0);

    @NativeType(value="rmtU64")
    public static long rmt_SampleGetSelfTime(@NativeType(value="rmtSample *") long sample) {
        if (Checks.CHECKS) {
            Checks.check(sample);
        }
        return Remotery.nrmt_SampleGetSelfTime(sample);
    }

    public static native void nrmt_SampleGetColour(long var0, long var2, long var4, long var6);

    public static void rmt_SampleGetColour(@NativeType(value="rmtSample *") long sample, @NativeType(value="rmtU8 *") ByteBuffer r, @NativeType(value="rmtU8 *") ByteBuffer g, @NativeType(value="rmtU8 *") ByteBuffer b) {
        if (Checks.CHECKS) {
            Checks.check(sample);
            Checks.check((Buffer)r, 1);
            Checks.check((Buffer)g, 1);
            Checks.check((Buffer)b, 1);
        }
        Remotery.nrmt_SampleGetColour(sample, MemoryUtil.memAddress(r), MemoryUtil.memAddress(g), MemoryUtil.memAddress(b));
    }

    public static native int nrmt_SampleGetType(long var0);

    @NativeType(value="rmtSampleType")
    public static int rmt_SampleGetType(@NativeType(value="rmtSample *") long sample) {
        if (Checks.CHECKS) {
            Checks.check(sample);
        }
        return Remotery.nrmt_SampleGetType(sample);
    }

    public static native void nrmt_PropertyIterateChildren(long var0, long var2);

    public static void rmt_PropertyIterateChildren(@NativeType(value="rmtPropertyIterator *") RMTPropertyIterator iter, @NativeType(value="rmtProperty *") @Nullable RMTProperty sample) {
        Remotery.nrmt_PropertyIterateChildren(iter.address(), MemoryUtil.memAddressSafe(sample));
    }

    public static native int nrmt_PropertyIterateNext(long var0);

    @NativeType(value="rmtBool")
    public static boolean rmt_PropertyIterateNext(@NativeType(value="rmtPropertyIterator *") RMTPropertyIterator iter) {
        return Remotery.nrmt_PropertyIterateNext(iter.address()) != 0;
    }

    public static native int nrmt_PropertyGetType(long var0);

    @NativeType(value="rmtPropertyType")
    public static int rmt_PropertyGetType(@NativeType(value="rmtProperty *") RMTProperty property) {
        return Remotery.nrmt_PropertyGetType(property.address());
    }

    public static native long nrmt_PropertyGetName(long var0);

    @NativeType(value="char const *")
    public static @Nullable String rmt_PropertyGetName(@NativeType(value="rmtProperty *") RMTProperty property) {
        long __result = Remotery.nrmt_PropertyGetName(property.address());
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static native long nrmt_PropertyGetDescription(long var0);

    @NativeType(value="char const *")
    public static @Nullable String rmt_PropertyGetDescription(@NativeType(value="rmtProperty *") RMTProperty property) {
        long __result = Remotery.nrmt_PropertyGetDescription(property.address());
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static native void nrmt_PropertyGetValue(long var0, long var2);

    @NativeType(value="rmtPropertyValue")
    public static RMTPropertyValue rmt_PropertyGetValue(@NativeType(value="rmtProperty *") RMTProperty property, @NativeType(value="rmtPropertyValue") RMTPropertyValue __result) {
        Remotery.nrmt_PropertyGetValue(property.address(), __result.address());
        return __result;
    }

    public static native void n_rmt_PropertySetValue(long var0);

    public static void _rmt_PropertySetValue(@NativeType(value="rmtProperty *") RMTProperty property) {
        Remotery.n_rmt_PropertySetValue(property.address());
    }

    public static native void n_rmt_PropertyAddValue(long var0, long var2);

    public static void _rmt_PropertyAddValue(@NativeType(value="rmtProperty *") RMTProperty property, @NativeType(value="rmtPropertyValue") RMTPropertyValue add_value) {
        Remotery.n_rmt_PropertyAddValue(property.address(), add_value.address());
    }

    public static native int n_rmt_HashString32(long var0, int var2, int var3);

    @NativeType(value="rmtU32")
    public static int _rmt_HashString32(@NativeType(value="char const *") ByteBuffer s, int len, @NativeType(value="rmtU32") int seed) {
        if (Checks.CHECKS) {
            Checks.checkNT1(s);
        }
        return Remotery.n_rmt_HashString32(MemoryUtil.memAddress(s), len, seed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="rmtU32")
    public static int _rmt_HashString32(@NativeType(value="char const *") CharSequence s, int len, @NativeType(value="rmtU32") int seed) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(s, true);
            long sEncoded = stack.getPointerAddress();
            int n = Remotery.n_rmt_HashString32(sEncoded, len, seed);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static RMTProperty rmt_PropertyDefine(int type, int flags, RMTPropertyValue default_value, ByteBuffer name, ByteBuffer desc, @Nullable RMTProperty parent, RMTProperty __result) {
        return __result.initialised(false).type(type).flags(flags).value(default_value).lastFrameValue(default_value).prevValue(default_value).prevValueFrame(0).name(name).description(desc).defaultValue(default_value).parent(parent).firstChild(null).lastChild(null).nextSibling(null).nameHash(0).uniqueID(0);
    }

    public static RMTProperty rmt_PropertyDefine(int type, int flags, RMTPropertyValue default_value, String name, String desc, @Nullable RMTProperty parent, MemoryStack frame) {
        return RMTProperty.malloc(frame).initialised(false).type(type).flags(flags).value(default_value).lastFrameValue(default_value).prevValue(default_value).prevValueFrame(0).name(frame.UTF8(name)).description(frame.UTF8(desc)).defaultValue(default_value).parent(parent).firstChild(null).lastChild(null).nextSibling(null).nameHash(0).uniqueID(0);
    }

    public static RMTProperty rmt_PropertyDefine_Group(String name, String desc, @Nullable RMTProperty parent, MemoryStack frame) {
        return Remotery.rmt_PropertyDefine(0, 0, NULL_VALUE, name, desc, parent, frame);
    }

    public static RMTProperty rmt_PropertyDefine_Bool(String name, boolean default_value, int flags, String desc, @Nullable RMTProperty parent, MemoryStack frame) {
        return Remotery.rmt_PropertyDefine(1, flags, default_value ? TRUE : FALSE, name, desc, parent, frame);
    }

    public static RMTProperty rmt_PropertyDefine_S32(String name, int default_value, int flags, String desc, @Nullable RMTProperty parent, MemoryStack frame) {
        RMTProperty __result = RMTProperty.malloc(frame);
        ByteBuffer nameBuffer = frame.UTF8(name);
        ByteBuffer descBuffer = frame.UTF8(desc);
        try (MemoryStack tmp = frame.push();){
            RMTProperty rMTProperty = Remotery.rmt_PropertyDefine(2, flags, RMTPropertyValue.malloc(tmp).S32(default_value), nameBuffer, descBuffer, parent, __result);
            return rMTProperty;
        }
    }

    public static RMTProperty rmt_PropertyDefine_U32(String name, int default_value, int flags, String desc, @Nullable RMTProperty parent, MemoryStack frame) {
        RMTProperty __result = RMTProperty.malloc(frame);
        ByteBuffer nameBuffer = frame.UTF8(name);
        ByteBuffer descBuffer = frame.UTF8(desc);
        try (MemoryStack tmp = frame.push();){
            RMTProperty rMTProperty = Remotery.rmt_PropertyDefine(3, flags, RMTPropertyValue.malloc(tmp).U32(default_value), nameBuffer, descBuffer, parent, __result);
            return rMTProperty;
        }
    }

    public static RMTProperty rmt_PropertyDefine_F32(String name, float default_value, int flags, String desc, @Nullable RMTProperty parent, MemoryStack frame) {
        RMTProperty __result = RMTProperty.malloc(frame);
        ByteBuffer nameBuffer = frame.UTF8(name);
        ByteBuffer descBuffer = frame.UTF8(desc);
        try (MemoryStack tmp = frame.push();){
            RMTProperty rMTProperty = Remotery.rmt_PropertyDefine(4, flags, RMTPropertyValue.malloc(tmp).F32(default_value), nameBuffer, descBuffer, parent, __result);
            return rMTProperty;
        }
    }

    public static RMTProperty rmt_PropertyDefine_S64(String name, long default_value, int flags, String desc, @Nullable RMTProperty parent, MemoryStack frame) {
        RMTProperty __result = RMTProperty.malloc(frame);
        ByteBuffer nameBuffer = frame.UTF8(name);
        ByteBuffer descBuffer = frame.UTF8(desc);
        try (MemoryStack tmp = frame.push();){
            RMTProperty rMTProperty = Remotery.rmt_PropertyDefine(5, flags, RMTPropertyValue.malloc(tmp).S64(default_value), nameBuffer, descBuffer, parent, __result);
            return rMTProperty;
        }
    }

    public static RMTProperty rmt_PropertyDefine_U64(String name, long default_value, int flags, String desc, @Nullable RMTProperty parent, MemoryStack frame) {
        RMTProperty __result = RMTProperty.malloc(frame);
        ByteBuffer nameBuffer = frame.UTF8(name);
        ByteBuffer descBuffer = frame.UTF8(desc);
        try (MemoryStack tmp = frame.push();){
            RMTProperty rMTProperty = Remotery.rmt_PropertyDefine(6, flags, RMTPropertyValue.malloc(tmp).U64(default_value), nameBuffer, descBuffer, parent, __result);
            return rMTProperty;
        }
    }

    public static RMTProperty rmt_PropertyDefine_F64(String name, double default_value, int flags, String desc, @Nullable RMTProperty parent, MemoryStack frame) {
        RMTProperty __result = RMTProperty.malloc(frame);
        ByteBuffer nameBuffer = frame.UTF8(name);
        ByteBuffer descBuffer = frame.UTF8(desc);
        try (MemoryStack tmp = frame.push();){
            RMTProperty rMTProperty = Remotery.rmt_PropertyDefine(7, flags, RMTPropertyValue.malloc(tmp).F64(default_value), nameBuffer, descBuffer, parent, __result);
            return rMTProperty;
        }
    }

    public static void rmt_PropertySet_Bool(RMTProperty property, boolean value) {
        property.value().Bool(value);
        Remotery._rmt_PropertySetValue(property);
    }

    public static void rmt_PropertySet_S32(RMTProperty property, int value) {
        property.value().S32(value);
        Remotery._rmt_PropertySetValue(property);
    }

    public static void rmt_PropertySet_U32(RMTProperty property, int value) {
        property.value().U32(value);
        Remotery._rmt_PropertySetValue(property);
    }

    public static void rmt_PropertySet_F32(RMTProperty property, float value) {
        property.value().F32(value);
        Remotery._rmt_PropertySetValue(property);
    }

    public static void rmt_PropertySet_S64(RMTProperty property, long value) {
        property.value().S64(value);
        Remotery._rmt_PropertySetValue(property);
    }

    public static void rmt_PropertySet_U64(RMTProperty property, long value) {
        property.value().U64(value);
        Remotery._rmt_PropertySetValue(property);
    }

    public static void rmt_PropertySet_F64(RMTProperty property, double value) {
        property.value().F64(value);
        Remotery._rmt_PropertySetValue(property);
    }

    public static void rmt_PropertyAdd_S32(RMTProperty property, int add_value, MemoryStack frame) {
        Remotery.rmt_PropertyAdd_S32(property, RMTPropertyValue.malloc(frame).S32(add_value));
    }

    public static void rmt_PropertyAdd_S32(RMTProperty property, RMTPropertyValue add_value) {
        property.value().S32(property.value().S32() + add_value.S32());
        Remotery._rmt_PropertyAddValue(property, add_value);
    }

    public static void rmt_PropertyAdd_U32(RMTProperty property, int add_value, MemoryStack frame) {
        Remotery.rmt_PropertyAdd_U32(property, RMTPropertyValue.malloc(frame).U32(add_value));
    }

    public static void rmt_PropertyAdd_U32(RMTProperty property, RMTPropertyValue add_value) {
        property.value().U32(property.value().U32() + add_value.U32());
        Remotery._rmt_PropertyAddValue(property, add_value);
    }

    public static void rmt_PropertyAdd_F32(RMTProperty property, float add_value, MemoryStack frame) {
        Remotery.rmt_PropertyAdd_F32(property, RMTPropertyValue.malloc(frame).F32(add_value));
    }

    public static void rmt_PropertyAdd_F32(RMTProperty property, RMTPropertyValue add_value) {
        property.value().F32(property.value().F32() + add_value.F32());
        Remotery._rmt_PropertyAddValue(property, add_value);
    }

    public static void rmt_PropertyAdd_S64(RMTProperty property, long add_value, MemoryStack frame) {
        Remotery.rmt_PropertyAdd_S64(property, RMTPropertyValue.malloc(frame).S64(add_value));
    }

    public static void rmt_PropertyAdd_S64(RMTProperty property, RMTPropertyValue add_value) {
        property.value().S64(property.value().S64() + add_value.S64());
        Remotery._rmt_PropertyAddValue(property, add_value);
    }

    public static void rmt_PropertyAdd_U64(RMTProperty property, long add_value, MemoryStack frame) {
        Remotery.rmt_PropertyAdd_U64(property, RMTPropertyValue.malloc(frame).U64(add_value));
    }

    public static void rmt_PropertyAdd_U64(RMTProperty property, RMTPropertyValue add_value) {
        property.value().U64(property.value().U64() + add_value.U64());
        Remotery._rmt_PropertyAddValue(property, add_value);
    }

    public static void rmt_PropertyAdd_F64(RMTProperty property, double add_value, MemoryStack frame) {
        Remotery.rmt_PropertyAdd_F64(property, RMTPropertyValue.malloc(frame).F64(add_value));
    }

    public static void rmt_PropertyAdd_F64(RMTProperty property, RMTPropertyValue add_value) {
        property.value().F64(property.value().F64() + add_value.F64());
        Remotery._rmt_PropertyAddValue(property, add_value);
    }

    static {
        LibRemotery.initialize();
        NULL_VALUE = RMTPropertyValue.create();
        FALSE = RMTPropertyValue.create().Bool(false);
        TRUE = RMTPropertyValue.create().Bool(true);
    }
}

