/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.remotery;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.util.remotery.LibRemotery;
import org.lwjgl.util.remotery.RMTVulkanBind;
import org.lwjgl.util.remotery.RMTVulkanFunctions;

public class RemoteryVulkan {
    protected RemoteryVulkan() {
        throw new UnsupportedOperationException();
    }

    public static native void nrmt_BindVulkan(long var0, long var2, long var4, long var6, long var8, long var10);

    public static void rmt_BindVulkan(@NativeType(value="VkInstance") long instance, @NativeType(value="VkPhysicalDevice") long physical_device, @NativeType(value="VkDevice") long device, @NativeType(value="VkQueue") long queue, @NativeType(value="rmtVulkanFunctions const *") RMTVulkanFunctions funcs, @NativeType(value="rmtVulkanBind **") PointerBuffer out_bind) {
        if (Checks.CHECKS) {
            Checks.check(instance);
            Checks.check(physical_device);
            Checks.check(device);
            Checks.check(queue);
            Checks.check(out_bind, 1);
            RMTVulkanFunctions.validate(funcs.address());
        }
        RemoteryVulkan.nrmt_BindVulkan(instance, physical_device, device, queue, funcs.address(), MemoryUtil.memAddress(out_bind));
    }

    public static native void nrmt_UnbindVulkan(long var0);

    public static void rmt_UnbindVulkan(@NativeType(value="rmtVulkanBind *") RMTVulkanBind bind) {
        RemoteryVulkan.nrmt_UnbindVulkan(bind.address());
    }

    public static native void nrmt_BeginVulkanSample(long var0, long var2, long var4, long var6);

    public static void rmt_BeginVulkanSample(@NativeType(value="rmtVulkanBind *") RMTVulkanBind bind, @NativeType(value="VkCommandBuffer") long command_buffer, @NativeType(value="rmtPStr") ByteBuffer name, @NativeType(value="rmtU32 *") @Nullable IntBuffer hash_cache) {
        if (Checks.CHECKS) {
            Checks.check(command_buffer);
            Checks.checkNT1(name);
            Checks.checkSafe((Buffer)hash_cache, 1);
        }
        RemoteryVulkan.nrmt_BeginVulkanSample(bind.address(), command_buffer, MemoryUtil.memAddress(name), MemoryUtil.memAddressSafe(hash_cache));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rmt_BeginVulkanSample(@NativeType(value="rmtVulkanBind *") RMTVulkanBind bind, @NativeType(value="VkCommandBuffer") long command_buffer, @NativeType(value="rmtPStr") CharSequence name, @NativeType(value="rmtU32 *") @Nullable IntBuffer hash_cache) {
        if (Checks.CHECKS) {
            Checks.check(command_buffer);
            Checks.checkSafe((Buffer)hash_cache, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(name, true);
            long nameEncoded = stack.getPointerAddress();
            RemoteryVulkan.nrmt_BeginVulkanSample(bind.address(), command_buffer, nameEncoded, MemoryUtil.memAddressSafe(hash_cache));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void rmt_EndVulkanSample();

    static {
        LibRemotery.initialize();
    }
}

