/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.shaderc;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct shaderc_include_result")
public class ShadercIncludeResult
extends Struct<ShadercIncludeResult>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SOURCE_NAME;
    public static final int SOURCE_NAME_LENGTH;
    public static final int CONTENT;
    public static final int CONTENT_LENGTH;
    public static final int USER_DATA;

    protected ShadercIncludeResult(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected ShadercIncludeResult create(long address, @Nullable ByteBuffer container) {
        return new ShadercIncludeResult(address, container);
    }

    public ShadercIncludeResult(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), ShadercIncludeResult.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char const *")
    public ByteBuffer source_name() {
        return ShadercIncludeResult.nsource_name(this.address());
    }

    @NativeType(value="char const *")
    public String source_nameString() {
        return ShadercIncludeResult.nsource_nameString(this.address());
    }

    @NativeType(value="size_t")
    public long source_name_length() {
        return ShadercIncludeResult.nsource_name_length(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer content() {
        return ShadercIncludeResult.ncontent(this.address());
    }

    @NativeType(value="char const *")
    public String contentString() {
        return ShadercIncludeResult.ncontentString(this.address());
    }

    @NativeType(value="size_t")
    public long content_length() {
        return ShadercIncludeResult.ncontent_length(this.address());
    }

    @NativeType(value="void *")
    public long user_data() {
        return ShadercIncludeResult.nuser_data(this.address());
    }

    public ShadercIncludeResult source_name(@NativeType(value="char const *") ByteBuffer value) {
        ShadercIncludeResult.nsource_name(this.address(), value);
        return this;
    }

    public ShadercIncludeResult content(@NativeType(value="char const *") ByteBuffer value) {
        ShadercIncludeResult.ncontent(this.address(), value);
        return this;
    }

    public ShadercIncludeResult user_data(@NativeType(value="void *") long value) {
        ShadercIncludeResult.nuser_data(this.address(), value);
        return this;
    }

    public ShadercIncludeResult set(ByteBuffer source_name, ByteBuffer content, long user_data) {
        this.source_name(source_name);
        this.content(content);
        this.user_data(user_data);
        return this;
    }

    public ShadercIncludeResult set(ShadercIncludeResult src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static ShadercIncludeResult malloc() {
        return new ShadercIncludeResult(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static ShadercIncludeResult calloc() {
        return new ShadercIncludeResult(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static ShadercIncludeResult create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new ShadercIncludeResult(MemoryUtil.memAddress(container), container);
    }

    public static ShadercIncludeResult create(long address) {
        return new ShadercIncludeResult(address, null);
    }

    public static @Nullable ShadercIncludeResult createSafe(long address) {
        return address == 0L ? null : new ShadercIncludeResult(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(ShadercIncludeResult.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ShadercIncludeResult.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static ShadercIncludeResult mallocStack() {
        return ShadercIncludeResult.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ShadercIncludeResult callocStack() {
        return ShadercIncludeResult.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ShadercIncludeResult mallocStack(MemoryStack stack) {
        return ShadercIncludeResult.malloc(stack);
    }

    @Deprecated
    public static ShadercIncludeResult callocStack(MemoryStack stack) {
        return ShadercIncludeResult.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return ShadercIncludeResult.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return ShadercIncludeResult.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ShadercIncludeResult.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ShadercIncludeResult.calloc(capacity, stack);
    }

    public static ShadercIncludeResult malloc(MemoryStack stack) {
        return new ShadercIncludeResult(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ShadercIncludeResult calloc(MemoryStack stack) {
        return new ShadercIncludeResult(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nsource_name(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)SOURCE_NAME));
    }

    public static String nsource_nameString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)SOURCE_NAME));
    }

    public static long nsource_name_length(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SOURCE_NAME_LENGTH);
    }

    public static ByteBuffer ncontent(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)CONTENT));
    }

    public static String ncontentString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)CONTENT));
    }

    public static long ncontent_length(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CONTENT_LENGTH);
    }

    public static long nuser_data(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)USER_DATA);
    }

    public static void nsource_name(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)SOURCE_NAME, MemoryUtil.memAddress(value));
        ShadercIncludeResult.nsource_name_length(struct, value.remaining());
    }

    public static void nsource_name_length(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SOURCE_NAME_LENGTH, value);
    }

    public static void ncontent(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)CONTENT, MemoryUtil.memAddress(value));
        ShadercIncludeResult.ncontent_length(struct, value.remaining());
    }

    public static void ncontent_length(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)CONTENT_LENGTH, value);
    }

    public static void nuser_data(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)USER_DATA, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SOURCE_NAME));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CONTENT));
    }

    static {
        Struct.Layout layout = ShadercIncludeResult.__struct(ShadercIncludeResult.__member(POINTER_SIZE), ShadercIncludeResult.__member(POINTER_SIZE), ShadercIncludeResult.__member(POINTER_SIZE), ShadercIncludeResult.__member(POINTER_SIZE), ShadercIncludeResult.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SOURCE_NAME = layout.offsetof(0);
        SOURCE_NAME_LENGTH = layout.offsetof(1);
        CONTENT = layout.offsetof(2);
        CONTENT_LENGTH = layout.offsetof(3);
        USER_DATA = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<ShadercIncludeResult, Buffer>
    implements NativeResource {
        private static final ShadercIncludeResult ELEMENT_FACTORY = ShadercIncludeResult.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected ShadercIncludeResult getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char const *")
        public ByteBuffer source_name() {
            return ShadercIncludeResult.nsource_name(this.address());
        }

        @NativeType(value="char const *")
        public String source_nameString() {
            return ShadercIncludeResult.nsource_nameString(this.address());
        }

        @NativeType(value="size_t")
        public long source_name_length() {
            return ShadercIncludeResult.nsource_name_length(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer content() {
            return ShadercIncludeResult.ncontent(this.address());
        }

        @NativeType(value="char const *")
        public String contentString() {
            return ShadercIncludeResult.ncontentString(this.address());
        }

        @NativeType(value="size_t")
        public long content_length() {
            return ShadercIncludeResult.ncontent_length(this.address());
        }

        @NativeType(value="void *")
        public long user_data() {
            return ShadercIncludeResult.nuser_data(this.address());
        }

        public Buffer source_name(@NativeType(value="char const *") ByteBuffer value) {
            ShadercIncludeResult.nsource_name(this.address(), value);
            return this;
        }

        public Buffer content(@NativeType(value="char const *") ByteBuffer value) {
            ShadercIncludeResult.ncontent(this.address(), value);
            return this;
        }

        public Buffer user_data(@NativeType(value="void *") long value) {
            ShadercIncludeResult.nuser_data(this.address(), value);
            return this;
        }
    }
}

