/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spvc_hlsl_resource_binding_mapping")
public class SpvcHLSLResourceBindingMapping
extends Struct<SpvcHLSLResourceBindingMapping>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int REGISTER_SPACE;
    public static final int REGISTER_BINDING;

    protected SpvcHLSLResourceBindingMapping(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SpvcHLSLResourceBindingMapping create(long address, @Nullable ByteBuffer container) {
        return new SpvcHLSLResourceBindingMapping(address, container);
    }

    public SpvcHLSLResourceBindingMapping(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SpvcHLSLResourceBindingMapping.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned")
    public int register_space() {
        return SpvcHLSLResourceBindingMapping.nregister_space(this.address());
    }

    @NativeType(value="unsigned")
    public int register_binding() {
        return SpvcHLSLResourceBindingMapping.nregister_binding(this.address());
    }

    public SpvcHLSLResourceBindingMapping register_space(@NativeType(value="unsigned") int value) {
        SpvcHLSLResourceBindingMapping.nregister_space(this.address(), value);
        return this;
    }

    public SpvcHLSLResourceBindingMapping register_binding(@NativeType(value="unsigned") int value) {
        SpvcHLSLResourceBindingMapping.nregister_binding(this.address(), value);
        return this;
    }

    public SpvcHLSLResourceBindingMapping set(int register_space, int register_binding) {
        this.register_space(register_space);
        this.register_binding(register_binding);
        return this;
    }

    public SpvcHLSLResourceBindingMapping set(SpvcHLSLResourceBindingMapping src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SpvcHLSLResourceBindingMapping malloc() {
        return new SpvcHLSLResourceBindingMapping(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SpvcHLSLResourceBindingMapping calloc() {
        return new SpvcHLSLResourceBindingMapping(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SpvcHLSLResourceBindingMapping create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SpvcHLSLResourceBindingMapping(MemoryUtil.memAddress(container), container);
    }

    public static SpvcHLSLResourceBindingMapping create(long address) {
        return new SpvcHLSLResourceBindingMapping(address, null);
    }

    public static @Nullable SpvcHLSLResourceBindingMapping createSafe(long address) {
        return address == 0L ? null : new SpvcHLSLResourceBindingMapping(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SpvcHLSLResourceBindingMapping.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SpvcHLSLResourceBindingMapping.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SpvcHLSLResourceBindingMapping malloc(MemoryStack stack) {
        return new SpvcHLSLResourceBindingMapping(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SpvcHLSLResourceBindingMapping calloc(MemoryStack stack) {
        return new SpvcHLSLResourceBindingMapping(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nregister_space(long struct) {
        return MemoryUtil.memGetInt(struct + (long)REGISTER_SPACE);
    }

    public static int nregister_binding(long struct) {
        return MemoryUtil.memGetInt(struct + (long)REGISTER_BINDING);
    }

    public static void nregister_space(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)REGISTER_SPACE, value);
    }

    public static void nregister_binding(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)REGISTER_BINDING, value);
    }

    static {
        Struct.Layout layout = SpvcHLSLResourceBindingMapping.__struct(SpvcHLSLResourceBindingMapping.__member(4), SpvcHLSLResourceBindingMapping.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        REGISTER_SPACE = layout.offsetof(0);
        REGISTER_BINDING = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<SpvcHLSLResourceBindingMapping, Buffer>
    implements NativeResource {
        private static final SpvcHLSLResourceBindingMapping ELEMENT_FACTORY = SpvcHLSLResourceBindingMapping.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SpvcHLSLResourceBindingMapping getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned")
        public int register_space() {
            return SpvcHLSLResourceBindingMapping.nregister_space(this.address());
        }

        @NativeType(value="unsigned")
        public int register_binding() {
            return SpvcHLSLResourceBindingMapping.nregister_binding(this.address());
        }

        public Buffer register_space(@NativeType(value="unsigned") int value) {
            SpvcHLSLResourceBindingMapping.nregister_space(this.address(), value);
            return this;
        }

        public Buffer register_binding(@NativeType(value="unsigned") int value) {
            SpvcHLSLResourceBindingMapping.nregister_binding(this.address(), value);
            return this;
        }
    }
}

