/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spvc_msl_shader_interface_var")
public class SpvcMslShaderInterfaceVar
extends Struct<SpvcMslShaderInterfaceVar>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LOCATION;
    public static final int FORMAT;
    public static final int BUILTIN;
    public static final int VECSIZE;

    protected SpvcMslShaderInterfaceVar(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SpvcMslShaderInterfaceVar create(long address, @Nullable ByteBuffer container) {
        return new SpvcMslShaderInterfaceVar(address, container);
    }

    public SpvcMslShaderInterfaceVar(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SpvcMslShaderInterfaceVar.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned")
    public int location() {
        return SpvcMslShaderInterfaceVar.nlocation(this.address());
    }

    @NativeType(value="spvc_msl_vertex_format")
    public int format() {
        return SpvcMslShaderInterfaceVar.nformat(this.address());
    }

    @NativeType(value="SpvBuiltIn")
    public int builtin() {
        return SpvcMslShaderInterfaceVar.nbuiltin(this.address());
    }

    @NativeType(value="unsigned")
    public int vecsize() {
        return SpvcMslShaderInterfaceVar.nvecsize(this.address());
    }

    public SpvcMslShaderInterfaceVar location(@NativeType(value="unsigned") int value) {
        SpvcMslShaderInterfaceVar.nlocation(this.address(), value);
        return this;
    }

    public SpvcMslShaderInterfaceVar format(@NativeType(value="spvc_msl_vertex_format") int value) {
        SpvcMslShaderInterfaceVar.nformat(this.address(), value);
        return this;
    }

    public SpvcMslShaderInterfaceVar builtin(@NativeType(value="SpvBuiltIn") int value) {
        SpvcMslShaderInterfaceVar.nbuiltin(this.address(), value);
        return this;
    }

    public SpvcMslShaderInterfaceVar vecsize(@NativeType(value="unsigned") int value) {
        SpvcMslShaderInterfaceVar.nvecsize(this.address(), value);
        return this;
    }

    public SpvcMslShaderInterfaceVar set(int location, int format, int builtin, int vecsize) {
        this.location(location);
        this.format(format);
        this.builtin(builtin);
        this.vecsize(vecsize);
        return this;
    }

    public SpvcMslShaderInterfaceVar set(SpvcMslShaderInterfaceVar src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SpvcMslShaderInterfaceVar malloc() {
        return new SpvcMslShaderInterfaceVar(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SpvcMslShaderInterfaceVar calloc() {
        return new SpvcMslShaderInterfaceVar(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SpvcMslShaderInterfaceVar create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SpvcMslShaderInterfaceVar(MemoryUtil.memAddress(container), container);
    }

    public static SpvcMslShaderInterfaceVar create(long address) {
        return new SpvcMslShaderInterfaceVar(address, null);
    }

    public static @Nullable SpvcMslShaderInterfaceVar createSafe(long address) {
        return address == 0L ? null : new SpvcMslShaderInterfaceVar(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SpvcMslShaderInterfaceVar.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SpvcMslShaderInterfaceVar.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SpvcMslShaderInterfaceVar malloc(MemoryStack stack) {
        return new SpvcMslShaderInterfaceVar(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SpvcMslShaderInterfaceVar calloc(MemoryStack stack) {
        return new SpvcMslShaderInterfaceVar(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nlocation(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LOCATION);
    }

    public static int nformat(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FORMAT);
    }

    public static int nbuiltin(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BUILTIN);
    }

    public static int nvecsize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VECSIZE);
    }

    public static void nlocation(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LOCATION, value);
    }

    public static void nformat(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FORMAT, value);
    }

    public static void nbuiltin(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BUILTIN, value);
    }

    public static void nvecsize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VECSIZE, value);
    }

    static {
        Struct.Layout layout = SpvcMslShaderInterfaceVar.__struct(SpvcMslShaderInterfaceVar.__member(4), SpvcMslShaderInterfaceVar.__member(4), SpvcMslShaderInterfaceVar.__member(4), SpvcMslShaderInterfaceVar.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LOCATION = layout.offsetof(0);
        FORMAT = layout.offsetof(1);
        BUILTIN = layout.offsetof(2);
        VECSIZE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<SpvcMslShaderInterfaceVar, Buffer>
    implements NativeResource {
        private static final SpvcMslShaderInterfaceVar ELEMENT_FACTORY = SpvcMslShaderInterfaceVar.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SpvcMslShaderInterfaceVar getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned")
        public int location() {
            return SpvcMslShaderInterfaceVar.nlocation(this.address());
        }

        @NativeType(value="spvc_msl_vertex_format")
        public int format() {
            return SpvcMslShaderInterfaceVar.nformat(this.address());
        }

        @NativeType(value="SpvBuiltIn")
        public int builtin() {
            return SpvcMslShaderInterfaceVar.nbuiltin(this.address());
        }

        @NativeType(value="unsigned")
        public int vecsize() {
            return SpvcMslShaderInterfaceVar.nvecsize(this.address());
        }

        public Buffer location(@NativeType(value="unsigned") int value) {
            SpvcMslShaderInterfaceVar.nlocation(this.address(), value);
            return this;
        }

        public Buffer format(@NativeType(value="spvc_msl_vertex_format") int value) {
            SpvcMslShaderInterfaceVar.nformat(this.address(), value);
            return this;
        }

        public Buffer builtin(@NativeType(value="SpvBuiltIn") int value) {
            SpvcMslShaderInterfaceVar.nbuiltin(this.address(), value);
            return this;
        }

        public Buffer vecsize(@NativeType(value="unsigned") int value) {
            SpvcMslShaderInterfaceVar.nvecsize(this.address(), value);
            return this;
        }
    }
}

