/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.tootle;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Platform;

public class Tootle {
    public static final int TOOTLE_DEFAULT_VCACHE_SIZE = 16;
    public static final int TOOTLE_MAX_FACES = Integer.MAX_VALUE;
    public static final int TOOTLE_MAX_VERTICES = Integer.MAX_VALUE;
    public static final float TOOTLE_DEFAULT_ALPHA = 0.75f;
    public static final int TOOTLE_OK = 1;
    public static final int TOOTLE_INVALID_ARGS = 2;
    public static final int TOOTLE_OUT_OF_MEMORY = 3;
    public static final int TOOTLE_3D_API_ERROR = 4;
    public static final int TOOTLE_INTERNAL_ERROR = 5;
    public static final int TOOTLE_NOT_INITIALIZED = 6;
    public static final int TOOTLE_CCW = 1;
    public static final int TOOTLE_CW = 2;
    public static final int TOOTLE_VCACHE_AUTO = 1;
    public static final int TOOTLE_VCACHE_DIRECT3D = 2;
    public static final int TOOTLE_VCACHE_LSTRIPS = 3;
    public static final int TOOTLE_VCACHE_TIPSY = 4;
    public static final int TOOTLE_OVERDRAW_AUTO = 1;
    public static final int TOOTLE_OVERDRAW_DIRECT3D = 2;
    public static final int TOOTLE_OVERDRAW_RAYTRACE = 3;
    public static final int TOOTLE_OVERDRAW_FAST = 4;

    protected Tootle() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="TootleResult")
    public static native int TootleInit();

    public static native int nTootleOptimizeVCache(long var0, int var2, int var3, int var4, long var5, long var7, int var9);

    @NativeType(value="TootleResult")
    public static int TootleOptimizeVCache(@NativeType(value="unsigned int const *") IntBuffer pnIB, @NativeType(value="unsigned int") int nVertices, @NativeType(value="unsigned int") int nCacheSize, @NativeType(value="unsigned int *") @Nullable IntBuffer pnIBOut, @NativeType(value="unsigned int *") @Nullable IntBuffer pnFaceRemapOut, @NativeType(value="TootleVCacheOptimizer") int eVCacheOptimizer) {
        int nFaces = pnIB.remaining() / 3;
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)pnIBOut, pnIB.remaining());
            Checks.checkSafe((Buffer)pnFaceRemapOut, nFaces);
        }
        return Tootle.nTootleOptimizeVCache(MemoryUtil.memAddress(pnIB), nFaces, nVertices, nCacheSize, MemoryUtil.memAddressSafe(pnIBOut), MemoryUtil.memAddressSafe(pnFaceRemapOut), eVCacheOptimizer);
    }

    public static native int nTootleClusterMesh(long var0, long var2, int var4, int var5, int var6, int var7, long var8, long var10, long var12);

    @NativeType(value="TootleResult")
    public static int TootleClusterMesh(@NativeType(value="void const *") ByteBuffer pVB, @NativeType(value="unsigned int const *") IntBuffer pnIB, @NativeType(value="unsigned int") int nVBStride, @NativeType(value="unsigned int") int nTargetClusters, @NativeType(value="unsigned int *") IntBuffer pnClusteredIBOut, @NativeType(value="unsigned int *") IntBuffer pnFaceClustersOut, @NativeType(value="unsigned int *") @Nullable IntBuffer pnFaceRemapOut) {
        int nFaces = pnIB.remaining() / 3;
        if (Checks.CHECKS) {
            Checks.check((Buffer)pnClusteredIBOut, pnIB.remaining());
            Checks.check((Buffer)pnFaceClustersOut, nFaces + 1);
            Checks.checkSafe((Buffer)pnFaceRemapOut, nFaces);
        }
        return Tootle.nTootleClusterMesh(MemoryUtil.memAddress(pVB), MemoryUtil.memAddress(pnIB), pVB.remaining() / nVBStride, nFaces, nVBStride, nTargetClusters, MemoryUtil.memAddress(pnClusteredIBOut), MemoryUtil.memAddress(pnFaceClustersOut), MemoryUtil.memAddressSafe(pnFaceRemapOut));
    }

    @NativeType(value="TootleResult")
    public static int TootleClusterMesh(@NativeType(value="void const *") FloatBuffer pVB, @NativeType(value="unsigned int const *") IntBuffer pnIB, @NativeType(value="unsigned int") int nVBStride, @NativeType(value="unsigned int") int nTargetClusters, @NativeType(value="unsigned int *") IntBuffer pnClusteredIBOut, @NativeType(value="unsigned int *") IntBuffer pnFaceClustersOut, @NativeType(value="unsigned int *") @Nullable IntBuffer pnFaceRemapOut) {
        int nFaces = pnIB.remaining() / 3;
        if (Checks.CHECKS) {
            Checks.check((Buffer)pnClusteredIBOut, pnIB.remaining());
            Checks.check((Buffer)pnFaceClustersOut, nFaces + 1);
            Checks.checkSafe((Buffer)pnFaceRemapOut, nFaces);
        }
        return Tootle.nTootleClusterMesh(MemoryUtil.memAddress(pVB), MemoryUtil.memAddress(pnIB), (int)(((long)pVB.remaining() << 2) / (long)nVBStride), nFaces, nVBStride, nTargetClusters, MemoryUtil.memAddress(pnClusteredIBOut), MemoryUtil.memAddress(pnFaceClustersOut), MemoryUtil.memAddressSafe(pnFaceRemapOut));
    }

    public static native int nTootleFastOptimizeVCacheAndClusterMesh(long var0, int var2, int var3, int var4, long var5, long var7, long var9, float var11);

    @NativeType(value="TootleResult")
    public static int TootleFastOptimizeVCacheAndClusterMesh(@NativeType(value="unsigned int const *") IntBuffer pnIB, @NativeType(value="unsigned int") int nVertices, @NativeType(value="unsigned int") int nCacheSize, @NativeType(value="unsigned int *") IntBuffer pnIBOut, @NativeType(value="unsigned int *") IntBuffer pnClustersOut, @NativeType(value="unsigned int *") IntBuffer pnNumClustersOut, float fAlpha) {
        int nFaces = pnIB.remaining() / 3;
        if (Checks.CHECKS) {
            Checks.check((Buffer)pnIBOut, pnIB.remaining());
            Checks.check((Buffer)pnClustersOut, nFaces + 1);
            Checks.check((Buffer)pnNumClustersOut, 1);
        }
        return Tootle.nTootleFastOptimizeVCacheAndClusterMesh(MemoryUtil.memAddress(pnIB), nFaces, nVertices, nCacheSize, MemoryUtil.memAddress(pnIBOut), MemoryUtil.memAddress(pnClustersOut), MemoryUtil.memAddress(pnNumClustersOut), fAlpha);
    }

    public static native int nTootleOptimizeOverdraw(long var0, long var2, int var4, int var5, int var6, long var7, int var9, int var10, long var11, long var13, long var15, int var17);

    @NativeType(value="TootleResult")
    public static int TootleOptimizeOverdraw(@NativeType(value="void const *") ByteBuffer pVB, @NativeType(value="unsigned int const *") IntBuffer pnIB, @NativeType(value="unsigned int") int nVBStride, @NativeType(value="float const *") @Nullable FloatBuffer pfViewpoint, @NativeType(value="TootleFaceWinding") int eFrontWinding, @NativeType(value="unsigned int const *") IntBuffer pnFaceClusters, @NativeType(value="unsigned int *") @Nullable IntBuffer pnIBOut, @NativeType(value="unsigned int *") @Nullable IntBuffer pnClusterRemapOut, @NativeType(value="TootleOverdrawOptimizer") int eOverdrawOptimizer) {
        int nFaces = pnIB.remaining() / 3;
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)pnIBOut, pnIB.remaining());
            Checks.check((Buffer)pnFaceClusters, nFaces + 1);
            Checks.checkSafe((Buffer)pnClusterRemapOut, pnFaceClusters.get(nFaces));
        }
        return Tootle.nTootleOptimizeOverdraw(MemoryUtil.memAddress(pVB), MemoryUtil.memAddress(pnIB), pVB.remaining() / nVBStride, nFaces, nVBStride, MemoryUtil.memAddressSafe(pfViewpoint), Checks.remainingSafe(pfViewpoint) / 3, eFrontWinding, MemoryUtil.memAddress(pnFaceClusters), MemoryUtil.memAddressSafe(pnIBOut), MemoryUtil.memAddressSafe(pnClusterRemapOut), eOverdrawOptimizer);
    }

    @NativeType(value="TootleResult")
    public static int TootleOptimizeOverdraw(@NativeType(value="void const *") FloatBuffer pVB, @NativeType(value="unsigned int const *") IntBuffer pnIB, @NativeType(value="unsigned int") int nVBStride, @NativeType(value="float const *") @Nullable FloatBuffer pfViewpoint, @NativeType(value="TootleFaceWinding") int eFrontWinding, @NativeType(value="unsigned int const *") IntBuffer pnFaceClusters, @NativeType(value="unsigned int *") @Nullable IntBuffer pnIBOut, @NativeType(value="unsigned int *") @Nullable IntBuffer pnClusterRemapOut, @NativeType(value="TootleOverdrawOptimizer") int eOverdrawOptimizer) {
        int nFaces = pnIB.remaining() / 3;
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)pnIBOut, pnIB.remaining());
            Checks.check((Buffer)pnFaceClusters, nFaces + 1);
            Checks.checkSafe((Buffer)pnClusterRemapOut, pnFaceClusters.get(nFaces));
        }
        return Tootle.nTootleOptimizeOverdraw(MemoryUtil.memAddress(pVB), MemoryUtil.memAddress(pnIB), (int)(((long)pVB.remaining() << 2) / (long)nVBStride), nFaces, nVBStride, MemoryUtil.memAddressSafe(pfViewpoint), Checks.remainingSafe(pfViewpoint) / 3, eFrontWinding, MemoryUtil.memAddress(pnFaceClusters), MemoryUtil.memAddressSafe(pnIBOut), MemoryUtil.memAddressSafe(pnClusterRemapOut), eOverdrawOptimizer);
    }

    public static native void TootleCleanup();

    public static native int nTootleOptimize(long var0, long var2, int var4, int var5, int var6, int var7, long var8, int var10, int var11, long var12, long var14, int var16, int var17);

    @NativeType(value="TootleResult")
    public static int TootleOptimize(@NativeType(value="void const *") ByteBuffer pVB, @NativeType(value="unsigned int const *") IntBuffer pnIB, @NativeType(value="unsigned int") int nVBStride, @NativeType(value="unsigned int") int nCacheSize, @NativeType(value="float const *") @Nullable FloatBuffer pViewpoints, @NativeType(value="TootleFaceWinding") int eFrontWinding, @NativeType(value="unsigned int *") IntBuffer pnIBOut, @NativeType(value="unsigned int *") @Nullable IntBuffer pnNumClustersOut, @NativeType(value="TootleVCacheOptimizer") int eVCacheOptimizer, @NativeType(value="TootleOverdrawOptimizer") int eOverdrawOptimizer) {
        int nFaces = pnIB.remaining() / 3;
        if (Checks.CHECKS) {
            Checks.check((Buffer)pnIBOut, pnIB.remaining());
            Checks.checkSafe((Buffer)pnNumClustersOut, 1);
        }
        return Tootle.nTootleOptimize(MemoryUtil.memAddress(pVB), MemoryUtil.memAddress(pnIB), pVB.remaining() / nVBStride, nFaces, nVBStride, nCacheSize, MemoryUtil.memAddressSafe(pViewpoints), Checks.remainingSafe(pViewpoints) / 3, eFrontWinding, MemoryUtil.memAddress(pnIBOut), MemoryUtil.memAddressSafe(pnNumClustersOut), eVCacheOptimizer, eOverdrawOptimizer);
    }

    @NativeType(value="TootleResult")
    public static int TootleOptimize(@NativeType(value="void const *") FloatBuffer pVB, @NativeType(value="unsigned int const *") IntBuffer pnIB, @NativeType(value="unsigned int") int nVBStride, @NativeType(value="unsigned int") int nCacheSize, @NativeType(value="float const *") @Nullable FloatBuffer pViewpoints, @NativeType(value="TootleFaceWinding") int eFrontWinding, @NativeType(value="unsigned int *") IntBuffer pnIBOut, @NativeType(value="unsigned int *") @Nullable IntBuffer pnNumClustersOut, @NativeType(value="TootleVCacheOptimizer") int eVCacheOptimizer, @NativeType(value="TootleOverdrawOptimizer") int eOverdrawOptimizer) {
        int nFaces = pnIB.remaining() / 3;
        if (Checks.CHECKS) {
            Checks.check((Buffer)pnIBOut, pnIB.remaining());
            Checks.checkSafe((Buffer)pnNumClustersOut, 1);
        }
        return Tootle.nTootleOptimize(MemoryUtil.memAddress(pVB), MemoryUtil.memAddress(pnIB), (int)(((long)pVB.remaining() << 2) / (long)nVBStride), nFaces, nVBStride, nCacheSize, MemoryUtil.memAddressSafe(pViewpoints), Checks.remainingSafe(pViewpoints) / 3, eFrontWinding, MemoryUtil.memAddress(pnIBOut), MemoryUtil.memAddressSafe(pnNumClustersOut), eVCacheOptimizer, eOverdrawOptimizer);
    }

    public static native int nTootleFastOptimize(long var0, long var2, int var4, int var5, int var6, int var7, int var8, long var9, long var11, float var13);

    @NativeType(value="TootleResult")
    public static int TootleFastOptimize(@NativeType(value="void const *") ByteBuffer pVB, @NativeType(value="unsigned int const *") IntBuffer pnIB, @NativeType(value="unsigned int") int nVBStride, @NativeType(value="unsigned int") int nCacheSize, @NativeType(value="TootleFaceWinding") int eFrontWinding, @NativeType(value="unsigned int *") IntBuffer pnIBOut, @NativeType(value="unsigned int *") @Nullable IntBuffer pnNumClustersOut, float fAlpha) {
        int nFaces = pnIB.remaining() / 3;
        if (Checks.CHECKS) {
            Checks.check((Buffer)pnIBOut, pnIB.remaining());
            Checks.checkSafe((Buffer)pnNumClustersOut, 1);
        }
        return Tootle.nTootleFastOptimize(MemoryUtil.memAddress(pVB), MemoryUtil.memAddress(pnIB), pVB.remaining() / nVBStride, nFaces, nVBStride, nCacheSize, eFrontWinding, MemoryUtil.memAddress(pnIBOut), MemoryUtil.memAddressSafe(pnNumClustersOut), fAlpha);
    }

    @NativeType(value="TootleResult")
    public static int TootleFastOptimize(@NativeType(value="void const *") FloatBuffer pVB, @NativeType(value="unsigned int const *") IntBuffer pnIB, @NativeType(value="unsigned int") int nVBStride, @NativeType(value="unsigned int") int nCacheSize, @NativeType(value="TootleFaceWinding") int eFrontWinding, @NativeType(value="unsigned int *") IntBuffer pnIBOut, @NativeType(value="unsigned int *") @Nullable IntBuffer pnNumClustersOut, float fAlpha) {
        int nFaces = pnIB.remaining() / 3;
        if (Checks.CHECKS) {
            Checks.check((Buffer)pnIBOut, pnIB.remaining());
            Checks.checkSafe((Buffer)pnNumClustersOut, 1);
        }
        return Tootle.nTootleFastOptimize(MemoryUtil.memAddress(pVB), MemoryUtil.memAddress(pnIB), (int)(((long)pVB.remaining() << 2) / (long)nVBStride), nFaces, nVBStride, nCacheSize, eFrontWinding, MemoryUtil.memAddress(pnIBOut), MemoryUtil.memAddressSafe(pnNumClustersOut), fAlpha);
    }

    public static native int nTootleVCacheClusters(long var0, int var2, int var3, int var4, long var5, long var7, long var9, int var11);

    @NativeType(value="TootleResult")
    public static int TootleVCacheClusters(@NativeType(value="unsigned int const *") IntBuffer pnIB, @NativeType(value="unsigned int") int nVertices, @NativeType(value="unsigned int") int nCacheSize, @NativeType(value="unsigned int const *") IntBuffer pnFaceClusters, @NativeType(value="unsigned int *") @Nullable IntBuffer pnIBOut, @NativeType(value="unsigned int *") @Nullable IntBuffer pnFaceRemapOut, @NativeType(value="TootleVCacheOptimizer") int eVCacheOptimizer) {
        int nFaces = pnIB.remaining() / 3;
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)pnIBOut, pnIB.remaining());
            Checks.check((Buffer)pnFaceClusters, nFaces + 1);
            Checks.checkSafe((Buffer)pnFaceRemapOut, nFaces);
        }
        return Tootle.nTootleVCacheClusters(MemoryUtil.memAddress(pnIB), nFaces, nVertices, nCacheSize, MemoryUtil.memAddress(pnFaceClusters), MemoryUtil.memAddressSafe(pnIBOut), MemoryUtil.memAddressSafe(pnFaceRemapOut), eVCacheOptimizer);
    }

    public static native int nTootleMeasureCacheEfficiency(long var0, int var2, int var3, long var4);

    @NativeType(value="TootleResult")
    public static int TootleMeasureCacheEfficiency(@NativeType(value="unsigned int const *") IntBuffer pnIB, @NativeType(value="unsigned int") int nCacheSize, @NativeType(value="float *") FloatBuffer pfEfficiencyOut) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pfEfficiencyOut, 1);
        }
        return Tootle.nTootleMeasureCacheEfficiency(MemoryUtil.memAddress(pnIB), pnIB.remaining() / 3, nCacheSize, MemoryUtil.memAddress(pfEfficiencyOut));
    }

    public static native int nTootleMeasureOverdraw(long var0, long var2, int var4, int var5, int var6, long var7, int var9, int var10, long var11, long var13, int var15);

    @NativeType(value="TootleResult")
    public static int TootleMeasureOverdraw(@NativeType(value="void const *") ByteBuffer pVB, @NativeType(value="unsigned int const *") IntBuffer pnIB, @NativeType(value="unsigned int") int nVBStride, @NativeType(value="float const *") @Nullable FloatBuffer pfViewpoint, @NativeType(value="TootleFaceWinding") int eFrontWinding, @NativeType(value="float *") @Nullable FloatBuffer pfAvgODOut, @NativeType(value="float *") @Nullable FloatBuffer pfMaxODOut, @NativeType(value="TootleOverdrawOptimizer") int eOverdrawOptimizer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)pfAvgODOut, 1);
            Checks.checkSafe((Buffer)pfMaxODOut, 1);
        }
        return Tootle.nTootleMeasureOverdraw(MemoryUtil.memAddress(pVB), MemoryUtil.memAddress(pnIB), pVB.remaining() / nVBStride, pnIB.remaining() / 3, nVBStride, MemoryUtil.memAddressSafe(pfViewpoint), Checks.remainingSafe(pfViewpoint) / 3, eFrontWinding, MemoryUtil.memAddressSafe(pfAvgODOut), MemoryUtil.memAddressSafe(pfMaxODOut), eOverdrawOptimizer);
    }

    @NativeType(value="TootleResult")
    public static int TootleMeasureOverdraw(@NativeType(value="void const *") FloatBuffer pVB, @NativeType(value="unsigned int const *") IntBuffer pnIB, @NativeType(value="unsigned int") int nVBStride, @NativeType(value="float const *") @Nullable FloatBuffer pfViewpoint, @NativeType(value="TootleFaceWinding") int eFrontWinding, @NativeType(value="float *") @Nullable FloatBuffer pfAvgODOut, @NativeType(value="float *") @Nullable FloatBuffer pfMaxODOut, @NativeType(value="TootleOverdrawOptimizer") int eOverdrawOptimizer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)pfAvgODOut, 1);
            Checks.checkSafe((Buffer)pfMaxODOut, 1);
        }
        return Tootle.nTootleMeasureOverdraw(MemoryUtil.memAddress(pVB), MemoryUtil.memAddress(pnIB), (int)(((long)pVB.remaining() << 2) / (long)nVBStride), pnIB.remaining() / 3, nVBStride, MemoryUtil.memAddressSafe(pfViewpoint), Checks.remainingSafe(pfViewpoint) / 3, eFrontWinding, MemoryUtil.memAddressSafe(pfAvgODOut), MemoryUtil.memAddressSafe(pfMaxODOut), eOverdrawOptimizer);
    }

    public static native int nTootleOptimizeVertexMemory(long var0, long var2, int var4, int var5, int var6, long var7, long var9, long var11);

    @NativeType(value="TootleResult")
    public static int TootleOptimizeVertexMemory(@NativeType(value="void const *") ByteBuffer pVB, @NativeType(value="unsigned int const *") IntBuffer pnIB, @NativeType(value="unsigned int") int nVBStride, @NativeType(value="void *") ByteBuffer pVBOut, @NativeType(value="unsigned int *") IntBuffer pnIBOut, @NativeType(value="unsigned int *") @Nullable IntBuffer pnVertexRemapOut) {
        int nVertices = pVB.remaining() / nVBStride;
        if (Checks.CHECKS) {
            Checks.check((Buffer)pVBOut, pVB.remaining());
            Checks.check((Buffer)pnIBOut, pnIB.remaining());
            Checks.checkSafe((Buffer)pnVertexRemapOut, nVertices);
        }
        return Tootle.nTootleOptimizeVertexMemory(MemoryUtil.memAddress(pVB), MemoryUtil.memAddress(pnIB), nVertices, pnIB.remaining() / 3, nVBStride, MemoryUtil.memAddress(pVBOut), MemoryUtil.memAddress(pnIBOut), MemoryUtil.memAddressSafe(pnVertexRemapOut));
    }

    @NativeType(value="TootleResult")
    public static int TootleOptimizeVertexMemory(@NativeType(value="void const *") FloatBuffer pVB, @NativeType(value="unsigned int const *") IntBuffer pnIB, @NativeType(value="unsigned int") int nVBStride, @NativeType(value="void *") FloatBuffer pVBOut, @NativeType(value="unsigned int *") IntBuffer pnIBOut, @NativeType(value="unsigned int *") @Nullable IntBuffer pnVertexRemapOut) {
        int nVertices = (int)(((long)pVBOut.remaining() << 2) / (long)nVBStride);
        if (Checks.CHECKS) {
            Checks.check((Buffer)pVBOut, pVB.remaining());
            Checks.check((Buffer)pnIBOut, pnIB.remaining());
            Checks.checkSafe((Buffer)pnVertexRemapOut, nVertices);
        }
        return Tootle.nTootleOptimizeVertexMemory(MemoryUtil.memAddress(pVB), MemoryUtil.memAddress(pnIB), nVertices, pnIB.remaining() / 3, nVBStride, MemoryUtil.memAddress(pVBOut), MemoryUtil.memAddress(pnIBOut), MemoryUtil.memAddressSafe(pnVertexRemapOut));
    }

    static {
        Library.loadSystem(System::load, System::loadLibrary, Tootle.class, "org.lwjgl.tootle", Platform.mapLibraryNameBundled("lwjgl_tootle"));
    }
}

