/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.vma.VmaDefragmentationMove;

public class VmaDefragmentationPassMoveInfo
extends Struct<VmaDefragmentationPassMoveInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MOVECOUNT;
    public static final int PMOVES;

    protected VmaDefragmentationPassMoveInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VmaDefragmentationPassMoveInfo create(long address, @Nullable ByteBuffer container) {
        return new VmaDefragmentationPassMoveInfo(address, container);
    }

    public VmaDefragmentationPassMoveInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VmaDefragmentationPassMoveInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int moveCount() {
        return VmaDefragmentationPassMoveInfo.nmoveCount(this.address());
    }

    @NativeType(value="VmaDefragmentationMove *")
    public @Nullable VmaDefragmentationMove.Buffer pMoves() {
        return VmaDefragmentationPassMoveInfo.npMoves(this.address());
    }

    public VmaDefragmentationPassMoveInfo moveCount(@NativeType(value="uint32_t") int value) {
        VmaDefragmentationPassMoveInfo.nmoveCount(this.address(), value);
        return this;
    }

    public VmaDefragmentationPassMoveInfo pMoves(@NativeType(value="VmaDefragmentationMove *") @Nullable VmaDefragmentationMove.Buffer value) {
        VmaDefragmentationPassMoveInfo.npMoves(this.address(), value);
        return this;
    }

    public VmaDefragmentationPassMoveInfo set(int moveCount, @Nullable VmaDefragmentationMove.Buffer pMoves) {
        this.moveCount(moveCount);
        this.pMoves(pMoves);
        return this;
    }

    public VmaDefragmentationPassMoveInfo set(VmaDefragmentationPassMoveInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VmaDefragmentationPassMoveInfo malloc() {
        return new VmaDefragmentationPassMoveInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VmaDefragmentationPassMoveInfo calloc() {
        return new VmaDefragmentationPassMoveInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VmaDefragmentationPassMoveInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VmaDefragmentationPassMoveInfo(MemoryUtil.memAddress(container), container);
    }

    public static VmaDefragmentationPassMoveInfo create(long address) {
        return new VmaDefragmentationPassMoveInfo(address, null);
    }

    public static @Nullable VmaDefragmentationPassMoveInfo createSafe(long address) {
        return address == 0L ? null : new VmaDefragmentationPassMoveInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VmaDefragmentationPassMoveInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaDefragmentationPassMoveInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VmaDefragmentationPassMoveInfo malloc(MemoryStack stack) {
        return new VmaDefragmentationPassMoveInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VmaDefragmentationPassMoveInfo calloc(MemoryStack stack) {
        return new VmaDefragmentationPassMoveInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmoveCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MOVECOUNT);
    }

    public static @Nullable VmaDefragmentationMove.Buffer npMoves(long struct) {
        return VmaDefragmentationMove.createSafe(MemoryUtil.memGetAddress(struct + (long)PMOVES), VmaDefragmentationPassMoveInfo.nmoveCount(struct));
    }

    public static void nmoveCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MOVECOUNT, value);
    }

    public static void npMoves(long struct, @Nullable VmaDefragmentationMove.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PMOVES, MemoryUtil.memAddressSafe(value));
        VmaDefragmentationPassMoveInfo.nmoveCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        int moveCount = VmaDefragmentationPassMoveInfo.nmoveCount(struct);
        long pMoves = MemoryUtil.memGetAddress(struct + (long)PMOVES);
        if (pMoves != 0L) {
            VmaDefragmentationPassMoveInfo.validate(pMoves, moveCount, VmaDefragmentationMove.SIZEOF, VmaDefragmentationMove::validate);
        }
    }

    static {
        Struct.Layout layout = VmaDefragmentationPassMoveInfo.__struct(VmaDefragmentationPassMoveInfo.__member(4), VmaDefragmentationPassMoveInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MOVECOUNT = layout.offsetof(0);
        PMOVES = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VmaDefragmentationPassMoveInfo, Buffer>
    implements NativeResource {
        private static final VmaDefragmentationPassMoveInfo ELEMENT_FACTORY = VmaDefragmentationPassMoveInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VmaDefragmentationPassMoveInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int moveCount() {
            return VmaDefragmentationPassMoveInfo.nmoveCount(this.address());
        }

        @NativeType(value="VmaDefragmentationMove *")
        public @Nullable VmaDefragmentationMove.Buffer pMoves() {
            return VmaDefragmentationPassMoveInfo.npMoves(this.address());
        }

        public Buffer moveCount(@NativeType(value="uint32_t") int value) {
            VmaDefragmentationPassMoveInfo.nmoveCount(this.address(), value);
            return this;
        }

        public Buffer pMoves(@NativeType(value="VmaDefragmentationMove *") @Nullable VmaDefragmentationMove.Buffer value) {
            VmaDefragmentationPassMoveInfo.npMoves(this.address(), value);
            return this;
        }
    }
}

