/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VmaDefragmentationStats
extends Struct<VmaDefragmentationStats>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BYTESMOVED;
    public static final int BYTESFREED;
    public static final int ALLOCATIONSMOVED;
    public static final int DEVICEMEMORYBLOCKSFREED;

    protected VmaDefragmentationStats(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VmaDefragmentationStats create(long address, @Nullable ByteBuffer container) {
        return new VmaDefragmentationStats(address, container);
    }

    public VmaDefragmentationStats(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VmaDefragmentationStats.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long bytesMoved() {
        return VmaDefragmentationStats.nbytesMoved(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long bytesFreed() {
        return VmaDefragmentationStats.nbytesFreed(this.address());
    }

    @NativeType(value="uint32_t")
    public int allocationsMoved() {
        return VmaDefragmentationStats.nallocationsMoved(this.address());
    }

    @NativeType(value="uint32_t")
    public int deviceMemoryBlocksFreed() {
        return VmaDefragmentationStats.ndeviceMemoryBlocksFreed(this.address());
    }

    public static VmaDefragmentationStats malloc() {
        return new VmaDefragmentationStats(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VmaDefragmentationStats calloc() {
        return new VmaDefragmentationStats(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VmaDefragmentationStats create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VmaDefragmentationStats(MemoryUtil.memAddress(container), container);
    }

    public static VmaDefragmentationStats create(long address) {
        return new VmaDefragmentationStats(address, null);
    }

    public static @Nullable VmaDefragmentationStats createSafe(long address) {
        return address == 0L ? null : new VmaDefragmentationStats(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VmaDefragmentationStats.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaDefragmentationStats.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VmaDefragmentationStats mallocStack() {
        return VmaDefragmentationStats.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaDefragmentationStats callocStack() {
        return VmaDefragmentationStats.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaDefragmentationStats mallocStack(MemoryStack stack) {
        return VmaDefragmentationStats.malloc(stack);
    }

    @Deprecated
    public static VmaDefragmentationStats callocStack(MemoryStack stack) {
        return VmaDefragmentationStats.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VmaDefragmentationStats.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VmaDefragmentationStats.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VmaDefragmentationStats.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VmaDefragmentationStats.calloc(capacity, stack);
    }

    public static VmaDefragmentationStats malloc(MemoryStack stack) {
        return new VmaDefragmentationStats(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VmaDefragmentationStats calloc(MemoryStack stack) {
        return new VmaDefragmentationStats(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nbytesMoved(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BYTESMOVED);
    }

    public static long nbytesFreed(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BYTESFREED);
    }

    public static int nallocationsMoved(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ALLOCATIONSMOVED);
    }

    public static int ndeviceMemoryBlocksFreed(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEVICEMEMORYBLOCKSFREED);
    }

    static {
        Struct.Layout layout = VmaDefragmentationStats.__struct(VmaDefragmentationStats.__member(8), VmaDefragmentationStats.__member(8), VmaDefragmentationStats.__member(4), VmaDefragmentationStats.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BYTESMOVED = layout.offsetof(0);
        BYTESFREED = layout.offsetof(1);
        ALLOCATIONSMOVED = layout.offsetof(2);
        DEVICEMEMORYBLOCKSFREED = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VmaDefragmentationStats, Buffer>
    implements NativeResource {
        private static final VmaDefragmentationStats ELEMENT_FACTORY = VmaDefragmentationStats.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VmaDefragmentationStats getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceSize")
        public long bytesMoved() {
            return VmaDefragmentationStats.nbytesMoved(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long bytesFreed() {
            return VmaDefragmentationStats.nbytesFreed(this.address());
        }

        @NativeType(value="uint32_t")
        public int allocationsMoved() {
            return VmaDefragmentationStats.nallocationsMoved(this.address());
        }

        @NativeType(value="uint32_t")
        public int deviceMemoryBlocksFreed() {
            return VmaDefragmentationStats.ndeviceMemoryBlocksFreed(this.address());
        }
    }
}

