/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.vma.VmaStatistics;

public class VmaDetailedStatistics
extends Struct<VmaDetailedStatistics>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STATISTICS;
    public static final int UNUSEDRANGECOUNT;
    public static final int ALLOCATIONSIZEMIN;
    public static final int ALLOCATIONSIZEMAX;
    public static final int UNUSEDRANGESIZEMIN;
    public static final int UNUSEDRANGESIZEMAX;

    protected VmaDetailedStatistics(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VmaDetailedStatistics create(long address, @Nullable ByteBuffer container) {
        return new VmaDetailedStatistics(address, container);
    }

    public VmaDetailedStatistics(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VmaDetailedStatistics.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VmaStatistics statistics() {
        return VmaDetailedStatistics.nstatistics(this.address());
    }

    @NativeType(value="uint32_t")
    public int unusedRangeCount() {
        return VmaDetailedStatistics.nunusedRangeCount(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long allocationSizeMin() {
        return VmaDetailedStatistics.nallocationSizeMin(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long allocationSizeMax() {
        return VmaDetailedStatistics.nallocationSizeMax(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long unusedRangeSizeMin() {
        return VmaDetailedStatistics.nunusedRangeSizeMin(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long unusedRangeSizeMax() {
        return VmaDetailedStatistics.nunusedRangeSizeMax(this.address());
    }

    public static VmaDetailedStatistics malloc() {
        return new VmaDetailedStatistics(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VmaDetailedStatistics calloc() {
        return new VmaDetailedStatistics(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VmaDetailedStatistics create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VmaDetailedStatistics(MemoryUtil.memAddress(container), container);
    }

    public static VmaDetailedStatistics create(long address) {
        return new VmaDetailedStatistics(address, null);
    }

    public static @Nullable VmaDetailedStatistics createSafe(long address) {
        return address == 0L ? null : new VmaDetailedStatistics(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VmaDetailedStatistics.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaDetailedStatistics.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VmaDetailedStatistics malloc(MemoryStack stack) {
        return new VmaDetailedStatistics(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VmaDetailedStatistics calloc(MemoryStack stack) {
        return new VmaDetailedStatistics(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VmaStatistics nstatistics(long struct) {
        return VmaStatistics.create(struct + (long)STATISTICS);
    }

    public static int nunusedRangeCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)UNUSEDRANGECOUNT);
    }

    public static long nallocationSizeMin(long struct) {
        return MemoryUtil.memGetLong(struct + (long)ALLOCATIONSIZEMIN);
    }

    public static long nallocationSizeMax(long struct) {
        return MemoryUtil.memGetLong(struct + (long)ALLOCATIONSIZEMAX);
    }

    public static long nunusedRangeSizeMin(long struct) {
        return MemoryUtil.memGetLong(struct + (long)UNUSEDRANGESIZEMIN);
    }

    public static long nunusedRangeSizeMax(long struct) {
        return MemoryUtil.memGetLong(struct + (long)UNUSEDRANGESIZEMAX);
    }

    static {
        Struct.Layout layout = VmaDetailedStatistics.__struct(VmaDetailedStatistics.__member(VmaStatistics.SIZEOF, VmaStatistics.ALIGNOF), VmaDetailedStatistics.__member(4), VmaDetailedStatistics.__member(8), VmaDetailedStatistics.__member(8), VmaDetailedStatistics.__member(8), VmaDetailedStatistics.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STATISTICS = layout.offsetof(0);
        UNUSEDRANGECOUNT = layout.offsetof(1);
        ALLOCATIONSIZEMIN = layout.offsetof(2);
        ALLOCATIONSIZEMAX = layout.offsetof(3);
        UNUSEDRANGESIZEMIN = layout.offsetof(4);
        UNUSEDRANGESIZEMAX = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VmaDetailedStatistics, Buffer>
    implements NativeResource {
        private static final VmaDetailedStatistics ELEMENT_FACTORY = VmaDetailedStatistics.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VmaDetailedStatistics getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VmaStatistics statistics() {
            return VmaDetailedStatistics.nstatistics(this.address());
        }

        @NativeType(value="uint32_t")
        public int unusedRangeCount() {
            return VmaDetailedStatistics.nunusedRangeCount(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long allocationSizeMin() {
            return VmaDetailedStatistics.nallocationSizeMin(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long allocationSizeMax() {
            return VmaDetailedStatistics.nallocationSizeMax(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long unusedRangeSizeMin() {
            return VmaDetailedStatistics.nunusedRangeSizeMin(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long unusedRangeSizeMax() {
            return VmaDetailedStatistics.nunusedRangeSizeMax(this.address());
        }
    }
}

