/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.yoga;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class YGSize
extends Struct<YGSize>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;

    protected YGSize(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected YGSize create(long address, @Nullable ByteBuffer container) {
        return new YGSize(address, container);
    }

    public YGSize(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), YGSize.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float width() {
        return YGSize.nwidth(this.address());
    }

    public float height() {
        return YGSize.nheight(this.address());
    }

    public YGSize width(float value) {
        YGSize.nwidth(this.address(), value);
        return this;
    }

    public YGSize height(float value) {
        YGSize.nheight(this.address(), value);
        return this;
    }

    public YGSize set(float width, float height) {
        this.width(width);
        this.height(height);
        return this;
    }

    public YGSize set(YGSize src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static YGSize malloc() {
        return new YGSize(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static YGSize calloc() {
        return new YGSize(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static YGSize create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new YGSize(MemoryUtil.memAddress(container), container);
    }

    public static YGSize create(long address) {
        return new YGSize(address, null);
    }

    public static @Nullable YGSize createSafe(long address) {
        return address == 0L ? null : new YGSize(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(YGSize.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = YGSize.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static YGSize mallocStack() {
        return YGSize.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static YGSize callocStack() {
        return YGSize.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static YGSize mallocStack(MemoryStack stack) {
        return YGSize.malloc(stack);
    }

    @Deprecated
    public static YGSize callocStack(MemoryStack stack) {
        return YGSize.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return YGSize.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return YGSize.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return YGSize.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return YGSize.calloc(capacity, stack);
    }

    public static YGSize malloc(MemoryStack stack) {
        return new YGSize(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static YGSize calloc(MemoryStack stack) {
        return new YGSize(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nwidth(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)WIDTH);
    }

    public static float nheight(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)HEIGHT);
    }

    public static void nwidth(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)HEIGHT, value);
    }

    static {
        Struct.Layout layout = YGSize.__struct(YGSize.__member(4), YGSize.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<YGSize, Buffer>
    implements NativeResource {
        private static final YGSize ELEMENT_FACTORY = YGSize.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected YGSize getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float width() {
            return YGSize.nwidth(this.address());
        }

        public float height() {
            return YGSize.nheight(this.address());
        }

        public Buffer width(float value) {
            YGSize.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(float value) {
            YGSize.nheight(this.address(), value);
            return this;
        }
    }
}

