/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.zstd.ZDICTParams;

@NativeType(value="struct ZDICT_cover_params_t")
public class ZDICTCoverParams
extends Struct<ZDICTCoverParams>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int K;
    public static final int D;
    public static final int STEPS;
    public static final int NBTHREADS;
    public static final int SPLITPOINT;
    public static final int ZPARAMS;

    protected ZDICTCoverParams(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected ZDICTCoverParams create(long address, @Nullable ByteBuffer container) {
        return new ZDICTCoverParams(address, container);
    }

    public ZDICTCoverParams(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), ZDICTCoverParams.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned")
    public int k() {
        return ZDICTCoverParams.nk(this.address());
    }

    @NativeType(value="unsigned")
    public int d() {
        return ZDICTCoverParams.nd(this.address());
    }

    @NativeType(value="unsigned")
    public int steps() {
        return ZDICTCoverParams.nsteps(this.address());
    }

    @NativeType(value="unsigned")
    public int nbThreads() {
        return ZDICTCoverParams.nnbThreads(this.address());
    }

    public double splitPoint() {
        return ZDICTCoverParams.nsplitPoint(this.address());
    }

    @NativeType(value="ZDICT_params_t")
    public ZDICTParams zParams() {
        return ZDICTCoverParams.nzParams(this.address());
    }

    public ZDICTCoverParams k(@NativeType(value="unsigned") int value) {
        ZDICTCoverParams.nk(this.address(), value);
        return this;
    }

    public ZDICTCoverParams d(@NativeType(value="unsigned") int value) {
        ZDICTCoverParams.nd(this.address(), value);
        return this;
    }

    public ZDICTCoverParams steps(@NativeType(value="unsigned") int value) {
        ZDICTCoverParams.nsteps(this.address(), value);
        return this;
    }

    public ZDICTCoverParams nbThreads(@NativeType(value="unsigned") int value) {
        ZDICTCoverParams.nnbThreads(this.address(), value);
        return this;
    }

    public ZDICTCoverParams splitPoint(double value) {
        ZDICTCoverParams.nsplitPoint(this.address(), value);
        return this;
    }

    public ZDICTCoverParams zParams(@NativeType(value="ZDICT_params_t") ZDICTParams value) {
        ZDICTCoverParams.nzParams(this.address(), value);
        return this;
    }

    public ZDICTCoverParams zParams(Consumer<ZDICTParams> consumer) {
        consumer.accept(this.zParams());
        return this;
    }

    public ZDICTCoverParams set(int k, int d, int steps, int nbThreads, double splitPoint, ZDICTParams zParams) {
        this.k(k);
        this.d(d);
        this.steps(steps);
        this.nbThreads(nbThreads);
        this.splitPoint(splitPoint);
        this.zParams(zParams);
        return this;
    }

    public ZDICTCoverParams set(ZDICTCoverParams src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static ZDICTCoverParams malloc() {
        return new ZDICTCoverParams(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static ZDICTCoverParams calloc() {
        return new ZDICTCoverParams(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static ZDICTCoverParams create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new ZDICTCoverParams(MemoryUtil.memAddress(container), container);
    }

    public static ZDICTCoverParams create(long address) {
        return new ZDICTCoverParams(address, null);
    }

    public static @Nullable ZDICTCoverParams createSafe(long address) {
        return address == 0L ? null : new ZDICTCoverParams(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(ZDICTCoverParams.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZDICTCoverParams.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static ZDICTCoverParams mallocStack() {
        return ZDICTCoverParams.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZDICTCoverParams callocStack() {
        return ZDICTCoverParams.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZDICTCoverParams mallocStack(MemoryStack stack) {
        return ZDICTCoverParams.malloc(stack);
    }

    @Deprecated
    public static ZDICTCoverParams callocStack(MemoryStack stack) {
        return ZDICTCoverParams.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return ZDICTCoverParams.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return ZDICTCoverParams.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ZDICTCoverParams.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ZDICTCoverParams.calloc(capacity, stack);
    }

    public static ZDICTCoverParams malloc(MemoryStack stack) {
        return new ZDICTCoverParams(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ZDICTCoverParams calloc(MemoryStack stack) {
        return new ZDICTCoverParams(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nk(long struct) {
        return MemoryUtil.memGetInt(struct + (long)K);
    }

    public static int nd(long struct) {
        return MemoryUtil.memGetInt(struct + (long)D);
    }

    public static int nsteps(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STEPS);
    }

    public static int nnbThreads(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NBTHREADS);
    }

    public static double nsplitPoint(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)SPLITPOINT);
    }

    public static ZDICTParams nzParams(long struct) {
        return ZDICTParams.create(struct + (long)ZPARAMS);
    }

    public static void nk(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)K, value);
    }

    public static void nd(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)D, value);
    }

    public static void nsteps(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STEPS, value);
    }

    public static void nnbThreads(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NBTHREADS, value);
    }

    public static void nsplitPoint(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)SPLITPOINT, value);
    }

    public static void nzParams(long struct, ZDICTParams value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ZPARAMS, ZDICTParams.SIZEOF);
    }

    static {
        Struct.Layout layout = ZDICTCoverParams.__struct(ZDICTCoverParams.__member(4), ZDICTCoverParams.__member(4), ZDICTCoverParams.__member(4), ZDICTCoverParams.__member(4), ZDICTCoverParams.__member(8), ZDICTCoverParams.__member(ZDICTParams.SIZEOF, ZDICTParams.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        K = layout.offsetof(0);
        D = layout.offsetof(1);
        STEPS = layout.offsetof(2);
        NBTHREADS = layout.offsetof(3);
        SPLITPOINT = layout.offsetof(4);
        ZPARAMS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<ZDICTCoverParams, Buffer>
    implements NativeResource {
        private static final ZDICTCoverParams ELEMENT_FACTORY = ZDICTCoverParams.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected ZDICTCoverParams getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned")
        public int k() {
            return ZDICTCoverParams.nk(this.address());
        }

        @NativeType(value="unsigned")
        public int d() {
            return ZDICTCoverParams.nd(this.address());
        }

        @NativeType(value="unsigned")
        public int steps() {
            return ZDICTCoverParams.nsteps(this.address());
        }

        @NativeType(value="unsigned")
        public int nbThreads() {
            return ZDICTCoverParams.nnbThreads(this.address());
        }

        public double splitPoint() {
            return ZDICTCoverParams.nsplitPoint(this.address());
        }

        @NativeType(value="ZDICT_params_t")
        public ZDICTParams zParams() {
            return ZDICTCoverParams.nzParams(this.address());
        }

        public Buffer k(@NativeType(value="unsigned") int value) {
            ZDICTCoverParams.nk(this.address(), value);
            return this;
        }

        public Buffer d(@NativeType(value="unsigned") int value) {
            ZDICTCoverParams.nd(this.address(), value);
            return this;
        }

        public Buffer steps(@NativeType(value="unsigned") int value) {
            ZDICTCoverParams.nsteps(this.address(), value);
            return this;
        }

        public Buffer nbThreads(@NativeType(value="unsigned") int value) {
            ZDICTCoverParams.nnbThreads(this.address(), value);
            return this;
        }

        public Buffer splitPoint(double value) {
            ZDICTCoverParams.nsplitPoint(this.address(), value);
            return this;
        }

        public Buffer zParams(@NativeType(value="ZDICT_params_t") ZDICTParams value) {
            ZDICTCoverParams.nzParams(this.address(), value);
            return this;
        }

        public Buffer zParams(Consumer<ZDICTParams> consumer) {
            consumer.accept(this.zParams());
            return this;
        }
    }
}

