/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ZSTD_compressionParameters")
public class ZSTDCompressionParameters
extends Struct<ZSTDCompressionParameters>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WINDOWLOG;
    public static final int CHAINLOG;
    public static final int HASHLOG;
    public static final int SEARCHLOG;
    public static final int MINMATCH;
    public static final int TARGETLENGTH;
    public static final int STRATEGY;

    protected ZSTDCompressionParameters(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected ZSTDCompressionParameters create(long address, @Nullable ByteBuffer container) {
        return new ZSTDCompressionParameters(address, container);
    }

    public ZSTDCompressionParameters(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), ZSTDCompressionParameters.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int windowLog() {
        return ZSTDCompressionParameters.nwindowLog(this.address());
    }

    @NativeType(value="unsigned int")
    public int chainLog() {
        return ZSTDCompressionParameters.nchainLog(this.address());
    }

    @NativeType(value="unsigned int")
    public int hashLog() {
        return ZSTDCompressionParameters.nhashLog(this.address());
    }

    @NativeType(value="unsigned int")
    public int searchLog() {
        return ZSTDCompressionParameters.nsearchLog(this.address());
    }

    @NativeType(value="unsigned int")
    public int minMatch() {
        return ZSTDCompressionParameters.nminMatch(this.address());
    }

    @NativeType(value="unsigned int")
    public int targetLength() {
        return ZSTDCompressionParameters.ntargetLength(this.address());
    }

    @NativeType(value="ZSTD_strategy")
    public int strategy() {
        return ZSTDCompressionParameters.nstrategy(this.address());
    }

    public ZSTDCompressionParameters windowLog(@NativeType(value="unsigned int") int value) {
        ZSTDCompressionParameters.nwindowLog(this.address(), value);
        return this;
    }

    public ZSTDCompressionParameters chainLog(@NativeType(value="unsigned int") int value) {
        ZSTDCompressionParameters.nchainLog(this.address(), value);
        return this;
    }

    public ZSTDCompressionParameters hashLog(@NativeType(value="unsigned int") int value) {
        ZSTDCompressionParameters.nhashLog(this.address(), value);
        return this;
    }

    public ZSTDCompressionParameters searchLog(@NativeType(value="unsigned int") int value) {
        ZSTDCompressionParameters.nsearchLog(this.address(), value);
        return this;
    }

    public ZSTDCompressionParameters minMatch(@NativeType(value="unsigned int") int value) {
        ZSTDCompressionParameters.nminMatch(this.address(), value);
        return this;
    }

    public ZSTDCompressionParameters targetLength(@NativeType(value="unsigned int") int value) {
        ZSTDCompressionParameters.ntargetLength(this.address(), value);
        return this;
    }

    public ZSTDCompressionParameters strategy(@NativeType(value="ZSTD_strategy") int value) {
        ZSTDCompressionParameters.nstrategy(this.address(), value);
        return this;
    }

    public ZSTDCompressionParameters set(int windowLog, int chainLog, int hashLog, int searchLog, int minMatch, int targetLength, int strategy) {
        this.windowLog(windowLog);
        this.chainLog(chainLog);
        this.hashLog(hashLog);
        this.searchLog(searchLog);
        this.minMatch(minMatch);
        this.targetLength(targetLength);
        this.strategy(strategy);
        return this;
    }

    public ZSTDCompressionParameters set(ZSTDCompressionParameters src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static ZSTDCompressionParameters malloc() {
        return new ZSTDCompressionParameters(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static ZSTDCompressionParameters calloc() {
        return new ZSTDCompressionParameters(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static ZSTDCompressionParameters create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new ZSTDCompressionParameters(MemoryUtil.memAddress(container), container);
    }

    public static ZSTDCompressionParameters create(long address) {
        return new ZSTDCompressionParameters(address, null);
    }

    public static @Nullable ZSTDCompressionParameters createSafe(long address) {
        return address == 0L ? null : new ZSTDCompressionParameters(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(ZSTDCompressionParameters.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZSTDCompressionParameters.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static ZSTDCompressionParameters mallocStack() {
        return ZSTDCompressionParameters.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDCompressionParameters callocStack() {
        return ZSTDCompressionParameters.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDCompressionParameters mallocStack(MemoryStack stack) {
        return ZSTDCompressionParameters.malloc(stack);
    }

    @Deprecated
    public static ZSTDCompressionParameters callocStack(MemoryStack stack) {
        return ZSTDCompressionParameters.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return ZSTDCompressionParameters.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return ZSTDCompressionParameters.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ZSTDCompressionParameters.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ZSTDCompressionParameters.calloc(capacity, stack);
    }

    public static ZSTDCompressionParameters malloc(MemoryStack stack) {
        return new ZSTDCompressionParameters(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ZSTDCompressionParameters calloc(MemoryStack stack) {
        return new ZSTDCompressionParameters(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nwindowLog(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WINDOWLOG);
    }

    public static int nchainLog(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CHAINLOG);
    }

    public static int nhashLog(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HASHLOG);
    }

    public static int nsearchLog(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SEARCHLOG);
    }

    public static int nminMatch(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MINMATCH);
    }

    public static int ntargetLength(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TARGETLENGTH);
    }

    public static int nstrategy(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STRATEGY);
    }

    public static void nwindowLog(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WINDOWLOG, value);
    }

    public static void nchainLog(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CHAINLOG, value);
    }

    public static void nhashLog(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HASHLOG, value);
    }

    public static void nsearchLog(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SEARCHLOG, value);
    }

    public static void nminMatch(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MINMATCH, value);
    }

    public static void ntargetLength(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TARGETLENGTH, value);
    }

    public static void nstrategy(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STRATEGY, value);
    }

    static {
        Struct.Layout layout = ZSTDCompressionParameters.__struct(ZSTDCompressionParameters.__member(4), ZSTDCompressionParameters.__member(4), ZSTDCompressionParameters.__member(4), ZSTDCompressionParameters.__member(4), ZSTDCompressionParameters.__member(4), ZSTDCompressionParameters.__member(4), ZSTDCompressionParameters.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WINDOWLOG = layout.offsetof(0);
        CHAINLOG = layout.offsetof(1);
        HASHLOG = layout.offsetof(2);
        SEARCHLOG = layout.offsetof(3);
        MINMATCH = layout.offsetof(4);
        TARGETLENGTH = layout.offsetof(5);
        STRATEGY = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<ZSTDCompressionParameters, Buffer>
    implements NativeResource {
        private static final ZSTDCompressionParameters ELEMENT_FACTORY = ZSTDCompressionParameters.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected ZSTDCompressionParameters getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int windowLog() {
            return ZSTDCompressionParameters.nwindowLog(this.address());
        }

        @NativeType(value="unsigned int")
        public int chainLog() {
            return ZSTDCompressionParameters.nchainLog(this.address());
        }

        @NativeType(value="unsigned int")
        public int hashLog() {
            return ZSTDCompressionParameters.nhashLog(this.address());
        }

        @NativeType(value="unsigned int")
        public int searchLog() {
            return ZSTDCompressionParameters.nsearchLog(this.address());
        }

        @NativeType(value="unsigned int")
        public int minMatch() {
            return ZSTDCompressionParameters.nminMatch(this.address());
        }

        @NativeType(value="unsigned int")
        public int targetLength() {
            return ZSTDCompressionParameters.ntargetLength(this.address());
        }

        @NativeType(value="ZSTD_strategy")
        public int strategy() {
            return ZSTDCompressionParameters.nstrategy(this.address());
        }

        public Buffer windowLog(@NativeType(value="unsigned int") int value) {
            ZSTDCompressionParameters.nwindowLog(this.address(), value);
            return this;
        }

        public Buffer chainLog(@NativeType(value="unsigned int") int value) {
            ZSTDCompressionParameters.nchainLog(this.address(), value);
            return this;
        }

        public Buffer hashLog(@NativeType(value="unsigned int") int value) {
            ZSTDCompressionParameters.nhashLog(this.address(), value);
            return this;
        }

        public Buffer searchLog(@NativeType(value="unsigned int") int value) {
            ZSTDCompressionParameters.nsearchLog(this.address(), value);
            return this;
        }

        public Buffer minMatch(@NativeType(value="unsigned int") int value) {
            ZSTDCompressionParameters.nminMatch(this.address(), value);
            return this;
        }

        public Buffer targetLength(@NativeType(value="unsigned int") int value) {
            ZSTDCompressionParameters.ntargetLength(this.address(), value);
            return this;
        }

        public Buffer strategy(@NativeType(value="ZSTD_strategy") int value) {
            ZSTDCompressionParameters.nstrategy(this.address(), value);
            return this;
        }
    }
}

