/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ZSTD_frameProgression")
public class ZSTDFrameProgression
extends Struct<ZSTDFrameProgression>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int INGESTED;
    public static final int CONSUMED;
    public static final int PRODUCED;
    public static final int FLUSHED;
    public static final int CURRENTJOBID;
    public static final int NBACTIVEWORKERS;

    protected ZSTDFrameProgression(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected ZSTDFrameProgression create(long address, @Nullable ByteBuffer container) {
        return new ZSTDFrameProgression(address, container);
    }

    public ZSTDFrameProgression(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), ZSTDFrameProgression.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned long long")
    public long ingested() {
        return ZSTDFrameProgression.ningested(this.address());
    }

    @NativeType(value="unsigned long long")
    public long consumed() {
        return ZSTDFrameProgression.nconsumed(this.address());
    }

    @NativeType(value="unsigned long long")
    public long produced() {
        return ZSTDFrameProgression.nproduced(this.address());
    }

    @NativeType(value="unsigned long long")
    public long flushed() {
        return ZSTDFrameProgression.nflushed(this.address());
    }

    @NativeType(value="unsigned int")
    public int currentJobID() {
        return ZSTDFrameProgression.ncurrentJobID(this.address());
    }

    @NativeType(value="unsigned int")
    public int nbActiveWorkers() {
        return ZSTDFrameProgression.nnbActiveWorkers(this.address());
    }

    public static ZSTDFrameProgression malloc() {
        return new ZSTDFrameProgression(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static ZSTDFrameProgression calloc() {
        return new ZSTDFrameProgression(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static ZSTDFrameProgression create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new ZSTDFrameProgression(MemoryUtil.memAddress(container), container);
    }

    public static ZSTDFrameProgression create(long address) {
        return new ZSTDFrameProgression(address, null);
    }

    public static @Nullable ZSTDFrameProgression createSafe(long address) {
        return address == 0L ? null : new ZSTDFrameProgression(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(ZSTDFrameProgression.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZSTDFrameProgression.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static ZSTDFrameProgression mallocStack() {
        return ZSTDFrameProgression.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDFrameProgression callocStack() {
        return ZSTDFrameProgression.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDFrameProgression mallocStack(MemoryStack stack) {
        return ZSTDFrameProgression.malloc(stack);
    }

    @Deprecated
    public static ZSTDFrameProgression callocStack(MemoryStack stack) {
        return ZSTDFrameProgression.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return ZSTDFrameProgression.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return ZSTDFrameProgression.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ZSTDFrameProgression.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ZSTDFrameProgression.calloc(capacity, stack);
    }

    public static ZSTDFrameProgression malloc(MemoryStack stack) {
        return new ZSTDFrameProgression(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ZSTDFrameProgression calloc(MemoryStack stack) {
        return new ZSTDFrameProgression(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ningested(long struct) {
        return MemoryUtil.memGetLong(struct + (long)INGESTED);
    }

    public static long nconsumed(long struct) {
        return MemoryUtil.memGetLong(struct + (long)CONSUMED);
    }

    public static long nproduced(long struct) {
        return MemoryUtil.memGetLong(struct + (long)PRODUCED);
    }

    public static long nflushed(long struct) {
        return MemoryUtil.memGetLong(struct + (long)FLUSHED);
    }

    public static int ncurrentJobID(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CURRENTJOBID);
    }

    public static int nnbActiveWorkers(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NBACTIVEWORKERS);
    }

    static {
        Struct.Layout layout = ZSTDFrameProgression.__struct(ZSTDFrameProgression.__member(8), ZSTDFrameProgression.__member(8), ZSTDFrameProgression.__member(8), ZSTDFrameProgression.__member(8), ZSTDFrameProgression.__member(4), ZSTDFrameProgression.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        INGESTED = layout.offsetof(0);
        CONSUMED = layout.offsetof(1);
        PRODUCED = layout.offsetof(2);
        FLUSHED = layout.offsetof(3);
        CURRENTJOBID = layout.offsetof(4);
        NBACTIVEWORKERS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<ZSTDFrameProgression, Buffer>
    implements NativeResource {
        private static final ZSTDFrameProgression ELEMENT_FACTORY = ZSTDFrameProgression.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected ZSTDFrameProgression getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned long long")
        public long ingested() {
            return ZSTDFrameProgression.ningested(this.address());
        }

        @NativeType(value="unsigned long long")
        public long consumed() {
            return ZSTDFrameProgression.nconsumed(this.address());
        }

        @NativeType(value="unsigned long long")
        public long produced() {
            return ZSTDFrameProgression.nproduced(this.address());
        }

        @NativeType(value="unsigned long long")
        public long flushed() {
            return ZSTDFrameProgression.nflushed(this.address());
        }

        @NativeType(value="unsigned int")
        public int currentJobID() {
            return ZSTDFrameProgression.ncurrentJobID(this.address());
        }

        @NativeType(value="unsigned int")
        public int nbActiveWorkers() {
            return ZSTDFrameProgression.nnbActiveWorkers(this.address());
        }
    }
}

