/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.zstd.ZSTDCompressionParameters;
import org.lwjgl.util.zstd.ZSTDFrameParameters;

@NativeType(value="struct ZSTD_parameters")
public class ZSTDParameters
extends Struct<ZSTDParameters>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CPARAMS;
    public static final int FPARAMS;

    protected ZSTDParameters(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected ZSTDParameters create(long address, @Nullable ByteBuffer container) {
        return new ZSTDParameters(address, container);
    }

    public ZSTDParameters(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), ZSTDParameters.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ZSTD_compressionParameters")
    public ZSTDCompressionParameters cParams() {
        return ZSTDParameters.ncParams(this.address());
    }

    @NativeType(value="ZSTD_frameParameters")
    public ZSTDFrameParameters fParams() {
        return ZSTDParameters.nfParams(this.address());
    }

    public ZSTDParameters cParams(@NativeType(value="ZSTD_compressionParameters") ZSTDCompressionParameters value) {
        ZSTDParameters.ncParams(this.address(), value);
        return this;
    }

    public ZSTDParameters cParams(Consumer<ZSTDCompressionParameters> consumer) {
        consumer.accept(this.cParams());
        return this;
    }

    public ZSTDParameters fParams(@NativeType(value="ZSTD_frameParameters") ZSTDFrameParameters value) {
        ZSTDParameters.nfParams(this.address(), value);
        return this;
    }

    public ZSTDParameters fParams(Consumer<ZSTDFrameParameters> consumer) {
        consumer.accept(this.fParams());
        return this;
    }

    public ZSTDParameters set(ZSTDCompressionParameters cParams, ZSTDFrameParameters fParams) {
        this.cParams(cParams);
        this.fParams(fParams);
        return this;
    }

    public ZSTDParameters set(ZSTDParameters src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static ZSTDParameters malloc() {
        return new ZSTDParameters(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static ZSTDParameters calloc() {
        return new ZSTDParameters(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static ZSTDParameters create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new ZSTDParameters(MemoryUtil.memAddress(container), container);
    }

    public static ZSTDParameters create(long address) {
        return new ZSTDParameters(address, null);
    }

    public static @Nullable ZSTDParameters createSafe(long address) {
        return address == 0L ? null : new ZSTDParameters(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(ZSTDParameters.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZSTDParameters.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static ZSTDParameters mallocStack() {
        return ZSTDParameters.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDParameters callocStack() {
        return ZSTDParameters.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDParameters mallocStack(MemoryStack stack) {
        return ZSTDParameters.malloc(stack);
    }

    @Deprecated
    public static ZSTDParameters callocStack(MemoryStack stack) {
        return ZSTDParameters.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return ZSTDParameters.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return ZSTDParameters.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ZSTDParameters.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ZSTDParameters.calloc(capacity, stack);
    }

    public static ZSTDParameters malloc(MemoryStack stack) {
        return new ZSTDParameters(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ZSTDParameters calloc(MemoryStack stack) {
        return new ZSTDParameters(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ZSTDCompressionParameters ncParams(long struct) {
        return ZSTDCompressionParameters.create(struct + (long)CPARAMS);
    }

    public static ZSTDFrameParameters nfParams(long struct) {
        return ZSTDFrameParameters.create(struct + (long)FPARAMS);
    }

    public static void ncParams(long struct, ZSTDCompressionParameters value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CPARAMS, ZSTDCompressionParameters.SIZEOF);
    }

    public static void nfParams(long struct, ZSTDFrameParameters value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FPARAMS, ZSTDFrameParameters.SIZEOF);
    }

    static {
        Struct.Layout layout = ZSTDParameters.__struct(ZSTDParameters.__member(ZSTDCompressionParameters.SIZEOF, ZSTDCompressionParameters.ALIGNOF), ZSTDParameters.__member(ZSTDFrameParameters.SIZEOF, ZSTDFrameParameters.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CPARAMS = layout.offsetof(0);
        FPARAMS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<ZSTDParameters, Buffer>
    implements NativeResource {
        private static final ZSTDParameters ELEMENT_FACTORY = ZSTDParameters.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected ZSTDParameters getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ZSTD_compressionParameters")
        public ZSTDCompressionParameters cParams() {
            return ZSTDParameters.ncParams(this.address());
        }

        @NativeType(value="ZSTD_frameParameters")
        public ZSTDFrameParameters fParams() {
            return ZSTDParameters.nfParams(this.address());
        }

        public Buffer cParams(@NativeType(value="ZSTD_compressionParameters") ZSTDCompressionParameters value) {
            ZSTDParameters.ncParams(this.address(), value);
            return this;
        }

        public Buffer cParams(Consumer<ZSTDCompressionParameters> consumer) {
            consumer.accept(this.cParams());
            return this;
        }

        public Buffer fParams(@NativeType(value="ZSTD_frameParameters") ZSTDFrameParameters value) {
            ZSTDParameters.nfParams(this.address(), value);
            return this;
        }

        public Buffer fParams(Consumer<ZSTDFrameParameters> consumer) {
            consumer.accept(this.fParams());
            return this;
        }
    }
}

