/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ZSTD_Sequence")
public class ZSTDSequence
extends Struct<ZSTDSequence>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OFFSET;
    public static final int LITLENGTH;
    public static final int MATCHLENGTH;
    public static final int REP;

    protected ZSTDSequence(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected ZSTDSequence create(long address, @Nullable ByteBuffer container) {
        return new ZSTDSequence(address, container);
    }

    public ZSTDSequence(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), ZSTDSequence.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int offset() {
        return ZSTDSequence.noffset(this.address());
    }

    @NativeType(value="unsigned int")
    public int litLength() {
        return ZSTDSequence.nlitLength(this.address());
    }

    @NativeType(value="unsigned int")
    public int matchLength() {
        return ZSTDSequence.nmatchLength(this.address());
    }

    @NativeType(value="unsigned int")
    public int rep() {
        return ZSTDSequence.nrep(this.address());
    }

    public static ZSTDSequence malloc() {
        return new ZSTDSequence(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static ZSTDSequence calloc() {
        return new ZSTDSequence(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static ZSTDSequence create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new ZSTDSequence(MemoryUtil.memAddress(container), container);
    }

    public static ZSTDSequence create(long address) {
        return new ZSTDSequence(address, null);
    }

    public static @Nullable ZSTDSequence createSafe(long address) {
        return address == 0L ? null : new ZSTDSequence(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(ZSTDSequence.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZSTDSequence.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static ZSTDSequence malloc(MemoryStack stack) {
        return new ZSTDSequence(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ZSTDSequence calloc(MemoryStack stack) {
        return new ZSTDSequence(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int noffset(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OFFSET);
    }

    public static int nlitLength(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LITLENGTH);
    }

    public static int nmatchLength(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MATCHLENGTH);
    }

    public static int nrep(long struct) {
        return MemoryUtil.memGetInt(struct + (long)REP);
    }

    static {
        Struct.Layout layout = ZSTDSequence.__struct(ZSTDSequence.__member(4), ZSTDSequence.__member(4), ZSTDSequence.__member(4), ZSTDSequence.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OFFSET = layout.offsetof(0);
        LITLENGTH = layout.offsetof(1);
        MATCHLENGTH = layout.offsetof(2);
        REP = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<ZSTDSequence, Buffer>
    implements NativeResource {
        private static final ZSTDSequence ELEMENT_FACTORY = ZSTDSequence.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected ZSTDSequence getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int offset() {
            return ZSTDSequence.noffset(this.address());
        }

        @NativeType(value="unsigned int")
        public int litLength() {
            return ZSTDSequence.nlitLength(this.address());
        }

        @NativeType(value="unsigned int")
        public int matchLength() {
            return ZSTDSequence.nmatchLength(this.address());
        }

        @NativeType(value="unsigned int")
        public int rep() {
            return ZSTDSequence.nrep(this.address());
        }
    }
}

