/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkDispatchGraphCountInfoAMDX;
import org.lwjgl.vulkan.VkExecutionGraphPipelineCreateInfoAMDX;
import org.lwjgl.vulkan.VkExecutionGraphPipelineScratchSizeAMDX;
import org.lwjgl.vulkan.VkPipelineShaderStageNodeCreateInfoAMDX;

public class AMDXShaderEnqueue {
    public static final int VK_AMDX_SHADER_ENQUEUE_SPEC_VERSION = 2;
    public static final String VK_AMDX_SHADER_ENQUEUE_EXTENSION_NAME = "VK_AMDX_shader_enqueue";
    public static final int VK_SHADER_INDEX_UNUSED_AMDX = -1;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ENQUEUE_FEATURES_AMDX = 1000134000;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ENQUEUE_PROPERTIES_AMDX = 1000134001;
    public static final int VK_STRUCTURE_TYPE_EXECUTION_GRAPH_PIPELINE_SCRATCH_SIZE_AMDX = 1000134002;
    public static final int VK_STRUCTURE_TYPE_EXECUTION_GRAPH_PIPELINE_CREATE_INFO_AMDX = 1000134003;
    public static final int VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_NODE_CREATE_INFO_AMDX = 1000134004;
    public static final int VK_BUFFER_USAGE_EXECUTION_GRAPH_SCRATCH_BIT_AMDX = 0x2000000;
    public static final int VK_PIPELINE_BIND_POINT_EXECUTION_GRAPH_AMDX = 1000134000;
    public static final long VK_BUFFER_USAGE_2_EXECUTION_GRAPH_SCRATCH_BIT_AMDX = 0x2000000L;
    public static final long VK_PIPELINE_CREATE_2_EXECUTION_GRAPH_BIT_AMDX = 0x100000000L;

    protected AMDXShaderEnqueue() {
        throw new UnsupportedOperationException();
    }

    public static int nvkCreateExecutionGraphPipelinesAMDX(VkDevice device, long pipelineCache, int createInfoCount, long pCreateInfos, long pAllocator, long pPipelines) {
        long __functionAddress = device.getCapabilities().vkCreateExecutionGraphPipelinesAMDX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Struct.validate(pCreateInfos, createInfoCount, VkExecutionGraphPipelineCreateInfoAMDX.SIZEOF, VkExecutionGraphPipelineCreateInfoAMDX::validate);
        }
        return JNI.callPJPPPI(device.address(), pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateExecutionGraphPipelinesAMDX(VkDevice device, @NativeType(value="VkPipelineCache") long pipelineCache, @NativeType(value="VkExecutionGraphPipelineCreateInfoAMDX const *") VkExecutionGraphPipelineCreateInfoAMDX.Buffer pCreateInfos, @NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks pAllocator, @NativeType(value="VkPipeline *") LongBuffer pPipelines) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pPipelines, pCreateInfos.remaining());
        }
        return AMDXShaderEnqueue.nvkCreateExecutionGraphPipelinesAMDX(device, pipelineCache, pCreateInfos.remaining(), pCreateInfos.address(), MemoryUtil.memAddressSafe(pAllocator), MemoryUtil.memAddress(pPipelines));
    }

    public static int nvkGetExecutionGraphPipelineScratchSizeAMDX(VkDevice device, long executionGraph, long pSizeInfo) {
        long __functionAddress = device.getCapabilities().vkGetExecutionGraphPipelineScratchSizeAMDX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPI(device.address(), executionGraph, pSizeInfo, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetExecutionGraphPipelineScratchSizeAMDX(VkDevice device, @NativeType(value="VkPipeline") long executionGraph, @NativeType(value="VkExecutionGraphPipelineScratchSizeAMDX *") VkExecutionGraphPipelineScratchSizeAMDX pSizeInfo) {
        return AMDXShaderEnqueue.nvkGetExecutionGraphPipelineScratchSizeAMDX(device, executionGraph, pSizeInfo.address());
    }

    public static int nvkGetExecutionGraphPipelineNodeIndexAMDX(VkDevice device, long executionGraph, long pNodeInfo, long pNodeIndex) {
        long __functionAddress = device.getCapabilities().vkGetExecutionGraphPipelineNodeIndexAMDX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPPI(device.address(), executionGraph, pNodeInfo, pNodeIndex, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetExecutionGraphPipelineNodeIndexAMDX(VkDevice device, @NativeType(value="VkPipeline") long executionGraph, @NativeType(value="VkPipelineShaderStageNodeCreateInfoAMDX const *") VkPipelineShaderStageNodeCreateInfoAMDX pNodeInfo, @NativeType(value="uint32_t *") IntBuffer pNodeIndex) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pNodeIndex, 1);
        }
        return AMDXShaderEnqueue.nvkGetExecutionGraphPipelineNodeIndexAMDX(device, executionGraph, pNodeInfo.address(), MemoryUtil.memAddress(pNodeIndex));
    }

    public static void vkCmdInitializeGraphScratchMemoryAMDX(VkCommandBuffer commandBuffer, @NativeType(value="VkPipeline") long executionGraph, @NativeType(value="VkDeviceAddress") long scratch, @NativeType(value="VkDeviceSize") long scratchSize) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdInitializeGraphScratchMemoryAMDX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPJJJV(commandBuffer.address(), executionGraph, scratch, scratchSize, __functionAddress);
    }

    public static void nvkCmdDispatchGraphAMDX(VkCommandBuffer commandBuffer, long scratch, long scratchSize, long pCountInfo) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdDispatchGraphAMDX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPJJPV(commandBuffer.address(), scratch, scratchSize, pCountInfo, __functionAddress);
    }

    public static void vkCmdDispatchGraphAMDX(VkCommandBuffer commandBuffer, @NativeType(value="VkDeviceAddress") long scratch, @NativeType(value="VkDeviceSize") long scratchSize, @NativeType(value="VkDispatchGraphCountInfoAMDX const *") VkDispatchGraphCountInfoAMDX pCountInfo) {
        AMDXShaderEnqueue.nvkCmdDispatchGraphAMDX(commandBuffer, scratch, scratchSize, pCountInfo.address());
    }

    public static void nvkCmdDispatchGraphIndirectAMDX(VkCommandBuffer commandBuffer, long scratch, long scratchSize, long pCountInfo) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdDispatchGraphIndirectAMDX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPJJPV(commandBuffer.address(), scratch, scratchSize, pCountInfo, __functionAddress);
    }

    public static void vkCmdDispatchGraphIndirectAMDX(VkCommandBuffer commandBuffer, @NativeType(value="VkDeviceAddress") long scratch, @NativeType(value="VkDeviceSize") long scratchSize, @NativeType(value="VkDispatchGraphCountInfoAMDX const *") VkDispatchGraphCountInfoAMDX pCountInfo) {
        AMDXShaderEnqueue.nvkCmdDispatchGraphIndirectAMDX(commandBuffer, scratch, scratchSize, pCountInfo.address());
    }

    public static void vkCmdDispatchGraphIndirectCountAMDX(VkCommandBuffer commandBuffer, @NativeType(value="VkDeviceAddress") long scratch, @NativeType(value="VkDeviceSize") long scratchSize, @NativeType(value="VkDeviceAddress") long countInfo) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdDispatchGraphIndirectCountAMDX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPJJJV(commandBuffer.address(), scratch, scratchSize, countInfo, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateExecutionGraphPipelinesAMDX(VkDevice device, @NativeType(value="VkPipelineCache") long pipelineCache, @NativeType(value="VkExecutionGraphPipelineCreateInfoAMDX const *") VkExecutionGraphPipelineCreateInfoAMDX.Buffer pCreateInfos, @NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks pAllocator, @NativeType(value="VkPipeline *") long[] pPipelines) {
        long __functionAddress = device.getCapabilities().vkCreateExecutionGraphPipelinesAMDX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pPipelines, pCreateInfos.remaining());
            Struct.validate(pCreateInfos.address(), pCreateInfos.remaining(), VkExecutionGraphPipelineCreateInfoAMDX.SIZEOF, VkExecutionGraphPipelineCreateInfoAMDX::validate);
        }
        return JNI.callPJPPPI(device.address(), pipelineCache, pCreateInfos.remaining(), pCreateInfos.address(), MemoryUtil.memAddressSafe(pAllocator), pPipelines, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetExecutionGraphPipelineNodeIndexAMDX(VkDevice device, @NativeType(value="VkPipeline") long executionGraph, @NativeType(value="VkPipelineShaderStageNodeCreateInfoAMDX const *") VkPipelineShaderStageNodeCreateInfoAMDX pNodeInfo, @NativeType(value="uint32_t *") int[] pNodeIndex) {
        long __functionAddress = device.getCapabilities().vkGetExecutionGraphPipelineNodeIndexAMDX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pNodeIndex, 1);
        }
        return JNI.callPJPPI(device.address(), executionGraph, pNodeInfo.address(), pNodeIndex, __functionAddress);
    }
}

