/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkCalibratedTimestampInfoKHR;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkPhysicalDevice;

public class EXTCalibratedTimestamps {
    public static final int VK_EXT_CALIBRATED_TIMESTAMPS_SPEC_VERSION = 2;
    public static final String VK_EXT_CALIBRATED_TIMESTAMPS_EXTENSION_NAME = "VK_EXT_calibrated_timestamps";
    public static final int VK_STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_EXT = 1000184000;
    public static final int VK_TIME_DOMAIN_DEVICE_EXT = 0;
    public static final int VK_TIME_DOMAIN_CLOCK_MONOTONIC_EXT = 1;
    public static final int VK_TIME_DOMAIN_CLOCK_MONOTONIC_RAW_EXT = 2;
    public static final int VK_TIME_DOMAIN_QUERY_PERFORMANCE_COUNTER_EXT = 3;
    public static final int VK_TIME_DOMAIN_DEVICE_KHR = 0;
    public static final int VK_TIME_DOMAIN_CLOCK_MONOTONIC_KHR = 1;
    public static final int VK_TIME_DOMAIN_CLOCK_MONOTONIC_RAW_KHR = 2;
    public static final int VK_TIME_DOMAIN_QUERY_PERFORMANCE_COUNTER_KHR = 3;

    protected EXTCalibratedTimestamps() {
        throw new UnsupportedOperationException();
    }

    public static int nvkGetPhysicalDeviceCalibrateableTimeDomainsEXT(VkPhysicalDevice physicalDevice, long pTimeDomainCount, long pTimeDomains) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceCalibrateableTimeDomainsEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(physicalDevice.address(), pTimeDomainCount, pTimeDomains, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceCalibrateableTimeDomainsEXT(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t *") IntBuffer pTimeDomainCount, @NativeType(value="VkTimeDomainKHR *") @Nullable IntBuffer pTimeDomains) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pTimeDomainCount, 1);
            Checks.checkSafe((Buffer)pTimeDomains, pTimeDomainCount.get(pTimeDomainCount.position()));
        }
        return EXTCalibratedTimestamps.nvkGetPhysicalDeviceCalibrateableTimeDomainsEXT(physicalDevice, MemoryUtil.memAddress(pTimeDomainCount), MemoryUtil.memAddressSafe(pTimeDomains));
    }

    public static int nvkGetCalibratedTimestampsEXT(VkDevice device, int timestampCount, long pTimestampInfos, long pTimestamps, long pMaxDeviation) {
        long __functionAddress = device.getCapabilities().vkGetCalibratedTimestampsEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPPI(device.address(), timestampCount, pTimestampInfos, pTimestamps, pMaxDeviation, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetCalibratedTimestampsEXT(VkDevice device, @NativeType(value="VkCalibratedTimestampInfoKHR const *") VkCalibratedTimestampInfoKHR.Buffer pTimestampInfos, @NativeType(value="uint64_t *") LongBuffer pTimestamps, @NativeType(value="uint64_t *") LongBuffer pMaxDeviation) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pTimestamps, pTimestampInfos.remaining());
            Checks.check((Buffer)pMaxDeviation, 1);
        }
        return EXTCalibratedTimestamps.nvkGetCalibratedTimestampsEXT(device, pTimestampInfos.remaining(), pTimestampInfos.address(), MemoryUtil.memAddress(pTimestamps), MemoryUtil.memAddress(pMaxDeviation));
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceCalibrateableTimeDomainsEXT(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t *") int[] pTimeDomainCount, @NativeType(value="VkTimeDomainKHR *") int @Nullable [] pTimeDomains) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceCalibrateableTimeDomainsEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pTimeDomainCount, 1);
            Checks.checkSafe(pTimeDomains, pTimeDomainCount[0]);
        }
        return JNI.callPPPI(physicalDevice.address(), pTimeDomainCount, pTimeDomains, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetCalibratedTimestampsEXT(VkDevice device, @NativeType(value="VkCalibratedTimestampInfoKHR const *") VkCalibratedTimestampInfoKHR.Buffer pTimestampInfos, @NativeType(value="uint64_t *") long[] pTimestamps, @NativeType(value="uint64_t *") long[] pMaxDeviation) {
        long __functionAddress = device.getCapabilities().vkGetCalibratedTimestampsEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pTimestamps, pTimestampInfos.remaining());
            Checks.check(pMaxDeviation, 1);
        }
        return JNI.callPPPPI(device.address(), pTimestampInfos.remaining(), pTimestampInfos.address(), pTimestamps, pMaxDeviation, __functionAddress);
    }
}

