/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAccelerationStructureInfoNV;
import org.lwjgl.vulkan.VkOpaqueCaptureDescriptorDataCreateInfoEXT;

public class VkAccelerationStructureCreateInfoNV
extends Struct<VkAccelerationStructureCreateInfoNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int COMPACTEDSIZE;
    public static final int INFO;

    protected VkAccelerationStructureCreateInfoNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkAccelerationStructureCreateInfoNV create(long address, @Nullable ByteBuffer container) {
        return new VkAccelerationStructureCreateInfoNV(address, container);
    }

    public VkAccelerationStructureCreateInfoNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkAccelerationStructureCreateInfoNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkAccelerationStructureCreateInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkAccelerationStructureCreateInfoNV.npNext(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long compactedSize() {
        return VkAccelerationStructureCreateInfoNV.ncompactedSize(this.address());
    }

    public VkAccelerationStructureInfoNV info() {
        return VkAccelerationStructureCreateInfoNV.ninfo(this.address());
    }

    public VkAccelerationStructureCreateInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkAccelerationStructureCreateInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkAccelerationStructureCreateInfoNV sType$Default() {
        return this.sType(1000165001);
    }

    public VkAccelerationStructureCreateInfoNV pNext(@NativeType(value="void const *") long value) {
        VkAccelerationStructureCreateInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkAccelerationStructureCreateInfoNV pNext(VkOpaqueCaptureDescriptorDataCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkAccelerationStructureCreateInfoNV compactedSize(@NativeType(value="VkDeviceSize") long value) {
        VkAccelerationStructureCreateInfoNV.ncompactedSize(this.address(), value);
        return this;
    }

    public VkAccelerationStructureCreateInfoNV info(VkAccelerationStructureInfoNV value) {
        VkAccelerationStructureCreateInfoNV.ninfo(this.address(), value);
        return this;
    }

    public VkAccelerationStructureCreateInfoNV info(Consumer<VkAccelerationStructureInfoNV> consumer) {
        consumer.accept(this.info());
        return this;
    }

    public VkAccelerationStructureCreateInfoNV set(int sType, long pNext, long compactedSize, VkAccelerationStructureInfoNV info) {
        this.sType(sType);
        this.pNext(pNext);
        this.compactedSize(compactedSize);
        this.info(info);
        return this;
    }

    public VkAccelerationStructureCreateInfoNV set(VkAccelerationStructureCreateInfoNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkAccelerationStructureCreateInfoNV malloc() {
        return new VkAccelerationStructureCreateInfoNV(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkAccelerationStructureCreateInfoNV calloc() {
        return new VkAccelerationStructureCreateInfoNV(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkAccelerationStructureCreateInfoNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkAccelerationStructureCreateInfoNV(MemoryUtil.memAddress(container), container);
    }

    public static VkAccelerationStructureCreateInfoNV create(long address) {
        return new VkAccelerationStructureCreateInfoNV(address, null);
    }

    public static @Nullable VkAccelerationStructureCreateInfoNV createSafe(long address) {
        return address == 0L ? null : new VkAccelerationStructureCreateInfoNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkAccelerationStructureCreateInfoNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAccelerationStructureCreateInfoNV.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkAccelerationStructureCreateInfoNV mallocStack() {
        return VkAccelerationStructureCreateInfoNV.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkAccelerationStructureCreateInfoNV callocStack() {
        return VkAccelerationStructureCreateInfoNV.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkAccelerationStructureCreateInfoNV mallocStack(MemoryStack stack) {
        return VkAccelerationStructureCreateInfoNV.malloc(stack);
    }

    @Deprecated
    public static VkAccelerationStructureCreateInfoNV callocStack(MemoryStack stack) {
        return VkAccelerationStructureCreateInfoNV.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkAccelerationStructureCreateInfoNV.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkAccelerationStructureCreateInfoNV.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkAccelerationStructureCreateInfoNV.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkAccelerationStructureCreateInfoNV.calloc(capacity, stack);
    }

    public static VkAccelerationStructureCreateInfoNV malloc(MemoryStack stack) {
        return new VkAccelerationStructureCreateInfoNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkAccelerationStructureCreateInfoNV calloc(MemoryStack stack) {
        return new VkAccelerationStructureCreateInfoNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long ncompactedSize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)COMPACTEDSIZE);
    }

    public static VkAccelerationStructureInfoNV ninfo(long struct) {
        return VkAccelerationStructureInfoNV.create(struct + (long)INFO);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ncompactedSize(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)COMPACTEDSIZE, value);
    }

    public static void ninfo(long struct, VkAccelerationStructureInfoNV value) {
        MemoryUtil.memCopy(value.address(), struct + (long)INFO, VkAccelerationStructureInfoNV.SIZEOF);
    }

    public static void validate(long struct) {
        VkAccelerationStructureInfoNV.validate(struct + (long)INFO);
    }

    static {
        Struct.Layout layout = VkAccelerationStructureCreateInfoNV.__struct(VkAccelerationStructureCreateInfoNV.__member(4), VkAccelerationStructureCreateInfoNV.__member(POINTER_SIZE), VkAccelerationStructureCreateInfoNV.__member(8), VkAccelerationStructureCreateInfoNV.__member(VkAccelerationStructureInfoNV.SIZEOF, VkAccelerationStructureInfoNV.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        COMPACTEDSIZE = layout.offsetof(2);
        INFO = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkAccelerationStructureCreateInfoNV, Buffer>
    implements NativeResource {
        private static final VkAccelerationStructureCreateInfoNV ELEMENT_FACTORY = VkAccelerationStructureCreateInfoNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkAccelerationStructureCreateInfoNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkAccelerationStructureCreateInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkAccelerationStructureCreateInfoNV.npNext(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long compactedSize() {
            return VkAccelerationStructureCreateInfoNV.ncompactedSize(this.address());
        }

        public VkAccelerationStructureInfoNV info() {
            return VkAccelerationStructureCreateInfoNV.ninfo(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkAccelerationStructureCreateInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000165001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkAccelerationStructureCreateInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkOpaqueCaptureDescriptorDataCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer compactedSize(@NativeType(value="VkDeviceSize") long value) {
            VkAccelerationStructureCreateInfoNV.ncompactedSize(this.address(), value);
            return this;
        }

        public Buffer info(VkAccelerationStructureInfoNV value) {
            VkAccelerationStructureCreateInfoNV.ninfo(this.address(), value);
            return this;
        }

        public Buffer info(Consumer<VkAccelerationStructureInfoNV> consumer) {
            consumer.accept(this.info());
            return this;
        }
    }
}

