/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBaseOutStructure
extends Struct<VkBaseOutStructure>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;

    protected VkBaseOutStructure(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkBaseOutStructure create(long address, @Nullable ByteBuffer container) {
        return new VkBaseOutStructure(address, container);
    }

    public VkBaseOutStructure(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkBaseOutStructure.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBaseOutStructure.nsType(this.address());
    }

    @NativeType(value="VkBaseOutStructure *")
    public @Nullable VkBaseOutStructure pNext() {
        return VkBaseOutStructure.npNext(this.address());
    }

    public VkBaseOutStructure sType(@NativeType(value="VkStructureType") int value) {
        VkBaseOutStructure.nsType(this.address(), value);
        return this;
    }

    public VkBaseOutStructure pNext(@NativeType(value="VkBaseOutStructure *") @Nullable VkBaseOutStructure value) {
        VkBaseOutStructure.npNext(this.address(), value);
        return this;
    }

    public VkBaseOutStructure set(int sType, @Nullable VkBaseOutStructure pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkBaseOutStructure set(VkBaseOutStructure src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBaseOutStructure malloc() {
        return new VkBaseOutStructure(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkBaseOutStructure calloc() {
        return new VkBaseOutStructure(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkBaseOutStructure create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkBaseOutStructure(MemoryUtil.memAddress(container), container);
    }

    public static VkBaseOutStructure create(long address) {
        return new VkBaseOutStructure(address, null);
    }

    public static @Nullable VkBaseOutStructure createSafe(long address) {
        return address == 0L ? null : new VkBaseOutStructure(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkBaseOutStructure.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBaseOutStructure.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkBaseOutStructure mallocStack() {
        return VkBaseOutStructure.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBaseOutStructure callocStack() {
        return VkBaseOutStructure.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBaseOutStructure mallocStack(MemoryStack stack) {
        return VkBaseOutStructure.malloc(stack);
    }

    @Deprecated
    public static VkBaseOutStructure callocStack(MemoryStack stack) {
        return VkBaseOutStructure.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkBaseOutStructure.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkBaseOutStructure.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBaseOutStructure.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBaseOutStructure.calloc(capacity, stack);
    }

    public static VkBaseOutStructure malloc(MemoryStack stack) {
        return new VkBaseOutStructure(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBaseOutStructure calloc(MemoryStack stack) {
        return new VkBaseOutStructure(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static @Nullable VkBaseOutStructure npNext(long struct) {
        return VkBaseOutStructure.createSafe(MemoryUtil.memGetAddress(struct + (long)PNEXT));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, @Nullable VkBaseOutStructure value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, MemoryUtil.memAddressSafe(value));
    }

    static {
        Struct.Layout layout = VkBaseOutStructure.__struct(VkBaseOutStructure.__member(4), VkBaseOutStructure.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkBaseOutStructure, Buffer>
    implements NativeResource {
        private static final VkBaseOutStructure ELEMENT_FACTORY = VkBaseOutStructure.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkBaseOutStructure getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBaseOutStructure.nsType(this.address());
        }

        @NativeType(value="VkBaseOutStructure *")
        public @Nullable VkBaseOutStructure pNext() {
            return VkBaseOutStructure.npNext(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBaseOutStructure.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="VkBaseOutStructure *") @Nullable VkBaseOutStructure value) {
            VkBaseOutStructure.npNext(this.address(), value);
            return this;
        }
    }
}

