/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkRect2D;

public class VkBindImageMemoryDeviceGroupInfo
extends Struct<VkBindImageMemoryDeviceGroupInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DEVICEINDEXCOUNT;
    public static final int PDEVICEINDICES;
    public static final int SPLITINSTANCEBINDREGIONCOUNT;
    public static final int PSPLITINSTANCEBINDREGIONS;

    protected VkBindImageMemoryDeviceGroupInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkBindImageMemoryDeviceGroupInfo create(long address, @Nullable ByteBuffer container) {
        return new VkBindImageMemoryDeviceGroupInfo(address, container);
    }

    public VkBindImageMemoryDeviceGroupInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkBindImageMemoryDeviceGroupInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBindImageMemoryDeviceGroupInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBindImageMemoryDeviceGroupInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int deviceIndexCount() {
        return VkBindImageMemoryDeviceGroupInfo.ndeviceIndexCount(this.address());
    }

    @NativeType(value="uint32_t const *")
    public @Nullable IntBuffer pDeviceIndices() {
        return VkBindImageMemoryDeviceGroupInfo.npDeviceIndices(this.address());
    }

    @NativeType(value="uint32_t")
    public int splitInstanceBindRegionCount() {
        return VkBindImageMemoryDeviceGroupInfo.nsplitInstanceBindRegionCount(this.address());
    }

    @NativeType(value="VkRect2D const *")
    public @Nullable VkRect2D.Buffer pSplitInstanceBindRegions() {
        return VkBindImageMemoryDeviceGroupInfo.npSplitInstanceBindRegions(this.address());
    }

    public VkBindImageMemoryDeviceGroupInfo sType(@NativeType(value="VkStructureType") int value) {
        VkBindImageMemoryDeviceGroupInfo.nsType(this.address(), value);
        return this;
    }

    public VkBindImageMemoryDeviceGroupInfo sType$Default() {
        return this.sType(1000060014);
    }

    public VkBindImageMemoryDeviceGroupInfo pNext(@NativeType(value="void const *") long value) {
        VkBindImageMemoryDeviceGroupInfo.npNext(this.address(), value);
        return this;
    }

    public VkBindImageMemoryDeviceGroupInfo pDeviceIndices(@NativeType(value="uint32_t const *") @Nullable IntBuffer value) {
        VkBindImageMemoryDeviceGroupInfo.npDeviceIndices(this.address(), value);
        return this;
    }

    public VkBindImageMemoryDeviceGroupInfo pSplitInstanceBindRegions(@NativeType(value="VkRect2D const *") @Nullable VkRect2D.Buffer value) {
        VkBindImageMemoryDeviceGroupInfo.npSplitInstanceBindRegions(this.address(), value);
        return this;
    }

    public VkBindImageMemoryDeviceGroupInfo set(int sType, long pNext, @Nullable IntBuffer pDeviceIndices, @Nullable VkRect2D.Buffer pSplitInstanceBindRegions) {
        this.sType(sType);
        this.pNext(pNext);
        this.pDeviceIndices(pDeviceIndices);
        this.pSplitInstanceBindRegions(pSplitInstanceBindRegions);
        return this;
    }

    public VkBindImageMemoryDeviceGroupInfo set(VkBindImageMemoryDeviceGroupInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBindImageMemoryDeviceGroupInfo malloc() {
        return new VkBindImageMemoryDeviceGroupInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkBindImageMemoryDeviceGroupInfo calloc() {
        return new VkBindImageMemoryDeviceGroupInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkBindImageMemoryDeviceGroupInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkBindImageMemoryDeviceGroupInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkBindImageMemoryDeviceGroupInfo create(long address) {
        return new VkBindImageMemoryDeviceGroupInfo(address, null);
    }

    public static @Nullable VkBindImageMemoryDeviceGroupInfo createSafe(long address) {
        return address == 0L ? null : new VkBindImageMemoryDeviceGroupInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkBindImageMemoryDeviceGroupInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBindImageMemoryDeviceGroupInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkBindImageMemoryDeviceGroupInfo mallocStack() {
        return VkBindImageMemoryDeviceGroupInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBindImageMemoryDeviceGroupInfo callocStack() {
        return VkBindImageMemoryDeviceGroupInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBindImageMemoryDeviceGroupInfo mallocStack(MemoryStack stack) {
        return VkBindImageMemoryDeviceGroupInfo.malloc(stack);
    }

    @Deprecated
    public static VkBindImageMemoryDeviceGroupInfo callocStack(MemoryStack stack) {
        return VkBindImageMemoryDeviceGroupInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkBindImageMemoryDeviceGroupInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkBindImageMemoryDeviceGroupInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBindImageMemoryDeviceGroupInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBindImageMemoryDeviceGroupInfo.calloc(capacity, stack);
    }

    public static VkBindImageMemoryDeviceGroupInfo malloc(MemoryStack stack) {
        return new VkBindImageMemoryDeviceGroupInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBindImageMemoryDeviceGroupInfo calloc(MemoryStack stack) {
        return new VkBindImageMemoryDeviceGroupInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int ndeviceIndexCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEVICEINDEXCOUNT);
    }

    public static @Nullable IntBuffer npDeviceIndices(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PDEVICEINDICES), VkBindImageMemoryDeviceGroupInfo.ndeviceIndexCount(struct));
    }

    public static int nsplitInstanceBindRegionCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SPLITINSTANCEBINDREGIONCOUNT);
    }

    public static @Nullable VkRect2D.Buffer npSplitInstanceBindRegions(long struct) {
        return VkRect2D.createSafe(MemoryUtil.memGetAddress(struct + (long)PSPLITINSTANCEBINDREGIONS), VkBindImageMemoryDeviceGroupInfo.nsplitInstanceBindRegionCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ndeviceIndexCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEVICEINDEXCOUNT, value);
    }

    public static void npDeviceIndices(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDEVICEINDICES, MemoryUtil.memAddressSafe(value));
        VkBindImageMemoryDeviceGroupInfo.ndeviceIndexCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nsplitInstanceBindRegionCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SPLITINSTANCEBINDREGIONCOUNT, value);
    }

    public static void npSplitInstanceBindRegions(long struct, @Nullable VkRect2D.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSPLITINSTANCEBINDREGIONS, MemoryUtil.memAddressSafe(value));
        VkBindImageMemoryDeviceGroupInfo.nsplitInstanceBindRegionCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkBindImageMemoryDeviceGroupInfo.ndeviceIndexCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PDEVICEINDICES));
        }
        if (VkBindImageMemoryDeviceGroupInfo.nsplitInstanceBindRegionCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PSPLITINSTANCEBINDREGIONS));
        }
    }

    static {
        Struct.Layout layout = VkBindImageMemoryDeviceGroupInfo.__struct(VkBindImageMemoryDeviceGroupInfo.__member(4), VkBindImageMemoryDeviceGroupInfo.__member(POINTER_SIZE), VkBindImageMemoryDeviceGroupInfo.__member(4), VkBindImageMemoryDeviceGroupInfo.__member(POINTER_SIZE), VkBindImageMemoryDeviceGroupInfo.__member(4), VkBindImageMemoryDeviceGroupInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DEVICEINDEXCOUNT = layout.offsetof(2);
        PDEVICEINDICES = layout.offsetof(3);
        SPLITINSTANCEBINDREGIONCOUNT = layout.offsetof(4);
        PSPLITINSTANCEBINDREGIONS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkBindImageMemoryDeviceGroupInfo, Buffer>
    implements NativeResource {
        private static final VkBindImageMemoryDeviceGroupInfo ELEMENT_FACTORY = VkBindImageMemoryDeviceGroupInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkBindImageMemoryDeviceGroupInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBindImageMemoryDeviceGroupInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBindImageMemoryDeviceGroupInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int deviceIndexCount() {
            return VkBindImageMemoryDeviceGroupInfo.ndeviceIndexCount(this.address());
        }

        @NativeType(value="uint32_t const *")
        public @Nullable IntBuffer pDeviceIndices() {
            return VkBindImageMemoryDeviceGroupInfo.npDeviceIndices(this.address());
        }

        @NativeType(value="uint32_t")
        public int splitInstanceBindRegionCount() {
            return VkBindImageMemoryDeviceGroupInfo.nsplitInstanceBindRegionCount(this.address());
        }

        @NativeType(value="VkRect2D const *")
        public @Nullable VkRect2D.Buffer pSplitInstanceBindRegions() {
            return VkBindImageMemoryDeviceGroupInfo.npSplitInstanceBindRegions(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBindImageMemoryDeviceGroupInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000060014);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBindImageMemoryDeviceGroupInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pDeviceIndices(@NativeType(value="uint32_t const *") @Nullable IntBuffer value) {
            VkBindImageMemoryDeviceGroupInfo.npDeviceIndices(this.address(), value);
            return this;
        }

        public Buffer pSplitInstanceBindRegions(@NativeType(value="VkRect2D const *") @Nullable VkRect2D.Buffer value) {
            VkBindImageMemoryDeviceGroupInfo.npSplitInstanceBindRegions(this.address(), value);
            return this;
        }
    }
}

