/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkClearColorValue
extends Struct<VkClearColorValue>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLOAT32;
    public static final int INT32;
    public static final int UINT32;

    protected VkClearColorValue(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkClearColorValue create(long address, @Nullable ByteBuffer container) {
        return new VkClearColorValue(address, container);
    }

    public VkClearColorValue(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkClearColorValue.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float[4]")
    public FloatBuffer float32() {
        return VkClearColorValue.nfloat32(this.address());
    }

    public float float32(int index) {
        return VkClearColorValue.nfloat32(this.address(), index);
    }

    @NativeType(value="int32_t[4]")
    public IntBuffer int32() {
        return VkClearColorValue.nint32(this.address());
    }

    @NativeType(value="int32_t")
    public int int32(int index) {
        return VkClearColorValue.nint32(this.address(), index);
    }

    @NativeType(value="uint32_t[4]")
    public IntBuffer uint32() {
        return VkClearColorValue.nuint32(this.address());
    }

    @NativeType(value="uint32_t")
    public int uint32(int index) {
        return VkClearColorValue.nuint32(this.address(), index);
    }

    public VkClearColorValue float32(@NativeType(value="float[4]") FloatBuffer value) {
        VkClearColorValue.nfloat32(this.address(), value);
        return this;
    }

    public VkClearColorValue float32(int index, float value) {
        VkClearColorValue.nfloat32(this.address(), index, value);
        return this;
    }

    public VkClearColorValue int32(@NativeType(value="int32_t[4]") IntBuffer value) {
        VkClearColorValue.nint32(this.address(), value);
        return this;
    }

    public VkClearColorValue int32(int index, @NativeType(value="int32_t") int value) {
        VkClearColorValue.nint32(this.address(), index, value);
        return this;
    }

    public VkClearColorValue uint32(@NativeType(value="uint32_t[4]") IntBuffer value) {
        VkClearColorValue.nuint32(this.address(), value);
        return this;
    }

    public VkClearColorValue uint32(int index, @NativeType(value="uint32_t") int value) {
        VkClearColorValue.nuint32(this.address(), index, value);
        return this;
    }

    public VkClearColorValue set(VkClearColorValue src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkClearColorValue malloc() {
        return new VkClearColorValue(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkClearColorValue calloc() {
        return new VkClearColorValue(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkClearColorValue create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkClearColorValue(MemoryUtil.memAddress(container), container);
    }

    public static VkClearColorValue create(long address) {
        return new VkClearColorValue(address, null);
    }

    public static @Nullable VkClearColorValue createSafe(long address) {
        return address == 0L ? null : new VkClearColorValue(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkClearColorValue.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkClearColorValue.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkClearColorValue mallocStack() {
        return VkClearColorValue.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkClearColorValue callocStack() {
        return VkClearColorValue.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkClearColorValue mallocStack(MemoryStack stack) {
        return VkClearColorValue.malloc(stack);
    }

    @Deprecated
    public static VkClearColorValue callocStack(MemoryStack stack) {
        return VkClearColorValue.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkClearColorValue.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkClearColorValue.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkClearColorValue.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkClearColorValue.calloc(capacity, stack);
    }

    public static VkClearColorValue malloc(MemoryStack stack) {
        return new VkClearColorValue(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkClearColorValue calloc(MemoryStack stack) {
        return new VkClearColorValue(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer nfloat32(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)FLOAT32, 4);
    }

    public static float nfloat32(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)FLOAT32 + Checks.check(index, 4) * 4L);
    }

    public static IntBuffer nint32(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)INT32, 4);
    }

    public static int nint32(long struct, int index) {
        return MemoryUtil.memGetInt(struct + (long)INT32 + Checks.check(index, 4) * 4L);
    }

    public static IntBuffer nuint32(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)UINT32, 4);
    }

    public static int nuint32(long struct, int index) {
        return MemoryUtil.memGetInt(struct + (long)UINT32 + Checks.check(index, 4) * 4L);
    }

    public static void nfloat32(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 4);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)FLOAT32, value.remaining() * 4);
    }

    public static void nfloat32(long struct, int index, float value) {
        MemoryUtil.memPutFloat(struct + (long)FLOAT32 + Checks.check(index, 4) * 4L, value);
    }

    public static void nint32(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 4);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)INT32, value.remaining() * 4);
    }

    public static void nint32(long struct, int index, int value) {
        MemoryUtil.memPutInt(struct + (long)INT32 + Checks.check(index, 4) * 4L, value);
    }

    public static void nuint32(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 4);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)UINT32, value.remaining() * 4);
    }

    public static void nuint32(long struct, int index, int value) {
        MemoryUtil.memPutInt(struct + (long)UINT32 + Checks.check(index, 4) * 4L, value);
    }

    static {
        Struct.Layout layout = VkClearColorValue.__union(VkClearColorValue.__array(4, 4), VkClearColorValue.__array(4, 4), VkClearColorValue.__array(4, 4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLOAT32 = layout.offsetof(0);
        INT32 = layout.offsetof(1);
        UINT32 = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkClearColorValue, Buffer>
    implements NativeResource {
        private static final VkClearColorValue ELEMENT_FACTORY = VkClearColorValue.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkClearColorValue getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="float[4]")
        public FloatBuffer float32() {
            return VkClearColorValue.nfloat32(this.address());
        }

        public float float32(int index) {
            return VkClearColorValue.nfloat32(this.address(), index);
        }

        @NativeType(value="int32_t[4]")
        public IntBuffer int32() {
            return VkClearColorValue.nint32(this.address());
        }

        @NativeType(value="int32_t")
        public int int32(int index) {
            return VkClearColorValue.nint32(this.address(), index);
        }

        @NativeType(value="uint32_t[4]")
        public IntBuffer uint32() {
            return VkClearColorValue.nuint32(this.address());
        }

        @NativeType(value="uint32_t")
        public int uint32(int index) {
            return VkClearColorValue.nuint32(this.address(), index);
        }

        public Buffer float32(@NativeType(value="float[4]") FloatBuffer value) {
            VkClearColorValue.nfloat32(this.address(), value);
            return this;
        }

        public Buffer float32(int index, float value) {
            VkClearColorValue.nfloat32(this.address(), index, value);
            return this;
        }

        public Buffer int32(@NativeType(value="int32_t[4]") IntBuffer value) {
            VkClearColorValue.nint32(this.address(), value);
            return this;
        }

        public Buffer int32(int index, @NativeType(value="int32_t") int value) {
            VkClearColorValue.nint32(this.address(), index, value);
            return this;
        }

        public Buffer uint32(@NativeType(value="uint32_t[4]") IntBuffer value) {
            VkClearColorValue.nuint32(this.address(), value);
            return this;
        }

        public Buffer uint32(int index, @NativeType(value="uint32_t") int value) {
            VkClearColorValue.nuint32(this.address(), index, value);
            return this;
        }
    }
}

