/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDeviceOrHostAddressKHR;

public class VkCopyAccelerationStructureToMemoryInfoKHR
extends Struct<VkCopyAccelerationStructureToMemoryInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRC;
    public static final int DST;
    public static final int MODE;

    protected VkCopyAccelerationStructureToMemoryInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkCopyAccelerationStructureToMemoryInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkCopyAccelerationStructureToMemoryInfoKHR(address, container);
    }

    public VkCopyAccelerationStructureToMemoryInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkCopyAccelerationStructureToMemoryInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCopyAccelerationStructureToMemoryInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCopyAccelerationStructureToMemoryInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkAccelerationStructureKHR")
    public long src() {
        return VkCopyAccelerationStructureToMemoryInfoKHR.nsrc(this.address());
    }

    public VkDeviceOrHostAddressKHR dst() {
        return VkCopyAccelerationStructureToMemoryInfoKHR.ndst(this.address());
    }

    @NativeType(value="VkCopyAccelerationStructureModeKHR")
    public int mode() {
        return VkCopyAccelerationStructureToMemoryInfoKHR.nmode(this.address());
    }

    public VkCopyAccelerationStructureToMemoryInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkCopyAccelerationStructureToMemoryInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkCopyAccelerationStructureToMemoryInfoKHR sType$Default() {
        return this.sType(1000150011);
    }

    public VkCopyAccelerationStructureToMemoryInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkCopyAccelerationStructureToMemoryInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkCopyAccelerationStructureToMemoryInfoKHR src(@NativeType(value="VkAccelerationStructureKHR") long value) {
        VkCopyAccelerationStructureToMemoryInfoKHR.nsrc(this.address(), value);
        return this;
    }

    public VkCopyAccelerationStructureToMemoryInfoKHR dst(VkDeviceOrHostAddressKHR value) {
        VkCopyAccelerationStructureToMemoryInfoKHR.ndst(this.address(), value);
        return this;
    }

    public VkCopyAccelerationStructureToMemoryInfoKHR dst(Consumer<VkDeviceOrHostAddressKHR> consumer) {
        consumer.accept(this.dst());
        return this;
    }

    public VkCopyAccelerationStructureToMemoryInfoKHR mode(@NativeType(value="VkCopyAccelerationStructureModeKHR") int value) {
        VkCopyAccelerationStructureToMemoryInfoKHR.nmode(this.address(), value);
        return this;
    }

    public VkCopyAccelerationStructureToMemoryInfoKHR set(int sType, long pNext, long src, VkDeviceOrHostAddressKHR dst, int mode) {
        this.sType(sType);
        this.pNext(pNext);
        this.src(src);
        this.dst(dst);
        this.mode(mode);
        return this;
    }

    public VkCopyAccelerationStructureToMemoryInfoKHR set(VkCopyAccelerationStructureToMemoryInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkCopyAccelerationStructureToMemoryInfoKHR malloc() {
        return new VkCopyAccelerationStructureToMemoryInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkCopyAccelerationStructureToMemoryInfoKHR calloc() {
        return new VkCopyAccelerationStructureToMemoryInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkCopyAccelerationStructureToMemoryInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkCopyAccelerationStructureToMemoryInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkCopyAccelerationStructureToMemoryInfoKHR create(long address) {
        return new VkCopyAccelerationStructureToMemoryInfoKHR(address, null);
    }

    public static @Nullable VkCopyAccelerationStructureToMemoryInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkCopyAccelerationStructureToMemoryInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkCopyAccelerationStructureToMemoryInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCopyAccelerationStructureToMemoryInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkCopyAccelerationStructureToMemoryInfoKHR malloc(MemoryStack stack) {
        return new VkCopyAccelerationStructureToMemoryInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCopyAccelerationStructureToMemoryInfoKHR calloc(MemoryStack stack) {
        return new VkCopyAccelerationStructureToMemoryInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nsrc(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SRC);
    }

    public static VkDeviceOrHostAddressKHR ndst(long struct) {
        return VkDeviceOrHostAddressKHR.create(struct + (long)DST);
    }

    public static int nmode(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MODE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nsrc(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SRC, value);
    }

    public static void ndst(long struct, VkDeviceOrHostAddressKHR value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DST, VkDeviceOrHostAddressKHR.SIZEOF);
    }

    public static void nmode(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MODE, value);
    }

    static {
        Struct.Layout layout = VkCopyAccelerationStructureToMemoryInfoKHR.__struct(VkCopyAccelerationStructureToMemoryInfoKHR.__member(4), VkCopyAccelerationStructureToMemoryInfoKHR.__member(POINTER_SIZE), VkCopyAccelerationStructureToMemoryInfoKHR.__member(8), VkCopyAccelerationStructureToMemoryInfoKHR.__member(VkDeviceOrHostAddressKHR.SIZEOF, VkDeviceOrHostAddressKHR.ALIGNOF), VkCopyAccelerationStructureToMemoryInfoKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRC = layout.offsetof(2);
        DST = layout.offsetof(3);
        MODE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkCopyAccelerationStructureToMemoryInfoKHR, Buffer>
    implements NativeResource {
        private static final VkCopyAccelerationStructureToMemoryInfoKHR ELEMENT_FACTORY = VkCopyAccelerationStructureToMemoryInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkCopyAccelerationStructureToMemoryInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCopyAccelerationStructureToMemoryInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCopyAccelerationStructureToMemoryInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkAccelerationStructureKHR")
        public long src() {
            return VkCopyAccelerationStructureToMemoryInfoKHR.nsrc(this.address());
        }

        public VkDeviceOrHostAddressKHR dst() {
            return VkCopyAccelerationStructureToMemoryInfoKHR.ndst(this.address());
        }

        @NativeType(value="VkCopyAccelerationStructureModeKHR")
        public int mode() {
            return VkCopyAccelerationStructureToMemoryInfoKHR.nmode(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCopyAccelerationStructureToMemoryInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000150011);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCopyAccelerationStructureToMemoryInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer src(@NativeType(value="VkAccelerationStructureKHR") long value) {
            VkCopyAccelerationStructureToMemoryInfoKHR.nsrc(this.address(), value);
            return this;
        }

        public Buffer dst(VkDeviceOrHostAddressKHR value) {
            VkCopyAccelerationStructureToMemoryInfoKHR.ndst(this.address(), value);
            return this;
        }

        public Buffer dst(Consumer<VkDeviceOrHostAddressKHR> consumer) {
            consumer.accept(this.dst());
            return this;
        }

        public Buffer mode(@NativeType(value="VkCopyAccelerationStructureModeKHR") int value) {
            VkCopyAccelerationStructureToMemoryInfoKHR.nmode(this.address(), value);
            return this;
        }
    }
}

